/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.common.blocks.detector.Detector;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class DetectorAnimal
extends Detector
implements IGuiReturnHandler {
    public boolean chicken = true;
    public boolean cow = true;
    public boolean pig = true;
    public boolean sheep = true;
    public boolean mooshroom = true;
    public boolean wolf = true;
    public boolean other = true;

    @Override
    public EnumDetector getType() {
        return EnumDetector.ANIMAL;
    }

    @Override
    public int testCarts(List<EntityMinecart> carts) {
        for (EntityMinecart cart : carts) {
            if (!(cart.field_70153_n instanceof EntityChicken ? this.chicken : (cart.field_70153_n instanceof EntityMooshroom ? this.mooshroom : (cart.field_70153_n instanceof EntityPig ? this.pig : (cart.field_70153_n instanceof EntitySheep ? this.sheep : (cart.field_70153_n instanceof EntityCow ? this.cow : (cart.field_70153_n instanceof EntityWolf ? this.wolf : cart.field_70153_n instanceof EntityAnimal && this.other))))))) continue;
            return 15;
        }
        return 0;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        this.openGui(EnumGui.DETECTOR_ANIMAL, player);
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("chicken", this.chicken);
        data.func_74757_a("cow", this.cow);
        data.func_74757_a("pig", this.pig);
        data.func_74757_a("sheep", this.sheep);
        data.func_74757_a("mooshroom", this.mooshroom);
        data.func_74757_a("wolf", this.wolf);
        data.func_74757_a("other", this.other);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.chicken = data.func_74767_n("chicken");
        this.cow = data.func_74767_n("cow");
        this.pig = data.func_74767_n("pig");
        this.sheep = data.func_74767_n("sheep");
        this.mooshroom = data.func_74767_n("mooshroom");
        this.wolf = data.func_74767_n("wolf");
        this.other = data.func_74767_n("other");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.writeGuiData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.readGuiData(data, null);
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        byte bits = 0;
        bits = (byte)(bits | (this.chicken ? 1 : 0));
        bits = (byte)(bits | (this.cow ? 2 : 0));
        bits = (byte)(bits | (this.pig ? 4 : 0));
        bits = (byte)(bits | (this.sheep ? 8 : 0));
        bits = (byte)(bits | (this.mooshroom ? 16 : 0));
        bits = (byte)(bits | (this.wolf ? 32 : 0));
        bits = (byte)(bits | (this.other ? 64 : 0));
        data.writeByte(bits);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        byte bits = data.readByte();
        this.chicken = (bits & 1) != 0;
        this.cow = (bits & 2) != 0;
        this.pig = (bits & 4) != 0;
        this.sheep = (bits & 8) != 0;
        this.mooshroom = (bits & 0x10) != 0;
        this.wolf = (bits & 0x20) != 0;
        this.other = (bits & 0x40) != 0;
    }
}

