/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.oldservercode.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import journeymap.common.Journeymap;

public class FileManager {
    public static String readFile(File file) {
        String row = "";
        StringBuilder fileOutput = new StringBuilder();
        try {
            FileInputStream fileIn = new FileInputStream(file);
            BufferedReader bReader = new BufferedReader(new InputStreamReader(fileIn));
            try {
                while ((row = bReader.readLine()) != null) {
                    fileOutput.append(row);
                }
                bReader.close();
            }
            catch (IOException e) {
                Journeymap.getLogger().error("Unable to read the JsonFile");
                Journeymap.getLogger().error("Error" + e);
                return null;
            }
            return fileOutput.toString();
        }
        catch (FileNotFoundException e) {
            Journeymap.getLogger().info(file + " not found!");
            return null;
        }
    }

    public static boolean writeFile(File file, String text) {
        try {
            File dir = new File(file.getParent());
            if (!dir.exists() && !dir.isDirectory()) {
                dir.mkdirs();
                File newConfig = new File(dir, file.getName());
                newConfig.createNewFile();
            }
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(text);
            bw.close();
            return true;
        }
        catch (IOException e) {
            Journeymap.getLogger().error("Error creating file " + file);
            Journeymap.getLogger().error("Error " + e);
            return false;
        }
    }
}

