/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.layer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.model.BlockCoordIntPair;
import journeymap.client.model.ChunkMD;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.ui.fullscreen.layer.LayerDelegate;
import journeymap.client.ui.option.LocationFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;

public class BlockInfoLayer
implements LayerDelegate.Layer {
    private final List<DrawStep> drawStepList = new ArrayList<DrawStep>(1);
    LocationFormat locationFormat = new LocationFormat();
    LocationFormat.LocationFormatKeys locationFormatKeys;
    BlockCoordIntPair lastCoord = null;
    long lastClicked = 0L;
    int lastMouseX;
    int lastMouseY;
    BlockInfoStep blockInfoStep;
    FontRenderer fontRenderer = ForgeHelper.INSTANCE.getFontRenderer();

    public BlockInfoLayer() {
        this.blockInfoStep = new BlockInfoStep();
        this.drawStepList.add(this.blockInfoStep);
    }

    @Override
    public List<DrawStep> onMouseMove(Minecraft mc, double mouseX, double mouseY, int gridWidth, int gridHeight, BlockCoordIntPair blockCoord) {
        if (!blockCoord.equals(this.lastCoord)) {
            String info;
            FullMapProperties fullMapProperties = JourneymapClient.getFullMapProperties();
            this.locationFormatKeys = this.locationFormat.getFormatKeys((String)fullMapProperties.locationFormat.get());
            this.lastCoord = blockCoord;
            Chunk chunk = mc.field_71441_e.func_72964_e(blockCoord.x >> 4, blockCoord.z >> 4);
            if (!chunk.func_76621_g()) {
                ChunkMD chunkMD = DataCache.instance().getChunkMD(ChunkCoordIntPair.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h));
                int blockY = chunkMD.getPrecipitationHeight(blockCoord.x & 0xF, blockCoord.z & 0xF);
                String biome = ForgeHelper.INSTANCE.getBiome((int)blockCoord.x, (int)blockY, (int)blockCoord.z).field_76791_y;
                info = this.locationFormatKeys.format(fullMapProperties.locationFormatVerbose.get(), blockCoord.x, blockCoord.z, blockY, blockY >> 4) + " " + biome;
            } else {
                info = Constants.getString("jm.common.location_xz_verbose", blockCoord.x, blockCoord.z);
            }
            double infoHeight = (double)DrawUtil.getLabelHeight(this.fontRenderer, true) * this.getMapFontScale();
            this.blockInfoStep.update(info, gridWidth / 2, (double)gridHeight - infoHeight);
        } else {
            this.blockInfoStep.update(this.blockInfoStep.text, gridWidth / 2, this.blockInfoStep.y);
        }
        return this.drawStepList;
    }

    private double getMapFontScale() {
        return JourneymapClient.getFullMapProperties().fontScale.get();
    }

    @Override
    public List<DrawStep> onMouseClick(Minecraft mc, double mouseX, double mouseY, int gridWidth, int gridHeight, BlockCoordIntPair blockCoord) {
        return Collections.EMPTY_LIST;
    }

    class BlockInfoStep
    implements DrawStep {
        Integer bgColor = 0x404040;
        Integer fgColor = 0xFFFFFF;
        double fontScale = 1.0;
        boolean fontShadow = false;
        int alpha = 255;
        int ticks = 100;
        private double x;
        private double y;
        private String text;

        BlockInfoStep() {
        }

        void update(String text, double x, double y) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.alpha = 255;
            this.ticks = 100;
        }

        @Override
        public void draw(double xOffset, double yOffset, GridRenderer gridRenderer, float drawScale, double fontScale, double rotation) {
            if (this.ticks-- < 0 && this.alpha > 0) {
                --this.alpha;
            }
            if (this.alpha > 10 && this.text != null) {
                DrawUtil.drawLabel(this.text, this.x, this.y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, this.bgColor, Math.max(0, this.alpha), this.fgColor, Math.max(0, this.alpha), BlockInfoLayer.this.getMapFontScale(), this.fontShadow);
            }
        }
    }
}

