/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.mantle;

import com.dreammaster.main.MainRegistry;
import eu.usrv.yamcore.auxiliary.LogHelper;
import java.util.Objects;
import mantle.books.BookData;
import mantle.books.BookDataStore;

class BookDataStoreProxy {
    private static final BookDataStoreProxy INSTANCE = new BookDataStoreProxy(MainRegistry.Logger);
    private final LogHelper logger;

    static BookDataStoreProxy getInstance() {
        return INSTANCE;
    }

    BookDataStoreProxy(LogHelper logger) {
        Objects.requireNonNull(logger);
        this.logger = logger;
    }

    void addBook(BookData bookData) {
        Objects.requireNonNull(bookData);
        try {
            BookDataStore.addBook((BookData)bookData);
        }
        catch (IllegalArgumentException e) {
            this.logger.error((Object)("Cannot override book " + bookData.unlocalizedName + " which is already defined elsewhere."));
        }
    }
}

