/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util.misc;

import serverutils.lib.gui.GuiIcons;
import serverutils.lib.icon.Icon;
import serverutils.lib.util.IStringSerializable;
import serverutils.lib.util.misc.NameMap;

public enum EnumRedstoneMode implements IStringSerializable
{
    DISABLED("disabled"),
    ACTIVE_HIGH("active_high"),
    ACTIVE_LOW("active_low"),
    PULSE("pulse");

    public static final NameMap<EnumRedstoneMode> NAME_MAP;
    public static final NameMap<EnumRedstoneMode> NAME_MAP_WITH_PULSE;
    private final String name;

    private EnumRedstoneMode(String n2) {
        this.name = n2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isActive(boolean prevValue, boolean value) {
        boolean bl;
        switch (this) {
            case ACTIVE_HIGH: {
                bl = value;
                break;
            }
            case ACTIVE_LOW: {
                if (!value) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public Icon getIcon() {
        Icon icon;
        switch (this) {
            case ACTIVE_HIGH: {
                icon = GuiIcons.RS_HIGH;
                break;
            }
            case ACTIVE_LOW: {
                icon = GuiIcons.RS_LOW;
                break;
            }
            case PULSE: {
                icon = GuiIcons.RS_PULSE;
                break;
            }
            default: {
                icon = GuiIcons.RS_NONE;
            }
        }
        return icon;
    }

    static {
        NAME_MAP = NameMap.createWithBaseTranslationKey(DISABLED, "redstone_mode", DISABLED, ACTIVE_HIGH, ACTIVE_LOW);
        NAME_MAP_WITH_PULSE = NameMap.createWithBaseTranslationKey(DISABLED, "redstone_mode", DISABLED, ACTIVE_HIGH, ACTIVE_LOW, PULSE);
    }
}

