/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util;

import net.minecraft.item.ItemStack;
import serverutils.lib.EnumDyeColor;
import serverutils.lib.util.StringUtils;

public class EnumDyeColorHelper {
    public static final EnumDyeColorHelper[] HELPERS = new EnumDyeColorHelper[EnumDyeColor.values().length];
    private final EnumDyeColor dye;
    private final String langKey;
    private final String oreName;

    private EnumDyeColorHelper(EnumDyeColor col) {
        this.dye = col;
        this.langKey = "item.fireworksCharge." + col.unlocalizedName;
        this.oreName = StringUtils.firstUppercase(col.unlocalizedName);
    }

    public static EnumDyeColorHelper get(EnumDyeColor dye) {
        return HELPERS[dye.ordinal()];
    }

    public ItemStack getDye(int s) {
        return this.dye.getDye(s);
    }

    public String toString() {
        return this.dye.name;
    }

    public int hashCode() {
        return this.dye.ordinal();
    }

    public EnumDyeColor getDye() {
        return this.dye;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public String getOreName() {
        return this.oreName;
    }

    public String getDyeName() {
        return this.dye.dyeName;
    }

    public String getGlassName() {
        return this.dye.glassName;
    }

    public String getPaneName() {
        return this.dye.paneName;
    }

    static {
        for (EnumDyeColor c : EnumDyeColor.values()) {
            EnumDyeColorHelper.HELPERS[c.ordinal()] = new EnumDyeColorHelper(c);
        }
    }
}

