/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.gui.misc;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.Theme;
import serverutils.lib.icon.Color4I;

public class GuiLoading
extends GuiBase {
    private boolean startedLoading = false;
    private boolean isLoading = true;
    private String title;
    public float timer;

    public GuiLoading() {
        this("");
    }

    public GuiLoading(String t) {
        this.setSize(128, 128);
        this.title = t;
    }

    @Override
    public void addWidgets() {
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        if (!this.startedLoading) {
            this.startLoading();
            this.startedLoading = true;
        }
        if (this.isLoading()) {
            GuiHelper.drawHollowRect(x + this.width / 2 - 48, y + this.height / 2 - 8, 96, 16, Color4I.WHITE, true);
            int x1 = x + this.width / 2 - 48;
            int y1 = y + this.height / 2 - 8;
            int w1 = 96;
            int h1 = 16;
            Color4I col = Color4I.WHITE;
            GlStateManager.disableTexture2D();
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            GuiHelper.addRectToBuffer(tessellator, x1, y1 + 1, 1.0, h1 - 2, col);
            GuiHelper.addRectToBuffer(tessellator, x1 + w1 - 1, y1 + 1, 1.0, h1 - 2, col);
            GuiHelper.addRectToBuffer(tessellator, x1 + 1, y1, w1 - 2, 1.0, col);
            GuiHelper.addRectToBuffer(tessellator, x1 + 1, y1 + h1 - 1, w1 - 2, 1.0, col);
            ++x1;
            ++y1;
            w1 -= 2;
            h1 -= 2;
            this.timer += Minecraft.func_71410_x().field_71428_T.field_74282_a;
            for (int oy = 0; oy < h1; ++oy) {
                for (int ox = 0; ox < w1; ++ox) {
                    int index = ox + oy + (int)this.timer;
                    if (index % (h1 * 2) >= h1) continue;
                    col = Color4I.WHITE.withAlpha(200 - index % h1 * 9);
                    GuiHelper.addRectToBuffer(tessellator, x1 + ox, y1 + oy, 1.0, 1.0, col);
                }
            }
            tessellator.func_78381_a();
            GlStateManager.enableTexture2D();
            String s = this.getTitle();
            if (!s.isEmpty()) {
                String[] s1 = s.split("\n");
                for (int i = 0; i < s1.length; ++i) {
                    theme.drawString(s1[i], x + this.width / 2, y - 26 + i * 12, 4);
                }
            }
        } else {
            this.closeGui();
            this.finishLoading();
        }
    }

    @Override
    public synchronized String getTitle() {
        return this.title;
    }

    public synchronized void setTitle(String s) {
        this.title = s;
    }

    public synchronized void setFinished() {
        this.isLoading = false;
    }

    public void startLoading() {
    }

    public synchronized boolean isLoading() {
        return this.isLoading;
    }

    public void finishLoading() {
    }
}

