/*
 * Decompiled with CFR 0.152.
 */
package serverutils.invsee;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import serverutils.invsee.InvseeContainer;
import serverutils.invsee.inventories.IModdedInventory;
import serverutils.invsee.inventories.InvSeeInventories;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiContainerWrapper;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.SimpleButton;
import serverutils.lib.gui.TextField;
import serverutils.lib.gui.Theme;
import serverutils.lib.gui.Widget;
import serverutils.lib.icon.Color4I;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.PlayerHeadIcon;
import serverutils.lib.util.StringUtils;
import serverutils.net.MessageInvseeSwitch;

public class GuiInvseeContainer
extends GuiBase {
    private static final Icon BUTTON_BACKGROUND = Color4I.GRAY.withBorder(Color4I.DARK_GRAY, true);
    private final Map<InvSeeInventories, IInventory> inventories;
    private final InvseeContainer container;
    private final String playerName;
    private final PlayerHeadIcon playerIcon;
    private final GuiContainerWrapper wrapper;
    private int topY;
    private String inventoryName;
    private TextField textField;

    public GuiInvseeContainer(Map<InvSeeInventories, IInventory> inventories, String playerName, String playerId) {
        this.inventories = inventories;
        this.container = new InvseeContainer(inventories, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, null);
        this.playerName = playerName;
        this.playerIcon = new PlayerHeadIcon(StringUtils.fromString(playerId));
        this.wrapper = new GuiWrapper(this, this.container).disableSlotDrawing();
        this.inventoryName = playerName + "'s " + InvSeeInventories.MAIN.getInventory().getInventoryName();
    }

    @Override
    public GuiScreen getWrapper() {
        return this.wrapper;
    }

    @Override
    public int getY() {
        return super.getY() + 20;
    }

    @Override
    public void alignWidgets() {
        int textY = -13;
        this.textField.setText(this.inventoryName);
        if (this.textField.text.length > 1) {
            textY -= 3 * this.textField.text.length;
        }
        this.textField.setPos(28, textY);
        int highestSlot = this.container.getHighestSlot();
        int lowestSlot = this.container.getLowestSlot();
        this.topY = this.wrapper.field_147009_r + highestSlot;
        this.setHeight(lowestSlot - highestSlot);
        int xOffset = 0;
        int yOffset = 0;
        for (Widget widget : this.widgets) {
            if (!(widget instanceof Button)) continue;
            widget.setX(-18 - xOffset * 16);
            widget.setY(lowestSlot - 72 + yOffset * 16);
            if (yOffset % 5 == 4) {
                ++xOffset;
                yOffset = 0;
                continue;
            }
            ++yOffset;
        }
    }

    @Override
    public void drawForeground(Theme theme, int x, int y, int w, int h) {
        this.playerIcon.draw(x + 8, this.topY - 18, 16, 16);
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        super.drawBackground(theme, x, this.topY - 20, w, this.height + 42);
        GuiHelper.setupDrawing();
        for (int i = 0; i < this.container.field_75151_b.size(); ++i) {
            Icon overlay;
            Slot slot = (Slot)this.container.field_75151_b.get(i);
            theme.drawContainerSlot(x + slot.field_75223_e, y + slot.field_75221_f, 16, 16);
            if (i >= this.container.getNonPlayerSlots() || slot.func_75216_d() || (overlay = this.container.getActiveInventory().getInventory().getSlotOverlay(slot)) == null) continue;
            overlay.draw(x + slot.field_75223_e, y + slot.field_75221_f, 16, 16);
        }
    }

    @Override
    public void addWidgets() {
        this.textField = new TextField(this){

            @Override
            public int getY() {
                return GuiInvseeContainer.this.topY + this.posY;
            }
        }.setColor(Color4I.DARK_GRAY).setScale(0.9f).setMaxWidth(165).setSpacing(8);
        this.add(this.textField);
        for (InvSeeInventories inventory : this.inventories.keySet()) {
            IModdedInventory moddedInv = inventory.getInventory();
            this.add(new SimpleButton(this, moddedInv.getButtonText(), moddedInv.getButtonIcon(), (a, b) -> this.switchInventory(inventory)){

                @Override
                public void drawBackground(Theme theme, int x, int y, int w, int h) {
                    BUTTON_BACKGROUND.draw(x, y, w, h);
                }

                @Override
                public int getY() {
                    return ((GuiInvseeContainer)GuiInvseeContainer.this).wrapper.field_147009_r + this.posY;
                }
            });
        }
    }

    public void switchInventory(InvSeeInventories inventory) {
        if (this.container.getActiveInventory() == inventory) {
            return;
        }
        this.container.setActiveInventory(inventory);
        this.inventoryName = this.playerName + "'s " + inventory.getInventory().getInventoryName();
        this.alignWidgets();
        new MessageInvseeSwitch(inventory).sendToServer();
    }

    private static class GuiWrapper
    extends GuiContainerWrapper {
        private final GuiInvseeContainer gui;
        private int tempMouseY;
        private int oldTop;

        private GuiWrapper(GuiInvseeContainer gui, Container container) {
            super(gui, container);
            this.gui = gui;
        }

        @Override
        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            if (this.oldTop != this.field_147009_r) {
                this.gui.alignWidgets();
                this.oldTop = this.field_147009_r;
            }
            super.func_73863_a(mouseX, mouseY, partialTicks);
        }

        @Override
        protected void func_73864_a(int mouseX, int mouseY, int button) {
            if (mouseY < this.field_147009_r && mouseY > this.gui.topY) {
                this.tempMouseY = mouseY;
                super.func_73864_a(mouseX, this.field_147009_r, button);
                this.tempMouseY = 0;
                return;
            }
            super.func_73864_a(mouseX, mouseY, button);
        }

        protected boolean func_146978_c(int left, int top, int right, int bottom, int pointX, int pointY) {
            if (this.tempMouseY != 0) {
                pointY = this.tempMouseY;
            }
            return super.func_146978_c(left, top, right, bottom, pointX, pointY);
        }
    }
}

