/*
 * Decompiled with CFR 0.152.
 */
package serverutils.data;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import serverutils.ServerUtilitiesConfig;
import serverutils.ServerUtilitiesNotifications;
import serverutils.ServerUtilitiesPermissions;
import serverutils.data.ClaimResult;
import serverutils.data.ClaimedChunk;
import serverutils.data.ServerUtilitiesLoadedChunkManager;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.data.ServerUtilitiesTeamData;
import serverutils.data.ServerUtilitiesUniverseData;
import serverutils.events.chunks.ChunkModifiedEvent;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.data.Universe;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.net.MessageClaimedChunksUpdate;

public class ClaimedChunks {
    public static ClaimedChunks instance;
    public final Universe universe;
    private final Collection<ClaimedChunk> pendingChunks = new HashSet<ClaimedChunk>();
    private final Map<ChunkDimPos, ClaimedChunk> map = new HashMap<ChunkDimPos, ClaimedChunk>();
    public long nextChunkloaderUpdate;
    private boolean isDirty = true;
    private static boolean forceSave;

    public static boolean isActive() {
        return instance != null && ServerUtilitiesConfig.world.chunk_claiming;
    }

    public ClaimedChunks(Universe u) {
        this.universe = u;
    }

    @Nullable
    public ForgeTeam getChunkTeam(ChunkDimPos pos) {
        ClaimedChunk chunk = this.getChunk(pos);
        return chunk == null ? null : chunk.getTeam();
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public void clear() {
        this.pendingChunks.clear();
        this.map.clear();
        this.nextChunkloaderUpdate = 0L;
        this.isDirty = true;
        forceSave = false;
    }

    public void processQueue() {
        if (!this.pendingChunks.isEmpty()) {
            for (ClaimedChunk chunk : this.pendingChunks) {
                ClaimedChunk prevChunk = this.map.put(chunk.getPos(), chunk);
                if (prevChunk != null && prevChunk != chunk) {
                    prevChunk.setInvalid();
                }
                this.markDirty();
            }
            this.pendingChunks.clear();
        }
        Iterator<ClaimedChunk> iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            ClaimedChunk chunk;
            chunk = iterator.next();
            if (!chunk.isInvalid()) continue;
            ServerUtilitiesLoadedChunkManager.INSTANCE.unforceChunk(chunk);
            iterator.remove();
        }
    }

    public void update(Universe universe, long now) {
        if (this.nextChunkloaderUpdate <= now) {
            this.nextChunkloaderUpdate = now + Ticks.MINUTE.millis();
            this.markDirty();
        }
        if (this.isDirty) {
            this.processQueue();
            if (ServerUtilitiesConfig.world.chunk_loading) {
                for (ForgeTeam team : universe.getTeams()) {
                    ServerUtilitiesTeamData.get((ForgeTeam)team).canForceChunks = ServerUtilitiesLoadedChunkManager.INSTANCE.canForceChunks(team);
                }
                for (ClaimedChunk chunk : this.getAllChunks()) {
                    boolean force;
                    boolean bl = force = chunk.getData().canForceChunks && chunk.isLoaded();
                    if (chunk.forced != null && chunk.forced == force) continue;
                    if (force) {
                        ServerUtilitiesLoadedChunkManager.INSTANCE.forceChunk(universe.server, chunk);
                        continue;
                    }
                    ServerUtilitiesLoadedChunkManager.INSTANCE.unforceChunk(chunk);
                }
            }
            for (EntityPlayerMP player : universe.server.func_71203_ab().field_72404_b) {
                ChunkDimPos playerPos = new ChunkDimPos((Entity)player);
                int startX = playerPos.posX - 7;
                int startZ = playerPos.posZ - 7;
                new MessageClaimedChunksUpdate(startX, startZ, (EntityPlayer)player).sendTo(player);
                ServerUtilitiesNotifications.updateChunkMessage(player, playerPos);
            }
            this.isDirty = false;
        }
    }

    @Nullable
    public ClaimedChunk getChunk(ChunkDimPos pos) {
        if (ServerUtilitiesConfig.world.blockDimension(pos.dim)) {
            return null;
        }
        ClaimedChunk chunk = this.map.get(pos);
        return chunk == null || chunk.isInvalid() ? null : chunk;
    }

    public void removeChunk(ChunkDimPos pos) {
        ClaimedChunk prevChunk = this.map.get(pos);
        if (prevChunk != null) {
            prevChunk.setInvalid();
            this.markDirty();
        }
    }

    public void addChunk(ClaimedChunk chunk) {
        this.pendingChunks.add(chunk);
        chunk.getTeam().claimedChunks.add(chunk);
        chunk.getTeam().markDirty();
        this.markDirty();
    }

    public Collection<ClaimedChunk> getAllChunks() {
        return this.map.isEmpty() ? Collections.emptyList() : this.map.values();
    }

    public Set<ChunkDimPos> getAllClaimedPositions() {
        return this.map.isEmpty() ? Collections.emptySet() : this.map.keySet();
    }

    public Set<ClaimedChunk> getTeamChunks(@Nullable ForgeTeam team, OptionalInt dimension, boolean includePending) {
        HashSet<ClaimedChunk> set;
        if (team == null) {
            return Collections.emptySet();
        }
        if (dimension.isPresent()) {
            set = new HashSet();
            for (ClaimedChunk chunk : team.claimedChunks) {
                if (chunk.getPos().dim != dimension.getAsInt()) continue;
                set.add(chunk);
            }
        } else {
            set = new HashSet<ClaimedChunk>(team.claimedChunks);
        }
        if (includePending) {
            for (ClaimedChunk chunk : this.pendingChunks) {
                if (!team.equalsTeam(chunk.getTeam()) || dimension.isPresent() && dimension.getAsInt() != chunk.getPos().dim) continue;
                set.add(chunk);
            }
        }
        return set;
    }

    public Set<ClaimedChunk> getTeamChunks(@Nullable ForgeTeam team, OptionalInt dimension) {
        return this.getTeamChunks(team, dimension, false);
    }

    public static boolean canAttackEntity(EntityPlayer player, Entity target) {
        if (!ClaimedChunks.isActive() || player.field_70170_p == null || !(player instanceof EntityPlayerMP)) {
            return true;
        }
        if (target instanceof EntityPlayer) {
            if (ServerUtilitiesConfig.world.safe_spawn && player.field_70170_p.field_73011_w.field_76574_g == 0 && ServerUtilitiesUniverseData.isInSpawn(ClaimedChunks.instance.universe.server, new ChunkDimPos(target))) {
                return false;
            }
            if (ServerUtilitiesConfig.world.enable_pvp.isDefault()) {
                return ServerUtilitiesPlayerData.get(ClaimedChunks.instance.universe.getPlayer((ICommandSender)player)).enablePVP() && ServerUtilitiesPlayerData.get(ClaimedChunks.instance.universe.getPlayer((ICommandSender)((EntityPlayer)target))).enablePVP();
            }
            return ServerUtilitiesConfig.world.enable_pvp.isTrue();
        }
        if (!(target instanceof IMob)) {
            ClaimedChunk chunk = instance.getChunk(new ChunkDimPos(target));
            return chunk == null || PermissionAPI.hasPermission(player, "serverutilities.claims.attack_animals") || chunk.getTeam().hasStatus(ClaimedChunks.instance.universe.getPlayer((ICommandSender)player), chunk.getData().getAttackEntitiesStatus());
        }
        return true;
    }

    public static boolean blockBlockEditing(EntityPlayer player, int x, int y, int z, int meta) {
        if (!(ClaimedChunks.isActive() && player.field_70170_p != null && player instanceof EntityPlayerMP && ServerUtilitiesConfig.teams.grief_protection)) {
            return false;
        }
        if (meta == 0) {
            meta = player.field_70170_p.func_72805_g(x, y, z);
        }
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        ClaimedChunk chunk = instance.getChunk(new ChunkDimPos(x, y, z, player.field_71093_bK));
        return chunk != null && !ServerUtilitiesPermissions.hasBlockEditingPermission(player, block) && !chunk.getTeam().hasStatus(ClaimedChunks.instance.universe.getPlayer((ICommandSender)player), chunk.getData().getEditBlocksStatus());
    }

    public static boolean blockBlockInteractions(EntityPlayer player, int x, int y, int z, int meta) {
        if (!(ClaimedChunks.isActive() && player.field_70170_p != null && player instanceof EntityPlayerMP && ServerUtilitiesConfig.teams.interaction_protection)) {
            return false;
        }
        if (meta == 0) {
            meta = player.field_70170_p.func_72805_g(x, y, z);
        }
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        ClaimedChunk chunk = instance.getChunk(new ChunkDimPos(x, y, z, player.field_71093_bK));
        return chunk != null && !ServerUtilitiesPermissions.hasBlockInteractionPermission(player, block) && !chunk.getTeam().hasStatus(ClaimedChunks.instance.universe.getPlayer((ICommandSender)player), chunk.getData().getInteractWithBlocksStatus());
    }

    public static boolean blockItemUse(EntityPlayer player, int x, int y, int z) {
        if (!(ClaimedChunks.isActive() && player.field_70170_p != null && player instanceof EntityPlayerMP && player.func_70694_bm() != null && ServerUtilitiesConfig.teams.grief_protection)) {
            return false;
        }
        ClaimedChunk chunk = instance.getChunk(new ChunkDimPos(x, y, z, player.field_71093_bK));
        return chunk != null && !ServerUtilitiesPermissions.hasItemUsePermission(player, player.func_70694_bm().func_77973_b()) && !chunk.getTeam().hasStatus(ClaimedChunks.instance.universe.getPlayer((ICommandSender)player), chunk.getData().getUseItemsStatus());
    }

    public boolean canPlayerModify(ForgePlayer player, ChunkDimPos pos, String perm) {
        ClaimedChunk chunk = this.getChunk(pos);
        if (chunk == null) {
            return true;
        }
        if (ServerUtilitiesConfig.world.blockDimension(pos.dim)) {
            return false;
        }
        return player.hasTeam() && chunk.getTeam().equalsTeam(player.team) || perm.isEmpty() || player.hasPermission(perm);
    }

    public ClaimResult claimChunk(ForgePlayer player, ChunkDimPos pos) {
        return this.claimChunk(player, pos, true);
    }

    public ClaimResult claimChunk(ForgePlayer player, ChunkDimPos pos, boolean checkLimits) {
        int max;
        if (!player.hasTeam()) {
            return ClaimResult.NO_TEAM;
        }
        if (checkLimits && ServerUtilitiesConfig.world.blockDimension(pos.dim)) {
            return ClaimResult.DIMENSION_BLOCKED;
        }
        ServerUtilitiesTeamData data = ServerUtilitiesTeamData.get(player.team);
        if (checkLimits && !player.hasPermission("serverutilities.claims.bypass_limits") && ((max = data.getMaxClaimChunks()) == 0 || this.getTeamChunks(data.team, OptionalInt.empty(), true).size() >= max)) {
            return ClaimResult.NO_POWER;
        }
        ClaimedChunk chunk = this.getChunk(pos);
        if (chunk != null) {
            return ClaimResult.ALREADY_CLAIMED;
        }
        if (checkLimits && new ChunkModifiedEvent.Claim(pos, player).post()) {
            return ClaimResult.BLOCKED;
        }
        chunk = new ClaimedChunk(pos, data);
        this.addChunk(chunk);
        new ChunkModifiedEvent.Claimed(chunk, player).post();
        return ClaimResult.SUCCESS;
    }

    public boolean unclaimChunk(@Nullable ForgePlayer player, ChunkDimPos pos) {
        ClaimedChunk chunk = this.map.get(pos);
        if (chunk != null && !chunk.isInvalid()) {
            if (chunk.isLoaded()) {
                new ChunkModifiedEvent.Unloaded(chunk, player).post();
            }
            chunk.setLoaded(false);
            new ChunkModifiedEvent.Unclaimed(chunk, player).post();
            this.removeChunk(pos);
            return true;
        }
        return false;
    }

    public void unclaimAllChunks(@Nullable ForgePlayer player, ForgeTeam team, OptionalInt dim) {
        for (ClaimedChunk chunk : this.getTeamChunks(team, dim)) {
            ChunkDimPos pos = chunk.getPos();
            if (chunk.isLoaded()) {
                new ChunkModifiedEvent.Unloaded(chunk, player).post();
            }
            chunk.setLoaded(false);
            new ChunkModifiedEvent.Unclaimed(chunk, player).post();
            this.removeChunk(pos);
        }
    }

    public boolean loadChunk(@Nullable ForgePlayer player, ForgeTeam team, ChunkDimPos pos) {
        ClaimedChunk chunk = this.getChunk(pos);
        if (chunk == null || chunk.isLoaded()) {
            return false;
        }
        int max = ServerUtilitiesTeamData.get(team).getMaxChunkloaderChunks();
        if (max == 0) {
            return false;
        }
        int loadedChunks = 0;
        for (ClaimedChunk c : this.getTeamChunks(team, OptionalInt.empty())) {
            if (!c.isLoaded() || ++loadedChunks < max) continue;
            return false;
        }
        if (chunk.setLoaded(true)) {
            new ChunkModifiedEvent.Loaded(chunk, player).post();
        }
        return true;
    }

    public boolean unloadChunk(@Nullable ForgePlayer player, ChunkDimPos pos) {
        ClaimedChunk chunk = this.getChunk(pos);
        if (chunk == null || !chunk.isLoaded()) {
            return false;
        }
        new ChunkModifiedEvent.Unloaded(chunk, player).post();
        chunk.setLoaded(false);
        return true;
    }

    public void forceSave() {
        forceSave = true;
    }

    public static boolean isForcedToSave() {
        return instance != null && forceSave;
    }

    static {
        forceSave = false;
    }
}

