/*
 * Decompiled with CFR 0.152.
 */
package serverutils.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.util.INBTSerializable;
import serverutils.lib.util.StringUtils;

public final class BlockDimPosStorage
implements INBTSerializable<NBTTagCompound> {
    private final Map<String, BlockDimPos> map = new HashMap<String, BlockDimPos>();
    private final List<String> names = new ArrayList<String>();

    public Collection<String> list() {
        return this.names;
    }

    @Nullable
    public BlockDimPos get(String s) {
        return this.map.get(s);
    }

    public boolean set(String name, @Nullable BlockDimPos pos) {
        if (pos == null) {
            if (this.map.remove(name) != null) {
                this.names.remove(name);
                return true;
            }
            return false;
        }
        if (this.map.put(name, pos.copy()) == null) {
            this.names.add(name);
            this.names.sort(StringUtils.IGNORE_CASE_COMPARATOR);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry<String, BlockDimPos> entry : this.map.entrySet()) {
            nbt.func_74783_a(entry.getKey().toLowerCase(), entry.getValue().toIntArray());
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        this.map.clear();
        this.names.clear();
        for (String name : nbt.func_150296_c()) {
            BlockDimPos pos = BlockDimPos.fromIntArray(nbt.func_74759_k(name));
            if (pos == null) continue;
            this.map.put(name.toLowerCase(), pos);
        }
        this.names.addAll(this.map.keySet());
        this.names.sort(StringUtils.IGNORE_CASE_COMPARATOR);
    }
}

