/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.tp;

import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.data.TeleportType;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.math.TeleporterDimPos;
import serverutils.lib.util.permission.PermissionAPI;

public class CmdSpawn
extends CmdBase {
    public CmdSpawn() {
        super("spawn", CmdBase.Level.ALL);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = CmdSpawn.func_71521_c((ICommandSender)sender);
        if (player.field_71093_bK != ServerUtilitiesConfig.world.spawn_dimension && !PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.spawn.cross_dim")) {
            throw ServerUtilities.error(sender, "serverutilities.lang.warps.cross_dim", new Object[0]);
        }
        ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(CommandUtils.getForgePlayer((ICommandSender)player));
        data.checkTeleportCooldown(sender, TeleportType.SPAWN);
        data.teleport(this.getSpawnTeleporter(), TeleportType.SPAWN, null);
    }

    private TeleporterDimPos getSpawnTeleporter() {
        WorldServer w = DimensionManager.getWorld((int)ServerUtilitiesConfig.world.spawn_dimension);
        ChunkCoordinates spawnpoint = w.func_72861_E();
        while (w.func_147439_a(spawnpoint.field_71574_a, spawnpoint.field_71572_b, spawnpoint.field_71573_c).func_149721_r()) {
            spawnpoint.field_71572_b += 2;
        }
        return new BlockDimPos(spawnpoint, ServerUtilitiesConfig.world.spawn_dimension).teleporter();
    }
}

