/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.client.PixelBuffer;
import serverutils.lib.icon.Color4I;
import serverutils.lib.math.MathUtils;

public class ThreadReloadChunkSelector
extends Thread {
    private static ByteBuffer pixelBuffer = null;
    private static final int PIXEL_SIZE = 256;
    private static final PixelBuffer PIXELS = new PixelBuffer(256, 256);
    private static final Map<Pair<Block, Integer>, Color4I> COLOR_CACHE = new HashMap<Pair<Block, Integer>, Color4I>();
    private static final ChunkCoordinates CURRENT_BLOCK_POS = new ChunkCoordinates(0, 0, 0);
    private static World world = null;
    private static final Function<Pair<Block, Integer>, Color4I> COLOR_GETTER = state1 -> Color4I.rgb(ThreadReloadChunkSelector.getBlockColor0((Pair<Block, Integer>)state1));
    private static ThreadReloadChunkSelector instance;
    private static int textureID;
    private static final int[] HEIGHT_MAP;
    private final int startX;
    private final int startZ;
    private boolean cancelled = false;

    static int getTextureId() {
        if (textureID == -1) {
            textureID = TextureUtil.func_110996_a();
        }
        return textureID;
    }

    static void updateTexture() {
        if (pixelBuffer != null) {
            GlStateManager.bindTexture(ThreadReloadChunkSelector.getTextureId());
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)256, (int)256, (int)0, (int)6408, (int)5121, (ByteBuffer)pixelBuffer);
            pixelBuffer = null;
        }
    }

    static void reloadArea(World w, int sx, int sz) {
        if (instance != null) {
            ThreadReloadChunkSelector.instance.cancelled = true;
            instance = null;
        }
        instance = new ThreadReloadChunkSelector(w, sx, sz);
        ThreadReloadChunkSelector.instance.cancelled = false;
        instance.start();
        COLOR_CACHE.clear();
    }

    private ThreadReloadChunkSelector(World w, int sx, int sz) {
        super("ChunkSelectorAreaReloader");
        this.setDaemon(true);
        world = w;
        this.startX = sx;
        this.startZ = sz;
    }

    private static int getBlockColor0(Pair<Block, Integer> state) {
        Block b = (Block)state.getLeft();
        if (b == Blocks.field_150322_A || b == Blocks.field_150377_bs) {
            return MapColor.field_151658_d.field_76291_p;
        }
        if (b == Blocks.field_150480_ab) {
            return MapColor.field_151645_D.field_76291_p;
        }
        if (b == Blocks.field_150327_N) {
            return MapColor.field_151673_t.field_76291_p;
        }
        if (b == Blocks.field_150353_l) {
            return MapColor.field_151676_q.field_76291_p;
        }
        if (b == Blocks.field_150343_Z) {
            return 1376327;
        }
        if (b == Blocks.field_150351_n) {
            return 9279387;
        }
        if (b == Blocks.field_150349_c) {
            return 0x549954;
        }
        if (b == Blocks.field_150478_aa) {
            return 16753968;
        }
        if (b == Blocks.field_150424_aL || b == Blocks.field_150449_bY) {
            return 8327969;
        }
        if (b == Blocks.field_150328_O) {
            switch ((Integer)state.getRight()) {
                case 0: {
                    return MapColor.field_151645_D.field_76291_p;
                }
                case 1: {
                    return MapColor.field_151674_s.field_76291_p;
                }
                case 2: {
                    return MapColor.field_151675_r.field_76291_p;
                }
                case 3: {
                    return MapColor.field_151680_x.field_76291_p;
                }
                case 4: {
                    return MapColor.field_151645_D.field_76291_p;
                }
                case 5: {
                    return MapColor.field_151676_q.field_76291_p;
                }
                case 6: {
                    return MapColor.field_151666_j.field_76291_p;
                }
                case 7: {
                    return MapColor.field_151671_v.field_76291_p;
                }
                case 8: {
                    return MapColor.field_151680_x.field_76291_p;
                }
            }
        } else if (b == Blocks.field_150344_f) {
            switch ((Integer)state.getRight()) {
                case 0: {
                    return 13015113;
                }
                case 1: {
                    return 8150574;
                }
                case 2: {
                    return 15917203;
                }
                case 3: {
                    return 13006419;
                }
                case 4: {
                    return 14712638;
                }
                case 5: {
                    return 5319956;
                }
            }
        }
        return ((Block)state.getLeft()).func_149728_f((int)((Integer)state.getRight()).intValue()).field_76291_p;
    }

    private static int getHeight(int x, int z) {
        int index = x + z * 256;
        return index < 0 || index >= HEIGHT_MAP.length ? -1 : HEIGHT_MAP[index];
    }

    @Override
    public void run() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        Arrays.fill(PIXELS.getPixels(), Color4I.rgb(world.func_72833_a((Entity)player, 0.0f)).rgba());
        Arrays.fill(HEIGHT_MAP, -1);
        pixelBuffer = PIXELS.toByteBuffer(false);
        int startY = (int)player.func_70666_h((float)1.0f).field_72448_b;
        try {
            Pair state;
            int by;
            int wz;
            int wx;
            int wi;
            int z;
            int x;
            Chunk chunk;
            int cz;
            int cx;
            ChunkCoordIntPair pos;
            World w;
            int index;
            for (index = 0; index < 226 && (w = world) != null; ++index) {
                pos = MathUtils.getSpiralPoint(index);
                if (pos == null) continue;
                cx = pos.field_77276_a + 7;
                cz = pos.field_77275_b + 7;
                chunk = w.func_72863_F().func_73154_d(this.startX + cx, this.startZ + cz);
                if (chunk == null) continue;
                x = this.startX + cx << 4;
                z = this.startZ + cz << 4;
                int topY = w.field_73011_w.field_76574_g == -1 ? startY + 5 : Math.max(w.func_72940_L(), chunk.func_76625_h() + 15);
                block3: for (wi = 0; wi < 256; ++wi) {
                    wx = wi % 16;
                    wz = wi / 16;
                    for (by = topY; by > 0; --by) {
                        if (this.cancelled) {
                            return;
                        }
                        CURRENT_BLOCK_POS.func_71571_b(x + wx, by, z + wz);
                        state = Pair.of((Object)chunk.func_150810_a(wx, by, wz), (Object)chunk.func_76628_c(wx, by, wz));
                        if (state.getLeft() == Blocks.field_150329_H || ((Block)state.getLeft()).isAir((IBlockAccess)w, ThreadReloadChunkSelector.CURRENT_BLOCK_POS.field_71574_a, ThreadReloadChunkSelector.CURRENT_BLOCK_POS.field_71572_b, ThreadReloadChunkSelector.CURRENT_BLOCK_POS.field_71573_c)) continue;
                        ThreadReloadChunkSelector.HEIGHT_MAP[cx * 16 + wx + (cz * 16 + wz) * 256] = by;
                        continue block3;
                    }
                }
            }
            for (index = 0; index < 226 && (w = world) != null; ++index) {
                pos = MathUtils.getSpiralPoint(index);
                if (pos == null) continue;
                cx = pos.field_77276_a + 7;
                cz = pos.field_77275_b + 7;
                chunk = w.func_72863_F().func_73154_d(this.startX + cx, this.startZ + cz);
                if (chunk == null) continue;
                x = this.startX + cx << 4;
                z = this.startZ + cz << 4;
                for (wi = 0; wi < 256; ++wi) {
                    wx = wi % 16;
                    wz = wi / 16;
                    by = ThreadReloadChunkSelector.getHeight(cx * 16 + wx, cz * 16 + wz);
                    if (by < 0) continue;
                    CURRENT_BLOCK_POS.func_71571_b(x + wx, by, z + wz);
                    state = Pair.of((Object)chunk.func_150810_a(wx, by, wz), (Object)chunk.func_76628_c(wx, by, wz));
                    Color4I color = COLOR_CACHE.computeIfAbsent((Pair<Block, Integer>)state, COLOR_GETTER).addBrightness(MathUtils.RAND.nextFloat() * 0.04f);
                    int bn = ThreadReloadChunkSelector.getHeight(cx * 16 + wx, cz * 16 + wz - 1);
                    int bw = ThreadReloadChunkSelector.getHeight(cx * 16 + wx - 1, cz * 16 + wz);
                    if (by > bn && bn != -1 || by > bw && bw != -1) {
                        color = color.addBrightness(0.1f);
                    }
                    if (by < bn && bn != -1 || by < bw && bw != -1) {
                        color = color.addBrightness(-0.1f);
                    }
                    PIXELS.setRGB(cx * 16 + wx, cz * 16 + wz, color.rgba());
                }
                pixelBuffer = PIXELS.toByteBuffer(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        pixelBuffer = PIXELS.toByteBuffer(false);
        world = null;
        instance = null;
    }

    static {
        textureID = -1;
        HEIGHT_MAP = new int[65536];
    }
}

