/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.ChunkCoordIntPair;
import org.lwjgl.opengl.GL11;
import serverutils.client.ServerUtilitiesClientConfig;
import serverutils.client.gui.ClientClaimedChunks;
import serverutils.lib.EnumTeamColor;
import serverutils.lib.client.CachedVertexData;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.misc.ChunkSelectorMap;
import serverutils.lib.gui.misc.GuiChunkSelectorBase;
import serverutils.lib.icon.Icon;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.misc.MouseButton;
import serverutils.net.MessageClaimedChunksModify;
import serverutils.net.MessageClaimedChunksRequest;
import serverutils.net.MessageClaimedChunksUpdate;

public class GuiClaimedChunks
extends GuiChunkSelectorBase {
    public static final ClientClaimedChunks.ChunkData[] chunkData = new ClientClaimedChunks.ChunkData[225];
    private static final ClientClaimedChunks.ChunkData NULL_CHUNK_DATA = new ClientClaimedChunks.ChunkData(new ClientClaimedChunks.Team(0), 0);
    public static final CachedVertexData AREA = new CachedVertexData(7, false, true, false);
    public static final CachedVertexData LINES = new CachedVertexData(1, false, true, false);
    public static GuiClaimedChunks instance;
    public static int claimedChunks;
    public static int loadedChunks;
    public static int maxClaimedChunks;
    public static int maxLoadedChunks;
    private final String currentDimName;

    public GuiClaimedChunks() {
        this.currentDimName = ServerUtils.getDimensionName(Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g).func_150254_d();
    }

    @Nullable
    public static ClientClaimedChunks.ChunkData getAt(int x, int y) {
        int i = x + y * 15;
        return i < 0 || i >= chunkData.length ? null : chunkData[i];
    }

    public static boolean hasBorder(ClientClaimedChunks.ChunkData data, @Nullable ClientClaimedChunks.ChunkData with) {
        if (with == null) {
            with = NULL_CHUNK_DATA;
        }
        return (data.getFlags() != with.getFlags() || data.team != with.team) && !with.isLoaded();
    }

    @Override
    public void onPostInit() {
        new MessageClaimedChunksRequest(this.startX, this.startZ).sendToServer();
        ChunkSelectorMap.getMap().resetMap(this.startX, this.startZ);
    }

    public static void onChunkDataUpdate(MessageClaimedChunksUpdate m) {
        ClientClaimedChunks.ChunkData data;
        claimedChunks = m.claimedChunks;
        loadedChunks = m.loadedChunks;
        maxClaimedChunks = m.maxClaimedChunks;
        maxLoadedChunks = m.maxLoadedChunks;
        Arrays.fill(chunkData, null);
        for (ClientClaimedChunks.Team team : m.teams.values()) {
            for (Map.Entry entry : team.chunks.int2ObjectEntrySet()) {
                int x = (Integer)entry.getKey() % 15;
                int z = (Integer)entry.getKey() / 15;
                GuiClaimedChunks.chunkData[x + z * 15] = (ClientClaimedChunks.ChunkData)entry.getValue();
            }
        }
        AREA.reset();
        LINES.reset();
        EnumTeamColor prevCol = null;
        for (int i = 0; i < chunkData.length; ++i) {
            data = chunkData[i];
            if (data == null) continue;
            if (prevCol != data.team.color) {
                prevCol = data.team.color;
                GuiClaimedChunks.AREA.color.set(data.team.color.getColor(), 150);
            }
            AREA.rect(i % 15 * 12, i / 15 * 12, 12, 12);
        }
        for (int i = 0; i < chunkData.length; ++i) {
            boolean borderR;
            data = chunkData[i];
            if (data == null) continue;
            int x = i % 15;
            int dx = x * 12;
            int y = i / 15;
            int dy = y * 12;
            boolean borderU = y > 0 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x, y - 1));
            boolean borderD = y < 14 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x, y + 1));
            boolean borderL = x > 0 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x - 1, y));
            boolean bl = borderR = x < 14 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x + 1, y));
            if (data.isLoaded()) {
                GuiClaimedChunks.AREA.color.set(255, 80, 80, 230);
                if (ServerUtilitiesClientConfig.show_dotted_lines) {
                    int offset = 6;
                    GuiClaimedChunks.LINES.color.set(0, 0, 0, 90);
                    LINES.pos(dx, dy);
                    LINES.pos(dx + 12, dy + 12);
                    LINES.pos(dx, dy + offset);
                    LINES.pos(dx + offset, dy + 12);
                    LINES.pos(dx + offset, dy);
                    LINES.pos(dx + 12, dy + offset);
                }
            } else {
                GuiClaimedChunks.AREA.color.set(80, 80, 80, 230);
            }
            if (borderU) {
                AREA.rect(dx, dy, 12, 1, 1);
            }
            if (borderD) {
                AREA.rect(dx, dy + 12 - 1, 12, 1, 1);
            }
            if (borderL) {
                AREA.rect(dx, dy, 1, 12, 1);
            }
            if (!borderR) continue;
            AREA.rect(dx + 12 - 1, dy, 1, 12, 1);
        }
    }

    @Override
    public int getSelectionMode(MouseButton button) {
        boolean claim = !GuiClaimedChunks.isShiftKeyDown();
        boolean flag = button.isLeft();
        if (GuiClaimedChunks.isCtrlKeyDown()) {
            this.blockMode = true;
        }
        if (flag) {
            return claim ? 0 : 2;
        }
        return claim ? 1 : 3;
    }

    @Override
    public void onChunksSelected(Collection<ChunkCoordIntPair> chunks) {
        new MessageClaimedChunksModify(this.startX, this.startZ, this.currentSelectionMode, chunks).sendToServer();
    }

    @Override
    public void drawArea(Tessellator tessellator) {
        AREA.draw(tessellator);
        GL11.glEnable((int)2852);
        GL11.glLineStipple((int)3, (short)-21846);
        GL11.glLineWidth((float)0.8f);
        LINES.draw(tessellator);
        GL11.glDisable((int)2852);
        GL11.glLineWidth((float)1.0f);
    }

    @Override
    public void addCornerButtons(Panel panel) {
        panel.add(new ButtonSide(panel, I18n.func_135052_a((String)"gui.close", (Object[])new Object[0]), GuiIcons.ACCEPT){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                this.getGui().closeGui();
            }
        });
        panel.add(new ButtonSide(panel, I18n.func_135052_a((String)"selectServer.refresh", (Object[])new Object[0]), GuiIcons.REFRESH){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                new MessageClaimedChunksRequest(GuiClaimedChunks.this.startX, GuiClaimedChunks.this.startZ).sendToServer();
                ChunkSelectorMap.getMap().resetMap(GuiClaimedChunks.this.startX, GuiClaimedChunks.this.startZ);
            }
        });
        if (maxClaimedChunks >= 0) {
            panel.add(new ButtonSide(panel, I18n.func_135052_a((String)"serverutilities.lang.chunks.unclaim_all_dim", (Object[])new Object[]{this.currentDimName}), GuiIcons.REMOVE){

                @Override
                public void onClicked(MouseButton button) {
                    GuiHelper.playClickSound();
                    String s = I18n.func_135052_a((String)"serverutilities.lang.chunks.unclaim_all_dim_q", (Object[])new Object[]{GuiClaimedChunks.this.currentDimName});
                    GuiClaimedChunks.this.openYesNo(s, "", () -> ClientUtils.execClientCommand("/chunks unclaim_all " + Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g));
                }
            });
            panel.add(new ButtonSide(panel, I18n.func_135052_a((String)"serverutilities.lang.chunks.unclaim_all", (Object[])new Object[0]), GuiIcons.REMOVE){

                @Override
                public void onClicked(MouseButton button) {
                    GuiHelper.playClickSound();
                    String s = I18n.func_135052_a((String)"serverutilities.lang.chunks.unclaim_all_q", (Object[])new Object[0]);
                    GuiClaimedChunks.this.openYesNo(s, "", () -> ClientUtils.execClientCommand("/chunks unclaim_all"));
                }
            });
        }
        panel.add(new ButtonSide(panel, I18n.func_135052_a((String)"gui.info", (Object[])new Object[0]), GuiIcons.INFO){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                this.handleClick("https://github.com/GTNewHorizons/ServerUtilities/wiki");
            }
        });
    }

    @Override
    public void addCornerText(List<String> list, GuiChunkSelectorBase.Corner corner) {
        if (maxClaimedChunks < 0) {
            if (corner == GuiChunkSelectorBase.Corner.BOTTOM_RIGHT) {
                if (maxClaimedChunks == -2) {
                    list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"serverutilities.lang.team.error.no_team", (Object[])new Object[0]));
                } else {
                    list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"feature_disabled_server", (Object[])new Object[0]));
                }
            }
            return;
        }
        switch (corner) {
            case BOTTOM_RIGHT: {
                list.add(I18n.func_135052_a((String)"serverutilities.lang.chunks.claimed_count", (Object[])new Object[]{claimedChunks, maxClaimedChunks == Integer.MAX_VALUE ? "\u221e" : Integer.toString(maxClaimedChunks)}));
                list.add(I18n.func_135052_a((String)"serverutilities.lang.chunks.loaded_count", (Object[])new Object[]{loadedChunks, maxLoadedChunks == Integer.MAX_VALUE ? "\u221e" : Integer.toString(maxLoadedChunks)}));
            }
        }
    }

    @Override
    public void addButtonText(GuiChunkSelectorBase.MapButton button, List<String> list) {
        ClientClaimedChunks.ChunkData data = chunkData[button.index];
        if (data != null) {
            list.add(data.team.nameComponent.func_150254_d());
            list.add(EnumChatFormatting.GREEN + I18n.func_135052_a((String)"serverutilities.lang.chunks.claimed_area", (Object[])new Object[0]));
            if (data.isLoaded()) {
                list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"serverutilities.lang.chunks.upgrade.loaded", (Object[])new Object[0]));
            }
        } else {
            list.add(EnumChatFormatting.DARK_GREEN + I18n.func_135052_a((String)"serverutilities.lang.chunks.wilderness", (Object[])new Object[0]));
        }
        if (GuiClaimedChunks.isCtrlKeyDown()) {
            list.add(button.chunkPos.toString());
        }
    }

    private static abstract class ButtonSide
    extends Button {
        public ButtonSide(Panel panel, String text, Icon icon) {
            super(panel, text, icon);
            this.setSize(20, 20);
        }
    }
}

