/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.sodium.vertex_format.terrain_xhfp;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import java.nio.ByteBuffer;
import net.coderbot.iris.vertices.IrisQuadView;

public abstract class QuadViewTerrain
implements IrisQuadView {
    long writePointer;
    int stride;

    @Override
    public float x(int index) {
        return QuadViewTerrain.normalizeVertexPositionShortAsFloat(this.getShort(this.writePointer - (long)this.stride * (3L - (long)index)));
    }

    @Override
    public float y(int index) {
        return QuadViewTerrain.normalizeVertexPositionShortAsFloat(this.getShort(this.writePointer + 2L - (long)this.stride * (3L - (long)index)));
    }

    @Override
    public float z(int index) {
        return QuadViewTerrain.normalizeVertexPositionShortAsFloat(this.getShort(this.writePointer + 4L - (long)this.stride * (3L - (long)index)));
    }

    @Override
    public float u(int index) {
        return QuadViewTerrain.normalizeVertexTextureShortAsFloat(this.getShort(this.writePointer + 12L - (long)this.stride * (3L - (long)index)));
    }

    @Override
    public float v(int index) {
        return QuadViewTerrain.normalizeVertexTextureShortAsFloat(this.getShort(this.writePointer + 14L - (long)this.stride * (3L - (long)index)));
    }

    private static float normalizeVertexTextureShortAsFloat(short value) {
        return (float)(value & 0xFFFF) * 3.0517578E-5f;
    }

    private static float normalizeVertexPositionShortAsFloat(short value) {
        return (float)(value & 0xFFFF) * 1.5259022E-5f;
    }

    abstract short getShort(long var1);

    public static class QuadViewTerrainNio
    extends QuadViewTerrain {
        private ByteBuffer buffer;

        public void setup(ByteBuffer buffer, int writePointer, int stride) {
            this.buffer = buffer;
            this.writePointer = writePointer;
            this.stride = stride;
        }

        @Override
        short getShort(long writePointer) {
            return this.buffer.getShort((int)writePointer);
        }
    }

    public static class QuadViewTerrainUnsafe
    extends QuadViewTerrain {
        public void setup(long writePointer, int stride) {
            this.writePointer = writePointer;
            this.stride = stride;
        }

        @Override
        short getShort(long writePointer) {
            return MemoryUtilities.memGetShort((long)writePointer);
        }
    }
}

