/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.util.function.Supplier;
import net.coderbot.iris.gl.uniform.Uniform;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class Vector3Uniform
extends Uniform {
    private final Vector3f cachedValue = new Vector3f();
    private final Supplier<Vector3f> value;

    Vector3Uniform(int location, Supplier<Vector3f> value) {
        super(location);
        this.value = value;
    }

    static Vector3Uniform converted(int location, Supplier<Vector3d> value) {
        Vector3f held = new Vector3f();
        return new Vector3Uniform(location, () -> {
            Vector3d updated = (Vector3d)value.get();
            held.set((float)updated.x, (float)updated.y, (float)updated.z);
            return held;
        });
    }

    static Vector3Uniform truncated(int location, Supplier<Vector4f> value) {
        Vector3f held = new Vector3f();
        return new Vector3Uniform(location, () -> {
            Vector4f updated = (Vector4f)value.get();
            held.set(updated.x(), updated.y(), updated.z());
            return held;
        });
    }

    @Override
    public void update() {
        Vector3f newValue = this.value.get();
        if (!newValue.equals((Object)this.cachedValue)) {
            this.cachedValue.set(newValue.x(), newValue.y(), newValue.z());
            RenderSystem.uniform3f(this.location, this.cachedValue.x(), this.cachedValue.y(), this.cachedValue.z());
        }
    }
}

