/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.common.util.collections;

import com.gtnewhorizons.angelica.rendering.AngelicaRenderQueue;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;

public class FutureDequeDrain<T>
implements Iterator<T> {
    private final Deque<CompletableFuture<T>> deque;
    private T next = null;

    public FutureDequeDrain(Deque<CompletableFuture<T>> deque) {
        this.deque = deque;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        this.findNext();
        return this.next != null;
    }

    private void findNext() {
        while (!this.deque.isEmpty()) {
            CompletableFuture<T> future = this.deque.remove();
            try {
                AngelicaRenderQueue.managedBlock(future::isDone);
                this.next = future.join();
                return;
            }
            catch (CancellationException cancellationException) {
            }
        }
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.next;
        this.next = null;
        return result;
    }
}

