/*
 * Decompiled with CFR 0.152.
 */
package jss.notfine.core;

import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLights;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLightsMode;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import jss.notfine.core.SettingsManager;
import jss.notfine.gui.options.control.NotFineControlValueFormatter;
import jss.notfine.gui.options.named.AlwaysNever;
import jss.notfine.gui.options.named.BackgroundSelect;
import jss.notfine.gui.options.named.DownfallQuality;
import jss.notfine.gui.options.named.GraphicsQualityOff;
import jss.notfine.gui.options.named.GraphicsToggle;
import jss.notfine.gui.options.named.LeavesQuality;
import jss.notfine.gui.options.storage.NotFineMinecraftOptionsStorage;
import jss.notfine.render.RenderStars;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.named.GraphicsQuality;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.MathHelper;

@SideOnly(value=Side.CLIENT)
public enum Settings {
    CLOUD_HEIGHT((NotFineOption)new NotFineOptionSlider(128, 96, 384, 8, null, new OptionFlag[0])){

        @Override
        public void applyChanges() {
            SettingsManager.cloudsUpdated();
        }
    }
    ,
    CLOUD_SCALE(new NotFineOptionSlider(1, 1, 3, 1, null, new OptionFlag[0])),
    DOWNFALL_DISTANCE(new NotFineOptionCycling<DownfallQuality>(DownfallQuality.DEFAULT, OptionImpact.MEDIUM, new OptionFlag[0])){

        @Override
        public void applyChanges() {
            SettingsManager.downfallDistanceUpdated();
        }
    }
    ,
    DYNAMIC_FOV(new NotFineOptionTickBox(true, null, new OptionFlag[0])),
    DYNAMIC_LIGHTS(new NotFineOptionCycling<DynamicLightsMode>(DynamicLightsMode.FANCY, OptionImpact.VARIES, new OptionFlag[0])){

        @Override
        public void applyChanges() {
            DynamicLights.Mode = (DynamicLightsMode)((Object)this.option.getStore());
        }
    }
    ,
    DYNAMIC_LIGHTS_SHADER_FORCE((NotFineOption)new NotFineOptionTickBox(false, OptionImpact.VARIES, new OptionFlag[0])){

        @Override
        public void applyChanges() {
            DynamicLights.ShaderForce = (Boolean)this.option.getStore();
        }
    }
    ,
    FOG_DISABLE(new NotFineOptionTickBox(false, OptionImpact.LOW, new OptionFlag[0])),
    FOG_NEAR_DISTANCE(new NotFineOptionSliderPercentage(75, 1, 100, 1, OptionImpact.LOW, new OptionFlag[0])),
    GUI_BACKGROUND(new NotFineOptionCycling<BackgroundSelect>(BackgroundSelect.DEFAULT, null, new OptionFlag[0])){

        @Override
        public void applyChanges() {
            SettingsManager.backgroundUpdated();
        }
    }
    ,
    MODE_CLOUD_TRANSLUCENCY(new NotFineOptionCycling<AlwaysNever>(AlwaysNever.DEFAULT, null, new OptionFlag[0])){

        @Override
        public void applyChanges() {
            SettingsManager.cloudsUpdated();
        }
    }
    ,
    MODE_CLOUDS(new NotFineOptionCycling<GraphicsQualityOff>(GraphicsQualityOff.DEFAULT, OptionImpact.MEDIUM, new OptionFlag[0])){

        @Override
        public void applyChanges() {
            SettingsManager.cloudsUpdated();
        }
    }
    ,
    MODE_DROPPED_ITEMS(new NotFineOptionCycling<GraphicsQuality>(GraphicsQuality.DEFAULT, OptionImpact.LOW, new OptionFlag[0])){

        @Override
        public void applyChanges() {
            SettingsManager.droppedItemDetailUpdated();
        }
    }
    ,
    MODE_GLINT_INV(new NotFineOptionTickBox(true, OptionImpact.VARIES, new OptionFlag[0])),
    MODE_GLINT_WORLD(new NotFineOptionTickBox(true, OptionImpact.VARIES, new OptionFlag[0])),
    MODE_GUI_BACKGROUND(new NotFineOptionTickBox(true, null, new OptionFlag[0])),
    MODE_LEAVES(new NotFineOptionCycling<LeavesQuality>(LeavesQuality.DEFAULT, OptionImpact.VARIES, OptionFlag.REQUIRES_RENDERER_RELOAD)){

        @Override
        public void applyChanges() {
            SettingsManager.leavesUpdated();
        }
    }
    ,
    MODE_LIGHT_FLICKER(new NotFineOptionTickBox(true, OptionImpact.LOW, new OptionFlag[0])),
    MODE_SHADOWS(new NotFineOptionCycling<GraphicsToggle>(GraphicsToggle.DEFAULT, OptionImpact.LOW, new OptionFlag[0])){

        @Override
        public void applyChanges() {
            SettingsManager.shadowsUpdated();
        }
    }
    ,
    MODE_SKY(new NotFineOptionTickBox(true, OptionImpact.LOW, new OptionFlag[0])),
    MODE_STARS(new NotFineOptionTickBox(true, OptionImpact.LOW, new OptionFlag[0])),
    MODE_SUN_MOON(new NotFineOptionTickBox(true, OptionImpact.LOW, new OptionFlag[0])),
    MODE_WATER(new NotFineOptionCycling<GraphicsQuality>(GraphicsQuality.DEFAULT, OptionImpact.LOW, new OptionFlag[0])){

        @Override
        public void applyChanges() {
            SettingsManager.waterDetailUpdated();
        }
    }
    ,
    MODE_VIGNETTE(new NotFineOptionCycling<GraphicsToggle>(GraphicsToggle.DEFAULT, OptionImpact.LOW, new OptionFlag[0])){

        @Override
        public void applyChanges() {
            SettingsManager.vignetteUpdated();
        }
    }
    ,
    PARTICLES_ENC_TABLE(new NotFineOptionSlider(1, 0, 16, 1, OptionImpact.LOW, new OptionFlag[0])),
    PARTICLES_VOID(new NotFineOptionTickBox(true, OptionImpact.LOW, new OptionFlag[0])),
    RENDER_DISTANCE_CLOUDS((NotFineOption)new NotFineOptionSlider(4, 4, 64, 1, OptionImpact.VARIES, new OptionFlag[0])){

        @Override
        public void applyChanges() {
            SettingsManager.cloudsUpdated();
        }
    }
    ,
    TOTAL_STARS((NotFineOption)new NotFineOptionSlider(1500, 500, 32000, 500, OptionImpact.LOW, new OptionFlag[0])){

        @Override
        public void applyChanges() {
            RenderStars.reloadStarRenderList(Minecraft.func_71410_x().field_71438_f);
        }
    }
    ,
    VOID_FOG(new NotFineOptionTickBox(false, OptionImpact.LOW, new OptionFlag[0]));

    public final NotFineOption<?> option;

    private Settings(NotFineOption<?> option) {
        this.option = option;
    }

    public void ready() {
        this.option.setting = this;
    }

    public void applyChanges() {
    }

    public static abstract class NotFineOption<T>
    implements Option<T> {
        private static final NotFineMinecraftOptionsStorage optionStorage = new NotFineMinecraftOptionsStorage();
        private final OptionImpact impact;
        private final EnumSet<OptionFlag> optionFlags = EnumSet.noneOf(OptionFlag.class);
        protected final T base;
        protected T value;
        protected T modifiedValue;
        protected T store;
        protected Settings setting;

        protected NotFineOption(T base, OptionImpact impact, OptionFlag ... optionFlags) {
            this.value = base;
            this.modifiedValue = base;
            this.store = base;
            this.base = base;
            this.impact = impact;
            Collections.addAll(this.optionFlags, optionFlags);
        }

        public abstract void deserialize(String var1);

        public T getStore() {
            return this.store;
        }

        @Override
        public String getName() {
            return I18n.func_135052_a((String)("options." + this.setting.name().toLowerCase()), (Object[])new Object[0]);
        }

        @Override
        public String getTooltip() {
            return I18n.func_135052_a((String)("options." + this.setting.name().toLowerCase() + ".tooltip"), (Object[])new Object[0]);
        }

        @Override
        public OptionImpact getImpact() {
            return this.impact;
        }

        @Override
        public T getValue() {
            return this.modifiedValue;
        }

        @Override
        public void setValue(T value) {
            this.modifiedValue = value;
        }

        @Override
        public void reset() {
            this.value = this.store;
            this.modifiedValue = this.store;
        }

        @Override
        public OptionStorage<?> getStorage() {
            return optionStorage;
        }

        @Override
        public boolean isAvailable() {
            return AngelicaConfig.enableNotFineFeatures;
        }

        @Override
        public boolean hasChanged() {
            return !this.value.equals(this.modifiedValue);
        }

        @Override
        public void applyChanges() {
            this.store = this.modifiedValue;
            this.value = this.modifiedValue;
            this.setting.applyChanges();
        }

        @Override
        public Collection<OptionFlag> getFlags() {
            return this.optionFlags;
        }
    }

    public static class NotFineOptionSlider
    extends NotFineOption<Integer> {
        public final int min;
        public final int max;
        public final int step;

        protected NotFineOptionSlider(int base, int min, int max, int step, OptionImpact impact, OptionFlag ... optionFlags) {
            super(base, impact, optionFlags);
            this.min = min;
            this.max = max;
            this.step = step;
        }

        @Override
        public Control<Integer> getControl() {
            return new SliderControl(this, this.min, this.max, this.step, ControlValueFormatter.number());
        }

        @Override
        public void deserialize(String fragment) {
            int deserialized = Integer.parseInt(fragment);
            deserialized = MathHelper.func_76125_a((int)deserialized, (int)this.min, (int)this.max);
            if (this.step > 1) {
                deserialized = this.step * Math.round((float)deserialized / (float)this.step);
            }
            this.value = this.store = Integer.valueOf(deserialized);
            this.modifiedValue = this.store;
        }
    }

    public static class NotFineOptionCycling<T extends Enum<T>>
    extends NotFineOption<T> {
        protected NotFineOptionCycling(T base, OptionImpact impact, OptionFlag ... optionFlags) {
            super(base, impact, optionFlags);
        }

        @Override
        public void deserialize(String fragment) {
            this.value = this.store = Enum.valueOf(((Enum)this.value).getDeclaringClass(), fragment);
            this.modifiedValue = this.store;
        }

        @Override
        public Control<T> getControl() {
            return new CyclingControl(this, ((Enum)this.value).getDeclaringClass());
        }
    }

    public static class NotFineOptionTickBox
    extends NotFineOption<Boolean> {
        protected NotFineOptionTickBox(boolean base, OptionImpact impact, OptionFlag ... optionFlags) {
            super(base, impact, optionFlags);
        }

        @Override
        public Control<Boolean> getControl() {
            return new TickBoxControl(this);
        }

        @Override
        public void deserialize(String fragment) {
            this.value = this.store = Boolean.valueOf(Boolean.parseBoolean(fragment));
            this.modifiedValue = this.store;
        }
    }

    public static class NotFineOptionSliderPercentage
    extends NotFineOptionSlider {
        protected NotFineOptionSliderPercentage(int base, int min, int max, int step, OptionImpact impact, OptionFlag ... optionFlags) {
            super(base, min, max, step, impact, optionFlags);
        }

        @Override
        public Control<Integer> getControl() {
            return new SliderControl(this, this.min, this.max, this.step, NotFineControlValueFormatter.percentage());
        }
    }
}

