/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.ctm.BlockOrientation;
import com.prupe.mcpatcher.ctm.GlassPaneRenderer;
import com.prupe.mcpatcher.ctm.TileOverride;
import com.prupe.mcpatcher.ctm.TileOverrideIterator;
import com.prupe.mcpatcher.mal.block.BlockAPI;
import com.prupe.mcpatcher.mal.block.BlockStateMatcher;
import com.prupe.mcpatcher.mal.block.RenderBlocksUtils;
import com.prupe.mcpatcher.mal.block.RenderPassAPI;
import com.prupe.mcpatcher.mal.resource.BlendMethod;
import com.prupe.mcpatcher.mal.resource.ResourceList;
import com.prupe.mcpatcher.mal.resource.TexturePackChangeHandler;
import com.prupe.mcpatcher.mal.tile.TileLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jss.notfine.config.MCPatcherForgeConfig;
import net.minecraft.block.Block;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;

public class CTMUtils {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.CONNECTED_TEXTURES, "CTM");
    private static final List<TileOverride> allOverrides = new ArrayList<TileOverride>();
    private static final Map<Block, List<BlockStateMatcher>> blockOverrides = new IdentityHashMap<Block, List<BlockStateMatcher>>();
    private static final Map<String, List<TileOverride>> tileOverrides = new HashMap<String, List<TileOverride>>();
    private static TileLoader tileLoader;
    private static TileOverride lastOverride;
    private static final TileOverrideIterator.IJK ijkIterator;
    private static final TileOverrideIterator.Metadata metadataIterator;
    private static boolean haveBlockFace;
    private static final BlockOrientation renderBlockState;

    private static void clearBlockFace() {
        haveBlockFace = false;
    }

    public static synchronized IIcon getBlockIcon(IIcon icon, Block block, IBlockAccess blockAccess, int x, int y, int z, int face) {
        lastOverride = null;
        if (blockAccess != null && CTMUtils.checkFace(face)) {
            if (!haveBlockFace) {
                renderBlockState.setBlock(block, blockAccess, x, y, z);
                renderBlockState.setFace(face);
            }
            if ((lastOverride = ijkIterator.go(renderBlockState, icon)) != null) {
                icon = ijkIterator.getIcon();
            }
        }
        CTMUtils.clearBlockFace();
        return lastOverride == null && CTMUtils.skipDefaultRendering(block) ? RenderBlocksUtils.blankIcon : icon;
    }

    public static synchronized IIcon getBlockIcon(IIcon icon, Block block, int face, int metadata) {
        lastOverride = null;
        if (CTMUtils.checkFace(face) && CTMUtils.checkRenderType(block)) {
            renderBlockState.setBlockMetadata(block, metadata, face);
            lastOverride = metadataIterator.go(renderBlockState, icon);
            if (lastOverride != null) {
                icon = metadataIterator.getIcon();
            }
        }
        return icon;
    }

    public static IIcon getBlockIcon(IIcon icon, Block block, int face) {
        return CTMUtils.getBlockIcon(icon, block, face, 0);
    }

    public static void reset() {
    }

    private static boolean checkFace(int face) {
        return face < 0 ? MCPatcherForgeConfig.ConnectedTextures.nonStandard : MCPatcherForgeConfig.ConnectedTextures.standard;
    }

    private static boolean checkRenderType(Block block) {
        boolean bl;
        switch (block.func_149645_b()) {
            case 11: 
            case 21: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private static synchronized boolean skipDefaultRendering(Block block) {
        return RenderPassAPI.instance.skipDefaultRendering(block);
    }

    private static synchronized void registerOverride(TileOverride override) {
        if (override != null && !override.isDisabled()) {
            Set<String> matchingTiles;
            List list;
            boolean registered = false;
            List<BlockStateMatcher> matchingBlocks = override.getMatchingBlocks();
            if (!MCPatcherUtils.isNullOrEmpty(matchingBlocks)) {
                for (BlockStateMatcher matcher : matchingBlocks) {
                    if (matcher == null) continue;
                    Block block = matcher.getBlock();
                    list = blockOverrides.computeIfAbsent(block, k -> new ArrayList());
                    list.add(matcher);
                    logger.fine("using %s for block %s", override, BlockAPI.getBlockName(block));
                    registered = true;
                }
            }
            if (!MCPatcherUtils.isNullOrEmpty(matchingTiles = override.getMatchingTiles())) {
                for (String name : matchingTiles) {
                    list = tileOverrides.computeIfAbsent(name, k -> new ArrayList());
                    list.add(override);
                    logger.fine("using %s for tile %s", override, name);
                    registered = true;
                }
            }
            if (registered) {
                allOverrides.add(override);
            }
        }
    }

    public static synchronized void setBlankResource() {
        RenderBlocksUtils.blankIcon = tileLoader.getIcon(RenderPassAPI.instance.getBlankResource());
    }

    public static TileOverrideIterator.IJK newIJKIterator() {
        return new TileOverrideIterator.IJK(blockOverrides, tileOverrides);
    }

    public static TileOverrideIterator.Metadata newMetadataIterator() {
        return new TileOverrideIterator.Metadata(blockOverrides, tileOverrides);
    }

    static {
        ijkIterator = CTMUtils.newIJKIterator();
        metadataIterator = CTMUtils.newMetadataIterator();
        renderBlockState = new BlockOrientation();
        try {
            Class.forName("com.prupe.mcpatcher.renderpass.RenderPass").getMethod("finish", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Connected Textures", 3){

            @Override
            public void initialize() {
            }

            @Override
            public void beforeChange() {
                RenderPassAPI.instance.clear();
                try {
                    GlassPaneRenderer.clear();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                renderBlockState.clear();
                ijkIterator.clear();
                metadataIterator.clear();
                allOverrides.clear();
                blockOverrides.clear();
                tileOverrides.clear();
                lastOverride = null;
                RenderBlocksUtils.blankIcon = null;
                tileLoader = new TileLoader("textures/blocks", logger);
                RenderPassAPI.instance.refreshBlendingOptions();
                if (MCPatcherForgeConfig.ConnectedTextures.standard || MCPatcherForgeConfig.ConnectedTextures.nonStandard) {
                    for (ResourceLocation resource : ResourceList.getInstance().listResources("mcpatcher/ctm", ".properties", true)) {
                        CTMUtils.registerOverride(TileOverride.create(resource, tileLoader));
                    }
                }
                for (ResourceLocation resource : BlendMethod.getAllBlankResources()) {
                    tileLoader.preloadTile(resource, false);
                }
            }

            @Override
            public void afterChange() {
                for (TileOverride tileOverride : allOverrides) {
                    tileOverride.registerIcons();
                }
                for (Map.Entry entry : blockOverrides.entrySet()) {
                    for (BlockStateMatcher matcher : (List)entry.getValue()) {
                        TileOverride override = (TileOverride)matcher.getData();
                        if (override.getRenderPass() < 0) continue;
                        RenderPassAPI.instance.setRenderPassForBlock((Block)entry.getKey(), override.getRenderPass());
                    }
                }
                for (List list : blockOverrides.values()) {
                    list.sort((m1, m2) -> {
                        TileOverride o1 = (TileOverride)m1.getData();
                        TileOverride o2 = (TileOverride)m2.getData();
                        return o1.compareTo(o2);
                    });
                }
                for (List list : tileOverrides.values()) {
                    Collections.sort(list);
                }
                CTMUtils.setBlankResource();
            }
        });
    }
}

