/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.gtnewhorizons.angelica.mixins.interfaces.EntityRendererAccessor;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.mal.biome.ColorUtils;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import jss.notfine.config.MCPatcherForgeConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public final class Lightmap {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.CUSTOM_COLORS);
    private static final String LIGHTMAP_FORMAT = "lightmap/world%d.png";
    private static final int LIGHTMAP_SIZE = 16;
    private static final int HEIGHT_WITHOUT_NIGHTVISION = 32;
    private static final int HEIGHT_WITH_NIGHTVISION = 64;
    private static final boolean useLightmaps = MCPatcherForgeConfig.CustomColors.lightmaps;
    private static final Map<Integer, Lightmap> lightmaps = new HashMap<Integer, Lightmap>();
    private final int width;
    private final boolean customNightvision;
    private final int[] origMap;
    private final boolean valid;
    private final float[] sunrgb = new float[48];
    private final float[] torchrgb = new float[48];
    private final float[] sunrgbnv = new float[48];
    private final float[] torchrgbnv = new float[48];
    private final float[] rgb = new float[3];

    static void reset() {
        lightmaps.clear();
    }

    public static boolean computeLightmap(EntityRenderer renderer, World world, int[] mapRGB, float partialTick) {
        if (world == null || !useLightmaps) {
            return false;
        }
        Lightmap lightmap = null;
        int worldType = world.field_73011_w.field_76574_g;
        if (lightmaps.containsKey(worldType)) {
            lightmap = lightmaps.get(worldType);
        } else {
            ResourceLocation resource = TexturePackAPI.newMCPatcherResourceLocation(String.format(LIGHTMAP_FORMAT, worldType));
            BufferedImage image = TexturePackAPI.getImage(resource);
            if (image != null) {
                lightmap = new Lightmap(resource, image);
                if (!lightmap.valid) {
                    lightmap = null;
                }
            }
            lightmaps.put(worldType, lightmap);
        }
        return lightmap != null && lightmap.compute(renderer, world, mapRGB, partialTick);
    }

    private Lightmap(ResourceLocation resource, BufferedImage image) {
        this.width = image.getWidth();
        int height = image.getHeight();
        this.customNightvision = height == 64;
        this.origMap = new int[this.width * height];
        image.getRGB(0, 0, this.width, height, this.origMap, 0, this.width);
        boolean bl = this.valid = height == 32 || height == 64;
        if (!this.valid) {
            logger.error("%s must be exactly %d or %d pixels high", resource, 32, 64);
        }
    }

    private float getNightVisionStrength(EntityRenderer renderer, float n) {
        if (Minecraft.func_71410_x().field_71439_g.func_70644_a(Potion.field_76439_r)) {
            return ((EntityRendererAccessor)renderer).invokeGetNightVisionBrightness((EntityPlayer)Minecraft.func_71410_x().field_71439_g, n);
        }
        return 0.0f;
    }

    private boolean compute(EntityRenderer renderer, World world, int[] mapRGB, float partialTick) {
        float sun = ColorUtils.clamp(world.field_73016_r > 0 ? 1.0f : 1.1666666f * (world.func_72971_b(1.0f) - 0.2f)) * (float)(this.width - 1);
        float torch = ColorUtils.clamp(renderer.field_78514_e + 0.5f) * (float)(this.width - 1);
        float nightVisionStrength = this.getNightVisionStrength(renderer, partialTick);
        float gamma = ColorUtils.clamp(Minecraft.func_71410_x().field_71474_y.field_74333_Y);
        for (int i = 0; i < 16; ++i) {
            Lightmap.interpolate(this.origMap, i * this.width, sun, this.sunrgb, 3 * i);
            Lightmap.interpolate(this.origMap, (i + 16) * this.width, torch, this.torchrgb, 3 * i);
            if (!this.customNightvision || !(nightVisionStrength > 0.0f)) continue;
            Lightmap.interpolate(this.origMap, (i + 32) * this.width, sun, this.sunrgbnv, 3 * i);
            Lightmap.interpolate(this.origMap, (i + 48) * this.width, torch, this.torchrgbnv, 3 * i);
        }
        for (int s = 0; s < 16; ++s) {
            for (int t = 0; t < 16; ++t) {
                int k;
                for (k = 0; k < 3; ++k) {
                    this.rgb[k] = ColorUtils.clamp(this.sunrgb[3 * s + k] + this.torchrgb[3 * t + k]);
                }
                if (nightVisionStrength > 0.0f) {
                    if (this.customNightvision) {
                        for (k = 0; k < 3; ++k) {
                            this.rgb[k] = ColorUtils.clamp((1.0f - nightVisionStrength) * this.rgb[k] + nightVisionStrength * (this.sunrgbnv[3 * s + k] + this.torchrgbnv[3 * t + k]));
                        }
                    } else {
                        float nightVisionMultiplier = Math.max(Math.max(this.rgb[0], this.rgb[1]), this.rgb[2]);
                        if (nightVisionMultiplier > 0.0f) {
                            nightVisionMultiplier = 1.0f - nightVisionStrength + nightVisionStrength / nightVisionMultiplier;
                            for (int k2 = 0; k2 < 3; ++k2) {
                                this.rgb[k2] = ColorUtils.clamp(this.rgb[k2] * nightVisionMultiplier);
                            }
                        }
                    }
                }
                if (gamma != 0.0f) {
                    for (int k3 = 0; k3 < 3; ++k3) {
                        float tmp = 1.0f - this.rgb[k3];
                        tmp = 1.0f - tmp * tmp * tmp * tmp;
                        this.rgb[k3] = gamma * tmp + (1.0f - gamma) * this.rgb[k3];
                    }
                }
                mapRGB[s * 16 + t] = 0xFF000000 | ColorUtils.float3ToInt(this.rgb);
            }
        }
        return true;
    }

    private static void interpolate(int[] map, int offset1, float x, float[] rgb, int offset2) {
        int x1;
        int x0 = (int)Math.floor(x);
        if (x0 == (x1 = (int)Math.ceil(x))) {
            ColorUtils.intToFloat3(map[offset1 + x0], rgb, offset2);
        } else {
            float xf = x - (float)x0;
            float xg = 1.0f - xf;
            float[] rgb0 = new float[3];
            float[] rgb1 = new float[3];
            ColorUtils.intToFloat3(map[offset1 + x0], rgb0);
            ColorUtils.intToFloat3(map[offset1 + x1], rgb1);
            for (int i = 0; i < 3; ++i) {
                rgb[offset2 + i] = xg * rgb0[i] + xf * rgb1[i];
            }
        }
    }
}

