/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.utils;

import com.gtnewhorizons.angelica.mixins.interfaces.IPatchedTextureAtlasSprite;
import com.gtnewhorizons.angelica.mixins.interfaces.ITexturesCache;
import java.util.ArrayDeque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class AnimationsRenderUtils {
    private static final ThreadLocal<ArrayDeque<ITexturesCache>> TEXTURE_CACHE_STACK = ThreadLocal.withInitial(ArrayDeque::new);

    public static void markBlockTextureForUpdate(IIcon icon) {
        AnimationsRenderUtils.markBlockTextureForUpdate(icon, null);
    }

    public static void markBlockTextureForUpdate(IIcon icon, IBlockAccess blockAccess) {
        TextureMap textureMap = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite textureAtlasSprite = textureMap.func_110572_b(icon.func_94215_i());
        if (textureAtlasSprite != null && textureAtlasSprite.func_130098_m()) {
            if (blockAccess instanceof ITexturesCache) {
                ITexturesCache texturesCache = (ITexturesCache)blockAccess;
                texturesCache.getRenderedTextures().add((IIcon)textureAtlasSprite);
            } else if (textureAtlasSprite instanceof IPatchedTextureAtlasSprite) {
                IPatchedTextureAtlasSprite patchedSprite = (IPatchedTextureAtlasSprite)textureAtlasSprite;
                patchedSprite.markNeedsAnimationUpdate();
            }
        }
    }

    public static void onSpriteUsed(IPatchedTextureAtlasSprite sprite) {
        ArrayDeque<ITexturesCache> stack = TEXTURE_CACHE_STACK.get();
        if (stack == null || stack.isEmpty()) {
            sprite.markNeedsAnimationUpdate();
            return;
        }
        stack.peek().track(sprite);
    }

    public static void pushCache(ITexturesCache cache) {
        TEXTURE_CACHE_STACK.get().push(cache);
    }

    public static void popCache() {
        TEXTURE_CACHE_STACK.get().pop();
    }
}

