/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.loading;

import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import com.gtnewhorizon.gtnhmixins.IEarlyMixinLoader;
import com.gtnewhorizon.gtnhmixins.builders.IMixins;
import com.gtnewhorizon.gtnhmixins.builders.ITransformers;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.config.CompatConfig;
import com.gtnewhorizons.angelica.loading.fml.compat.CompatHandlers;
import com.gtnewhorizons.angelica.mixins.Mixins;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jss.notfine.asm.AsmTransformers;
import jss.notfine.asm.mappings.Namer;
import jss.notfine.config.MCPatcherForgeConfig;
import jss.notfine.config.NotFineConfig;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.service.mojang.MixinServiceLaunchWrapper;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@IFMLLoadingPlugin.TransformerExclusions(value={"jss.notfine.asm", "com.gtnewhorizons.angelica.loading", "com.gtnewhorizons.angelica.glsm.GLStateManager"})
public class AngelicaTweaker
implements IFMLLoadingPlugin,
IEarlyMixinLoader {
    private static Boolean OBF_ENV;
    public static final Logger LOGGER;
    private String[] transformerClasses;

    public AngelicaTweaker() {
        try {
            ConfigurationManager.registerConfig(AngelicaConfig.class);
            ConfigurationManager.registerConfig(CompatConfig.class);
            MCPatcherForgeConfig.registerConfig();
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig("");
            if (AngelicaConfig.enableDebugLogging) {
                loggerConfig.setLevel(Level.DEBUG);
            }
            ctx.updateLoggers();
            AngelicaConfig.enableTestBlocks = Boolean.getBoolean("angelica.enableTestBlocks");
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
        AngelicaTweaker.verifyDependencies();
    }

    private static void verifyDependencies() {
        if (AngelicaTweaker.class.getResource("/it/unimi/dsi/fastutil/ints/Int2ObjectMap.class") == null) {
            throw new RuntimeException("Missing dependency: Angelica requires GTNHLib 0.2.1 or newer! Download: https://modrinth.com/mod/gtnhlib");
        }
    }

    public String[] getASMTransformerClass() {
        if (this.transformerClasses == null) {
            ArrayList<String> transformers = new ArrayList<String>();
            transformers.addAll(CompatHandlers.getTransformers());
            List<String> notFineTransformers = Arrays.asList(ITransformers.getTransformers(AsmTransformers.class));
            if (!notFineTransformers.isEmpty()) {
                Namer.initNames();
            }
            transformers.addAll(notFineTransformers);
            this.transformerClasses = transformers.toArray(new String[0]);
        }
        return this.transformerClasses;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        OBF_ENV = (Boolean)data.get("runtimeDeobfuscationEnabled");
        List tweaks = (List)GlobalProperties.get((GlobalProperties.Keys)MixinServiceLaunchWrapper.BLACKBOARD_KEY_TWEAKCLASSES);
        if (tweaks != null) {
            tweaks.add("com.gtnewhorizons.angelica.loading.fml.tweakers.IncompatibleModsDisablerTweaker");
            if (AngelicaConfig.enableHudCaching) {
                tweaks.add("com.gtnewhorizons.angelica.loading.fml.tweakers.XaerosTransformerDisablerTweaker");
            }
            if (FMLLaunchHandler.side().isClient()) {
                boolean rfbLoaded;
                boolean bl = rfbLoaded = Launch.blackboard.getOrDefault("angelica.rfbPluginLoaded", Boolean.FALSE) == Boolean.TRUE;
                if (!rfbLoaded) {
                    tweaks.add("com.gtnewhorizons.angelica.loading.fml.tweakers.AngelicaLateTweaker");
                }
                if (AngelicaConfig.enableSodium) {
                    tweaks.add("com.gtnewhorizons.angelica.loading.fml.tweakers.SodiumLateTweaker");
                }
            }
        }
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public String getMixinConfig() {
        return "mixins.angelica.early.json";
    }

    public List<String> getMixins(Set<String> loadedCoreMods) {
        NotFineConfig.loadSettings();
        if (loadedCoreMods.contains("cofh.asm.LoadingPlugin")) {
            MCPatcherForgeConfig.ExtendedHD.hdFont = false;
        }
        return IMixins.getEarlyMixins(Mixins.class, loadedCoreMods);
    }

    public static boolean isObfEnv() {
        if (OBF_ENV == null) {
            throw new IllegalStateException("Obfuscation state has been accessed too early!");
        }
        return OBF_ENV;
    }

    public static String obf(String deobf, String obf) {
        if (OBF_ENV == null) {
            throw new IllegalStateException("Obfuscation state has been accessed too early!");
        }
        if (OBF_ENV.booleanValue()) {
            return obf;
        }
        return deobf;
    }

    static {
        LOGGER = LogManager.getLogger((String)"Angelica");
    }
}

