/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.client.render;

import com.projecturanus.betterp2p.util.GlStateManager;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class OutlineRenderer {
    public static void renderOutlines(RenderWorldLastEvent evt, EntityPlayer p, Collection<List<Integer>> coordinates, int r, int g, int b) {
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S);
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T);
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U);
        GlStateManager.pushAttrib();
        GlStateManager.disableDepth();
        GlStateManager.disableTexture2D();
        GlStateManager.disableLighting();
        GlStateManager.depthMask(false);
        GlStateManager.pushMatrix();
        GlStateManager.translate(-doubleX, -doubleY, -doubleZ);
        OutlineRenderer.renderOutlines(coordinates, r, g, b, 4);
        GlStateManager.popMatrix();
        GlStateManager.popAttrib();
        GlStateManager.enableDepth();
        GlStateManager.enableTexture2D();
        GlStateManager.enableLighting();
        GlStateManager.depthMask(true);
    }

    private static void renderOutlines(Collection<List<Integer>> coordinates, int r, int g, int b, int thickness) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(1);
        GL11.glLineWidth((float)thickness);
        for (List<Integer> coordinate : coordinates) {
            float x = coordinate.get(0).intValue();
            float y = coordinate.get(1).intValue();
            float z = coordinate.get(2).intValue();
            OutlineRenderer.renderHighLightedBlocksOutline(tessellator, x, y, z, r, g, b, 255);
        }
        tessellator.func_78381_a();
    }

    public static void renderHighLightedBlocksOutline(Tessellator tessellator, float mx, float my, float mz, int r, int g, int b, int a) {
        tessellator.func_78370_a(r, g, b, a);
        tessellator.func_78377_a((double)mx, (double)my, (double)mz);
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)mz);
        tessellator.func_78377_a((double)mx, (double)my, (double)mz);
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)mx, (double)my, (double)mz);
        tessellator.func_78377_a((double)mx, (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)mz);
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)mz);
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)mx, (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)mx, (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f));
    }

    public static void renderOutlinesWithFacing(RenderWorldLastEvent evt, EntityPlayer p, Collection<Pair<List<Integer>, ForgeDirection>> coordinates, int r, int g, int b) {
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)evt.partialTicks;
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)evt.partialTicks;
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)evt.partialTicks;
        GlStateManager.pushAttrib();
        GlStateManager.disableDepth();
        GlStateManager.disableTexture2D();
        GlStateManager.disableLighting();
        GlStateManager.depthMask(false);
        OutlineRenderer.renderOutlinesWithFacing(coordinates, -doubleX, -doubleY, -doubleZ, r, g, b, 4);
        GlStateManager.popAttrib();
        GlStateManager.enableDepth();
        GlStateManager.enableTexture2D();
        GlStateManager.enableLighting();
        GlStateManager.depthMask(true);
    }

    private static void renderOutlinesWithFacing(Collection<Pair<List<Integer>, ForgeDirection>> coordinates, double x, double y, double z, int r, int g, int b, int thickness) {
        Tessellator tessellator = Tessellator.field_78398_a;
        for (Pair<List<Integer>, ForgeDirection> coordinate : coordinates) {
            List pos = (List)coordinate.component1();
            ForgeDirection facing = (ForgeDirection)coordinate.component2();
            if (pos == null || facing == null || pos.size() != 3) continue;
            GlStateManager.pushMatrix();
            GlStateManager.translate(x, y, z);
            tessellator.func_78371_b(1);
            GL11.glLineWidth((float)thickness);
            tessellator.func_78373_b((double)((Integer)pos.get(0)).intValue(), (double)((Integer)pos.get(1)).intValue(), (double)((Integer)pos.get(2)).intValue());
            OutlineRenderer.renderHighLightedBlocksOutlineForFacing(tessellator, r, g, b, 255);
            tessellator.func_78373_b(0.0, 0.0, 0.0);
            GlStateManager.translate(((Integer)pos.get(0)).intValue(), ((Integer)pos.get(1)).intValue(), ((Integer)pos.get(2)).intValue());
            GlStateManager.translate(0.5, 0.5, 0.5);
            switch (facing) {
                case DOWN: {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                    break;
                }
                case UP: {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)270.0, (double)0.0, (double)0.0, (double)1.0);
                    break;
                }
                case NORTH: {
                    GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
                case SOUTH: {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
                case EAST: {
                    GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                    break;
                }
            }
            int[] west_matrix = new int[]{1, 0, 0, 0, 1, 0, 0, 0, 1};
            int[] east_matrix = new int[]{-1, 0, 0, 0, 1, 0, 0, 0, 1};
            int[] north_matrix = new int[]{0, 0, -1, 0, 1, 0, 1, 0, 0};
            int[] south_matrix = new int[]{0, 0, 1, 0, 1, 0, -1, 0, 0};
            GlStateManager.translate(-0.5, -0.5, -0.5);
            GlStateManager.translate(-((Integer)pos.get(0)).intValue(), -((Integer)pos.get(1)).intValue(), -((Integer)pos.get(2)).intValue());
            tessellator.func_78381_a();
            GlStateManager.popMatrix();
        }
    }

    public static void renderHighLightedBlocksOutlineForFacing(Tessellator tessellator, int r, int g, int b, int a) {
        double minX = 0.0;
        double minY = 0.125;
        double minZ = 0.125;
        double maxX = 0.1875;
        double maxY = 0.875;
        double maxZ = 0.875;
        tessellator.func_78370_a(r, g, b, a);
        tessellator.func_78377_a(minX, minY, minZ);
        tessellator.func_78377_a(maxX, minY, minZ);
        tessellator.func_78377_a(minX, minY, minZ);
        tessellator.func_78377_a(minX, maxY, minZ);
        tessellator.func_78377_a(minX, minY, minZ);
        tessellator.func_78377_a(minX, minY, maxZ);
        tessellator.func_78377_a(maxX, maxY, maxZ);
        tessellator.func_78377_a(minX, maxY, maxZ);
        tessellator.func_78377_a(maxX, maxY, maxZ);
        tessellator.func_78377_a(maxX, minY, maxZ);
        tessellator.func_78377_a(maxX, maxY, maxZ);
        tessellator.func_78377_a(maxX, maxY, minZ);
        tessellator.func_78377_a(minX, maxY, minZ);
        tessellator.func_78377_a(minX, maxY, maxZ);
        tessellator.func_78377_a(minX, maxY, minZ);
        tessellator.func_78377_a(maxX, maxY, minZ);
        tessellator.func_78377_a(maxX, minY, minZ);
        tessellator.func_78377_a(maxX, minY, maxZ);
        tessellator.func_78377_a(maxX, minY, minZ);
        tessellator.func_78377_a(maxX, maxY, minZ);
        tessellator.func_78377_a(minX, minY, maxZ);
        tessellator.func_78377_a(maxX, minY, maxZ);
        tessellator.func_78377_a(minX, minY, maxZ);
        tessellator.func_78377_a(minX, maxY, maxZ);
    }
}

