/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.AEApi;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.util.IConfigManager;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.expanded.IBaubleExpanded;
import com.google.common.base.Optional;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles"), @Optional.Interface(iface="baubles.api.expanded.IBaubleExpanded", modid="Baubles|Expanded")})
public class ToolWirelessTerminal
extends AEBasePoweredItem
implements IWirelessTermHandler,
IBauble,
IBaubleExpanded {
    public ToolWirelessTerminal() {
        super(AEConfig.instance.wirelessTerminalBattery, (Optional<String>)Optional.absent());
        this.setFeature(EnumSet.of(AEFeature.WirelessAccessTerminal, AEFeature.PoweredTools));
    }

    public ItemStack func_77659_a(ItemStack item, World w, EntityPlayer player) {
        if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)item, (int)1) > 0) {
            AEApi.instance().registries().wireless().openWirelessTerminalGui(item, w, player);
        }
        return item;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        super.addCheckedInformation(stack, player, lines, displayMoreInfo);
        if (stack.func_77942_o()) {
            NBTTagCompound tag = Platform.openNbtData(stack);
            if (tag != null) {
                String encKey = tag.func_74779_i("encryptionKey");
                if (encKey == null || encKey.isEmpty()) {
                    lines.add(EnumChatFormatting.RED + GuiText.Unlinked.getLocal() + EnumChatFormatting.RESET);
                } else {
                    lines.add(EnumChatFormatting.GREEN + GuiText.Linked.getLocal() + EnumChatFormatting.RESET);
                }
            }
        } else {
            lines.add(GuiText.Unlinked.getLocal());
        }
    }

    @Override
    public boolean canHandle(ItemStack is) {
        return AEApi.instance().definitions().items().wirelessTerminal().isSameAs(is);
    }

    @Override
    public boolean usePower(EntityPlayer player, double amount, ItemStack is) {
        return this.extractAEPower(is, amount) >= amount - 0.5;
    }

    @Override
    public boolean hasPower(EntityPlayer player, double amt, ItemStack is) {
        return this.getAECurrentPower(is) >= amt;
    }

    @Override
    public IConfigManager getConfigManager(ItemStack target) {
        ConfigManager out = new ConfigManager((manager, settingName, newValue) -> {
            NBTTagCompound data = Platform.openNbtData(target);
            manager.writeToNBT(data);
        });
        out.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        out.registerSetting(Settings.TYPE_FILTER, (Enum)TypeFilter.ALL);
        out.readFromNBT((NBTTagCompound)Platform.openNbtData(target).func_74737_b());
        return out;
    }

    @Override
    public String getEncryptionKey(ItemStack item) {
        NBTTagCompound tag = Platform.openNbtData(item);
        return tag.func_74779_i("encryptionKey");
    }

    @Override
    public void setEncryptionKey(ItemStack item, String encKey, String name) {
        NBTTagCompound tag = Platform.openNbtData(item);
        tag.func_74778_a("encryptionKey", encKey);
        tag.func_74778_a("name", name);
    }

    public String[] getBaubleTypes(ItemStack itemstack) {
        return new String[]{"Terminal"};
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }
}

