/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.config.SecurityPermissions;
import appeng.api.features.IPlayerRegistry;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.networking.security.ISecurityRegistry;
import appeng.client.render.items.ToolBiometricCardRender;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import com.mojang.authlib.GameProfile;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.event.ForgeEventFactory;

public class ToolBiometricCard
extends AEBaseItem
implements IBiometricCard {
    public ToolBiometricCard() {
        this.setFeature(EnumSet.of(AEFeature.Security));
        this.func_77625_d(1);
        if (Platform.isClient()) {
            MinecraftForgeClient.registerItemRenderer((Item)this, (IItemRenderer)new ToolBiometricCardRender());
        }
    }

    public ItemStack func_77659_a(ItemStack is, World w, EntityPlayer p) {
        if (ForgeEventFactory.onItemUseStart((EntityPlayer)p, (ItemStack)is, (int)1) > 0 && p.func_70093_af()) {
            this.encode(is, p);
            p.func_71038_i();
            return is;
        }
        return is;
    }

    public boolean func_111207_a(ItemStack is, EntityPlayer par2EntityPlayer, EntityLivingBase target) {
        if (target instanceof EntityPlayer && !par2EntityPlayer.func_70093_af()) {
            if (par2EntityPlayer.field_71075_bZ.field_75098_d) {
                is = par2EntityPlayer.func_71045_bC();
            }
            this.encode(is, (EntityPlayer)target);
            par2EntityPlayer.func_71038_i();
            return true;
        }
        return false;
    }

    public String func_77653_i(ItemStack is) {
        GameProfile username = this.getProfile(is);
        return username != null ? super.func_77653_i(is) + " - " + username.getName() : super.func_77653_i(is);
    }

    private void encode(ItemStack is, EntityPlayer p) {
        GameProfile username = this.getProfile(is);
        if (username != null && username.equals((Object)p.func_146103_bH())) {
            this.setProfile(is, null);
        } else {
            this.setProfile(is, p.func_146103_bH());
        }
    }

    @Override
    public void setProfile(ItemStack itemStack, GameProfile profile) {
        NBTTagCompound tag = Platform.openNbtData(itemStack);
        if (profile != null) {
            NBTTagCompound pNBT = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)pNBT, (GameProfile)profile);
            tag.func_74782_a("profile", (NBTBase)pNBT);
        } else {
            tag.func_82580_o("profile");
        }
    }

    @Override
    public GameProfile getProfile(ItemStack is) {
        NBTTagCompound tag = Platform.openNbtData(is);
        if (tag.func_74764_b("profile")) {
            return NBTUtil.func_152459_a((NBTTagCompound)tag.func_74775_l("profile"));
        }
        return null;
    }

    @Override
    public EnumSet<SecurityPermissions> getPermissions(ItemStack is) {
        NBTTagCompound tag = Platform.openNbtData(is);
        EnumSet<SecurityPermissions> result = EnumSet.noneOf(SecurityPermissions.class);
        for (SecurityPermissions sp : SecurityPermissions.values()) {
            if (!tag.func_74767_n(sp.name())) continue;
            result.add(sp);
        }
        return result;
    }

    @Override
    public boolean hasPermission(ItemStack is, SecurityPermissions permission) {
        NBTTagCompound tag = Platform.openNbtData(is);
        return tag.func_74767_n(permission.name());
    }

    @Override
    public void removePermission(ItemStack itemStack, SecurityPermissions permission) {
        NBTTagCompound tag = Platform.openNbtData(itemStack);
        if (tag.func_74764_b(permission.name())) {
            tag.func_82580_o(permission.name());
        }
    }

    @Override
    public void addPermission(ItemStack itemStack, SecurityPermissions permission) {
        NBTTagCompound tag = Platform.openNbtData(itemStack);
        tag.func_74757_a(permission.name(), true);
    }

    @Override
    public void registerPermissions(ISecurityRegistry register, IPlayerRegistry pr, ItemStack is) {
        register.addPlayer(pr.getID(this.getProfile(is)), this.getPermissions(is));
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        EnumSet<SecurityPermissions> perms = this.getPermissions(stack);
        if (perms.isEmpty()) {
            lines.add(GuiText.NoPermissions.getLocal());
        } else {
            String msg = null;
            for (SecurityPermissions sp : perms) {
                if (msg == null) {
                    msg = Platform.gui_localize(sp.getUnlocalizedName());
                    continue;
                }
                msg = msg + ", " + Platform.gui_localize(sp.getUnlocalizedName());
            }
            lines.add(msg);
        }
    }
}

