/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.core.AELog;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class AEJSONEntry {
    public String item;
    public int meta_data = 0;
    public int min_value = 0;
    public int max_value = 1;
    public int weight = 1;
    public int exclusiveGroupID = -1;

    public AEJSONEntry(String item, Integer meta_data, Integer min_value, Integer max_value, Integer weight, Integer exclusiveGroupID) {
        if (item == null) {
            NullPointerException e = new NullPointerException();
            AELog.error(new NullPointerException(), "AE2: itemName is required! | Error: While loading JSON");
            throw e;
        }
        this.item = item;
        if (meta_data != null) {
            this.meta_data = meta_data;
        }
        if (min_value != null) {
            this.min_value = min_value;
        }
        if (max_value != null) {
            this.max_value = max_value;
        }
        if (weight != null) {
            this.weight = weight;
        }
        if (exclusiveGroupID != null) {
            this.exclusiveGroupID = exclusiveGroupID;
        }
    }

    public AEJSONEntry() {
    }

    private ItemStack getItemStack(int amount, Random rand) {
        String[] temp = this.item.split(":");
        switch (temp.length) {
            case 2: {
                if (GameRegistry.findItem((String)temp[0], (String)temp[1]) == null) {
                    AELog.error("AE2: NO SUCH ITEM FOUND IN REGISTRY. CONFIRM YOU ENTERED IT CORRECTLY. USING GLOWSTONE DUST | Error Getting ItemStack for Meteorite Loot from entry: " + this, new Object[0]);
                    return new ItemStack(Items.field_151114_aO);
                }
                return new ItemStack(GameRegistry.findItem((String)temp[0], (String)temp[1]), amount, this.meta_data);
            }
            case 1: {
                ItemStack stack;
                if (!temp[0].startsWith("ore#")) break;
                ArrayList oreDictLoot = OreDictionary.getOres((String)temp[0].substring(4));
                if (!oreDictLoot.isEmpty() && (stack = (ItemStack)oreDictLoot.get(rand.nextInt(oreDictLoot.size()))) != null) {
                    stack = stack.func_77946_l();
                    stack.field_77994_a = amount;
                    return stack;
                }
                AELog.error("AE2: NO SUCH ORE DICTIONARY OBJECT FOUND: " + this + " USING GLOWSTONE DUST | ERROR: Getting ItemStack for Meteorite Loot", new Object[0]);
                return new ItemStack(Items.field_151114_aO);
            }
        }
        IllegalArgumentException e = new IllegalArgumentException();
        AELog.error(e, "AE2: INCORRECT ENTRY FORMAT " + this + " MAKE SURE TO USE CORRECT ITEMID FORMAT: modid:item or ore#oreDictName | ERROR: Getting ItemStack for Meteorite Loot");
        throw e;
    }

    public ItemStack getItemStack(Random rand) {
        return this.getItemStack((this.max_value - this.min_value > 0 ? rand.nextInt(this.max_value + 1 - this.min_value) : 0) + this.min_value, rand);
    }

    public String toString() {
        return "Entry for " + this.item + ". Meta data: " + this.meta_data + ". Minimum and Maximum Value: " + this.min_value + ", " + this.max_value + ". Weight and Exclusive Group ID: " + this.weight + ", " + this.exclusiveGroupID + ".";
    }
}

