/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.config.TerminalFontSize;
import appeng.api.storage.IItemDisplayRegistry;
import appeng.client.render.AppEngRenderItem;
import appeng.client.render.StackSizeRenderer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class TranslatedRenderItem
extends RenderItem {
    public void func_94148_a(FontRenderer font, TextureManager texManager, ItemStack stack, int x, int y, String customText) {
        this.renderItemOverlayIntoGUI(font, texManager, stack, x, y, customText, null);
    }

    public void renderItemOverlayIntoGUI(FontRenderer font, TextureManager texManager, ItemStack stack, int x, int y, String customText, TerminalFontSize fontSize) {
        if (stack != null) {
            boolean skip = false;
            boolean showDurabilitybar = true;
            boolean showStackSize = true;
            boolean showCraftLabelText = true;
            for (IItemDisplayRegistry.ItemRenderHook hook : AppEngRenderItem.POST_HOOKS) {
                skip |= hook.renderOverlay(font, texManager, stack, x, y);
                showDurabilitybar &= hook.showDurability(stack);
                showStackSize &= hook.showStackSize(stack);
                showCraftLabelText &= hook.showCraftLabelText(stack);
            }
            if (skip) {
                return;
            }
            GL11.glPushMatrix();
            if (showStackSize && stack.field_77994_a > 1 || showCraftLabelText && customText != null) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)this.field_77023_b);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3042);
                StackSizeRenderer.drawStackSize(x, y, customText != null ? customText : StackSizeRenderer.getToBeRenderedStackSize(stack.field_77994_a, fontSize), font, fontSize);
                GL11.glEnable((int)2896);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-this.field_77023_b));
            }
            if (showDurabilitybar && stack.func_77973_b().showDurabilityBar(stack)) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(this.field_77023_b - 1.0f));
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int j1 = (int)Math.round(13.0 - health * 13.0);
                int k = (int)Math.round(255.0 - health * 255.0);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)3042);
                Tessellator tessellator = Tessellator.field_78398_a;
                int l = 255 - k << 16 | k << 8;
                int i1 = (255 - k) / 4 << 16 | 0x3F00;
                this.func_77017_a(tessellator, x + 2, y + 13, 13, 2, 0);
                this.func_77017_a(tessellator, x + 2, y + 13, 12, 1, i1);
                this.func_77017_a(tessellator, x + 2, y + 13, j1, 1, l);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)2896);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-(this.field_77023_b - 1.0f)));
            }
            GL11.glPopMatrix();
        }
    }
}

