/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.api.storage.ITerminalHost;
import appeng.client.gui.implementations.GuiAmount;
import appeng.container.implementations.ContainerPatternValueAmount;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketPatternValueSet;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.parts.reporting.PartPatternTerminalEx;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class GuiPatternValueAmount
extends GuiAmount {
    private final int valueIndex;
    private final int originalAmount;

    public GuiPatternValueAmount(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(new ContainerPatternValueAmount(inventoryPlayer, te));
        GuiContainer gui = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        if (gui != null && gui.field_147006_u != null && gui.field_147006_u.func_75216_d()) {
            Slot slot = gui.field_147006_u;
            this.originalAmount = slot.func_75211_c().field_77994_a;
            this.valueIndex = slot.field_75222_d;
        } else {
            this.valueIndex = -1;
            this.originalAmount = 0;
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.amountTextField.setText(String.valueOf(this.originalAmount));
        this.amountTextField.setCursorPositionEnd();
        this.amountTextField.setSelectionPos(0);
    }

    @Override
    protected void setOriginGUI(Object target) {
        ItemStack stack;
        Iterator iterator;
        IDefinitions definitions = AEApi.instance().definitions();
        IParts parts = definitions.parts();
        if (target instanceof PartPatternTerminal) {
            iterator = parts.patternTerminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                this.myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_PATTERN_TERMINAL;
        }
        if (target instanceof PartPatternTerminalEx) {
            iterator = parts.patternTerminalEx().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                this.myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_PATTERN_TERMINAL_EX;
        }
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(GuiText.SelectAmount.getLocal(), 8, 6, GuiColors.CraftAmountSelectAmount.getColor());
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawBG(offsetX, offsetY, mouseX, mouseY);
        this.nextBtn.field_146126_j = GuiText.Set.getLocal();
        this.nextBtn.field_146124_l = this.valueIndex >= 0;
        try {
            int resultI = this.getAmount();
            this.nextBtn.field_146124_l = resultI > 0;
        }
        catch (NumberFormatException e) {
            this.nextBtn.field_146124_l = false;
        }
        this.amountTextField.drawTextBox();
    }

    @Override
    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        try {
            if (btn == this.nextBtn && btn.field_146124_l) {
                NetworkHandler.instance.sendToServer(new PacketPatternValueSet(this.originalGui.ordinal(), this.getAmount(), this.valueIndex));
            }
        }
        catch (NumberFormatException e) {
            this.amountTextField.setText("1");
        }
    }

    @Override
    protected String getBackground() {
        return "guis/craftAmt.png";
    }
}

