/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.lexicon.page;

import com.google.common.base.Joiner;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.Language;
import net.minecraft.util.StatCollector;
import vazkii.botania.api.internal.IGuiLexiconEntry;
import vazkii.botania.api.lexicon.LexiconPage;
import vazkii.botania.common.core.handler.ConfigHandler;

public class PageText
extends LexiconPage {
    public PageText(String unlocalizedName) {
        super(unlocalizedName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderScreen(IGuiLexiconEntry gui, int mx, int my) {
        int width = gui.getWidth() - 30;
        int x = gui.getLeft() + 16;
        int y = gui.getTop() + 2;
        PageText.renderText(x, y, width, gui.getHeight(), this.getUnlocalizedName());
    }

    public static void renderText(int x, int y, int width, int height, String unlocalizedText) {
        PageText.renderText(x, y, width, height, 10, unlocalizedText);
    }

    /*
     * WARNING - void declaration
     */
    @SideOnly(value=Side.CLIENT)
    public static void renderText(int x, int y, int width, int height, int paragraphSize, String unlocalizedText) {
        void var16_18;
        y += 10;
        width -= 4;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        boolean unicode = font.func_82883_a();
        font.func_78264_a(true);
        String text = StatCollector.func_74838_a((String)unlocalizedText).replaceAll("&", "\u00a7");
        String[] textEntries = text.split("<br>");
        ArrayList lines = new ArrayList(textEntries.length * 2);
        Language lang = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        Locale locale = Locale.forLanguageTag(lang.toString().replace(" (", "-").replace(")", ""));
        if (locale == null) {
            locale = Locale.forLanguageTag(lang.func_135034_a());
        }
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        String[] stringArray = textEntries;
        int n = stringArray.length;
        boolean bl = false;
        while (var16_18 < n) {
            String s = stringArray[var16_18];
            ArrayList<String> words = new ArrayList<String>();
            String lineStr = "";
            BreakIterator breaker = BreakIterator.getLineInstance(locale);
            breaker.setText(s);
            int start = breaker.first();
            int end = breaker.next();
            while (end != -1) {
                String token = s.substring(start, end);
                String prev = lineStr;
                lineStr = lineStr + token;
                String controlCodes = PageText.toControlCodes(PageText.getControlCodes(prev));
                if (font.func_78256_a(lineStr) > width) {
                    lines.add(words);
                    lineStr = controlCodes + token;
                    words = new ArrayList();
                }
                words.add(controlCodes + token);
                start = end;
                end = breaker.next();
            }
            if (!lineStr.isEmpty()) {
                lines.add(words);
            }
            lines.add(new ArrayList());
            ++var16_18;
        }
        int i = 0;
        for (List list : lines) {
            int xi = x;
            ArrayList<Integer> gapIds = new ArrayList<Integer>(list.size());
            for (int k = 0; k < list.size() - 1; ++k) {
                if (font.func_78256_a((String)list.get(k)) <= 0 || font.func_78256_a((String)list.get(k + 1)) <= 0) continue;
                gapIds.add(k);
            }
            boolean nextLineExists = i + 1 < lines.size();
            boolean justify = ConfigHandler.lexiconJustifiedText && !list.isEmpty() && nextLineExists && !((List)lines.get(i + 1)).isEmpty() && !gapIds.isEmpty();
            int spacing = 0;
            int compensation = 0;
            if (justify) {
                String joined = Joiner.on((String)"").join((Iterable)list);
                int swidth = font.func_78256_a(joined);
                int extraSpace = width - swidth;
                int gaps = gapIds.size();
                spacing = extraSpace / gaps;
                compensation = extraSpace % gaps;
            }
            int gi = 0;
            for (int idx = 0; idx < list.size(); ++idx) {
                String tok = (String)list.get(idx);
                int tw = font.func_78256_a(tok);
                font.func_78276_b(tok, xi, y, 0);
                xi += tw;
                if (!justify || gi >= gapIds.size() || idx != (Integer)gapIds.get(gi)) continue;
                xi += spacing + (compensation > 0 ? 1 : 0);
                if (compensation > 0) {
                    --compensation;
                }
                ++gi;
            }
            y += list.isEmpty() ? paragraphSize : 10;
            ++i;
        }
        font.func_78264_a(unicode);
    }

    public static String getControlCodes(String s) {
        String controls = s.replaceAll("(?<!\u00a7)(.)", "");
        String wiped = controls.replaceAll(".*r", "r");
        return wiped;
    }

    public static String toControlCodes(String s) {
        return s.replaceAll(".", "\u00a7$0");
    }
}

