/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.shadow.org.apache.commons.math3.util;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import mcp.mobius.shadow.org.apache.commons.math3.exception.MaxCountExceededException;
import mcp.mobius.shadow.org.apache.commons.math3.util.Incrementor;
import mcp.mobius.shadow.org.apache.commons.math3.util.IterationEvent;
import mcp.mobius.shadow.org.apache.commons.math3.util.IterationListener;

public class IterationManager {
    private final Incrementor iterations;
    private final Collection<IterationListener> listeners;

    public IterationManager(int maxIterations) {
        this.iterations = new Incrementor(maxIterations);
        this.listeners = new CopyOnWriteArrayList<IterationListener>();
    }

    public IterationManager(int maxIterations, Incrementor.MaxCountExceededCallback callBack) {
        this.iterations = new Incrementor(maxIterations, callBack);
        this.listeners = new CopyOnWriteArrayList<IterationListener>();
    }

    public void addIterationListener(IterationListener listener) {
        this.listeners.add(listener);
    }

    public void fireInitializationEvent(IterationEvent e) {
        for (IterationListener l : this.listeners) {
            l.initializationPerformed(e);
        }
    }

    public void fireIterationPerformedEvent(IterationEvent e) {
        for (IterationListener l : this.listeners) {
            l.iterationPerformed(e);
        }
    }

    public void fireIterationStartedEvent(IterationEvent e) {
        for (IterationListener l : this.listeners) {
            l.iterationStarted(e);
        }
    }

    public void fireTerminationEvent(IterationEvent e) {
        for (IterationListener l : this.listeners) {
            l.terminationPerformed(e);
        }
    }

    public int getIterations() {
        return this.iterations.getCount();
    }

    public int getMaxIterations() {
        return this.iterations.getMaximalCount();
    }

    public void incrementIterationCount() throws MaxCountExceededException {
        this.iterations.incrementCount();
    }

    public void removeIterationListener(IterationListener listener) {
        this.listeners.remove(listener);
    }

    public void resetIterationCount() {
        this.iterations.resetCount();
    }
}

