/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.handlers;

import com.darkona.adventurebackpack.common.ServerActions;
import com.darkona.adventurebackpack.config.Keybindings;
import com.darkona.adventurebackpack.entity.EntityFriendlySpider;
import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.network.CycleToolPacket;
import com.darkona.adventurebackpack.network.GUIPacket;
import com.darkona.adventurebackpack.network.PlayerActionPacket;
import com.darkona.adventurebackpack.network.SyncPropertiesPacket;
import com.darkona.adventurebackpack.network.WearableModePacket;
import com.darkona.adventurebackpack.reference.BackpackTypes;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;

public class KeyInputEventHandler {
    @SubscribeEvent
    public void handleKeyInputEvent(InputEvent.KeyInputEvent event) {
        this.onInput();
    }

    @SubscribeEvent
    public void handleMouseInputEvent(InputEvent.MouseInputEvent event) {
        this.onInput();
    }

    public void onInput() {
        Key pressedKey = KeyInputEventHandler.getPressedKeyBinding();
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        if (pressedKey == Key.UNKNOWN || player == null || player.field_70128_L) {
            return;
        }
        if (pressedKey == Key.INVENTORY && mc.field_71415_G) {
            this.sendSyncPropertiesPacket();
            if (player.func_70093_af()) {
                if (Wearing.isHoldingBackpack((EntityPlayer)player)) {
                    this.sendGUIPacket((byte)1, (byte)1);
                }
            } else if (Wearing.isWearingBackpack((EntityPlayer)player)) {
                this.sendGUIPacket((byte)1, (byte)0);
            } else if (Wearing.isHoldingBackpack((EntityPlayer)player)) {
                this.sendGUIPacket((byte)1, (byte)1);
            } else if (Wearing.isWearingCopter((EntityPlayer)player)) {
                this.sendGUIPacket((byte)2, (byte)0);
            } else if (Wearing.isWearingJetpack((EntityPlayer)player)) {
                this.sendGUIPacket((byte)3, (byte)0);
            }
        }
        if (pressedKey == Key.ACTION) {
            if (Wearing.isHoldingHose((EntityPlayer)player)) {
                this.sendCycleToolPacket((byte)0);
                ServerActions.switchHose((EntityPlayer)player, false, true);
            } else if (Wearing.isWearingBackpack((EntityPlayer)player)) {
                if (player.func_70093_af()) {
                    if (BackpackTypes.isNightVision(Wearing.getWearingBackpackInv((EntityPlayer)player).getType())) {
                        this.sendWearableModePacket((byte)4);
                        ServerActions.toggleNightVision((EntityPlayer)player, Wearing.getWearingBackpack((EntityPlayer)player));
                    }
                } else {
                    this.sendWearableModePacket((byte)3);
                    ServerActions.toggleToolCycling((EntityPlayer)player, Wearing.getWearingBackpack((EntityPlayer)player));
                }
            } else if (Wearing.isWearingCopter((EntityPlayer)player)) {
                if (player.func_70093_af()) {
                    this.sendWearableModePacket((byte)0);
                    ServerActions.toggleCopterPack((EntityPlayer)player, Wearing.getWearingCopter((EntityPlayer)player), (byte)0);
                } else {
                    this.sendWearableModePacket((byte)1);
                    ServerActions.toggleCopterPack((EntityPlayer)player, Wearing.getWearingCopter((EntityPlayer)player), (byte)1);
                }
            } else if (Wearing.isWearingJetpack((EntityPlayer)player) && player.func_70093_af()) {
                this.sendWearableModePacket((byte)2);
                ServerActions.toggleCoalJetpack((EntityPlayer)player, Wearing.getWearingJetpack((EntityPlayer)player));
            }
        }
        if (pressedKey == Key.JUMP && player.field_70154_o instanceof EntityFriendlySpider) {
            this.sendPlayerActionPacket((byte)0);
            ((EntityFriendlySpider)player.field_70154_o).func_70637_d(true);
        }
    }

    private static Key getPressedKeyBinding() {
        if (Keybindings.openInventory.func_151468_f()) {
            return Key.INVENTORY;
        }
        if (Keybindings.toggleActions.func_151468_f()) {
            return Key.ACTION;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151468_f()) {
            return Key.JUMP;
        }
        return Key.UNKNOWN;
    }

    private void sendSyncPropertiesPacket() {
        ModNetwork.net.sendToServer((IMessage)new SyncPropertiesPacket.Message());
    }

    private void sendGUIPacket(byte type, byte from) {
        ModNetwork.net.sendToServer((IMessage)new GUIPacket.GUImessage(type, from));
    }

    private void sendWearableModePacket(byte type) {
        ModNetwork.net.sendToServer((IMessage)new WearableModePacket.Message(type));
    }

    private void sendCycleToolPacket(byte type) {
        ModNetwork.net.sendToServer((IMessage)new CycleToolPacket.CycleToolMessage(false, type));
    }

    private void sendPlayerActionPacket(byte type) {
        ModNetwork.net.sendToServer((IMessage)new PlayerActionPacket.ActionMessage(type));
    }

    public static enum Key {
        UNKNOWN,
        INVENTORY,
        ACTION,
        JUMP;

    }
}

