/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.common;

import com.darkona.adventurebackpack.block.TileAdventureBackpack;
import com.darkona.adventurebackpack.common.BackpackRemovals;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.entity.ai.EntityAIAvoidPlayerWithBackpack;
import com.darkona.adventurebackpack.init.ModFluids;
import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.inventory.InventoryBackpack;
import com.darkona.adventurebackpack.network.messages.EntityParticlePacket;
import com.darkona.adventurebackpack.reference.BackpackTypes;
import com.darkona.adventurebackpack.util.LogHelper;
import com.darkona.adventurebackpack.util.Utils;
import com.darkona.adventurebackpack.util.Wearing;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BackpackAbilities {
    public static BackpackAbilities backpackAbilities = new BackpackAbilities();
    public static BackpackRemovals backpackRemovals = new BackpackRemovals();
    private final FluidStack milkStack = new FluidStack(FluidRegistry.getFluid((String)"milk"), 1);
    private final FluidStack soupStack = new FluidStack(FluidRegistry.getFluid((String)"mushroomstew"), 1);
    private final FluidStack lavaStack = new FluidStack(FluidRegistry.LAVA, 1);

    public void executeAbility(EntityPlayer player, World world, ItemStack backpack) {
        String skinName = BackpackTypes.getSkinName(backpack);
        try {
            this.getClass().getMethod("item" + skinName, EntityPlayer.class, World.class, ItemStack.class).invoke((Object)backpackAbilities, player, world, backpack);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void executeTileAbility(World world, TileAdventureBackpack backpack) {
        String skinName = BackpackTypes.getSkinName(backpack.getType());
        try {
            this.getClass().getMethod("tile" + skinName, World.class, TileAdventureBackpack.class).invoke((Object)backpackAbilities, world, backpack);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void executeRemoval(EntityPlayer player, World world, ItemStack backpack) {
        String skinName = BackpackTypes.getSkinName(backpack);
        try {
            backpackRemovals.getClass().getMethod("item" + skinName, EntityPlayer.class, World.class, ItemStack.class).invoke((Object)backpackRemovals, player, world, backpack);
        }
        catch (Exception oops) {
            LogHelper.error("---Something bad happened when removing a backpack---");
            oops.printStackTrace();
        }
    }

    private boolean isUnderRain(EntityPlayer player) {
        return player.field_70170_p.func_72951_B(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v)) || player.field_70170_p.func_72951_B(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)(player.field_70163_u + (double)player.field_70131_O)), MathHelper.func_76128_c((double)player.field_70161_v));
    }

    public void itemSunflower(EntityPlayer player, World world, ItemStack backpack) {
        InventoryBackpack inv = new InventoryBackpack(backpack);
        if (inv.getLastTime() <= 0) {
            if (world.func_72935_r() && world.func_72937_j(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)(player.field_70163_u + 1.0)), MathHelper.func_76128_c((double)player.field_70161_v))) {
                player.func_71024_bL().func_75122_a(2, 0.2f);
            }
            inv.setLastTime(Utils.secondsToTicks(120));
        } else {
            inv.setLastTime(inv.getLastTime() - 1);
        }
        inv.dirtyTime();
    }

    public void itemBat(EntityPlayer player, World world, ItemStack backpack) {
        PotionEffect nightVision = null;
        if (player.func_82165_m(Potion.field_76439_r.field_76415_H)) {
            nightVision = player.func_70660_b(Potion.field_76439_r);
        }
        if (!(nightVision != null && nightVision.func_76459_b() >= 222 || Wearing.getWearingBackpackInv(player).getDisableNVision())) {
            player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 239, -1, true));
        } else if (nightVision != null && Wearing.getWearingBackpackInv(player).getDisableNVision()) {
            backpackRemovals.itemBat(player, world, backpack);
        }
    }

    public void itemSquid(EntityPlayer player, World world, ItemStack backpack) {
        if (player.func_70055_a(Material.field_151586_h)) {
            player.func_70690_d(new PotionEffect(Potion.field_76427_o.func_76396_c(), 19, -1, true));
            this.itemBat(player, world, backpack);
        } else if (player.func_82165_m(Potion.field_76427_o.field_76415_H) && player.func_70660_b(Potion.field_76427_o).func_76458_c() == -1) {
            backpackRemovals.itemSquid(player, world, backpack);
        }
    }

    public void itemPigman(EntityPlayer player, World world, ItemStack backpack) {
        PotionEffect potion = null;
        if (player.func_82165_m(Potion.field_76426_n.field_76415_H)) {
            potion = player.func_70660_b(Potion.field_76426_n);
        }
        if (potion == null || potion.func_76459_b() < 222) {
            player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 239, -1, true));
        }
    }

    public void itemDragon(EntityPlayer player, World world, ItemStack backpack) {
        this.itemBat(player, world, backpack);
        this.itemPigman(player, world, backpack);
        PotionEffect potion = null;
        if (ConfigHandler.dragonBackpackRegen != 0) {
            if (player.func_82165_m(Potion.field_76428_l.field_76415_H)) {
                potion = player.func_70660_b(Potion.field_76428_l);
            }
            if (player.func_110143_aJ() < player.func_110138_aP()) {
                if (potion == null || potion.func_76459_b() < 20) {
                    player.func_70690_d(new PotionEffect(Potion.field_76428_l.func_76396_c(), 900, ConfigHandler.dragonBackpackRegen - 1, true));
                }
            } else if (potion != null && potion.func_76458_c() == ConfigHandler.dragonBackpackRegen - 1) {
                if (player.field_70170_p.field_72995_K) {
                    player.func_70618_n(Potion.field_76428_l.field_76415_H);
                } else {
                    player.func_82170_o(Potion.field_76428_l.field_76415_H);
                }
            }
        }
        if (ConfigHandler.dragonBackpackDamage != 0) {
            if (player.func_82165_m(Potion.field_76420_g.field_76415_H)) {
                potion = player.func_70660_b(Potion.field_76420_g);
            }
            if (potion == null || potion.func_76459_b() < 222) {
                player.func_70690_d(new PotionEffect(Potion.field_76420_g.func_76396_c(), 239, ConfigHandler.dragonBackpackDamage - 1, true));
            }
        }
    }

    public void itemRainbow(EntityPlayer player, World world, ItemStack backpack) {
        InventoryBackpack inv = new InventoryBackpack(backpack);
        int noteTime = inv.getLastTime() - 1;
        if (noteTime >= 0 && noteTime < Utils.secondsToTicks(147)) {
            if (ConfigHandler.rainbowBackpackSSpeed != 0) {
                player.func_70690_d(new PotionEffect(Potion.field_76424_c.func_76396_c(), 60, ConfigHandler.rainbowBackpackSSpeed - 1, true));
            }
            if (ConfigHandler.rainbowBackpackSJump != 0) {
                player.func_70690_d(new PotionEffect(Potion.field_76430_j.func_76396_c(), 60, ConfigHandler.rainbowBackpackSJump - 1, true));
            }
            if (noteTime % 2 == 0 && !world.field_72995_K) {
                ModNetwork.sendToNearby(new EntityParticlePacket.Message(0, (Entity)player), player);
            }
        }
        PotionEffect moveSpeed = null;
        if (player.func_82165_m(Potion.field_76424_c.field_76415_H)) {
            moveSpeed = player.func_70660_b(Potion.field_76424_c);
        }
        if (ConfigHandler.rainbowBackpackSpeed != 0 && (moveSpeed == null || moveSpeed.func_76459_b() < 222)) {
            player.func_70690_d(new PotionEffect(Potion.field_76424_c.func_76396_c(), 239, ConfigHandler.rainbowBackpackSpeed - 1, true));
        }
        inv.setLastTime(noteTime);
        inv.func_70296_d();
    }

    public void itemIronGolem(EntityPlayer player, World world, ItemStack backpack) {
    }

    public void itemCactus(EntityPlayer player, World world, ItemStack backpack) {
        if (world.field_72995_K) {
            return;
        }
        InventoryBackpack inv = new InventoryBackpack(backpack);
        int drops = 0;
        if (player.func_70090_H()) {
            drops += 2;
        }
        if (this.isUnderRain(player)) {
            ++drops;
        }
        if (inv.getLastTime() <= 0 && drops > 0) {
            inv.setLastTime(5);
            FluidStack raindrop = new FluidStack(FluidRegistry.WATER, drops);
            inv.getLeftTank().fill(raindrop, true);
            inv.getRightTank().fill(raindrop, true);
        } else {
            inv.setLastTime(inv.getLastTime() - 1);
        }
        inv.dirtyTime();
        inv.dirtyTanks();
    }

    public void itemPig(EntityPlayer player, World world, ItemStack backpack) {
        InventoryBackpack inv = new InventoryBackpack(backpack);
        int oinkTime = inv.getLastTime() - 1;
        if (oinkTime <= 0) {
            world.func_72956_a((Entity)player, "mob.pig.say", 0.8f, 1.0f);
            oinkTime = Utils.secondsToTicks(world.field_73012_v.nextInt(61));
        }
        inv.setLastTime(oinkTime);
        inv.dirtyTime();
    }

    public void itemSlime(EntityPlayer player, World world, ItemStack backpack) {
        if (world.func_72853_d() == 0 && !world.func_72935_r()) {
            player.func_70690_d(new PotionEffect(Potion.field_76424_c.func_76396_c(), 100, 0, true));
        }
        if (player.field_70122_E) {
            if (player.field_70701_bs == 0.0f && player.field_70702_br == 0.0f && Math.abs(player.field_70701_bs) < 3.0f && Math.abs(player.field_70702_br) < 3.0f) {
                player.func_70024_g(player.field_70159_w *= 0.828, 0.0, player.field_70179_y *= 0.828);
            }
            if (player.func_70051_ag()) {
                int slimeTime;
                InventoryBackpack inv = new InventoryBackpack(backpack);
                int n = slimeTime = inv.getLastTime() > 0 ? inv.getLastTime() - 1 : 5;
                if (slimeTime <= 0) {
                    if (!world.field_72995_K) {
                        ModNetwork.sendToNearby(new EntityParticlePacket.Message(2, (Entity)player), player);
                    }
                    world.func_72956_a((Entity)player, "mob.slime.small", 0.6f, world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat());
                    slimeTime = 5;
                }
                inv.setLastTime(slimeTime);
                inv.dirtyTime();
            }
        }
    }

    public void itemChicken(EntityPlayer player, World world, ItemStack backpack) {
        InventoryBackpack inv = new InventoryBackpack(backpack);
        int eggTime = inv.getLastTime() - 1;
        if (eggTime <= 0) {
            player.func_85030_a("mob.chicken.plop", 1.0f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.3f + 1.0f);
            if (!world.field_72995_K) {
                player.func_145779_a(Items.field_151110_aK, 1);
            }
            eggTime = Utils.secondsToTicks(200 + 10 * world.field_73012_v.nextInt(10));
        }
        inv.setLastTime(eggTime);
        inv.dirtyTime();
    }

    public void itemMelon(EntityPlayer player, World world, ItemStack backpack) {
        if (world.field_72995_K) {
            return;
        }
        InventoryBackpack inv = new InventoryBackpack(backpack);
        int drops = 0;
        if (player.func_70090_H()) {
            drops += 2;
        }
        if (this.isUnderRain(player)) {
            ++drops;
        }
        if (inv.getLastTime() <= 0 && drops > 0) {
            inv.setLastTime(5);
            FluidStack raindrop = new FluidStack((Fluid)ModFluids.melonJuice, drops);
            inv.getLeftTank().fill(raindrop, true);
            inv.getRightTank().fill(raindrop, true);
        } else {
            inv.setLastTime(inv.getLastTime() - 1);
        }
        inv.dirtyTime();
        inv.dirtyTanks();
    }

    public void itemCreeper(EntityPlayer player, World world, ItemStack backpack) {
        InventoryBackpack inv = new InventoryBackpack(backpack);
        int pssstTime = inv.getLastTime() - 1;
        if (pssstTime <= 0) {
            pssstTime = 20;
            if (player.func_70093_af()) {
                List entities = player.field_70170_p.func_72839_b((Entity)player, AxisAlignedBB.func_72330_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)(player.field_70165_t + 1.0), (double)(player.field_70163_u + 1.0), (double)(player.field_70161_v + 1.0)).func_72314_b(5.0, 1.0, 5.0));
                if (entities.isEmpty()) {
                    --pssstTime;
                    return;
                }
                for (Entity entity : entities) {
                    if (!(entity instanceof EntityPlayer) || !(player.func_70032_d(entity) <= 3.0f)) continue;
                    world.func_72956_a((Entity)player, "creeper.primed", 1.2f, 0.5f);
                    pssstTime = Utils.secondsToTicks(120);
                }
            }
        }
        inv.setLastTime(pssstTime);
        inv.func_70296_d();
    }

    public void itemCow(EntityPlayer player, World world, ItemStack backpack) {
        if (world.field_72995_K) {
            return;
        }
        InventoryBackpack inv = new InventoryBackpack(backpack);
        inv.func_70295_k_();
        if (inv.getLeftTank().fill(this.milkStack, false) <= 0 && inv.getRightTank().fill(this.milkStack, false) <= 0) {
            return;
        }
        int wheatConsumed = 0;
        int milkTime = -1;
        if (inv.getExtendedProperties() != null && inv.getExtendedProperties().func_74764_b("wheatConsumed")) {
            wheatConsumed = inv.getExtendedProperties().func_74762_e("wheatConsumed");
            milkTime = inv.getExtendedProperties().func_74762_e("milkTime") - 1;
        }
        int eatTime = Math.max(inv.getLastTime() - 1, 0);
        if (inv.hasItem(Items.field_151015_O) && eatTime <= 0 && milkTime <= 0) {
            eatTime = 20;
            inv.consumeInventoryItem(Items.field_151015_O);
            ++wheatConsumed;
            inv.dirtyInventory();
        }
        int factor = 1;
        if (wheatConsumed == 16) {
            wheatConsumed = 0;
            milkTime = 1000 * factor - factor;
            world.func_72956_a((Entity)player, "mob.cow.say", 1.0f, 1.0f);
        }
        if (milkTime >= 0 && milkTime % factor == 0) {
            if (inv.getLeftTank().fill(this.milkStack, true) <= 0) {
                inv.getRightTank().fill(this.milkStack, true);
            }
            inv.dirtyTanks();
        }
        if (milkTime < -1) {
            milkTime = -1;
        }
        inv.getExtendedProperties().func_74768_a("wheatConsumed", wheatConsumed);
        inv.getExtendedProperties().func_74768_a("milkTime", milkTime);
        inv.setLastTime(eatTime);
        inv.dirtyExtended();
        inv.dirtyTime();
    }

    public void itemMooshroom(EntityPlayer player, World world, ItemStack backpack) {
        if (world.field_72995_K) {
            return;
        }
        InventoryBackpack inv = new InventoryBackpack(backpack);
        inv.func_70295_k_();
        if (inv.getLeftTank().fill(this.soupStack, false) <= 0 && inv.getRightTank().fill(this.soupStack, false) <= 0) {
            return;
        }
        int wheatConsumed = 0;
        int milkTime = -1;
        if (inv.getExtendedProperties() != null && inv.getExtendedProperties().func_74764_b("wheatConsumed")) {
            wheatConsumed = inv.getExtendedProperties().func_74762_e("wheatConsumed");
            milkTime = inv.getExtendedProperties().func_74762_e("milkTime") - 1;
        }
        int eatTime = Math.max(inv.getLastTime() - 1, 0);
        if (inv.hasItem(Items.field_151015_O) && eatTime <= 0 && milkTime <= 0) {
            eatTime = 20;
            inv.consumeInventoryItem(Items.field_151015_O);
            ++wheatConsumed;
            inv.dirtyInventory();
        }
        int factor = 1;
        if (wheatConsumed == 16) {
            wheatConsumed = 0;
            milkTime = 1000 * factor - factor;
            world.func_72956_a((Entity)player, "mob.cow.say", 1.0f, 1.0f);
        }
        if (milkTime >= 0 && milkTime % factor == 0) {
            if (inv.getLeftTank().fill(this.soupStack, true) <= 0) {
                inv.getRightTank().fill(this.soupStack, true);
            }
            inv.dirtyTanks();
        }
        if (milkTime < -1) {
            milkTime = -1;
        }
        inv.getExtendedProperties().func_74768_a("wheatConsumed", wheatConsumed);
        inv.getExtendedProperties().func_74768_a("milkTime", milkTime);
        inv.setLastTime(eatTime);
        inv.dirtyExtended();
        inv.dirtyTime();
    }

    public void itemWolf(EntityPlayer player, World world, ItemStack backpack) {
        InventoryBackpack inv = new InventoryBackpack(backpack);
        int lastCheckTime = inv.getLastTime() - 1;
        if (lastCheckTime <= 0) {
            lastCheckTime = 20;
            List wolves = world.func_72872_a(EntityWolf.class, AxisAlignedBB.func_72330_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)(player.field_70165_t + 1.0), (double)(player.field_70163_u + 1.0), (double)(player.field_70161_v + 1.0)).func_72314_b(16.0, 4.0, 16.0));
            if (wolves.isEmpty()) {
                return;
            }
            for (EntityWolf wolf : wolves) {
                if (!wolf.func_70919_bu() || wolf.func_70638_az() != player) continue;
                wolf.func_70916_h(false);
                wolf.func_70624_b(null);
                wolf.func_70604_c(null);
                for (Object o : wolf.field_70715_bh.field_75782_a) {
                    ((EntityAIBase)o).func_75251_c();
                }
            }
        }
        inv.setLastTime(lastCheckTime);
        inv.dirtyTime();
    }

    public void itemBlaze(EntityPlayer player, World world, ItemStack backpack) {
    }

    public void itemOcelot(EntityPlayer player, World world, ItemStack backpack) {
        InventoryBackpack inv = new InventoryBackpack(backpack);
        int lastCheckTime = inv.getLastTime() - 1;
        if (lastCheckTime <= 0) {
            lastCheckTime = 20;
            List creepers = player.field_70170_p.func_72872_a(EntityCreeper.class, AxisAlignedBB.func_72330_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)(player.field_70165_t + 1.0), (double)(player.field_70163_u + 1.0), (double)(player.field_70161_v + 1.0)).func_72314_b(16.0, 4.0, 16.0));
            for (EntityCreeper creeper : creepers) {
                boolean set = true;
                EntityAIAvoidPlayerWithBackpack task = new EntityAIAvoidPlayerWithBackpack((EntityCreature)creeper, EntityPlayer.class, 10.0f, 1.0, 1.3, BackpackTypes.OCELOT);
                for (Object entry : creeper.field_70714_bg.field_75782_a) {
                    if (!(((EntityAITasks.EntityAITaskEntry)entry).field_75733_a instanceof EntityAIAvoidPlayerWithBackpack)) continue;
                    set = false;
                    break;
                }
                if (!set) continue;
                creeper.field_70714_bg.func_75776_a(3, (EntityAIBase)task);
            }
        }
        inv.setLastTime(lastCheckTime);
        inv.func_70296_d();
    }

    private void fillWithRain(World world, TileAdventureBackpack backpack, FluidStack fluid, int time) {
        if (world.func_72896_J() && world.func_72937_j(backpack.field_145851_c, backpack.field_145848_d, backpack.field_145849_e)) {
            int dropTime = backpack.getLastTime() - 1;
            if (dropTime <= 0) {
                backpack.getRightTank().fill(fluid, true);
                backpack.getLeftTank().fill(fluid, true);
                dropTime = time;
                backpack.func_70296_d();
            }
            backpack.setLastTime(dropTime);
        }
    }

    public void tileCactus(World world, TileAdventureBackpack backpack) {
        this.fillWithRain(world, backpack, new FluidStack(FluidRegistry.WATER, 2), 5);
    }

    public void tileMelon(World world, TileAdventureBackpack backpack) {
        this.fillWithRain(world, backpack, new FluidStack((Fluid)ModFluids.melonJuice, 2), 5);
    }
}

