/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.neid.mixins.interfaces;

import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import com.gtnewhorizon.gtnhlib.util.data.BlockMeta;
import java.nio.ShortBuffer;
import java.util.function.IntToLongFunction;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public interface ClientBlockTransformer {
    public boolean transformBlock(World var1, int var2, int var3, int var4, BlockMeta var5);

    default public void transformBulk(World world, IntToLongFunction coord, ShortBuffer blocks, ShortBuffer metas) {
        BlockIdCache input = new BlockIdCache();
        BlockIdCache output = new BlockIdCache();
        int len = blocks.capacity();
        BlockMeta pooled = new BlockMeta(Blocks.field_150350_a, 0);
        for (int i = 0; i < len; ++i) {
            pooled.setBlock(input.getBlock(blocks.get(i)));
            pooled.setBlockMeta((int)metas.get(i));
            long c = coord.applyAsLong(i);
            boolean didSomething = this.transformBlock(world, CoordinatePacker.unpackX((long)c), CoordinatePacker.unpackY((long)c), CoordinatePacker.unpackZ((long)c), pooled);
            if (!didSomething) continue;
            blocks.put(i, (short)output.getId(pooled.getBlock()));
            metas.put(i, (short)pooled.getBlockMeta());
        }
    }

    public static class BlockIdCache {
        public Block block;
        public int blockId = -1;

        public int getId(Block block) {
            if (this.block == block) {
                return this.blockId;
            }
            this.block = block;
            this.blockId = Block.func_149682_b((Block)block);
            return this.blockId;
        }

        public Block getBlock(int id) {
            if (id == this.blockId) {
                return this.block;
            }
            this.blockId = id;
            this.block = Block.func_149729_e((int)id);
            return this.block;
        }
    }
}

