/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.storage;

import betterquesting.api.storage.INameCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;

public final class NameCache
implements INameCache {
    public static final NameCache INSTANCE = new NameCache();
    private final HashMap<UUID, NBTTagCompound> cache = new HashMap();
    private List<String> nameCache = null;

    @Override
    public synchronized boolean updateName(@Nonnull EntityPlayerMP player) {
        MinecraftServer server = player.field_71133_b;
        NBTTagCompound tag = this.cache.computeIfAbsent(player.func_146103_bH().getId(), key -> new NBTTagCompound());
        String name = player.func_146103_bH().getName();
        boolean isOP = server.func_71203_ab().func_152596_g(player.func_146103_bH());
        if (!tag.func_74779_i("name").equals(name) || tag.func_74767_n("isOP") != isOP) {
            tag.func_74778_a("name", name);
            tag.func_74757_a("isOP", isOP);
            return true;
        }
        return false;
    }

    @Override
    public synchronized String getName(@Nonnull UUID uuid) {
        NBTTagCompound tag = this.cache.get(uuid);
        return tag == null ? uuid.toString() : tag.func_74779_i("name");
    }

    @Override
    public synchronized UUID getUUID(@Nonnull String name) {
        for (Map.Entry<UUID, NBTTagCompound> entry : this.cache.entrySet()) {
            if (!entry.getValue().func_74779_i("name").equalsIgnoreCase(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public synchronized boolean isOP(@Nonnull UUID uuid) {
        NBTTagCompound tag = this.cache.get(uuid);
        return tag != null && tag.func_74767_n("isOP");
    }

    @Override
    public synchronized int size() {
        return this.cache.size();
    }

    @Override
    public synchronized NBTTagList writeToNBT(NBTTagList nbt, @Nullable List<UUID> users) {
        for (Map.Entry<UUID, NBTTagCompound> entry : this.cache.entrySet()) {
            if (users != null && !users.contains(entry.getKey())) continue;
            NBTTagCompound jn = new NBTTagCompound();
            jn.func_74778_a("uuid", entry.getKey().toString());
            jn.func_74778_a("name", entry.getValue().func_74779_i("name"));
            jn.func_74757_a("isOP", entry.getValue().func_74767_n("isOP"));
            nbt.func_74742_a((NBTBase)jn);
        }
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagList nbt, boolean merge) {
        if (!merge) {
            this.cache.clear();
        }
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            NBTTagCompound jn = nbt.func_150305_b(i);
            try {
                UUID uuid = UUID.fromString(jn.func_74779_i("uuid"));
                String name = jn.func_74779_i("name");
                boolean isOP = jn.func_74767_n("isOP");
                NBTTagCompound j2 = new NBTTagCompound();
                j2.func_74778_a("name", name);
                j2.func_74757_a("isOP", isOP);
                this.cache.put(uuid, j2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void reset() {
        this.cache.clear();
        this.nameCache = null;
    }

    @Override
    public synchronized List<String> getAllNames() {
        if (this.nameCache != null) {
            return this.nameCache;
        }
        this.nameCache = new ArrayList<String>();
        for (NBTTagCompound tag : this.cache.values()) {
            if (tag == null || !tag.func_150297_b("name", 8)) continue;
            this.nameCache.add(tag.func_74779_i("name"));
        }
        return Collections.unmodifiableList(this.nameCache);
    }
}

