/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors;

import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.editors.GuiImporters;
import betterquesting.client.gui2.editors.GuiQuestLineAddRemove;
import betterquesting.client.gui2.editors.GuiTextEditor;
import betterquesting.client.gui2.editors.designer.GuiDesigner;
import betterquesting.client.gui2.editors.nbt.GuiItemSelection;
import betterquesting.network.handlers.NetChapterEdit;
import betterquesting.questing.QuestLineDatabase;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.vector.Vector4f;

public class GuiQuestLinesEditor
extends GuiScreenCanvas
implements IPEventListener,
IVolatileScreen,
INeedsRefresh {
    private CanvasScrolling lineList;
    private PanelTextField<String> tfName;
    private PanelTextField<String> tfDesc;
    private PanelButton btnDesign;
    private PanelButton btnVis;
    private PanelButton btnIcon;
    private IQuestLine selected;
    private UUID selID = null;

    public GuiQuestLinesEditor(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void refreshGui() {
        if (this.selID != null) {
            this.selected = (IQuestLine)QuestLineDatabase.INSTANCE.get(this.selID);
            if (this.selected == null) {
                this.selID = null;
                this.btnDesign.setActive(false);
                this.btnIcon.setActive(false);
                this.btnVis.setActive(false);
                this.tfName.setText("");
                this.tfDesc.setText("");
            } else {
                this.btnDesign.setActive(true);
                this.btnIcon.setActive(true);
                this.btnVis.setActive(true);
                this.btnVis.setText(QuestTranslation.translate("betterquesting.btn.show", new Object[0]) + ": " + this.selected.getProperty(NativeProps.VISIBILITY));
                if (!this.tfName.isFocused()) {
                    this.tfName.setText(this.selected.getUnlocalisedName());
                }
                if (!this.tfDesc.isFocused()) {
                    this.tfDesc.setText(this.selected.getUnlocalisedDescription());
                }
            }
        }
        this.reloadList();
    }

    @Override
    public void initPanel() {
        super.initPanel();
        PEventBroadcaster.INSTANCE.register(this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        PanelTextBox panTxt = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate("betterquesting.title.edit_line1", new Object[0])).setAlignment(1);
        panTxt.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel(panTxt);
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0])));
        this.lineList = new CanvasScrolling(new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(16, 32, 16, 48), 0));
        cvBackground.addPanel(this.lineList);
        PanelVScrollBar scList = new PanelVScrollBar(new GuiTransform(new Vector4f(0.5f, 0.0f, 0.5f, 1.0f), new GuiPadding(-16, 32, 8, 48), 0));
        cvBackground.addPanel(scList);
        this.lineList.setScrollDriverY(scList);
        PanelButton btnAdd = new PanelButton(new GuiTransform(new Vector4f(0.0f, 1.0f, 0.25f, 1.0f), new GuiPadding(16, -40, 0, 24), 0), 1, QuestTranslation.translate("betterquesting.btn.new", new Object[0]));
        cvBackground.addPanel(btnAdd);
        PanelButton btnImport = new PanelButton(new GuiTransform(new Vector4f(0.25f, 1.0f, 0.5f, 1.0f), new GuiPadding(0, -40, 16, 24), 0), 2, QuestTranslation.translate("betterquesting.btn.import", new Object[0]));
        cvBackground.addPanel(btnImport);
        CanvasEmpty cvRight = new CanvasEmpty(new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(8, 32, 16, 24), 0));
        cvBackground.addPanel(cvRight);
        PanelTextBox txtName = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 4, 0, -16), 0), QuestTranslation.translate("betterquesting.gui.name", new Object[0]));
        txtName.setColor(PresetColor.TEXT_MAIN.getColor());
        cvRight.addPanel(txtName);
        this.tfName = new PanelTextField<String>(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), "", FieldFilterString.INSTANCE);
        cvRight.addPanel(this.tfName);
        PanelTextBox txtDesc = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 36, 0, -48), 0), QuestTranslation.translate("betterquesting.gui.description", new Object[0]));
        txtDesc.setColor(PresetColor.TEXT_MAIN.getColor());
        cvRight.addPanel(txtDesc);
        this.tfDesc = new PanelTextField<String>(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 48, 16, -64), 0), "", FieldFilterString.INSTANCE);
        this.tfDesc.setMaxLength(Integer.MAX_VALUE);
        cvRight.addPanel(this.tfDesc);
        this.btnIcon = new PanelButton(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 80, 0, -96), 0), -1, QuestTranslation.translate("betterquesting.btn.icon", new Object[0])){

            @Override
            public void onButtonClick() {
                if (GuiQuestLinesEditor.this.selected == null) {
                    return;
                }
                GuiQuestLinesEditor.this.field_146297_k.func_147108_a((GuiScreen)new GuiItemSelection((GuiScreen)GuiQuestLinesEditor.this, (BigItemStack)GuiQuestLinesEditor.this.selected.getProperty(NativeProps.ICON), value -> {
                    GuiQuestLinesEditor.this.selected.setProperty(NativeProps.ICON, value);
                    GuiQuestLinesEditor.this.SendChanges(Maps.immutableEntry((Object)GuiQuestLinesEditor.this.selID, (Object)GuiQuestLinesEditor.this.selected));
                }));
            }
        };
        this.btnIcon.setActive(this.selected != null);
        cvRight.addPanel(this.btnIcon);
        this.btnVis = new PanelButton(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 96, 0, -112), 0), -1, QuestTranslation.translate("betterquesting.btn.show", new Object[0]) + ": " + (Object)((Object)(this.selected == null ? EnumQuestVisibility.NORMAL : (EnumQuestVisibility)((Object)this.selected.getProperty(NativeProps.VISIBILITY))))){

            @Override
            public void onButtonClick() {
                if (GuiQuestLinesEditor.this.selected == null) {
                    return;
                }
                EnumQuestVisibility[] visList = EnumQuestVisibility.values();
                EnumQuestVisibility vis = (EnumQuestVisibility)((Object)GuiQuestLinesEditor.this.selected.getProperty(NativeProps.VISIBILITY));
                vis = visList[(vis.ordinal() + 1) % visList.length];
                GuiQuestLinesEditor.this.selected.setProperty(NativeProps.VISIBILITY, (Object)vis);
                this.setText(QuestTranslation.translate("betterquesting.btn.show", new Object[0]) + ": " + (Object)((Object)vis));
            }
        };
        this.btnVis.setActive(this.selected != null);
        cvRight.addPanel(this.btnVis);
        PanelButton btnManage = new PanelButton(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 112, 0, -128), 0), 3, QuestTranslation.translate("betterquesting.btn.add_remove_quests", new Object[0]));
        cvRight.addPanel(btnManage);
        this.btnDesign = new PanelButton(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 96, 0, -112), 0), 4, QuestTranslation.translate("betterquesting.btn.designer", new Object[0]));
        this.btnDesign.setActive(this.selected != null);
        cvRight.addPanel(this.btnDesign);
        PanelButton btnTextEditor = new PanelButton(new GuiTransform(GuiAlign.TOP_RIGHT, new GuiPadding(-16, 48, 0, -64), 0), 8, "Aa");
        cvRight.addPanel(btnTextEditor);
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_CENTER, 0, 32, 0, 0, 0);
        ls0.setParent(cvBackground.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -24, 0, 0, 0);
        le0.setParent(cvBackground.getTransform());
        PanelLine paLine0 = new PanelLine(ls0, le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        cvBackground.addPanel(paLine0);
        if (this.selID != null) {
            this.selected = (IQuestLine)QuestLineDatabase.INSTANCE.get(this.selID);
            if (this.selected == null) {
                this.selID = null;
                this.btnDesign.setActive(false);
                this.btnIcon.setActive(false);
                this.btnVis.setActive(false);
                this.tfName.setText("");
                this.tfDesc.setText("");
            } else {
                this.btnDesign.setActive(true);
                this.btnIcon.setActive(true);
                this.btnVis.setActive(true);
                if (!this.tfName.isFocused()) {
                    this.tfName.setText(this.selected.getUnlocalisedName());
                }
                if (!this.tfDesc.isFocused()) {
                    this.tfDesc.setText(this.selected.getUnlocalisedDescription());
                }
            }
        }
        this.reloadList();
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        if (this.selected != null) {
            boolean changed = false;
            if (!this.tfName.getValue().equals(this.selected.getUnlocalisedName())) {
                this.selected.setProperty(NativeProps.NAME, this.tfName.getValue());
                changed = true;
            }
            if (!this.tfDesc.getValue().equals(this.selected.getUnlocalisedDescription())) {
                this.selected.setProperty(NativeProps.DESC, this.tfDesc.getValue());
                changed = true;
            }
            if (changed) {
                this.SendChanges(Maps.immutableEntry((Object)this.selID, (Object)this.selected));
            }
        }
        return super.onMouseClick(mx, my, click);
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1) {
            NBTTagCompound payload = new NBTTagCompound();
            NBTTagList dataList = new NBTTagList();
            NBTTagCompound entry = new NBTTagCompound();
            dataList.func_74742_a((NBTBase)entry);
            payload.func_74782_a("data", (NBTBase)dataList);
            payload.func_74768_a("action", 3);
            NetChapterEdit.sendEdit(payload);
        } else if (btn.getButtonID() == 2) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiImporters(this));
        } else if (btn.getButtonID() == 3) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestLineAddRemove(this, this.selected));
        } else if (btn.getButtonID() == 4 && this.selected != null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiDesigner(this, this.selected));
        } else if (btn.getButtonID() == 5 && btn instanceof PanelButtonStorage) {
            Map.Entry entry = (Map.Entry)((PanelButtonStorage)btn).getStoredValue();
            this.selected = (IQuestLine)entry.getValue();
            this.selID = (UUID)entry.getKey();
            this.tfName.setText(this.selected.getUnlocalisedName());
            this.tfDesc.setText(this.selected.getUnlocalisedDescription());
            this.btnDesign.setActive(true);
            this.btnIcon.setActive(true);
            this.btnVis.setActive(true);
            this.btnVis.setText(QuestTranslation.translate("betterquesting.btn.show", new Object[0]) + ": " + this.selected.getProperty(NativeProps.VISIBILITY));
            this.reloadList();
        } else if (btn.getButtonID() == 6 && btn instanceof PanelButtonStorage) {
            Map.Entry entry = (Map.Entry)((PanelButtonStorage)btn).getStoredValue();
            NBTTagCompound payload = new NBTTagCompound();
            payload.func_74782_a("questLineIDs", (NBTBase)NBTConverter.UuidValueType.QUEST_LINE.writeIds(Collections.singletonList((UUID)entry.getKey())));
            payload.func_74768_a("action", 1);
            NetChapterEdit.sendEdit(payload);
        } else if (btn.getButtonID() == 7 && btn instanceof PanelButtonStorage) {
            Map.Entry entry = (Map.Entry)((PanelButtonStorage)btn).getStoredValue();
            int order = QuestLineDatabase.INSTANCE.getOrderIndex((UUID)entry.getKey());
            if (order > 0) {
                this.SendReorder(order);
            }
        } else if (btn.getButtonID() == 8) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiTextEditor(this, this.tfDesc.getRawText(), value -> {
                if (this.selected != null) {
                    this.tfDesc.setText((String)value);
                    this.selected.setProperty(NativeProps.DESC, value);
                    this.SendChanges(Maps.immutableEntry((Object)this.selID, (Object)this.selected));
                }
            }));
        }
    }

    private void reloadList() {
        this.lineList.resetCanvas();
        int w = this.lineList.getTransform().getWidth();
        int i = 0;
        for (Map.Entry<UUID, IQuestLine> entry : QuestLineDatabase.INSTANCE.getOrderedEntries()) {
            PanelButtonStorage<Map.Entry<UUID, IQuestLine>> tmp = new PanelButtonStorage<Map.Entry<UUID, IQuestLine>>(new GuiRectangle(0, i * 16, w - 32, 16, 0), 5, QuestTranslation.translateQuestLineName(entry), entry);
            tmp.setActive(!entry.getKey().equals(this.selID));
            this.lineList.addPanel(tmp);
            this.lineList.addPanel(new PanelButtonStorage<Map.Entry<UUID, IQuestLine>>(new GuiRectangle(w - 32, i * 16, 16, 16, 0), 6, "", entry).setIcon(PresetIcon.ICON_TRASH.getTexture()));
            this.lineList.addPanel(new PanelButtonStorage<Map.Entry<UUID, IQuestLine>>(new GuiRectangle(w - 16, i * 16, 16, 16, 0), 7, "", entry).setIcon(PresetIcon.ICON_UP.getTexture()));
            ++i;
        }
    }

    private void SendChanges(Map.Entry<UUID, IQuestLine> chapter) {
        NBTTagCompound payload = new NBTTagCompound();
        NBTTagList dataList = new NBTTagList();
        NBTTagCompound entry = new NBTTagCompound();
        NBTConverter.UuidValueType.QUEST_LINE.writeId(chapter.getKey(), entry);
        entry.func_74782_a("config", chapter.getValue().writeToNBT((NBTBase)new NBTTagCompound(), null));
        dataList.func_74742_a((NBTBase)entry);
        payload.func_74782_a("data", (NBTBase)dataList);
        payload.func_74768_a("action", 0);
        NetChapterEdit.sendEdit(payload);
    }

    private void SendReorder(int indexToShift) {
        if (indexToShift <= 0) {
            return;
        }
        List<Map.Entry<UUID, IQuestLine>> entries = QuestLineDatabase.INSTANCE.getOrderedEntries();
        if (indexToShift >= entries.size()) {
            return;
        }
        UUID[] chapterIDs = new UUID[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            chapterIDs[i] = entries.get(i).getKey();
        }
        UUID tmp = chapterIDs[indexToShift];
        chapterIDs[indexToShift] = chapterIDs[indexToShift - 1];
        chapterIDs[indexToShift - 1] = tmp;
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("questLineIDs", (NBTBase)NBTConverter.UuidValueType.QUEST_LINE.writeIds(Arrays.asList(chapterIDs)));
        payload.func_74768_a("action", 2);
        NetChapterEdit.sendEdit(payload);
    }
}

