/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2;

import betterquesting.api.utils.RenderUtils;
import betterquesting.api.utils.UuidConverter;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonQuest;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestBookmarks;
import betterquesting.api2.client.gui.popups.PopContextMenu;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.BookmarkHandler;
import betterquesting.client.gui2.GuiHome;
import betterquesting.client.gui2.GuiQuest;
import betterquesting.misc.QuestSearchEntry;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class GuiBookmarks
extends GuiScreenCanvas {
    private Consumer<QuestSearchEntry> callback;
    private CanvasQuestBookmarks cvBookmarks;

    public GuiBookmarks(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void initPanel() {
        super.initPanel();
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        CanvasEmpty cvInner = new CanvasEmpty(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(8, 8, 8, 8), 0));
        cvBackground.addPanel(cvInner);
        this.createExitButton(cvInner);
        PanelTextBox txtDb = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -16), 0), QuestTranslation.translate("betterquesting.gui.bookmarks", new Object[0])).setAlignment(1).setColor(PresetColor.TEXT_MAIN.getColor());
        cvInner.addPanel(txtDb);
        this.cvBookmarks = this.createMainCanvas();
        cvInner.addPanel(this.cvBookmarks);
        cvInner.addPanel(this.createPopupMenu());
        PanelVScrollBar scDb = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 32, 0, 24), 0));
        cvInner.addPanel(scDb);
        this.cvBookmarks.setScrollDriverY(scDb);
    }

    private CanvasQuestBookmarks createMainCanvas() {
        CanvasQuestBookmarks pins = new CanvasQuestBookmarks(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 32, 8, 24), 0), (EntityPlayer)this.field_146297_k.field_71439_g);
        pins.setQuestOpenCallback(pinEntry -> {
            this.acceptCallback((QuestSearchEntry)pinEntry);
            GuiHome.bookmark = new GuiQuest(this.parent, pinEntry.getQuest().getKey());
            this.field_146297_k.func_147108_a(GuiHome.bookmark);
        });
        pins.setQuestHighlightCallback(pinEntry -> {
            this.field_146297_k.func_147108_a(this.parent);
            this.acceptCallback((QuestSearchEntry)pinEntry);
        });
        return pins;
    }

    private void createExitButton(CanvasEmpty cvInner) {
        PanelButton btnExit = new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0]));
        btnExit.setClickAction(b -> this.field_146297_k.func_147108_a(this.parent));
        cvInner.addPanel(btnExit);
    }

    private CanvasEmpty createPopupMenu() {
        return new CanvasEmpty(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0)){

            @Override
            public boolean onMouseClick(int mx, int my, int click) {
                if (!this.getTransform().contains(mx, my)) {
                    return false;
                }
                if (click == 1) {
                    FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                    PanelButtonQuest btn = GuiBookmarks.this.cvBookmarks.getButtonAt(mx, my);
                    if (btn != null) {
                        UUID questId = (UUID)((Map.Entry)btn.getStoredValue()).getKey();
                        int maxWidth = RenderUtils.getStringWidth(QuestTranslation.translate("betterquesting.btn.share_quest", new Object[0]), fr);
                        PopContextMenu popup = new PopContextMenu(new GuiRectangle(mx, my, maxWidth + 12, 48), true);
                        Runnable pinQuest = () -> {
                            boolean bookmarked = BookmarkHandler.bookmarkQuest(questId);
                            btn.setBookmarked(bookmarked);
                            GuiBookmarks.this.closePopup();
                        };
                        String pinPopupText = BookmarkHandler.isBookmarked(questId) ? QuestTranslation.translate("betterquesting.btn.unbookmark_quest", new Object[0]) : QuestTranslation.translate("betterquesting.btn.bookmark_quest", new Object[0]);
                        popup.addButton(pinPopupText, null, pinQuest);
                        Runnable questSharer = () -> {
                            GuiBookmarks.this.field_146297_k.field_71439_g.func_71165_d("betterquesting.msg.sharequest:" + UuidConverter.encodeUuid(questId));
                            GuiBookmarks.this.closePopup();
                        };
                        popup.addButton(QuestTranslation.translate("betterquesting.btn.share_quest", new Object[0]), null, questSharer);
                        Runnable copyQuestId = () -> {
                            StringSelection stringToCopy = new StringSelection(UuidConverter.encodeUuid(questId));
                            try {
                                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringToCopy, null);
                                GuiBookmarks.this.field_146297_k.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(QuestTranslation.translate("betterquesting.msg.copy_quest_copied", new Object[0])));
                                GuiBookmarks.this.field_146297_k.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("  " + EnumChatFormatting.AQUA + UuidConverter.encodeUuid(questId)));
                            }
                            catch (IllegalStateException e) {
                                GuiBookmarks.this.field_146297_k.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(QuestTranslation.translate("betterquesting.msg.copy_quest_failed", new Object[0])));
                            }
                            GuiBookmarks.this.closePopup();
                        };
                        popup.addButton(QuestTranslation.translate("betterquesting.btn.copy_quest", new Object[0]), null, copyQuestId);
                        GuiBookmarks.this.openPopup(popup);
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public void setCallback(Consumer<QuestSearchEntry> callback) {
        this.callback = callback;
    }

    private void acceptCallback(QuestSearchEntry questSearchEntry) {
        if (this.callback != null) {
            this.callback.accept(questSearchEntry);
        }
    }
}

