/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class BQThreadedIO {
    public static final BQThreadedIO INSTANCE = new BQThreadedIO();
    public static final BQThreadedIO DISK_IO = new BQThreadedIO(){

        @Override
        public void init() {
            if (this.exService == null || this.exService.isShutdown()) {
                this.exService = Executors.newFixedThreadPool(4);
            }
        }
    };
    ExecutorService exService;

    public BQThreadedIO() {
        this.init();
    }

    public void init() {
        if (this.exService == null || this.exService.isShutdown()) {
            this.exService = Executors.newSingleThreadExecutor();
        }
    }

    public void shutdown() {
        this.exService.shutdownNow();
    }

    public void enqueue(Runnable job) {
        if (this.exService == null || this.exService.isShutdown()) {
            throw new RuntimeException("Attempted to schedule task before service was initialised!");
        }
        if (job == null) {
            throw new NullPointerException("Attempted to schedule null job!");
        }
        this.exService.submit(job);
    }

    public <T> Future<T> enqueue(Callable<T> job) {
        if (this.exService == null || this.exService.isShutdown()) {
            throw new RuntimeException("Attempted to schedule task before service was initialised!");
        }
        if (job == null) {
            throw new NullPointerException("Attempted to schedule null job!");
        }
        return this.exService.submit(job);
    }
}

