/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech.machines;

import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gttweaker.mods.AddMultipleRecipeAction;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.ArcFurnace")
@ModOnly(value={"gregtech"})
public class ArcFurnace {
    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, IIngredient input, ILiquidStack fluidInput, int[] outChances, int durationTicks, int euPerTick) {
        if (outputs.length < 1) {
            MineTweakerAPI.logError((String)"Arc Furnace must have at least 1 output");
        } else if (outputs.length != outChances.length) {
            MineTweakerAPI.logError((String)"Number of Outputs does not equal number of Chances");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Arc Furnace recipe for " + input, new Object[]{input, fluidInput, outputs, outChances, durationTicks, euPerTick}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    ItemStack input = i.nextItem();
                    FluidStack fluidInput = i.nextFluid();
                    ItemStack[] outputs = i.nextItemArr();
                    int[] chances = i.nextIntArr();
                    int duration = i.nextInt();
                    int eut = i.nextInt();
                    GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{input}).itemOutputs(outputs).outputChances(chances).fluidInputs(new FluidStack[]{fluidInput}).fluidOutputs(new FluidStack[0]).duration(duration).eut(eut).addTo((IRecipeMap)RecipeMaps.arcFurnaceRecipes);
                }
            });
        }
    }
}

