/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thermalexpansion.handlers;

import cofh.thermalexpansion.util.crafting.CrucibleManager;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.thermalexpansion.ThermalHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Crucible")
public class Crucible {
    public static final String name = "Thermal Expansion Crucible";

    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, ILiquidStack output) {
        if (input == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (CrucibleManager.recipeExists((ItemStack)InputHelper.toStack(input))) {
            LogHelper.logWarning(String.format("Duplicate %s Recipe found for %s. Command ignored!", name, LogHelper.getStackDescription(InputHelper.toStack(input))));
            return;
        }
        CrucibleManager.RecipeCrucible recipe = ReflectionHelper.getInstance(ThermalHelper.crucibleRecipe, InputHelper.toStack(input), InputHelper.toFluid(output), energy);
        if (recipe != null) {
            MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
        } else {
            LogHelper.logError(String.format("Error while creating instance for %s recipe.", name));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        LinkedList<CrucibleManager.RecipeCrucible> recipes = new LinkedList<CrucibleManager.RecipeCrucible>();
        for (CrucibleManager.RecipeCrucible recipe : CrucibleManager.getRecipeList()) {
            if (recipe == null || !StackHelper.matches(input, InputHelper.toIItemStack(recipe.getInput()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s.", name, input.toString()));
        }
    }

    @ZenMethod
    public static void refreshRecipes() {
        MineTweakerAPI.apply((IUndoableAction)new Refresh());
    }

    private static class Refresh
    implements IUndoableAction {
        private Refresh() {
        }

        public void apply() {
            CrucibleManager.refreshRecipes();
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Refreshing Thermal Expansion Crucible recipes";
        }

        public void undo() {
        }

        public String describeUndo() {
            return "Ignoring undo of Thermal Expansion Crucible recipe refresh";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Remove
    extends BaseListRemoval<CrucibleManager.RecipeCrucible> {
        public Remove(List<CrucibleManager.RecipeCrucible> recipes) {
            super(Crucible.name, null, recipes);
        }

        @Override
        public void apply() {
            for (CrucibleManager.RecipeCrucible recipe : this.recipes) {
                boolean removed = CrucibleManager.removeRecipe((ItemStack)recipe.getInput());
                if (!removed) continue;
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (CrucibleManager.RecipeCrucible recipe : this.successful) {
                CrucibleManager.addRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getInput(), (FluidStack)recipe.getOutput());
            }
        }

        @Override
        protected boolean equals(CrucibleManager.RecipeCrucible recipe, CrucibleManager.RecipeCrucible otherRecipe) {
            return ThermalHelper.equals(recipe, otherRecipe);
        }

        @Override
        protected String getRecipeInfo(CrucibleManager.RecipeCrucible recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }

    private static class Add
    extends BaseListAddition<CrucibleManager.RecipeCrucible> {
        public Add(CrucibleManager.RecipeCrucible recipe) {
            super(Crucible.name, null);
            this.recipes.add(recipe);
        }

        @Override
        public void apply() {
            for (CrucibleManager.RecipeCrucible recipe : this.recipes) {
                boolean applied = CrucibleManager.addRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getInput(), (FluidStack)recipe.getOutput());
                if (!applied) continue;
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (CrucibleManager.RecipeCrucible recipe : this.successful) {
                CrucibleManager.removeRecipe((ItemStack)recipe.getInput());
            }
        }

        @Override
        protected boolean equals(CrucibleManager.RecipeCrucible recipe, CrucibleManager.RecipeCrucible otherRecipe) {
            return ThermalHelper.equals(recipe, otherRecipe);
        }

        @Override
        protected String getRecipeInfo(CrucibleManager.RecipeCrucible recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }
}

