/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mekanism.handlers;

import java.util.HashMap;
import java.util.Map;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.CrusherRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientAny;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.mekanism.util.AddMekanismRecipe;
import modtweaker2.mods.mekanism.util.RemoveMekanismRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.Crusher")
public class Crusher {
    public static final String name = "Mekanism Crusher";

    @ZenMethod
    public static void addRecipe(IItemStack itemInput, IItemStack itemOutput) {
        if (itemInput == null || itemOutput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        CrusherRecipe recipe = new CrusherRecipe(InputHelper.toStack(itemInput), InputHelper.toStack(itemOutput));
        MineTweakerAPI.apply((IUndoableAction)new AddMekanismRecipe(name, (Map<MachineInput, MachineRecipe>)RecipeHandler.Recipe.CRUSHER.get(), (MachineRecipe)recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemOutput, @Optional IIngredient itemInput) {
        if (itemOutput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (itemInput == null) {
            itemInput = IngredientAny.INSTANCE;
        }
        HashMap<MachineInput, MachineRecipe> recipes = new HashMap<MachineInput, MachineRecipe>();
        for (Map.Entry entry : RecipeHandler.Recipe.CRUSHER.get().entrySet()) {
            IItemStack inputItem = InputHelper.toIItemStack(((ItemStackInput)entry.getKey()).ingredient);
            IItemStack outputItem = InputHelper.toIItemStack(((ItemStackOutput)((CrusherRecipe)entry.getValue()).recipeOutput).output);
            if (!StackHelper.matches(itemOutput, outputItem) || !StackHelper.matches(itemInput, inputItem)) continue;
            recipes.put((MachineInput)entry.getKey(), (MachineRecipe)entry.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveMekanismRecipe(name, RecipeHandler.Recipe.CRUSHER.get(), (Map<MachineInput, MachineRecipe>)recipes));
        } else {
            LogHelper.logWarning(String.format("No %s recipe found for %s and %s. Command ignored!", name, itemInput.toString(), itemOutput.toString()));
        }
    }
}

