if(TARGET onnxruntime_interface)
else()
  set(ONNX_RUNTIME_PATH "$ENV{ONNX_RUNTIME_PATH}" CACHE PATH "Where to find ONNX runtime")
  if("${ONNX_RUNTIME_PATH}" STREQUAL "")
    message(FATAL_ERROR "Please specify cmake variable ONNX_RUNTIME_PATH! E.g. via -DONNX_RUNTIME_PATH=/path/to/onnxruntime")
  endif()
  set(TRTRTX_RUNTIME_PATH "$ENV{TRTRTX_RUNTIME_PATH}" CACHE PATH "Where to find TensorRT RTX")
  if("${TRTRTX_RUNTIME_PATH}" STREQUAL "")
    message(WARNING "Please specify cmake variable TRTRTX_RUNTIME_PATH! E.g. via -DTRTRTX_RUNTIME_PATH=/path/to/tensorrt_rtx. This will ensure all libraries are copied to the execution directory.")
  endif()

  find_library(ONNXRUNTIME_LIB onnxruntime HINTS ${ONNX_RUNTIME_PATH} ${ONNX_RUNTIME_PATH}/lib REQUIRED)
  find_library(ONNXRUNTIME_PROVIDERS_SHARED_LIB onnxruntime_providers_shared HINTS ${ONNX_RUNTIME_PATH} ${ONNX_RUNTIME_PATH}/lib REQUIRED)
  find_library(ONNXRUNTIME_TRT_EP_LIB onnxruntime_providers_nv_tensorrt_rtx HINTS ${ONNX_RUNTIME_PATH} ${ONNX_RUNTIME_PATH}/lib REQUIRED)
  find_library(ONNXRUNTIME_CUDA_EP_LIB onnxruntime_providers_cuda HINTS ${ONNX_RUNTIME_PATH} ${ONNX_RUNTIME_PATH}/lib)
  if(WIN32)
    find_file(ONNXRUNTIME_DLL onnxruntime.dll HINTS ${ONNX_RUNTIME_PATH} ${ONNX_RUNTIME_PATH}/lib REQUIRED)
    find_file(ONNXRUNTIME_PROVIDERS_SHARED_DLL onnxruntime_providers_shared.dll HINTS ${ONNX_RUNTIME_PATH} ${ONNX_RUNTIME_PATH}/lib REQUIRED)
    find_file(ONNXRUNTIME_TRT_EP_DLL onnxruntime_providers_n    v_tensorrt_rtx.dll HINTS ${ONNX_RUNTIME_PATH} ${ONNX_RUNTIME_PATH}/lib REQUIRED)
    find_file(ONNXRUNTIME_CUDA_EP_DLL onnxruntime_providers_cuda.dll HINTS ${ONNX_RUNTIME_PATH} ${ONNX_RUNTIME_PATH}/lib)

    find_file(TRTRTX_DLL NAMES tensorrt_rtx_1_1.dll tensorrt_rtx_1_2.dll tensorrt_rtx_1_3.dll HINTS ${TRTRTX_RUNTIME_PATH} ${TRTRTX_RUNTIME_PATH}/lib)
  else()
    find_library(TRTRTX_LIB NAMES tensorrt_rtx tensorrt_rtx_1_1 tensorrt_rtx_1_2 tensorrt_rtx_1_3 HINTS ${TRTRTX_RUNTIME_PATH} ${TRTRTX_RUNTIME_PATH}/lib)
  endif()

  find_path(ONNXRUNTIME_INCLUDE
      onnxruntime/core/session/onnxruntime_cxx_api.h
      HINTS ${ONNX_RUNTIME_PATH}/include
      REQUIRED)
  add_library(onnxruntime_interface INTERFACE)
  target_include_directories(onnxruntime_interface SYSTEM INTERFACE ${ONNXRUNTIME_INCLUDE})
  target_link_libraries(onnxruntime_interface INTERFACE ${ONNXRUNTIME_LIB} ${ONNXRUNTIME_PROVIDERS_SHARED_LIB})

  message(STATUS "ONNX runtime include \"${ONNXRUNTIME_INCLUDE}\"")
  message(STATUS "ONNX runtime lib \"${ONNXRUNTIME_LIB}\"")
endif()

set(RUNTIME_DIRECTORY ${CMAKE_CURRENT_BINARY_DIR})

macro (copy_file_to_bin_dir file)
    get_property(is_multi_config GLOBAL PROPERTY GENERATOR_IS_MULTI_CONFIG)
    if(${is_multi_config})
      foreach(config IN LISTS CMAKE_CONFIGURATION_TYPES)
          set(OUTPUT_DIR ${RUNTIME_DIRECTORY}/${config})
          # Create the configuration-specific directory
          execute_process(COMMAND ${CMAKE_COMMAND} -E make_directory "${OUTPUT_DIR}")
          configure_file(${file} ${OUTPUT_DIR} COPYONLY)
      endforeach()
  else()
      configure_file(${file} ${RUNTIME_DIRECTORY} COPYONLY)
  endif()
endmacro()

if(WIN32)
    copy_file_to_bin_dir(${ONNXRUNTIME_DLL})
    copy_file_to_bin_dir(${ONNXRUNTIME_PROVIDERS_SHARED_DLL})
    copy_file_to_bin_dir(${ONNXRUNTIME_TRT_EP_DLL})
    if (TRTRTX_DLL)
        copy_file_to_bin_dir(${TRTRTX_DLL})
    endif()
    if(ONNXRUNTIME_CUDA_EP_DLL)
        copy_file_to_bin_dir(${ONNXRUNTIME_CUDA_EP_DLL})
    endif()
else()
    copy_file_to_bin_dir(${ONNXRUNTIME_LIB})
    copy_file_to_bin_dir(${ONNXRUNTIME_PROVIDERS_SHARED_LIB})
    copy_file_to_bin_dir(${ONNXRUNTIME_TRT_EP_LIB})
    if (TRTRTX_DLL)
        copy_file_to_bin_dir(${TRTRTX_LIB})
    endif()
    if(ONNXRUNTIME_CUDA_EP_LIB)
        copy_file_to_bin_dir(${ONNXRUNTIME_CUDA_EP_LIB})
    endif()
endif()
