## About
- Builds the sample compiled against the ONNX Runtime built with support for Qualcomm AI Engine Direct SDK (Qualcomm Neural Network (QNN) SDK).
- The sample uses the QNN EP to:
  - a. run the float32 model on QNN CPU backend.
  - b. run the QDQ model on HTP backend with session option ep.context_enable=1, and generates the Onnx model which has QNN context binary embedded.
    - Model inputs & outputs will be float32
  - c. run the QNN context binary model generated from ONNX Runtime (previous step) on HTP backend, to improve the model initialization time and reduce memory overhead.
  - d. run the QNN context binary model generated from QNN tool chain on HTP backend, to support models generated from native QNN tool chain.
    - Models inputs & outputs will be quantized INT8 and kitten_input_nhwc.raw input per the qnn-onnx-converter.exe options used
    - E.g. qnn-onnx-converter.exe --input_dtype uint8 --input_layout NHWC
    - See QNN doc - [docs/QNN/general/tools.html#qnn-onnx-converter](https://docs.qualcomm.com/bundle/publicresource/topics/80-63442-50/tools.html#qnn-onnx-converter)
  - e. run the float32 model on QNN HTP backend.
    - Need to set the EP provider option "enable_htp_fp16_precision" to "1". Otherwise it is with FP32 precision and runs very slow.
  - f. run the float16 model on QNN HTP backend.
    - [Convert the float32 model to float16 model](https://onnxruntime.ai/docs/performance/model-optimizations/float16.html).
    - It set keep_io_types=True, so that IOs are still float32. Here is the script example [to_fp16.py](https://github.com/microsoft/onnxruntime-inference-examples/blob/main/c_cxx/QNN_EP/mobilenetv2_classification/to_fp16.py)
- The sample downloads the mobilenetv2 model from Onnx model zoo, and use mobilenetv2_helper.py to quantize the float32 model to QDQ model which is required for HTP backend
- The sample is targeted to run on QC ARM64 device.
- There are 2 ways to improve the session creation time by using of QNN context binary:
  - Option 1: Use context binary generated by OnnxRuntime QNN EP. OnnxRuntime QNN EP use QNN API to generate the QNN context binary, and also dumps some metadata (model name, version, graph meta id, etc) to identify the model.
    - a. Set session option ep.context_enable to 1 and run with QDQ model.
    - b. The first run will generate the context binary model (Default file name is model_file_name.onnx_ctx.onnx if ep.context_file_path is not set.).
    - c. Use the generated context binary model (mobilenetv2-12_quant_shape.onnx_ctx.onnx) for inference going forward. (No need the QDQ model, no need to set the ep.context_enable).
    - Notes: The QNN context binary is embedded within the ONNX model by default. Alternatively, set the session option ep.context_embed_mode to 0 in order to generate the QNN context binary as a separate file and embed the file's relative path in the ONNX model. This is necessary if the QNN context binary size exceeds protobuf's 2GB limit.
    - Offline prepare is also supported. Generate the QNN context binary on x64 machine and run it on QC ARM64 device.
    ```
    # Build the qnn_ep_sample with x64.
    MSBuild.exe .\qnn_ep_sample.sln /property:Configuration=Release /p:Platform="x64"
    # Run qnn_ep_sample.exe on x64. It only create the Onnx Runtime session with QDQ model to generate the QNN context binary
    # No need to run the model
    qnn_ep_sample.exe --htp mobilenetv2-12_quant_shape.onnx kitten_input.raw --gen_ctx
    ```
  
  - Option 2: Use context binary generated by native QNN tool chain:
    - The sample also demonstrates the feature to create an Onnx model file from QNN generated context binary file libmobilenetv2-12.serialized.bin to better support customer application migration from native QNN to OnnxRuntime QNN EP. A script [gen_qnn_ctx_onnx_model.py](https://github.com/microsoft/onnxruntime/tree/main/onnxruntime/python/tools/qnn/gen_qnn_ctx_onnx_model.py) is provided to generate an Onnx model from QNN generated context binary file. It requires the QNN generated context binary file libmobilenetv2-12.serialized.bin and pre-converted QNN mobilenetv2-12_net.json.
    - a. Convert model to QNN model and generate the QNN context binary file. The sample provides mobilenetv2-12_net.json and context binary file libmobilenetv2-12.serialized.bin as exmple (generated by QNN version 2.10). Please follow QNN document to generated QNN model_net.json and the context binary file.
      - Example command used:
        - qnn-onnx-converter --input_list ./input.txt --input_network ./mobilenetv2-12.onnx --output_path ./mobilenetv2-12.cpp -b 1 --bias_bw 32
        - qnn-model-lib-generator -c ./mobilenetv2-12.cpp -b ./mobilenetv2-12.bin -o ./mobilenetv2_classification/qnn_lib
        - qnn-context-binary-generator --backend ${QNN_SDK_ROOT}/target/x86_64-linux-clang/lib/libQnnHtp.so --model ./mobilenetv2_classification/qnn_lib/x86_64-linux-clang/libmobilenetv2-12.so --binary_file libmobilenetv2-12.serialized
    - b. Create an Onnx model file from QNN generated context binary file libmobilenetv2-12.serialized.bin. More details refer to run_qnn_ep_sample.bat & [gen_qnn_ctx_onnx_model.py](https://github.com/microsoft/onnxruntime/tree/main/onnxruntime/python/tools/qnn/gen_qnn_ctx_onnx_model.py)
      - python gen_qnn_ctx_onnx_model.py -b libmobilenetv2-12.serialized.bin -q mobilenetv2-12_net.json
    - c. Create ONNX Runtime session with the model generated from step b.
    - d. Run the model with quantized input data. The output also need to be dequantized. This is because QNN quantized model use quantized data type for model inputs & outputs. More details refer to QuantizedData & DequantizedData in [main.cpp](https://github.com/microsoft/onnxruntime-inference-examples/blob/main/c_cxx/QNN_EP/mobilenetv2_classification/main.cpp). Also the input image is NHWC layout for QNN converted model.
    - Notes: Call gen_qnn_ctx_onnx_model.py with --disable_embed_mode to generate the ONNX model with the relative path to the QNN context binary file. This is necessary if the QNN context binary size exceeds protobuf's 2GB limit.

- More info on QNN EP - https://onnxruntime.ai/docs/execution-providers/QNN-ExecutionProvider.html

## Prerequisites
- Windows 11
- Visual Studio 2022
- Python (needed to quantize model)
- Qualcomm AI Engine Direct SDK (QNN SDK) from https://qpm.qualcomm.com/main/tools/details/qualcomm_ai_engine_direct
    - Last known working QNN version (by building ORT from source): 2.18, 2.19, 2.20
- OnnxRuntime ARM Build with QNN support such as ONNX Runtime (ORT) Microsoft.ML.OnnxRuntime.QNN 1.17+
  - Download from https://www.nuget.org/packages/Microsoft.ML.OnnxRuntime.QNN and unzip
  - Please wait for ONNX Runtime 1.17+ if you want to use ORT Nuget package. This example requires a latest change in main branch [PR 17757](https://github.com/microsoft/onnxruntime/pull/17757).
  - ORT Drop DOES NOT INCLUDE QNN so QNN binaries must be copied from QC SDK. E.g
    - robocopy C:\Qualcomm\AIStack\QNN\2.xx.x\lib\aarch64-windows-msvc %USERPROFILE%\Downloads\microsoft.ml.onnxruntime.qnn.1.17.0\runtimes\win-arm64\native
    - copy C:\Qualcomm\AIStack\QNN\2.xx.x\lib\hexagon-v68\unsigned\libQnnHtpV68Skel.so %USERPROFILE%\Downloads\microsoft.ml.onnxruntime.qnn.1.17.0\runtimes\win-arm64\native
    - copy C:\Qualcomm\AIStack\QNN\2.xx.x\lib\hexagon-v73\unsigned\libQnnHtpV73Skel.so %USERPROFILE%\Downloads\microsoft.ml.onnxruntime.qnn.1.17.0\runtimes\win-arm64\native
    - Note: QNN 2.14.1, 2.15.1, 2.15.3 are preview release. The v73 libraries are available for preview release only. Please skip it if you don't have.
- (OR) Compiled from onnxruntime source with QNN support - https://onnxruntime.ai/docs/build/eps.html#qnn

## How to run the application
(Windows11) Run ```run_qnn_ep_sample.bat``` with path to onnxruntime root directory (for includes) and path to bin directory
```
run_qnn_ep_sample.bat PATH_TO_ORT_ROOT_WITH_INCLUDE_FOLDER PATH_TO_ORT_BINARIES_WITH_QNN
Example (Drop): run_qnn_ep_sample.bat %USERPROFILE%\Downloads\microsoft.ml.onnxruntime.qnn.1.17.0\build\native %USERPROFILE%\Downloads\microsoft.ml.onnxruntime.qnn.1.17.0\runtimes\win-arm64\native
Example (Src): run_qnn_ep_sample.bat C:\src\onnxruntime C:\src\onnxruntime\build\Windows\RelWithDebInfo\RelWithDebInfo
```

## Example run result
```
...
REM run mobilenetv2-12_shape.onnx with QNN CPU backend
qnn_ep_sample.exe --cpu mobilenetv2-12_shape.onnx kitten_input.raw

Result:
position=281, classification=n02123045 tabby, tabby cat, probability=13.663178

REM run mobilenetv2-12_quant_shape.onnx with QNN HTP backend
qnn_ep_sample.exe --htp mobilenetv2-12_quant_shape.onnx kitten_input.raw

Result:
position=281, classification=n02123045 tabby, tabby cat, probability=13.637316

REM load mobilenetv2-12_quant_shape.onnx with QNN HTP backend, generate mobilenetv2-12_quant_shape.onnx_ctx.onnx which hs QNN context binary embedded
REM This does not has to be run on real device with HTP, it can be done on x64 platform also, since it supports offline generation
qnn_ep_sample.exe --htp mobilenetv2-12_quant_shape.onnx kitten_input.raw --gen_ctx

Onnx model with QNN context binary is generated.

REM run mobilenetv2-12_quant_shape.onnx_ctx.onnx with QNN HTP backend
qnn_ep_sample.exe --htp mobilenetv2-12_quant_shape.onnx_ctx.onnx kitten_input.raw

Result:
position=281, classification=n02123045 tabby, tabby cat, probability=13.637316

REM run mobilenetv2-12_net_qnn_ctx.onnx (generated from native QNN) with QNN HTP backend
qnn_ep_sample.exe --qnn mobilenetv2-12_net_qnn_ctx.onnx kitten_input_nhwc.raw
position=281, classification=n02123045 tabby, tabby cat, probability=13.637315

REM run mobilenetv2-12_shape.onnx (float32 model) with QNN HTP backend with FP16 precision
qnn_ep_sample.exe --fp32 mobilenetv2-12_shape.onnx kitten_input.raw

Result:
position=281, classification=n02123045 tabby, tabby cat, probability=13.656251

REM run mobilenetv2-12_shape_fp16.onnx (float16 model with float32 IO) with QNN HTP backend 
qnn_ep_sample.exe --fp16 mobilenetv2-12_shape_fp16.onnx kitten_input.raw

Result:
position=281, classification=n02123045 tabby, tabby cat, probability=13.656251
...
```