# ONNX Runtime Inference Examples

<div align="center">
  <img src="https://www.onnxruntime.ai/images/ONNX-Runtime-logo.png" /><br /><br />
</div>

This repo has examples that demonstrate the use of [ONNX Runtime](https://github.com/microsoft/onnxruntime) (ORT) for inference.

## Examples

Outline the examples in the repository.

| Example | Description | Pipeline Status |
|-|-|-|
| [C/C++ examples](c_cxx) |  Examples for ONNX Runtime C/C++ APIs | [![Linux-CPU](https://github.com/microsoft/onnxruntime-inference-examples/actions/workflows/linux-ci.yml/badge.svg)](https://github.com/microsoft/onnxruntime-inference-examples/actions/workflows/linux-ci.yml) [![Windows-CPU](https://github.com/microsoft/onnxruntime-inference-examples/actions/workflows/win-ci.yml/badge.svg)](https://github.com/microsoft/onnxruntime-inference-examples/actions/workflows/win-ci.yml) |
| [Mobile examples](mobile) | Examples that demonstrate how to use ONNX Runtime in mobile applications. | [![Build Status](https://aiinfra.visualstudio.com/PublicPackages/_apis/build/status/mobile-examples-ci-pipeline?branchName=main)](https://aiinfra.visualstudio.com/PublicPackages/_build/latest?definitionId=1055&branchName=main) |
| [JavaScript API examples](js) | Examples that demonstrate how to use JavaScript API for ONNX Runtime. | |
| [Quantization examples](quantization) | Examples that demonstrate how to use quantization for CPU EP and TensorRT EP | |

## Contributing

This project welcomes contributions and suggestions.  Most contributions require you to agree to a
Contributor License Agreement (CLA) declaring that you have the right to, and actually do, grant us
the rights to use your contribution. For details, visit https://cla.opensource.microsoft.com.

When you submit a pull request, a CLA bot will automatically determine whether you need to provide
a CLA and decorate the PR appropriately (e.g., status check, comment). Simply follow the instructions
provided by the bot. You will only need to do this once across all repos using our CLA.

This project has adopted the [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/).
For more information see the [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) or
contact [opencode@microsoft.com](mailto:opencode@microsoft.com) with any additional questions or comments.

## Trademarks

This project may contain trademarks or logos for projects, products, or services. Authorized use of Microsoft
trademarks or logos is subject to and must follow
[Microsoft's Trademark & Brand Guidelines](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general).
Use of Microsoft trademarks or logos in modified versions of this project must not cause confusion or imply Microsoft sponsorship.
Any use of third-party trademarks or logos are subject to those third-party's policies.
