# [clreq](https://www.w3.org/TR/clreq/)-[gap](https://www.w3.org/TR/clreq-gap/) for [typst](https://typst.app/home)

Chinese Layout Gap Analysis for Typst.
分析 Typst 与中文排版的差距。

[![Check](https://github.com/typst-doc-cn/clreq/actions/workflows/check.yml/badge.svg)](https://github.com/typst-doc-cn/clreq/actions/workflows/check.yml)
[![Website](https://img.shields.io/website?url=https%3A%2F%2Ftypst-doc-cn.github.io%2Fclreq%2F&label=Website)](https://typst-doc-cn.github.io/clreq/)

**Languages: [English (current)](./README.en.md)** | **[中文](./README.md)**

<!-- <included #intro by="main.typ"> -->
Typst is a markup-based typesetting software, and this document describes gaps or shortcomings for the support of the Chinese script within Typst.
In particular, it is concerned with [text layout](https://www.w3.org/TR/clreq/) and [bibliography](https://std.samr.gov.cn/gb/search/gbDetailed?id=71F772D8055ED3A7E05397BE0A0AB82A).
It examines whether needed features are supported by the typst compiler, and provides information on potential workarounds.
<!-- </included> -->

[The main the document is on the website](https://typst-doc-cn.github.io/clreq/), and the following is the contributing guide.

## Contributing Guide

### Feedback

If you find anything missing or incorrect, or have any questions or suggestions, please raise them on [GitHub Issues](https://github.com/typst-doc-cn/clreq/issues/).

- Language: Both Chinese and English are acceptable here. When it’s ready, we will forward it to [the Typst official](https://github.com/typst/typst/) in English, and complete both translations in this document.

- If it is your first time, you can refer to [W3C’s guide on GitHub Issue (with screenshots, in English)](https://www.w3.org/International/i18n-activity/guidelines/issues.html).

### Edit the document

The main document is generated by Typst. For daily edits:

1. [Open `main.typ` on GitHub](https://github.com/typst-doc-cn/clreq/blob/main/main.typ)
2. Click the edit button `✏️` on the top right corner, and follow the prompts to get ready (log in, fork, etc.).
3. Edit `main.typ`.
4. Click _Commit changes…_ on the top right corner, and follow the prompts to complete the editing (briefly explain it, create a pull request, etc.).
5. Wait a moment, and robots will render the new version as a web page and comment it under the pull request. You can continue editing if necessary.

<details>
<summary>To preview it locally</summary>

```shell
# Compile
pnpm build # ⇒ dist/index.html

# Recompile on changes
pnpm dev --open # ⇒ http://localhost:3000
```

Prerequisites:

- [pnpm](https://pnpm.io), the package manager

- _Noto Serif CJK SC_, the typeface

  1. Download [`09_NotoSerifCJKsc.zip`](https://mirrors.cernet.edu.cn/github-release/googlefonts/noto-cjk/LatestRelease/09_NotoSerifCJKsc.zip) from [校园网联合镜像站 · Google Fonts](https://mirrors.cernet.edu.cn/font/GoogleFonts), or [Language Specific OTFs Simplified Chinese (简体中文)](https://github.com/notofonts/noto-cjk/releases/latest/download/09_NotoSerifCJKsc.zip) from [GitHub Releases · notofonts/noto-cjk](https://github.com/notofonts/noto-cjk/releases).

  2. Then install the fonts to system, or put them under `./fonts/`.

  _Noto Serif CJK SC_ is enough for most contributors. However, if you want to reproduce all examples exactly, please refer to [`download_fonts.sh`](./scripts/download_fonts.sh).

</details>

## Reference for writing `main.typ`

### Content scope

For each issue, please try to:

- Briefly describe the problem

- Provide a concise example that can be understood at a glance

- Supplement the background that those who do not understand Chinese may not be clear about

  For example, typing Chinese characters requires an IME. You can link to [Unicode FAQ on Chinese and Japanese](https://unicode.org/faq/han_cjk.html).


But in most cases:

- No need to provide a solution directly

  Just link it as `#workaround("https://…")`.


- No need to describe comprehensively, nor is it recommended to propose improvements too much

  These contents can be initially proposed at [GitHub Issues](https://github.com/typst-doc-cn/clreq/issues/), and should eventually be forwarded to the Typst official.

### Multilingual content (`babel`/`bbl`)

- The `en` and `zh` fields are displayed in English and 中文 modes, respectively.

- `babel` is used for paragraphs `par`, and generates block-level elements (`<p>`); while `bbl` is used for short phrases within paragraphs, and generates inline elements (`<span>`).

Example:

```typst
=== #bbl(en: [Vertical Writing Mode], zh: [直排])

#babel(
  en: [There are *two* writing modes in Chinese composition…],
  zh: [中文有*两种*行文模式……],
)
```

Tips:

- When drafting a pull request, there is no need to write a full bilingual translation at the very beginning. You can start with a single language and then add others after the content is finalized.

- Not all content needs to be translated. Some terms are not possible to be translated, or might be ambiguous when only read in a single language. In such cases, there is no need to wrap `bbl`; just write them directly.

- Don’t pay special attention to line breaks and indentation. Just use tinymist (VS Code) / typstyle default settings. To make version comparison easier, we have set up a pull request robot to automatically format them.

### Adding a code example

Code examples will be compiled when rendering the website.

When writing code examples:

- Ensure that it is independent of the display language. `babel` is not supported and should not be used

- Use Han characters for placeholders if possible. Add punctuations and Latin letters only when necessary

- Try to avoid including descriptive text in the code. If really unavoidable, choose English phrases or emojis when possible

To add an example, insert a fenced code block with one of the following languages. We will introduce them one by one.

#### Simple examples (`example`)

A simple typst example.

````typst
```example
>>> Current: \
#underline[中文和English]

>>> Expected: \
>>> #set underline(offset: .15em, stroke: .05em)
>>> #underline[中文和English]
```
````

- Regular lines:

  👀 shown as the source, and 🚀 executed in preview.

- Lines starting with `>>>`:

  🙈 hidden from the source, but still 🚀 executed in preview.

- Lines starting with `<<<`:

  👀 shown as the source, but 🛑 not executed in the preview.

##### Limitations and caveats

Simple examples are evaluated in a container and their states are shared across the entire document.

As a result:

- Any page configuration is not allowed. 

  If you just want to `#set page(width: …)`, then use `#show: block.with(width: …)` instead.

- Updating counters will affect the following examples.

- Citations and bibliographies will conflict with other examples.

- The default configuration values are those specified in `raw`, which may differ from the defaults in regular documents.

  For example, the default `text.cjk-latin-spacing` is typically `auto`, but here it is `none`.

- …

If you require advanced features or 100% accuracy, please write a page example instead.

#### Page examples (`example-page`)

A standalone typst example compiled in a page.

`````typst
````example-page
>>> Current: \
孔乙己@key

>>> Expected: \
>>> 孔乙己@key
>>> #show bibliography: none
#let bib = ```bib
@misc{key,
  title = {Title},
}
```.text
#bibliography(bytes(bib), style: "gb-7714-2015-numeric")
````
`````

The meanings of `<<<` and `>>>` are the same as those in simple examples.

#### Bibliography examples (`example-bib`)

````typst
```example-bib
@book{key,
  title = {标题},
  author = {作者},
  year = {2025}
}
% 作者. 标题. 2025.
```
````

- Regular lines: BibTeX entries.

- Lines starting with `%`: Expected output.

## License

The code are licensed under Apache 2.0 unless otherwise specified. All rights of rest content are reserved.
