import { DEVICE, FRONTMATTER_KEYS, CJK_FONTS } from "src/constants/constants";
import { TAG_AUTOEXPORT, TAG_MDREADINGMODE, TAG_PDFEXPORT } from "src/constants/constSettingsTags";
import { labelALT, labelCTRL, labelMETA, labelSHIFT } from "src/utils/modifierkeyHelper";

// русский
export default {
  // main.ts
  CONVERT_URL_TO_FILE: "Сохранить изображение из URL в локальный файл",
  UNZIP_CURRENT_FILE: "Распаковать текущий файл Excalidraw",
  ZIP_CURRENT_FILE: "Сжать текущий файл Excalidraw",
  PUBLISH_SVG_CHECK: "Obsidian Publish: Поиск устаревших экспортированных SVG и PNG-файлов",
  EMBEDDABLE_PROPERTIES: "Свойства встраиваемых элементов",
  EMBEDDABLE_RELATIVE_ZOOM: "Масштабирование выбранных встраиваемых элементов до 100% относительно текущего масштаба холста",
  OPEN_IMAGE_SOURCE: "Открыть чертеж Excalidraw",
  INSTALL_SCRIPT: "Установите скрипт",
  UPDATE_SCRIPT: "Доступно обновление - нажмите для установки",
  CHECKING_SCRIPT: "Проверка на наличие новой версии - Нажмите для переустановки",
  UNABLETOCHECK_SCRIPT: "Проверка обновления не удалась - Нажмите, чтобы переустановить",
  UPTODATE_SCRIPT: "Скрипт обновлен - Нажмите для переустановки",
  OPEN_AS_EXCALIDRAW: "Открыть как рисунок Excalidraw",
  TOGGLE_MODE: "Переключение между режимами Excalidraw и Markdown",
  CONVERT_NOTE_TO_EXCALIDRAW: "Конвертировать заметку в формате Markdown в Excalidraw Drawing",
  CONVERT_EXCALIDRAW: "Преобразование файлов *.excalidraw в файлы *.md",
  CREATE_NEW: "Создать новый чертеж",
  CONVERT_FILE_KEEP_EXT: "*.excalidraw => *.excalidraw.md",
  CONVERT_FILE_REPLACE_EXT: "*.excalidraw => *.md (совместимость с Logseq)",
  DOWNLOAD_LIBRARY: "Экспорт библиотеки трафаретов в файл *.excalidrawlib",
  OPEN_EXISTING_NEW_PANE: "Открыть существующий чертеж - В НОВОЙ ПАНЕЛИ",
  OPEN_EXISTING_ACTIVE_PANE: "Открыть существующий чертеж - В ТЕКУЩЕЙ АКТИВНОЙ ПАНЕЛИ",
  TRANSCLUDE: "Вставить чертеж",
  TRANSCLUDE_MOST_RECENT: "Вставка последнего отредактированного рисунка",
  TOGGLE_LEFTHANDED_MODE: "Переключить левосторонний режим",
  TOGGLE_SPLASHSCREEN: "Показывать заставку в новых чертежах",
  FLIP_IMAGE: "Открыть фоновым рисуноком выбранное изображения excalidraw",
  NEW_IN_NEW_PANE: "Создать новый рисунок - В СОСЕДНЕМ ОКНЕ",
  NEW_IN_NEW_TAB: "Создать новый рисунок - В НОВОЙ ТАБЛИЦЕ",
  NEW_IN_ACTIVE_PANE: "Создать новый рисунок - В ТЕКУЩЕМ АКТИВНОМ ОКНЕ",
  NEW_IN_POPOUT_WINDOW: "Создать новый рисунок - В ОТКРЫВАЮЩЕМСЯ ОКНЕ",
  NEW_IN_NEW_PANE_EMBED: "Создание нового рисунка - В СОСЕДНЕМ ОКНЕ - и вставка в активный документ",
  NEW_IN_NEW_TAB_EMBED: "Создать новый чертеж - В НОВОЙ ТАБЛИЦЕ - и вставить в активный документ",
  NEW_IN_ACTIVE_PANE_EMBED: "Создать новый рисунок - В ТЕКУЩЕМ АКТИВНОМ ОКНЕ - и вставить в активный документ",
  NEW_IN_POPOUT_WINDOW_EMBED: "Создать новый рисунок - В ОТКРЫВАЮЩЕМСЯ ОКНЕ - и вставить в активный документ",
  TOGGLE_LOCK: "Переключение текстового элемента между режимами редактирования RAW (без обработки) и PREVIEW (просмотр)",
  DELETE_FILE: "Удалить выбранное изображение или файл Markdown из Obsidian хранилища",
  COPY_ELEMENT_LINK: "Скопировать [[ссылку]] для выбранного элемента(ов)",
  COPY_DRAWING_LINK: "Скопировать ![[ссылку на вставку]] для этого рисунка",
  INSERT_LINK_TO_ELEMENT: `Копирование [[ссылка]] для выбранного элемента в буфер обмена. ${labelCTRL()}+CLICK для копирования ссылки 'group='. ${labelSHIFT()}+CLICK для копирования ссылки 'area='.`,
  INSERT_LINK_TO_ELEMENT_GROUP: "Скопируйте 'group=' ![[ссылка]] для выбранного элемента в буфер обмена.",
  INSERT_LINK_TO_ELEMENT_AREA: "Скопировать 'area=' ![[ссылка]] для выбранного элемента в буфер обмена.",
  INSERT_LINK_TO_ELEMENT_FRAME: "Скопировать 'frame=' ![[ссылка]] для выбранного элемента в буфер обмена.",
  INSERT_LINK_TO_ELEMENT_FRAME_CLIPPED: "Скопировать 'clippedframe=' ![[ссылка]] для выбранного элемента в буфер обмена.",
  INSERT_LINK_TO_ELEMENT_NORMAL: "Скопировать [[ссылка]] для выбранного элемента в буфер обмена.",
  INSERT_LINK_TO_ELEMENT_ERROR: "Выбор отдельного элемента в сцене",
  INSERT_LINK_TO_ELEMENT_READY: "Ссылка ГОТОВА и доступна в буфере обмена",
  INSERT_LINK: "Вставить ссылку на файл",
  INSERT_COMMAND: "Вставить команду Obsidian в качестве ссылки",
  INSERT_IMAGE: "Вставить изображение или рисунок Excalidraw из вашего хранилища",
  IMPORT_SVG: "Импорт SVG-файла в виде штрихов Excalidraw (поддержка SVG ограничена, TEXT в настоящее время не поддерживается)",
  IMPORT_SVG_CONTEXTMENU: "Преобразование SVG в штрихи - с ограничениями",
  INSERT_MD: "Вставка файла markdown из хранилища",
  INSERT_PDF: "Вставить PDF-файл из хранилища",
  UNIVERSAL_ADD_FILE: "Вставка ЛЮБОГО файла",
  INSERT_CARD: "Добавить сноски",
  CONVERT_CARD_TO_FILE: "Переместить сноску в файл",
  ERROR_TRY_AGAIN: "Пожалуйста, попробуйте еще раз.",
  PASTE_CODEBLOCK: "Вставить блок кода",
  INSERT_LATEX: `Вставьте формулу LaTeX (например, \\\binom{n}{k} = \\\frac{n!}{k!(n-k)!}).`,
  ENTER_LATEX: "Введите правильное выражение LaTeX",
  READ_RELEASE_NOTES: "Прочитать последние заметки о выпуске",
  RUN_OCR: "OCR полного чертежа: Захват текста из freedraw + изображения в буфер обмена и doc.props",
  RERUN_OCR: "Повторный запуск полного чертежа OCR: Захват текста из freedraw + изображения в буфер обмена и doc.props",
  RUN_OCR_ELEMENTS: "OCR выделенных элементов: Захват текста из freedraw + изображения в буфер обмена",
  TRAY_MODE: "Переключение панели свойств в трей-режим",
  SEARCH: "Поиск текста на чертеже",
  CROP_PAGE: "Обрезка и маскирование выделенной страницы",
  CROP_IMAGE: "Обрезка и маскирование изображения",
  ANNOTATE_IMAGE : "Аннотирование изображения в Excalidraw",
  INSERT_ACTIVE_PDF_PAGE_AS_IMAGE: "Вставка активной страницы PDF в качестве изображения",
  RESET_IMG_TO_100: "Установить размер выбранного элемента изображения на 100% от исходного",
  RESET_IMG_ASPECT_RATIO: "Сбросить соотношение сторон выбранного элемента изображения",
  TEMPORARY_DISABLE_AUTOSAVE: "Отключить автосохранение до следующего запуска Obsidian (устанавливайте этот параметр, только если вы знаете, что делаете)",
  TEMPORARY_ENABLE_AUTOSAVE: "Включить автосохранение",

  //ExcalidrawView.ts
  NO_SEARCH_RESULT: "Не удалось найти подходящий элемент на чертеже",
  FORCE_SAVE_ABORTED: "Принудительное сохранение прервано, поскольку идет процесс сохранения",
  LINKLIST_SECOND_ORDER_LINK: "Ссылка второго порядка",
  MARKDOWN_EMBED_CUSTOMIZE_LINK_PROMPT_TITLE: "Настройка ссылки на встроенный файл",
  MARKDOWN_EMBED_CUSTOMIZE_LINK_PROMPT: "Не добавляйте [[квадратные скобки]] вокруг имени файла! <br>" +
    "При редактировании ссылок на изображения в формате markdown-страниц следуйте этому формату: <mark>filename#^blockref|WIDTHxMAXHEIGHT</mark><br>" +
    "Вы можете привязать изображения Excalidraw к 100% их размера, добавив  <code>|100%</code> в конец ссылки.<br>" +
    "Вы можете изменить страницу PDF, изменив <code>#page=1</code> на <code>#page=2</code> и т.д.<br>" +
    "Значения обрезки прямоугольника PDF: <code>left, bottom, right, top</code>. Например: <code>#rect=0,0,500,500</code><br>",
  FRAME_CLIPPING_ENABLED: "Рендеринг кадров: Включено",
  FRAME_CLIPPING_DISABLED: "Рендеринг кадров: Отключено",
  ARROW_BINDING_INVERSE_MODE: "Инвертированный режим: Привязка стрелок по умолчанию теперь отключена. Используйте CTRL/CMD, чтобы временно включить привязку, когда это необходимо.",
  ARROW_BINDING_NORMAL_MODE: "Обычный режим: Привязка стрелок теперь включена. Используйте CTRL/CMD, чтобы временно отключить привязку при необходимости.",
  EXPORT_FILENAME_PROMPT: "Пожалуйста, укажите имя файла",
  EXPORT_FILENAME_PROMPT_PLACEHOLDER: "имя файла, оставьте пустым, чтобы отменить действие",
  WARNING_SERIOUS_ERROR: "ПРЕДУПРЕЖДЕНИЕ: Excalidraw столкнулся с неизвестной проблемой!\n\n" +
    "Есть риск, что последние изменения не будут сохранены.\n\n" +
    "На всякий случай...\n" +
    "1) Выберите рисунок с помощью CTRL/CMD+A и создайте копию с помощью CTRL/CMD+C.\n" +
    "2) Затем создайте пустой чертеж в новой панели, нажав CTRL/CMD+кнопку ленты Excalidraw,\n" +
    "3) и вставьте свою работу в новый документ с помощью CTRL/CMD+V.",
  ARIA_LABEL_TRAY_MODE: "Трей-Режим предлагает альтернативный, более просторный холст",
  MASK_FILE_NOTICE: "Это файл маски. Он используется для кадрирования изображений и маскирования частей изображения. Нажмите и удерживайте уведомление, чтобы открытьe help video.",
  INSTALL_SCRIPT_BUTTON: "Установка или обновление скриптов Excalidraw",
  OPEN_AS_MD: "Открыть как Markdown",
  EXPORT_IMAGE: `Экспорт изображения`,
  OPEN_LINK: "Открыть выделенный текст как ссылку\n(SHIFT+CLICK для открытия в новой панели)",
  EXPORT_EXCALIDRAW: "Экспорт в файл .Excalidraw",
  LINK_BUTTON_CLICK_NO_TEXT: "Выберите элемент, содержащий внутреннюю или внешнюю ссылку.\n",
  LINEAR_ELEMENT_LINK_CLICK_ERROR:
    "Ссылки на элементы со стрелками и линиями нельзя перемещать с помощью " + labelCTRL() + " + КЛИКА по элементу, поскольку при этом также активируется редактор строк.\n" +
    "Чтобы открыть ссылку, воспользуйтесь контекстным меню правой кнопки мыши или щелкните индикатор ссылки в правом верхнем углу элемента.\n",
  FILENAME_INVALID_CHARS: 'Имя файла не может содержать ни одного из следующих символов: * " \\ < > : | ? #',
  FORCE_SAVE: "Сохранить (также будут обновлены включения)",
  RAW: "Переход в режим PREVIEW (влияет только на текстовые элементы со ссылками или включениями)",
  PARSED: "Переход в режим RAW (влияет только на текстовые элементы со ссылками или включениями)",
  NOFILE: "Excalidraw (без файла)",
  COMPATIBILITY_MODE: "Файл *.excalidraw открыт в режиме совместимости. Конвертируйте в новый формат для полной функциональности плагина.",
  CONVERT_FILE: "Преобразование в новый формат",
  BACKUP_AVAILABLE: "Мы столкнулись с ошибкой при загрузке вашего рисунка. Это могло произойти, если Obsidian неожиданно закрылся во время операции сохранения. Например, если вы случайно закрыли Obsidian на своем мобильном устройстве во время сохранения.<br><br><b>ХОРОШАЯ НОВОСТЬ:</b> К счастью, доступна локальная резервная копия. Однако учтите, что если вы последний раз изменяли этот рисунок на другом устройстве (например, на планшете), а сейчас находитесь на рабочем столе, то на другом устройстве, скорее всего, имеется более свежая резервная копия.<br><br>Я рекомендую сначала попробовать открыть рисунок на другом устройстве и восстановить резервную копию из его локального хранилища.<br><br>Хотите загрузить резервную копию?",
  BACKUP_RESTORED: "Резервная копия восстановлена",
  CACHE_NOT_READY: "Приношу извинения за неудобства, но при загрузке вашего файла произошла ошибка.<br><br><mark>Немного терпения может сэкономить вам массу времени...</mark><br><br>Плагин имеет резервный кэш, но похоже, что вы только что запустили Obsidian. Инициализация резервного кэша может занять некоторое время, обычно до минуты или больше, в зависимости от производительности вашего устройства. Вы получите уведомление в правом верхнем углу, когда инициализация кэша будет завершена.<br><br>Нажмите OK, чтобы попытаться загрузить файл снова и проверить, завершилась ли инициализация кэша. Если за этим сообщением вы видите абсолютно пустой файл, я рекомендую подождать, пока кэш резервного копирования будет готов, прежде чем продолжать. Кроме того, вы можете выбрать «Отмена», чтобы вручную исправить файл.<br>",
  OBSIDIAN_TOOLS_PANEL: "Панель инструментов Obsidian",
  ERROR_SAVING_IMAGE: "При получении изображения произошла неизвестная ошибка. Возможно, по какой-то причине изображение недоступно или отклонен запрос на получение от Obsidian",
  WARNING_PASTING_ELEMENT_AS_TEXT: "ВСТАВКА ЭЛЕМЕНТОВ EXCALIDRAW В КАЧЕСТВЕ ТЕКСТОВОГО ЭЛЕМЕНТА ЗАПРЕЩЕНА",
  USE_INSERT_FILE_MODAL: "Используйте 'Вставить любой файл', чтобы вставить заметку в формате markdown",
  RECURSIVE_INSERT_ERROR: "Нельзя рекурсивно вставлять часть изображения в одно и то же изображение, так как это приведет к созданию бесконечного цикла",
  CONVERT_TO_MARKDOWN: "Преобразовать в файл...",
  SELECT_TEXTELEMENT_ONLY: "Выбрать только текстовый элемент (не контейнер)",
  REMOVE_LINK: "Удалить ссылку на текстовый элемент",
  LASER_ON: "Включить лазерный указатель",
  LASER_OFF: "Отключить лазерный указатель",
  WELCOME_RANK_NEXT: "Больше рисунков до следующего ранга!",
  WELCOME_RANK_LEGENDARY: "Вы на вершине. Продолжайте быть легендарным!",
  WELCOME_COMMAND_PALETTE: 'Введите «Excalidraw» в палитре коман',
  WELCOME_OBSIDIAN_MENU: "Изучите меню Обсидиана в правом верхнем углу",
  WELCOME_SCRIPT_LIBRARY: "Посетите библиотеку сценариев",
  WELCOME_HELP_MENU: "Найдите помощь в гамбургер-меню",
  WELCOME_YOUTUBE_ARIA: "Канал Visual PKM на YouTube",
  WELCOME_YOUTUBE_LINK: "Загляните на YouTube-канал Visual PKM.",
  WELCOME_DISCORD_ARIA: "Присоединяйтесь к серверу Discord",
  WELCOME_DISCORD_LINK: "Присоединяйтесь к серверу Discord",
  WELCOME_TWITTER_ARIA: "Следите за мной в Twitter",
  WELCOME_TWITTER_LINK: "Следите за мной в Twitter",
  WELCOME_LEARN_ARIA: "Изучение Visual PKM",
  WELCOME_LEARN_LINK: "Запишитесь на семинар по визуальному мышлению",
  WELCOME_DONATE_ARIA: "Пожертвовать на поддержку Excalidraw-Obsidian",
  WELCOME_DONATE_LINK: 'Скажите «Спасибо» и поддержите плагин.',
  SAVE_IS_TAKING_LONG: "Сохранение предыдущего файла занимает много времени. Пожалуйста, подождите...",
  SAVE_IS_TAKING_VERY_LONG: "Для повышения производительности рассмотрите возможность разделения больших рисунков на несколько файлов меньшего размера.",

  //settings.ts
  RELEASE_NOTES_NAME: "Отображение информации о выпуске после обновления",
  RELEASE_NOTES_DESC:
    "<b><u>Переключатель ВКЛ:</u></b> Отображение информации о выпуске при каждом обновлении Excalidraw до новой версии.<br>" +
    "<b><u>Переключатель ВЫКЛ:</u></b> Тихий режим. Вы все еще можете прочитать заметки о выпуске на <a href='https://github.com/zsviczian/obsidian-excalidraw-plugin/releases'>GitHub</a>.",
  NEWVERSION_NOTIFICATION_NAME: "Уведомление об обновлении плагина",
  NEWVERSION_NOTIFICATION_DESC:
      "<b><u>Переключатель ВКЛ:</u></b> Показывайте уведомление о появлении новой версии плагина.<br>" +
      "<b><u>Переключатель ВЫКЛ:</u></b> Тихий режим. Вам необходимо проверить обновления плагинов в разделе Community Plugins.",
  
  BASIC_HEAD: "Основные",
  BASIC_DESC: `В настройках "Основные" можно настроить такие параметры, как отображение заметок о выпуске после обновлений, получение уведомлений об обновлении плагинов, установка местоположения по умолчанию для новых чертежей, указание папки Excalidraw для вставки чертежей в активные документы, определение файла шаблона Excalidraw и указание папки сценария Excalidraw Automate для управления сценариями автоматизации.`,
  FOLDER_NAME: "Папка Excalidraw",
  FOLDER_DESC: "Место по умолчанию для новых чертежей. Если пусто, чертежи будут создаваться в корне хранилища.",
  CROP_PREFIX_NAME: "Префикс файла обрезки",
  CROP_PREFIX_DESC:
    "Первая часть имени файла для новых чертежей, созданных при обрезке изображения. " +
    "Если пусто, то по умолчанию будет использоваться значение 'cropped_'.",  
  ANNOTATE_PREFIX_NAME: "Префикс файла аннотации",
  ANNOTATE_PREFIX_DESC:
    "Первая часть имени файла для новых чертежей, созданных при аннотировании изображения. " +
    "Если пусто, то по умолчанию будет использоваться 'annotated_'.",
  ANNOTATE_PRESERVE_SIZE_NAME: "Preserve image size when annotating",
  ANNOTATE_PRESERVE_SIZE_DESC: "When annotating an image in markdown the replacment image link will include the width of the original image.",
  CROP_FOLDER_NAME: "Папка с файлами обрезки",
  CROP_FOLDER_DESC: "Место по умолчанию для новых чертежей, созданных при обрезке изображения. Если папка пуста, рисунки будут создаваться в соответствии с настройками вложений Хранилища.",
  ANNOTATE_FOLDER_NAME: "Папка с файлами аннотаций изображений",
  ANNOTATE_FOLDER_DESC: "Место по умолчанию для новых рисунков, создаваемых при аннотировании изображения. Если пусто, рисунки будут создаваться в соответствии с настройками вложений Хранилища.",
  FOLDER_EMBED_NAME: "Использовать папку Excalidraw при встраивании рисунка в активный документ",
  FOLDER_EMBED_DESC:
    "Определите, в какую папку поместить новый вставленный рисунок " +
    "при использовании действия палитры команд: 'Создать новый рисунок и вставить в активный документ'.<br>" +
    "<b><u>Переключатель ВКЛ:</u></b> Используйте папку Excalidraw<br><b><u>Переключатель ВЫКЛ:</u></b> Используйте папку вложений, определенную в настройках Obsidian.",
  TEMPLATE_NAME: "Файл или папка шаблона Excalidraw",
  TEMPLATE_DESC:
    "Полный путь к файлу или папке с шаблоном Excalidraw.<br>" +
    "<b>Файл шаблона:</b>Например: Если ваш шаблон находится в папке Excalidraw по умолчанию и его имя " +
    "Template.md, настройка должна быть: Excalidraw/Template.md (или только Excalidraw/Template - вы можете опустить .md расширение файла). " +
    "Если вы используете Excalidraw в режиме совместимости, то ваш шаблон также должен быть устаревшим файлом Excalidraw " +
    "такие как Excalidraw/Template.excalidraw. <br><b>Папка с шаблонами:</b> Вы также можете задать папку в качестве шаблона. " +
    "В этом случае вам будет предложено выбрать шаблон при создании нового чертежа.<br>" +
    "<b>Совет профи:</b> Если вы используете плагин Obsidian Templater, вы можете добавить код Templater в различные Excalidraw " +
    "шаблоны для автоматизации настройки чертежей.",
  SCRIPT_FOLDER_NAME: "Папка скриптов Excalidraw Automate (РеГИстРозависимЫЙ!)",
  SCRIPT_FOLDER_DESC:
    "Файлы, которые вы поместите в эту папку, будут рассматриваться как сценарии Excalidraw Automate. " +
    "Вы можете получить доступ к своим скриптам из Excalidraw через палитру команд Obsidian. Назначьте " +
    "горячие клавиши для ваших любимых скриптов, как и для любой другой команды Obsidian. " +
    "Эта папка может не быть корневой папкой вашего хранилища. ",
  AI_HEAD: "Настройки ИИ - Экспериментальные",
  AI_DESC: `В настройках "ИИ" вы можете настроить параметры использования GPT API OpenAI. ` +
    `Пока API OpenAI находится в бета-версии, его использование строго ограничено - поэтому мы требуем, чтобы вы использовали свой собственный ключ API. ` +
    `Вы можете создать аккаунт OpenAI, добавить небольшой кредит (минимум 5 долларов) и сгенерировать свой собственный ключ API. ` +
    `После установки API-ключа вы сможете использовать инструменты искусственного интеллекта в Excalidraw.`,
  AI_OPENAI_TOKEN_NAME: "Ключ API OpenAI",
  AI_OPENAI_TOKEN_DESC: "Вы можете получить свой ключ API OpenAI из вашего <a href='https://platform.openai.com/api-keys'>OpenAI аккаунта</a>.",
  AI_OPENAI_TOKEN_PLACEHOLDER: "Введите свой ключ API OpenAI здесь",
  AI_OPENAI_DEFAULT_MODEL_NAME: "Модель ИИ по умолчанию",
  AI_OPENAI_DEFAULT_MODEL_DESC:
    "Модель ИИ по умолчанию, используемая при генерации текста. Это поле свободного текста, поэтому вы можете ввести любое действительное имя модели OpenAI. " +
    "Узнайте больше о доступных моделях на <a href='https://platform.openai.com/docs/models'>OpenAI сайте</a>.",
  AI_OPENAI_DEFAULT_MODEL_PLACEHOLDER: "Введите здесь модель искусственного интеллекта по умолчанию, например: gpt-3.5-turbo-1106.",
  AI_OPENAI_DEFAULT_IMAGE_MODEL_NAME: "Модель ИИ для генерации изображений по умолчанию",
  AI_OPENAI_DEFAULT_IMAGE_MODEL_DESC:
    "Модель ИИ по умолчанию, используемая при генерации изображений. Редактирование и изменение изображений поддерживается OpenAI только в dall-e-2, " +
    "поэтому dall-e-2 будет автоматически использоваться в таких случаях независимо от этой настройки.<br>" +
    "Это поле свободного текста, поэтому вы можете ввести любое действительное имя модели OpenAI. " +
    "Узнайте больше о доступных моделях на <a href='https://platform.openai.com/docs/models'>OpenAI сайте</a>.",
  AI_OPENAI_DEFAULT_IMAGE_MODEL_PLACEHOLDER: "Введите здесь модель ИИ Image Generation по умолчанию, например: dall-e-3.",
  AI_OPENAI_DEFAULT_VISION_MODEL_NAME: "Модель видения ИИ по умолчанию",
  AI_OPENAI_DEFAULT_VISION_MODEL_DESC:
    "Модель зрения ИИ по умолчанию, используемая при генерации текста из изображений. Это поле свободного текста, поэтому вы можете ввести любое действительное имя модели OpenAI. " +
    "Узнайте больше о доступных моделях на <a href='https://platform.openai.com/docs/models'>OpenAI сайте</a>.",
  AI_OPENAI_DEFAULT_API_URL_NAME: "URL-адрес API OpenAI",
  AI_OPENAI_DEFAULT_API_URL_DESC:
    "URL-адрес OpenAI API по умолчанию. Это поле свободного текста, поэтому вы можете ввести любой действительный URL, совместимый с OpenAI API. " +
    "Excalidraw будет использовать этот URL при отправке API-запросов в OpenAI. Я не делаю никакой обработки ошибок в этом поле, поэтому убедитесь, что вы вводите правильный URL и изменяйте его только в том случае, если вы знаете, что делаете. ",
  AI_OPENAI_DEFAULT_IMAGE_API_URL_NAME: "URL-адрес API генерации изображений OpenAI",
  AI_OPENAI_DEFAULT_VISION_MODEL_PLACEHOLDER: "Введите здесь модель зрения ИИ по умолчанию. Например: gpt-4o",
  SAVING_HEAD: "Сохранение",
  SAVING_DESC: "В разделе 'Сохранение' раздела Настройки Excalidraw вы можете настроить способ сохранения ваших чертежей. Сюда входят опции сжатия Excalidraw JSON в Markdown, установки интервалов автосохранения для настольных и мобильных компьютеров, определения форматов имен файлов, а также выбора расширения файла .excalidraw.md или .md. ",
  COMPRESS_NAME: "Сжатие Excalidraw JSON в формате Markdown",
  COMPRESS_DESC:
    "При включении этой функции Excalidraw будет хранить JSON рисунка в формате Base64. " +
    "формат с использованием алгоритма <a href='https://pieroxy.net/blog/pages/lz-string/index.html'>LZ-String</a>. " +
    "Это уменьшит вероятность того, что Excalidraw JSON загромоздит результаты поиска в Obsidian. " +
    "Как побочный эффект, это также уменьшит размер файлов чертежей Excalidraw. " +
    "При переключении чертежа Excalidraw в режим Markdown с помощью меню опций Excalidraw файл будет " +
    "сохранен без сжатия, чтобы вы могли читать и редактировать строку JSON. Чертеж будет снова сжат " +
    "как только вы переключитесь обратно в вид Excalidraw. " +
    "Настройка имеет силу только 'на перспективу', то есть существующие чертежи не будут затронуты настройкой " +
    "пока вы не откроете и не сохраните их.<br><b><u>Переключатель ВКЛ:</u></b> Сжать чертеж JSON<br><b><u>Переключатель ВЫКЛ:</u></b> Оставьте JSON для рисования без сжатия",
  DECOMPRESS_FOR_MD_NAME: "Декомпрессия Excalidraw JSON в Markdown Режим",
  DECOMPRESS_FOR_MD_DESC:
    "При включении этой функции Excalidraw будет автоматически распаковывать JSON чертежа при переключении в режим Markdown." +
    "Это позволит вам легко читать и редактировать строку JSON. Чертеж будет снова сжат " +
    "как только вы переключитесь обратно в режим Excalidraw и сохраните чертеж (CTRL+S).<br>" +
    "Я рекомендую отключить эту функцию, так как это приведет к уменьшению размера файлов и избавит от ненужных результатов в поиске Obsidian. " +
    "Вы всегда можете воспользоваться командой 'Excalidraw: Распаковать текущий файл Excalidraw' из палитры команд. "+
    "чтобы вручную распаковывать JSON чертежа, когда вам нужно его прочитать или отредактировать.",
  AUTOSAVE_INTERVAL_DESKTOP_NAME: "Интервал для автосохранения на рабочем столе",
  AUTOSAVE_INTERVAL_DESKTOP_DESC:
    "Интервал времени между сохранениями. Автосохранение будет пропущено, если в чертеже нет изменений. " +
    "Excalidraw также сохранит файл при закрытии вкладки рабочей области или при навигации в Obsidian, но вне активной вкладки Excalidraw (например, при нажатии на ленту Obsidian, проверке обратных ссылок и т. д.). " +
    "Excalidraw не сможет сохранить вашу работу при завершении работы Obsidian напрямую, либо убив процесс Obsidian, либо нажав кнопку закрытия Obsidian вообще.",
  AUTOSAVE_INTERVAL_MOBILE_NAME: "Интервал для автосохранения на мобильном телефоне",
  AUTOSAVE_INTERVAL_MOBILE_DESC:
    "Для мобильников я рекомендую более частый интервал. " +
    "Excalidraw также сохранит файл при закрытии вкладки рабочей области или при навигации в Obsidian, но вне активной вкладки Excalidraw (например, при нажатии на ленту Obsidian, проверке обратных ссылок и т. д.). " +
    "Excalidraw не сможет сохранить вашу работу при прямом завершении работы Obsidian (т.е. смахнув ее). Также обратите внимание, что при переключении приложений на мобильном устройстве, иногда Android и iOS закрываются " +
    "Obsidian в фоновом режиме для экономии системных ресурсов. В этом случае Excalidraw не сможет сохранить последние изменения.",
FILENAME_HEAD: "Имя файла",
  FILENAME_DESC:
    "<p>Нажмите на эту ссылку, чтобы получить <a href='https://momentjs.com/docs/#/displaying/format/'>" +
    "справочник по формату даты и времени</a>.</p>",
  FILENAME_SAMPLE: "Filename for a new drawing is: ",
  FILENAME_EMBED_SAMPLE: "Имя файла для нового встроенного чертежа: ",
  FILENAME_PREFIX_NAME: "Префикс имени файла",
  FILENAME_PREFIX_DESC: "Первая часть имени файла",
  FILENAME_PREFIX_EMBED_NAME: "Префикс имени файла при вставке нового чертежа в заметку в формате markdown",
  FILENAME_PREFIX_EMBED_DESC:
    "Должно ли имя файла нового вставленного чертежа начинаться с имени активной заметки в формате markdown " +
    "при использовании действия палитры команд: <code>Создать новый чертеж и вставить его в активный документ</code>?<br>" +
    "<b><u>Переключатель ВКЛ:</u></b> Да, имя файла нового чертежа должно начинаться с имени файла активного документа<br><b><u>Переключатель ВЫКЛ:</u></b> Нет, имя файла нового чертежа не должно включать имя файла активного документа",
  FILENAME_POSTFIX_NAME: "Пользовательский текст после имени заметки в формате markdown при вставке",
  FILENAME_POSTFIX_DESC: "Влияет на имя файла только при вставке в документ markdown. Этот текст будет вставлен после имени заметки, но перед датой.",
  FILENAME_DATE_NAME: "Дата имени файла",
  FILENAME_DATE_DESC: "Последняя часть имени файла. Оставьте пустой, если дата не нужна.",
  FILENAME_EXCALIDRAW_EXTENSION_NAME: ".excalidraw.md или .md",
  FILENAME_EXCALIDRAW_EXTENSION_DESC:
    "Эта настройка не применяется, если вы используете Excalidraw в режиме совместимости, " +
    "т.е. вы не используете файлы разметки Excalidraw.<br><b><u>Переключатель ВКЛ:</u></b> Имя файла заканчивается на .excalidraw.md<br><b><u>Переключатель ВЫКЛ:</u></b> Имя файла заканчивается на .md",
  DISPLAY_HEAD: "Внешний вид и поведение Excalidraw",
  DISPLAY_DESC: "В разделе 'Внешний вид и поведение' раздела Настройки Excalidraw вы можете настроить внешний вид и поведение Excalidraw. Сюда входят опции динамической стилизации, режима для левой руки, соответствия тем Excalidraw и Obsidian, режимов по умолчанию и многое другое.",
  DYNAMICSTYLE_NAME: "Динамическая стилизация",
  DYNAMICSTYLE_DESC: "Изменение цветов пользовательского интерфейса Excalidraw в соответствии с цветом холста",
  LEFTHANDED_MODE_NAME: "Левосторонний режим",
  LEFTHANDED_MODE_DESC:
    "В настоящее время действует только в трей режиме. Если включить этот режим, трей будет находиться с правой стороны." +
    "<br><b><u>Переключатель ВКЛ:</u></b> Левосторонний режим.<br><b><u>Переключатель ВЫКЛ:</u></b> Правосторонний режим",
  IFRAME_MATCH_THEME_NAME: "Вставки Markdown для соответствия теме Excalidraw",
  IFRAME_MATCH_THEME_DESC:
    "<b><u>Переключатель ВКЛ:</u></b> Установите значение true, если, например, вы используете Obsidian в темном режиме, но применяете excalidraw со светлым фоном. " +
    "С этой настройкой встроенный документ разметки Obsidian будет соответствовать теме Excalidraw (т.е. светлые цвета, если Excalidraw находится в светлом режиме).<br>" +
    "<b><u>Переключатель ВЫКЛ:</u></b> Установите значение false, если хотите, чтобы встроенный в Obsidian документ разметки соответствовал теме Obsidian (т.е. темные цвета, если Obsidian находится в темном режиме).",    
  MATCH_THEME_NAME: "Новый чертеж в соответствии с темой Obsidian",
  MATCH_THEME_DESC:
    "Если тема темная, новый рисунок будет создан в темном режиме. Это не относится к случаям, когда вы используете шаблон для новых рисунков. " +
    "Также это не повлияет на открытие существующего чертежа. Они будут соответствовать теме шаблона/чертежа соответственно." +
    "<br><b><u>Переключатель ВКЛ:</u></b> Следуйте за Obsidian Theme<br><b><u>Переключатель ВЫКЛ:</u></b> Следовать теме, заданной в вашем шаблоне",
  MATCH_THEME_ALWAYS_NAME: "Существующие чертежи должны соответствовать теме Obsidian",
  MATCH_THEME_ALWAYS_DESC:
    "Если тема темная, чертежи будут открываться в темном режиме. Если тема светлая, они будут открываться в светлом режиме. " +
    "<br><b><u>Переключатель ВКЛ:</u></b> Соответствовать теме Obsidian<br><b><u>Переключатель ВЫКЛ:</u></b> Открывать ту же тему, что и при последнем сохранении",
  MATCH_THEME_TRIGGER_NAME: "Excalidraw будет следовать за изменениями Темы Obsidian",
  MATCH_THEME_TRIGGER_DESC:
    "Если эта опция включена, открытая панель Excalidraw будет переключаться в светлый/темный режим при смене темы Obsidian. " +
    "<br><b><u>Переключатель ВКЛ:</u></b> Следить за изменениями темы<br><b><u>Переключатель ВЫКЛ:</u></b> Чертежи не подвержены изменениям темы Obsidian",
  DEFAULT_OPEN_MODE_NAME: "Режим по умолчанию при открытии Excalidraw",
  DEFAULT_OPEN_MODE_DESC:
    "Указывает режим, в котором открывается Excalidraw: Обычный, Zen или режим просмотра. Вы также можете задать это поведение на уровне файла " +
    "добавив в документ ключ excalidraw-default-mode frontmatter со значением: normal, view или zen.",
  DEFAULT_PEN_MODE_NAME: "Режим пера",
  DEFAULT_PEN_MODE_DESC: "Должен ли режим пера автоматически включаться при открытии Excalidraw?",
  DISABLE_DOUBLE_TAP_ERASER_NAME: "Включение двойного нажатия ластика в режиме пера",
  SHOW_PEN_MODE_FREEDRAW_CROSSHAIR_NAME: "Показать (+) перекрестие в режиме пера",
  SHOW_PEN_MODE_FREEDRAW_CROSSHAIR_DESC:
    "Показывайте перекрестие в режиме пера при использовании инструмента freedraw. <b><u>Toggle Переключатель ВКЛ</u></b> Показывать <b><u>Toggle Переключатель ВЫКЛ</u></b> Скрывать<br>"+
    "Эффект зависит от устройства. Перекрестие обычно видно на планшетах для рисования, MS Surface, но не на iOS.",
  SHOW_DRAWING_OR_MD_IN_HOVER_PREVIEW_NAME: "Передача файла Excalidraw в виде изображения в предварительном просмотре при наведении...",
  SHOW_DRAWING_OR_MD_IN_HOVER_PREVIEW_DESC:
    "...даже если файл имеет ключ <b>excalidraw-open-md: true</b> frontmatter.<br>" +
    "Если этот параметр выключен и файл по умолчанию открывается в формате md, при наведении на предварительный просмотр" +
    "будет показана часть документа, содержащая разметку.",
  SHOW_DRAWING_OR_MD_IN_READING_MODE_NAME: "Рендеринг в виде изображения при чтении файла Excalidraw в режиме разметки",
  SHOW_DRAWING_OR_MD_IN_READING_MODE_DESC:
    "Когда вы находитесь в режиме чтения разметки (а именно, читаете обратную сторону рисунка), должен ли рисунок Excalidraw отображаться как изображение? " +
    "Этот параметр не влияет на отображение чертежа в режиме Excalidraw, а также при встраивании чертежа в документ с пометками или при предварительном просмотре при наведении.<br><ul>" +
    "<li>Смотрите другие связанные настройки для <a href='#«+TAG_PDFEXPORT+»'>экспорта PDF</a> в разделе 'Встраивание и экспорт' ниже.</li></ul><br>" +
    "Вы должны закрыть активный файл excalidraw/markdown и снова открыть его, чтобы это изменение вступило в силу.",
  SHOW_DRAWING_OR_MD_IN_EXPORTPDF_NAME: "При экспорте файла Excalidraw в PDF файл отображается как изображение.",
  SHOW_DRAWING_OR_MD_IN_EXPORTPDF_DESC:
    "Этот параметр управляет поведением Excalidraw при экспорте файла Excalidraw в PDF в режиме просмотра разметки с помощью функции Obsidian <b>Экспорт в PDF</b> <br>" +
    "<ul><li>Если <b>разрешить</b>, в PDF будет отображаться только чертеж Excalidraw;</li>" +
    "<li>Если <b>заблокировать</b>, то в PDF будет отображаться разметка документа.</li></ul>" +
    "См. другие связанные настройки для <a href='#«+TAG_MDREADINGMODE+»'>режима чтения разметки</a> в разделе 'Внешний вид и поведение' выше.<br>" +
    "⚠️ Обратите внимание, что необходимо закрыть активный файл excalidraw/markdown и открыть его снова, чтобы изменения вступили в силу. ⚠️",
  HOTKEY_OVERRIDE_HEAD: "Переопределение горячих клавиш",
  HOTKEY_OVERRIDE_DESC: `Некоторые горячие клавиши Excalidraw, такие как <code>${labelCTRL()}+Enter</code> для редактирования текста или <code>${labelCTRL()}+K</code> создания ссылки на элемент ` +
    "конфликтуют с настройками горячих клавиш Obsidian. Комбинации горячих клавиш, которые вы добавите ниже, отменят настройки горячих клавиш Obsidian при использовании Excalidraw, таким образом " +
    `Вы можете добавить <code>${labelCTRL()}+G</code>, если хотите по умолчанию перейти к Группе Объектов в Excalidraw вместо открытия Режима просмотра Графиков.`,
  THEME_HEAD: "Тема и стиль",
  ZOOM_AND_PAN_HEAD: "Масштаб и панорамирование",
  PAN_WITH_RIGHT_MOUSE_BUTTON_NAME: "Перемещение холста правой кнопкой мыши (открыть меню с 'm')",
  PAN_WITH_RIGHT_MOUSE_BUTTON_DESC: "Когда этот параметр включен, вы можете перемещать холст, нажимая правую кнопку мыши и перетаскивая. Контекстное меню откроется с помощью клавиши 'm', если только вы не редактируете текст.",
  DEFAULT_PINCHZOOM_NAME: "Разрешить масштабирование в режиме пера",
  DEFAULT_PINCHZOOM_DESC:
    "По умолчанию зуммирование в режиме пера при использовании инструмента «Свободное рисование» отключено, чтобы предотвратить нежелательное случайное масштабирование с помощью ладони.<br>" +
    "<b><u>Переключатель ВКЛ:</u></b>Включение щипкового масштабирования в режиме пера<br><b><u>Переключатель ВЫКЛ:</u></b>Выключение щипкового масштабирования в режиме пера",

  DEFAULT_WHEELZOOM_NAME: "Колесо мыши для масштабирования по умолчанию",
  DEFAULT_WHEELZOOM_DESC:
    `<b><u>Переключатель ВКЛ:</u></b> Колесо мыши для масштабирования; ${labelCTRL()} + Колесо мыши для прокрутки</br><b><u>Переключатель ВЫКЛ:</u></b>${labelCTRL()} + Колесико мыши для масштабирования; Колесико мыши для прокрутки`,
    
  ZOOM_TO_FIT_NAME: "Изменение масштаба при изменении размера просмотра",
  ZOOM_TO_FIT_DESC: "Изменение масштаба чертежа при изменении размера панели" +
    "<br><b><u>Переключатель ВКЛ:</u></b> Увеличить масштаб<br><b><u>Переключатель ВЫКЛ:</u></b> Автоматическое масштабирование отключено",
  ZOOM_TO_FIT_ONOPEN_NAME: "Увеличение масштаба при открытии файла",
  ZOOM_TO_FIT_ONOPEN_DESC: "Изменение масштаба чертежа при его первом открытии" +
      "<br><b><u>Переключатель ВКЛ:</u></b> Увеличить масштаб<br><b><u>Переключатель ВЫКЛ:</u></b> Автоматическое масштабирование отключено",  
  ZOOM_TO_FIT_MAX_LEVEL_NAME: "Увеличение до максимального уровня масштабирования",
  ZOOM_TO_FIT_MAX_LEVEL_DESC: "Установите максимальный уровень, до которого масштабирование будет увеличивать чертеж. Минимальное значение - 0,5 (50 %), максимальное - 10 (1000 %).",
  GRID_HEAD: "Сетка",
  GRID_DYNAMIC_COLOR_NAME: "Динамический цвет сетки",
  GRID_DYNAMIC_COLOR_DESC: "<b><u>Переключатель ВКЛ:</u></b>Измените цвет сетки, чтобы он соответствовал цвету холста<br><b><u>Переключатель ВЫКЛ:</u></b>Используйте цвет, указанный ниже, в качестве цвета сетки",
  GRID_COLOR_NAME: "Цвет сетки",
  GRID_OPACITY_NAME: "Прозрачность сетки",
  GRID_OPACITY_DESC: "Прозрачность сетки также будет управлять прозрачностью поля привязки при привязке стрелки к элементу.<br>" +
    "Установите прозрачность сетки. 0 - прозрачная, 100 - непрозрачная.",
  LASER_HEAD: "Лазерный указатель",
  LASER_COLOR: "Цвет лазерного указателя",
  LASER_DECAY_TIME_NAME: "Время затухания лазерного указателя",
  LASER_DECAY_TIME_DESC: "Время затухания лазерного указателя в миллисекундах. По умолчанию - 1000 (т. е. 1 секунда).",
  LASER_DECAY_LENGTH_NAME: "Длительность затухания лазерного указателя.",
  LASER_DECAY_LENGTH_DESC: "Длина затухания лазерного указателя в точках линии. По умолчанию 50.",
  LINKS_HEAD: "Ссылки, включение и задачи TODO",
  LINKS_HEAD_DESC: "В разделе 'Ссылки, включения и TODO' раздела Настройки Excalidraw вы можете настроить, как Excalidraw обрабатывает ссылки, включения и элементы TODO. Сюда входят опции для открытия ссылок, управления панелями, отображения ссылок со скобками, настройки префиксов ссылок, обработки элементов TODO и т. д. ",
  LINKS_DESC:
    `${labelCTRL()}+КЛИКНИТЕ на <code>[[Text Elements]]</code> чтобы открыть их как ссылки. ` +
    "Если выделенный текст имеет более одного <code>[[valid Obsidian links]]</code>, только первый будет открыт. " +
    "Если текст начинается как правильная веб-ссылка (то есть <code>https://</code> или <code>http://</code>), потом " +
    "плагин откроет его в браузере. " +
    "Когда файлы Obsidian изменяются, соответствующие <code>[[link]]</code> в ваших чертежах также изменится. " +
    "Если вы не хотите, чтобы текст случайно менялся в ваших чертежах, используйте <code>[[links|with aliases]]</code>.",
  DRAG_MODIFIER_NAME: "Щелкните ссылку и перетащите клавиши-модификаторы",
  DRAG_MODIFIER_DESC: "Поведение клавиши-модификатора при нажатии на ссылки и перетаскивании элементов. " +
    "Excalidraw не будет проверять вашу конфигурацию... обратите внимание, чтобы избежать конфликтов настроек. " +
    "Эти настройки отличаются для Apple и не-Apple. Если вы используете Obsidian на нескольких платформах, вам нужно будет сделать настройки отдельно. "+
    "Переключатели расположены в порядке" +
    (DEVICE.isIOS || DEVICE.isMacOS ? "SHIFT, CMD, OPT, CONTROL." : "SHIFT, CTRL, ALT, META (Клавишы Windows)."),
  LONG_PRESS_DESKTOP_NAME: "Длительное нажатие открывает рабочий стол",
  LONG_PRESS_DESKTOP_DESC: "Задержка нажатия в миллисекундах для открытия чертежа Excalidraw, встроенного в файл Markdown.",
  LONG_PRESS_MOBILE_NAME: "Длительное нажатие открывает мобильную версию",
  LONG_PRESS_MOBILE_DESC: "Задержка нажатия в миллисекундах для открытия чертежа Excalidraw, встроенного в файл Markdown.",

  FOCUS_ON_EXISTING_TAB_NAME: "Фокус на существующей вкладке",
  FOCUS_ON_EXISTING_TAB_DESC: "При открытии ссылки Excalidraw будет фокусироваться на существующей вкладке, если файл уже открыт. " +
    "Включение этого параметра отменяет 'Повторное использование соседней панели', если файл уже открыт.",
  SECOND_ORDER_LINKS_NAME: "Показать ссылки второго порядка",
  SECOND_ORDER_LINKS_DESC: "Показывать ссылки при нажатии на ссылку в Excalidraw. Ссылки второго порядка - это обратные ссылки, указывающие на ссылку, по которой переходят. " +
    "При использовании значков изображений для соединения похожих заметок ссылки второго порядка позволяют перейти к связанным заметкам одним щелчком мыши, а не двумя. " +
    "Для понимания смотрите <a href='https://youtube.com/shorts/O_1ls9c6wBY?feature=share'>YT Short</a>.",
  ADJACENT_PANE_NAME: "Повторное использование соседней панели",
  ADJACENT_PANE_DESC:
    `Когда ${labelCTRL()}+${labelALT()} нажимает на ссылку в Excalidraw, по умолчанию плагин открывает ссылку в новой панели. ` +
    "Если включить этот параметр, Excalidraw сначала будет искать существующую панель и пытаться открыть ссылку в ней. " +
    "Excalidraw будет искать другую панель рабочего пространства, основываясь на истории фокуса/навигации, то есть на той панели, которая была активна до того, " +
    "как вы активировали Excalidraw.",
  MAINWORKSPACE_PANE_NAME: "Открыть в основном рабочем пространстве",
  MAINWORKSPACE_PANE_DESC:
    `Когда ${labelCTRL()}+${labelALT()} нажимает на ссылку в Excalidraw, по умолчанию плагин открывает ссылку в новой панели в текущем активном окне. ` +
    "Если включить этот параметр, Excalidraw откроет ссылку в существующей или новой панели в основном рабочем пространстве. ",  
  LINK_BRACKETS_NAME: "Показать <code>[[brackets]]</code> вокруг ссылок",
  LINK_BRACKETS_DESC: `${
    "В режиме ПРЕДВАРИТЕЛЬНОГО ПРОСМОТРА при разборе элементов текста ставьте скобки вокруг ссылок. " +
    "Вы можете переопределить эту настройку для конкретного чертежа, добавив <code>"
  }${FRONTMATTER_KEYS["link-brackets"].name}: true/false</code> в frontmatter файла.`,
  LINK_PREFIX_NAME: "Префикс ссылки",
  LINK_PREFIX_DESC: `${
    "В режиме ПРЕДВАРИТЕЛЬНОГО ПРОСМОТРА, если элемент 'Текст' содержит ссылку, перед текстом должны стоять эти символы. " +
    "Вы можете переопределить эту настройку для конкретного чертежа, добавив <code>"
  }${FRONTMATTER_KEYS["link-prefix"].name}: "📍 "</code> в frontmatter файла.`,
  URL_PREFIX_NAME: "Префикс URL-адреса",
  URL_PREFIX_DESC: `${
    "В режиме ПРЕДВАРИТЕЛЬНОГО ПРОСМОТРА, если элемент 'Текст' содержит ссылку URL, перед текстом должны стоять эти символы. " +
    "Вы можете переопределить эту настройку для конкретного чертежа, добавив <code>"
  }${FRONTMATTER_KEYS["url-prefix"].name}: "🌐 "</code> в frontmatter файла.`,
  PARSE_TODO_NAME: "Парсинг TODO",
  PARSE_TODO_DESC: "Преобразуйте '- [ ] ' и '- [x] ' в чекбокс и поставьте галочку.",
  TODO_NAME: "Открыть иконку TODO",
  TODO_DESC: "Иконка для открытых пунктов TODO",
  DONE_NAME: "Иконка завершенного TODO",
  DONE_DESC: "Иконка для завершенных элементов TODO",
  HOVERPREVIEW_NAME: `Предварительный просмотр наведением без нажатия клавиши ${labelCTRL()}`,
  HOVERPREVIEW_DESC:
    `<b><u>Переключатель ВКЛ:</u></b> <u>В режиме просмотра</u> Exalidraw предварительный просмотр при наведении на [[вики-ссылки]] будет показан сразу, без необходимости удерживать клавишу ${labelCTRL()}. ` +
    "В Excalidraw <u>нормальный режим</u>, предварительный просмотр будет показан сразу только при наведении на синий значок ссылки в правом верхнем углу элемента.<br> " +
    `<b><u>Переключатель ВЫКЛ:</u></b> Предварительный просмотр при наведении отображается только в том случае, если при наведении на ссылку вы удерживаете клавишу ${labelCTRL()}.`,
  LINKOPACITY_NAME: "Прозрачность значка ссылки",
  LINKOPACITY_DESC: "Прозрачность значка индикатора ссылки в правом верхнем углу элемента. 1 - непрозрачный, 0 - прозрачный.",
  LINK_CTRL_CLICK_NAME: `${labelCTRL()}+КЛИК на текст с [[links]] или [](links), чтобы открыть их`,
  LINK_CTRL_CLICK_DESC:
    "Вы можете отключить эту функцию, если она мешает работе стандартных функций Excalidraw, которые вы хотите использовать. " +
    `Если эта функция отключена, для открытия ссылок можно использовать либо ${labelCTRL()} + ${labelMETA()}, либо индикатор ссылок в правом верхнем углу элемента.`,
  TRANSCLUSION_WRAP_NAME: "Поведение переноса при переполненнии включенного текста",
  TRANSCLUSION_WRAP_DESC:
    "Число задает количество символов, через которое должен быть перенесен текст. " +
    "Устанавливает поведение переноса текста. Включите этот параметр, чтобы принудительно перенести " +
    " текст (т. е. без переполнения), или выключите, чтобы мягко перенести текст (по ближайшему пробелу).",
  TRANSCLUSION_DEFAULT_WRAP_NAME: "Перенос по словам включения по умолчанию",
  TRANSCLUSION_DEFAULT_WRAP_DESC:
    "Вы можете вручную задать/переопределить длину переноса слов, используя формат `![[page#^block]]{NUMBER}`. " +
    "Обычно вам не нужно устанавливать значение по умолчанию, поскольку если вы вставите текст внутрь стикера, то Excalidraw автоматически позаботится о переносе слов. " +
    "Установите это значение на '0', если вы не хотите устанавливать значение по умолчанию. ",
  PAGE_TRANSCLUSION_CHARCOUNT_NAME: "Максимальное количество символов при включении страниц (трансклюзии)",
  PAGE_TRANSCLUSION_CHARCOUNT_DESC:
    "Максимальное количество символов, отображаемых на странице при включении всей страницы" +
    "в формате ![[markdown page]].",
  QUOTE_TRANSCLUSION_REMOVE_NAME: "Включение (Трансклюзия) цитат: удалите ведущие '> ' из каждой строки",
  QUOTE_TRANSCLUSION_REMOVE_DESC: "Удалите начальный '>' из каждой строки включения. Это улучшит читаемость цитат в текстовых включениях <br>" +
    "<b><u>Переключатель ВКЛ:</u></b> Удалить ведущие '> '<br><b><u>Переключатель ВЫКЛ:</u></b> Не удалить ведущие '> ' (обратите внимание, что он все равно будет удален из первой строки из-за функциональности API Obsidian.)",
  GET_URL_TITLE_NAME: "Используйте iframely для преобразования заголовка страницы",
  GET_URL_TITLE_DESC:
    "Используйте <code>http://iframely.server.crestify.com/iframely?url=</code> для получения заголовка страницы при переходе по ссылке в Excalidraw",
  PDF_TO_IMAGE: "PDF в изображение",
  PDF_TO_IMAGE_SCALE_NAME: "Шкала преобразования PDF в изображения",
  PDF_TO_IMAGE_SCALE_DESC: "Устанавливает разрешение изображения, которое генерируется из PDF-страницы. Более высокое разрешение приведет к увеличению размера изображений в памяти и, как следствие, к увеличению нагрузки на систему (замедлению производительности), но при этом изображение будет более четким. " +
    "Кроме того, если вы хотите скопировать страницы PDF (как изображения) на Excalidraw.com, больший размер изображения может привести к превышению лимита в 2 МБ на Excalidraw.com.",
  EMBED_TOEXCALIDRAW_HEAD: "Встраивание файлов в Excalidraw",
  EMBED_TOEXCALIDRAW_DESC: "В разделе Встраивание файлов раздела Настройки Excalidraw вы можете настроить, как различные файлы будут встраиваться в Excalidraw. Сюда входят опции для встраивания интерактивных файлов разметки (Markdown), PDF-файлов и файлов разметки (Markdown) в виде изображений.",
  MD_HEAD: "Встраивать разметку в Excalidraw в виде изображения",
  MD_EMBED_CUSTOMDATA_HEAD_NAME: "Интерактивные файлы Markdown",
  MD_EMBED_CUSTOMDATA_HEAD_DESC: `Приведенные ниже настройки будут влиять только на будущие вставки. Текущие вставки остаются неизменными. Настройки темы для встроенных фреймов находятся в разделе "Внешний вид и поведение Excalidraw".`,
  MD_EMBED_SINGLECLICK_EDIT_NAME: "Редактирование встроенной разметки (Markdown) одним щелчком мыши",
  MD_EMBED_SINGLECLICK_EDIT_DESC:
    "Однократный щелчок на встроенном файле разметки (Markdown) для его редактирования. " +
    "Если отключить эту функцию, файл с пометками сначала откроется в режиме предварительного просмотра, а затем переключится в режим редактирования, когда вы снова нажмете на него.",
  MD_TRANSCLUDE_WIDTH_NAME: "Ширина по умолчанию для включенного документа с разметкой",
  MD_TRANSCLUDE_WIDTH_DESC:
    "Ширина страницы разметки (Markdown). Это влияет на обертку слов при встраивание длинных абзацев, а также на ширину элемента изображения " +
    " Вы можете изменить ширину встроенного файла по умолчанию, " +
    "используя синтаксис <code>[[filename#heading|WIDTHxMAXHEIGHT]]</code> в режиме просмотра markdown в разделе встроенных файлов.",
  MD_TRANSCLUDE_HEIGHT_NAME: "Максимальная высота по умолчанию для документа с пометкой встраиваемый",
  MD_TRANSCLUDE_HEIGHT_DESC:
    "Встроенное изображение будет настолько высоким, насколько этого требует текст разметки (Markdown), но не выше этого значения. " +
    "Вы можете переопределить это значение, отредактировав ссылку на встроенное изображение в режиме просмотра markdown со следующим синтаксисом <code>[[filename#^blockref|WIDTHxMAXHEIGHT]]</code>.",
  MD_DEFAULT_FONT_NAME: "Шрифт по умолчанию, используемый для встроенных файлов разметки (Markdown).",
  MD_DEFAULT_FONT_DESC:
    'Установите это значение на "Virgil" или "Cascadia" или на имя файла <code>.ttf</code>, <code>.woff</code>, или <code>.woff2</code> шрифта, например. <code>MyFont.woff2</code> ' +
    "Вы можете отменить эту настройку, добавив следующий frontmatter-ключ во встроенный файл разметки (markdown): <code>excalidraw-font: font_or_filename</code>",
  MD_DEFAULT_COLOR_NAME: "Цвет шрифта по умолчанию, используемый для встроенных файлов разметки (markdown).",
  MD_DEFAULT_COLOR_DESC:
    'Установите это значение в любое допустимое имя цвета css, например, "steelblue" (<a href="https://www.w3schools.com/colors/colors_names.asp">имена цветов</a>), или допустимый шестнадцатеричный цвет, например "#e67700", ' +
    "или на любую другую допустимую строку цвета css. Вы можете отменить эту настройку, добавив следующий frontmatter-ключ во встроенный файл разметки (markdown): <code>excalidraw-font-color: steelblue</code>",
  MD_DEFAULT_BORDER_COLOR_NAME: "Цвет границы, используемый по умолчанию для встроенных файлов разметки (markdown).",
  MD_DEFAULT_BORDER_COLOR_DESC:
    'Установите это значение на любое допустимое имя цвета css, например "steelblue" (<a href="https://www.w3schools.com/colors/colors_names.asp">имена цветов</a>),  или на допустимый шестнадцатеричный цвет, например "#e67700", ' +
    "или на любую другую допустимую строку цвета css. Вы можете отменить эту настройку, добавив следующий frontmatter-key во встроенный файл разметки (markdown): <code>excalidraw-border-color: gray</code>. " +
    "Оставьте пустым, если вам не нужна граница. ",
  MD_CSS_NAME: "CSS файл",
  MD_CSS_DESC:
    "Имя файла CSS для применения к вставкам markdown. Укажите имя файла с расширением (например, 'md-embed.css'). Файл css также может быть обычным файлом " +
    "markdow (e.g. 'md-embed-css.md'), просто убедитесь, что содержимое написано с использованием правильного синтаксиса css. " +
    `Если вам нужно просмотреть HTML-код, к которому вы применяете CSS, откройте Obsidian Developer Console (${DEVICE.isIOS || DEVICE.isMacOS ? "CMD+OPT+i" : "CTRL+SHIFT+i"}) и введите следующую команду: ` +
    '"ExcalidrawAutomate.mostRecentMarkdownSVG". Это отобразит последний SVG, сгенерированный Excalidraw. ' +
    "Установка font-family в css имеет свои ограничения. По умолчанию доступны только стандартные шрифты вашей операционной системы (подробнее см. в README). " +
    "Вы можете добавить еще один пользовательский шрифт, используя настройки выше. " +
    'Вы можете переопределить эту настройку css, добавив следующий frontmatter-ключ во встроенный файл разметки: "excalidraw-css: css_file_in_vault|css-snippet".',
  EMBED_HEAD: "Встраивание Excalidraw в заметки и экспорт",
  EMBED_DESC: `В настройках "Вставка и экспорт" можно настроить вставку и экспорт изображений и рисунков Excalidraw в документы. Основные настройки включают выбор типа изображения для предварительного просмотра в формате разметки (например, Native SVG или PNG), указание типа файла для вставки в документ (оригинальный Excalidraw, PNG или SVG) и управление кэшированием изображений для вставки в разметку. Вы также можете управлять размерами изображений, вставлять рисунки с помощью ссылок на вики или ссылок на разметку, а также настраивать темы изображений, цвета фона и интеграцию с Obsidian. 
    Кроме того, есть настройки автоэкспорта, который автоматически генерирует файлы SVG и/или PNG, соответствующие названию ваших рисунков Excalidraw, сохраняя их синхронизацию при переименовании и удалении файлов.`,
  EMBED_CANVAS: "Поддержка Obsidian Canvas",
  EMBED_CANVAS_NAME: "Иммерсивное встраивание",
  EMBED_CANVAS_DESC: 
    "Скрывайте границы и фон узлов холста при встраивании чертежа Excalidraw в холст. " +
    "Обратите внимание, что для создания полностью прозрачного фона изображения вам все равно придется настроить Excalidraw на экспорт изображений с прозрачным фоном.",
  EMBED_CACHING: "Кэширование изображений",
  EXPORT_SUBHEAD: "Настройки экспорта",
  EMBED_SIZING: "Размер изображения",
  EMBED_THEME_BACKGROUND: "Тема изображения и цвет фона",
  EMBED_IMAGE_CACHE_NAME: "Кэширование изображений для вставки в markdown",
  EMBED_IMAGE_CACHE_DESC: "Кэшируйте изображения для вставки в markdown. Это ускорит процесс встраивания, но в случае, если вы составите изображения из нескольких чертежей-субкомпонентов, " +
    "встроенное изображение в Markdown не будет обновляться, пока вы не откроете рисунок и не сохраните его, чтобы вызвать обновление кэша.",
  SCENE_IMAGE_CACHE_NAME: "Кэширование вложенных Excalidraws в Cцене",
  SCENE_IMAGE_CACHE_DESC: "Кэшируйте вложенные Excalidraws в сцене для ускорения рендеринга сцены. Это ускорит процесс рендеринга, особенно если в сцене есть глубоко вложенные Excalidraw. " + 
    "Excalidraw попытается интеллектуально определить, изменились ли дочерние элементы вложенного Excalidraw, и соответствующим образом обновит кэш. " +
    "Вы можете отключить эту функцию, если у вас есть подозрения, что кэш обновляется неправильно.",
  EMBED_IMAGE_CACHE_CLEAR: "Очистка кэша",
  BACKUP_CACHE_CLEAR: "Очистка резервных копий",
  BACKUP_CACHE_CLEAR_CONFIRMATION: "Это действие удалит все резервные копии чертежей Excalidraw. Резервные копии используются в качестве меры безопасности на случай повреждения файла рисунка. Каждый раз, когда вы открываете Obsidian, плагин автоматически удаляет резервные копии файлов, которые больше не существуют в вашем хранилище. Вы уверены, что хотите удалить все резервные копии?",
  EMBED_REUSE_EXPORTED_IMAGE_NAME: "Если найдено, используйте уже экспортированное изображение для предварительного просмотра",
  EMBED_REUSE_EXPORTED_IMAGE_DESC:
    "Эта настройка работает в сочетании с настройкой <a href='#«+TAG_AUTOEXPORT+»'>Автоэкспорт SVG/PNG</a>. Если имеется экспортированное изображение, соответствующее имени файла чертежа, используйте это изображение вместо того, " +
    "чтобы генерировать изображение предварительного просмотра на лету. Однако это позволит ускорить предварительный просмотр, особенно если в чертеже много встроенных объектов, " +
    "может случиться так, что последние изменения не будут отображаться, а изображение не будет автоматически соответствовать вашей теме Obsidian, " +
    "если вы изменили тему Obsidian с момента создания экспорта. Эта настройка применяется только для вставки изображений в документы markdown. " +
    "По ряду причин этот же подход не может быть использован для ускорения загрузки чертежей с большим количеством встроенных объектов. Смотрите демонстрацию <a href='https://github.com/zsviczian/obsidian-excalidraw-plugin/releases/tag/1.6.23' target='_blank'>здесь</a>.",
  /*EMBED_PREVIEW_SVG_NAME: "Отображение SVG в предварительном просмотре разметки (markdown)",
  EMBED_PREVIEW_SVG_DESC:
    "<b><u>Переключатель ВКЛ:</u></b> Вставьте рисунок как изображение <a href='https://en.wikipedia.org/wiki/Scalable_Vector_Graphics' target='_blank'>SVG</a> в предварительный просмотр разметки (markdown).<br>" +
    "<b><u>Переключатель ВЫКЛ:</u></b> Встроить рисунок как изображение <a href='' target='_blank'>PNG</a>. Обратите внимание, что некоторые из <a href='https://www.youtube.com/watch?v=yZQoJg2RCKI&t=633s' target='_blank'>функций ссылок на блоки изображений</a> не работают с встраиванием PNG.",*/
  EMBED_PREVIEW_IMAGETYPE_NAME: "Тип изображения в предварительном просмотре разметки (markdown)",
  EMBED_PREVIEW_IMAGETYPE_DESC:
    "<b><u>Родной SVG</u></b>: Высокое качество изображения. Встраиваемые веб-сайты, видео с YouTube, ссылки на Obsidian и внешние изображения, вставленные через URL-адрес, будут работать. Встроенные страницы Obsidian не будут<br>" +
    "<b><u>SVG-изображение</u></b>: Высокое качество изображений. Встроенные элементы и изображения, вставленные по URL, имеют только заполнители, ссылки не работают<br>" +
    "<b><u>PNG-изображение</u></b>: Более низкое качество изображения, но в некоторых случаях лучшая производительность при работе с большими рисунками. Встроенные элементы и изображения, вставленные по URL, имеют только заполнители, ссылки не работают. Также некоторые функции <a href='https://www.youtube.com/watch?v=yZQoJg2RCKI&t=633s' target='_blank'>ссылки на блок изображений</a> не работают с PNG-вставками.", 
  PREVIEW_MATCH_OBSIDIAN_NAME: "Предварительный просмотр Excalidraw в соответствии с темой Obsidian",
  PREVIEW_MATCH_OBSIDIAN_DESC:
    "Предварительный просмотр изображений в документах должен соответствовать теме Obsidian. Если эта функция включена, то когда Obsidian находится в темном режиме, изображения Excalidraw будут отображаться в темном режиме. " +
    "Когда Obsidian находится в режиме освещения, Excalidraw также будет рендерить в режиме освещения. Вы можете отключить функцию 'Экспортировать изображение с фоном', чтобы получить более интегрированный в Obsidian вид и ощущение.",
  EMBED_WIDTH_NAME: "Ширина по умолчанию для встроенного ('включенного') изображения",
  EMBED_WIDTH_DESC:
    "Ширина по умолчанию для встроенного рисунка. Это относится к режиму редактирования и чтения, а также к предварительным просмотрам при наведении. При вставке изображения можно указать его " +
    "ширину используя <code>![[drawing.excalidraw|100]]</code> или " +
    "<code>[[drawing.excalidraw|100x100]]</code> формат.",
  EMBED_HEIGHT_NAME: "Высота по умолчанию для встроенного ('включенного') изображения",
  EMBED_HEIGHT_DESC:
    "Высота по умолчанию для встроенного рисунка. Это относится к режиму редактирования и чтения, а также к предварительным просмотрам при наведении. При вставке изображения можно указать его " +
    "высоту используя <code>![[drawing.excalidraw|100]]</code> или " +
    "<code>[[drawing.excalidraw|100x100]]</code> формат.",
  EMBED_TYPE_NAME: "Тип файла для вставки в документ",
  EMBED_TYPE_DESC:
    "Когда вы вставляете изображение в документ с помощью командной палитры, этот параметр определяет, должен ли Excalidraw вставлять оригинальный файл Excalidraw " +
    "или копию PNG или SVG. Чтобы эти типы изображений были доступны в раскрывающемся списке, их необходимо включить <a href='#"+TAG_AUTOEXPORT+"'>auto-export PNG / SVG</a> (см. ниже в разделе 'Настройки экспорта'). Для чертежей, не имеющих соответствующего PNG или " +
    "SVG, действие из палитры команд вставит неработающую ссылку. Необходимо открыть исходный чертеж и инициировать экспорт вручную. " +
    "Эта опция не будет автоматически генерировать файлы PNG/SVG, а просто будет ссылаться на уже существующие файлы.",
  EMBED_MARKDOWN_COMMENT_NAME: "Вставить ссылку на чертеж как комментари",
  EMBED_MARKDOWN_COMMENT_DESC: 
    "Вставьте ссылку на исходный файл Excalidraw в виде ссылки в формате markdown под изображением, например: <code>%%[[drawing.excalidraw]]%%</code>.<br>" +
    "Вместо добавления комментария можно также выделить встроенную строку SVG или PNG и использовать действие из палитры команд: " +
    "'<code>Excalidraw: Open Excalidraw drawing</code>' чтобы открыть чертеж.",
  EMBED_WIKILINK_NAME: "Встраивание рисунка с помощью ссылки Wiki",
  EMBED_WIKILINK_DESC: "<b><u>Переключатель ВКЛ:</u></b> Excalidraw будет встраивать [[wiki link]].<br><b><u>Переключатель ВЫКЛ:</u></b> Excalidraw будет встраивать [markdown](link).",
  EXPORT_PNG_SCALE_NAME: "Масштаб экспортируемого изображения PNG",
  EXPORT_PNG_SCALE_DESC: "Масштаб экспортируемого PNG-изображения",
  EXPORT_BACKGROUND_NAME: "Экспорт изображения с фоном",
  EXPORT_BACKGROUND_DESC: "Если отключить эту функцию, экспортируемое изображение будет прозрачным.",
  EXPORT_PADDING_NAME: "Отступы изображений",
  EXPORT_PADDING_DESC:
    "Размер (в пикселях) вокруг экспортируемого изображения SVG или PNG. Для ссылок на clippedFrame значение Отступов равно 0." +
    "Если кривые линии расположены близко к краю изображения, они могут быть обрезаны при экспорте. Вы можете увеличить это значение, чтобы избежать обрезки. " +
    "Вы также можете отменить эту настройку на уровне файла, добавив ключ frontmatter <code>excalidraw-export-padding: 5<code>.",
  EXPORT_THEME_NAME: "Экспорт изображения с темой",
  EXPORT_THEME_DESC:
    "Экспортируйте изображение, соответствующее темной/светлой теме вашего рисунка. Если отключить эту функцию, " +
    "рисунки, созданные в темном режиме, будут отображаться так же, как и в светлом режиме. ",
  EXPORT_EMBED_SCENE_NAME: "Встроить сцену в экспортированное изображение",
  EXPORT_EMBED_SCENE_DESC:
    "Вставка сцены Excalidraw в экспортируемое изображение. Можно переопределить на уровне файла, добавив ключ frontmatter. <code>excalidraw-export-embed-scene: true/false<code>. " +
    "Настройка вступит в силу только при следующем (повторном) открытии чертежей.",
  EXPORT_HEAD: "Настройки автоэкспорта",
  EXPORT_SYNC_NAME: "Поддерживайте синхронизацию имен файлов .SVG и/или .PNG с файлом чертежа",
  EXPORT_SYNC_DESC:
    "Если плагин включен, он будет автоматически обновлять имена файлов .SVG и/или .PNG при переименовании чертежа в той же папке (и с тем же именем). " +
    "Плагин также автоматически удалит файлы .SVG и/или .PNG при удалении рисунка в той же папке (и с тем же именем). ",
  EXPORT_SVG_NAME: "Автоэкспорт SVG",
  EXPORT_SVG_DESC:
    "Автоматическое создание SVG-экспорта вашего чертежа, соответствующего названию файла. " +
    "Плагин сохранит файл *.SVG в той же папке, что и чертеж. " +
    "Встраивайте .svg-файл в документы вместо Excalidraw, делая вставки независимыми от платформы. " +
    "Если переключатель автоэкспорта включен, этот файл будет обновляться каждый раз, когда вы редактируете чертеж Excalidraw с соответствующим именем. " + 
    "Вы можете отменить эту настройку на уровне файла, добавив ключ frontmatter <code>excalidraw-autoexport</code>.Допустимыми значениями для этого ключа являются" +
    "<code>none</code>,<code>both</code>,<code>svg</code>, и <code>png</code>.",
  EXPORT_PNG_NAME: "Автоэкспорт PNG",
  EXPORT_PNG_DESC: "То же самое, что и автоэкспорт SVG, но для *.PNG",
  EXPORT_BOTH_DARK_AND_LIGHT_NAME: "Экспорт изображения с темной и светлой тематикой",
  EXPORT_BOTH_DARK_AND_LIGHT_DESC: "Если включить эту функцию, Excalidraw будет экспортировать два файла вместо одного: filename.dark.png, filename.light.png и/или filename.dark.svg и filename.light.svg.<br>" +
    "Двойные файлы будут экспортированы как при включенном автоэкспорте SVG или PNG (или обоих), так и при нажатии кнопки экспорта на одном изображении.",
  COMPATIBILITY_HEAD: "Особенности совместимости",
  COMPATIBILITY_DESC: "Включать эти функции следует только в том случае, если у вас есть веские причины работать с файлами excalidraw.com, а не с файлами markdown. Многие функции плагина не поддерживаются в старых файлах. Типичным случаем может быть использование хранилища поверх папки проекта Visual Studio Code, а также наличие чертежей .excalidraw, к которым вы хотите получить доступ из Visual Studio Code. Другим примером может быть параллельное использование Excalidraw в Logseq и Obsidian.",
  DUMMY_TEXT_ELEMENT_LINT_SUPPORT_NAME: "Совместимость с линтерами",
  DUMMY_TEXT_ELEMENT_LINT_SUPPORT_DESC: "Excalidraw чувствителен к структуре файлов ниже <code># Excalidraw Data</code>. Автоматическая линтинговая обработка документов может создавать ошибки в Excalidraw Data. " +
    "Хотя я приложил некоторые усилия, чтобы сделать загрузку данных устойчивой к изменениям линта," +
    "это решение не является надежным.<br><mark>Лучше всего избегать линтинга или других автоматических изменений документов Excalidraw с помощью различных плагинов.</mark><br>" +
    "Используйте эту настройку, если по уважительным причинам вы решили проигнорировать мою рекомендацию и настроили линтинг файлов Excalidraw.<br> " +
    "Раздел <code>## Текстовые элементы</code> чувствителен к пустым строкам. Обычный подход к линтингу заключается в добавлении пустой строки после заголовков разделов. В случае Excalidraw это приведет к поломке/изменению первого текстового элемента в чертеже. " +
    "Чтобы решить эту проблему, можно включить эту настройку. WhenЕсли она включена, Excalidraw добавит в начало фиктивный элемент, <code>## Текстовые элементы</code> который линтер может безопасно модифицировать." ,
  PRESERVE_TEXT_AFTER_DRAWING_NAME: "Совместимость Zotero и Footnotes",
  PRESERVE_TEXT_AFTER_DRAWING_DESC: "Сохраните текст после раздела ## Чертеж в файле Markdown. Это может незначительно повлиять на производительность при сохранении очень больших рисунков.",
  DEBUGMODE_NAME: "Включить отладочные сообщения",
  DEBUGMODE_DESC: "Я рекомендую перезапустить Obsidian после включения/выключения этой настройки. Это позволяет выводить отладочные сообщения в консоль. Это полезно для устранения неполадок. " +
    "Если у вас возникли проблемы с плагином, пожалуйста, включите эту настройку, воспроизведите проблему и включите журнал консоли в проблему, которую вы поднимаете на <a href='https://github.com/zsviczian/obsidian-excalidraw-plugin/issues'>GitHub</a>",
  SLIDING_PANES_NAME: "Поддержка плагина раздвижных областей окна (Sliding Panes plugin)",
  SLIDING_PANES_DESC:
    "Чтобы это изменение вступило в силу, необходимо перезапустить Obsidian.<br>" +
    "Если вы используете <a href='https://github.com/deathau/sliding-panes-obsidian' target='_blank'>Sliding Panes plugin</a> " +
    "Вы можете включить эту настройку, чтобы чертежи Excalidraw работали с плагином Sliding Panes.<br>" +
    "Обратите внимание, что поддержка раздвижных областей окна (Sliding Panes plugin) Excalidraw вызывает проблемы совместимости с рабочими пространствами Obsidian.<br>" +
    "Обратите внимание, что функция 'Stack Tabs' теперь доступна в Obsidian, обеспечивая встроенную поддержку большинства функций  раздвижных областей окна (Sliding Panes plugin)",
  EXPORT_EXCALIDRAW_NAME: "Автоэкспорт Excalidraw",
  EXPORT_EXCALIDRAW_DESC: "Аналогично автоэкспорту SVG, но для *.Excalidraw",
  SYNC_EXCALIDRAW_NAME: "Синхронизация *.excalidraw с *.md-версией одного и того же чертежа",
  SYNC_EXCALIDRAW_DESC:
    "Если дата изменения файла *.excalidraw более поздняя, чем дата изменения файла *.md " +
    "то обновите чертеж в файле .md на основе файла .excalidraw",
  COMPATIBILITY_MODE_NAME: "Новые чертежи в виде устаревших файлов",
  COMPATIBILITY_MODE_DESC:
    "⚠️ Включайте эту функцию, только если вы знаете, что делаете. В 99,9% случаев включать эту функцию НЕ нужно. " +
    "При включении этой функции рисунки, которые вы создаете с помощью значка ленты, действий палитры команд, " +
    "и в файловом проводнике, будут все старые файлы *.excalidraw. Эта настройка также отключит напоминание" +
    "при открытии устаревшего файла для редактирования.",
  MATHJAX_NAME: "Хост библиотеки javascript MathJax (LaTeX)",
  MATHJAX_DESC: "Если вы используете уравнения LaTeX в Excalidraw, то плагину необходимо загрузить библиотеку javascript для этого. " + 
    "Некоторые пользователи не могут получить доступ к определенным хост-серверам. Если у вас возникли проблемы, попробуйте сменить хост здесь. "+
    "Возможно, вам придется перезапустить Obsidian после закрытия настроек, чтобы это изменение вступило в силу.",
  LATEX_DEFAULT_NAME: "Формула LaTeX по умолчанию для новых уравнений",
  LATEX_DEFAULT_DESC: "Оставьте пустым, если вам не нужна формула по умолчанию. Здесь можно добавить форматирование по умолчанию, например <code>\\color{white}</code>.",
  NONSTANDARD_HEAD: "Поддерживаемые функции, не с Excalidraw.com",
  NONSTANDARD_DESC: `Эти настройки в разделе "Поддерживаемые функции, не относящиеся к Excalidraw.com" предоставляют возможности настройки, выходящие за рамки стандартных функций Excalidraw.com. Эти функции недоступны на сайте excalidraw.com. При экспорте чертежа в Excalidraw.com эти функции будут выглядеть иначе.
    Вы можете настроить количество пользовательских ручек, отображаемых рядом с меню Obsidian на холсте, что позволит вам выбирать из множества вариантов. Кроме того, можно включить опцию локального шрифта, которая добавляет локальный шрифт в список шрифтов на панели свойств элементов для текстовых элементов. `,
  RENDER_TWEAK_HEAD: "Улучшения рендеринга",
  MAX_IMAGE_ZOOM_IN_NAME: "Максимальное разрешение увеличения изображения",
  MAX_IMAGE_ZOOM_IN_DESC: "В целях экономии памяти и из-за того, что Apple Safari (Obsidian на iOS) имеет некоторые жестко закодированные ограничения, Excalidraw.com ограничивает максимальное разрешение изображений и крупных объектов при увеличении. Вы можете обойти это ограничение с помощью мультипликатора. " +
    "Это означает, что вы умножаете предел, установленный по умолчанию в Excalidraw. Чем больше множитель, тем лучше будет разрешение увеличения изображения, и тем больше памяти оно будет потреблять. " +
    "Я рекомендую поиграть с несколькими значениями этой настройки. Вы знаете, что натолкнулись на стену, когда при увеличении масштаба PNG-изображения оно вдруг исчезает из поля зрения. Значение по умолчанию - 1. Настройка не влияет на iOS.",
  CUSTOM_PEN_HEAD: "Пользовательские Ручки",
  CUSTOM_PEN_NAME: "Количество пользовательских ручек",
  CUSTOM_PEN_DESC: "Вы увидите эти ручки рядом с меню Obsidian на холсте. Вы можете настроить ручки на холсте, долго нажимая на кнопку ручки.",
  EXPERIMENTAL_HEAD: "Разные возможности",
  EXPERIMENTAL_DESC: `Среди прочих возможностей Excalidraw - установка формул LaTeX по умолчанию для новых уравнений, включение Предложение полей (Suggester) для автозаполнения, отображение индикаторов типов файлов Excalidraw, включение иммерсивного встраивания изображений в режиме предварительного просмотра и эксперименты с оптическим распознаванием символов Taskbone для извлечения текста из изображений и чертежей. Пользователи также могут ввести API-ключ Taskbone для расширенного использования сервиса OCR.`,
  EA_HEAD: "Автоматизация Excalidraw",
  EA_DESC: 
    "Excalidraw Автоматизация - это скриптовый и автоматизированный API для Excalidraw. К сожалению, документация по API скудна. " +
    "Рекомендую прочитать <a href='https://github.com/zsviczian/obsidian-excalidraw-plugin/blob/master/docs/API/ExcalidrawAutomate.d.ts'>ExcalidrawAutomate.d.ts</a> файл, " +
    "посетить <a href='https://zsviczian.github.io/obsidian-excalidraw-plugin/'>ExcalidrawAutomate How-to</a> страницу - хотя информация " +
    "здесь давно не обновлялся, - и, наконец, включите расположенный ниже Предложитель полей. Предложитель полей покажет вам доступные " +
    "функции, их параметры и краткое описание по мере ввода. Предложитель полей - это самая актуальная документация по API.",
  FIELD_SUGGESTER_NAME: "Включить Предложение полей (Suggester)",
  FIELD_SUGGESTER_DESC:
    "Предложение полей (Suggester) позаимствован у плагинов Breadcrumbs и Templater. Предложение полей (Suggester) полей будет показывать " +
    "меню автозаполнения при вводе текста с описанием функций <code>excalidraw-</code> или <code>ea.</code> в качестве подсказок для отдельных элементов в списке.",
  STARTUP_SCRIPT_NAME: "Сценарий запуска",
  STARTUP_SCRIPT_DESC:
    "Если этот параметр установлен, excalidraw будет выполнять скрипт при запуске плагина. Это полезно, если вы хотите установить какой-либо из крючков Excalidraw Automate. " +
    "Скрипт запуска - это файл в формате markdown, который должен содержать код javascript, который вы хотите выполнять при запуске Excalidraw.",
  STARTUP_SCRIPT_BUTTON_CREATE: "Создание сценария запуска",
  STARTUP_SCRIPT_BUTTON_OPEN: "Открыть сценарий запуска",
  STARTUP_SCRIPT_EXISTS: "Файл сценария запуска уже существует",
  FILETYPE_NAME: "Тип отображения (✏️) для файлов excalidraw.md в Файловом Проводнике",
  FILETYPE_DESC: "Файлы Excalidraw получат индикатор с помощью эмодзи или текста, заданного в следующей настройке.",
  FILETAG_NAME: "Установка типа индикатора для файлов excalidraw.md",
  FILETAG_DESC: "Текст или эмодзи для отображения в качестве типа индикатора.",
  INSERT_EMOJI: "Вставьте эмодзи",
  LIVEPREVIEW_NAME: "Встраивание изображений в режиме предварительного просмотра в реальном времени",
  LIVEPREVIEW_DESC:
    "Включите этот параметр для поддержки стилей вставки изображений, таких как ![[drawing|width|style]], в режиме редактирования живого предварительного просмотра. " +
    "Настройка не повлияет на открытые в данный момент документы. Чтобы изменения вступили в силу, необходимо закрыть открытые документы и" +
    "открыть их снова.",
  FADE_OUT_EXCALIDRAW_MARKUP_NAME: "Затухание разметки Excalidraw",
  FADE_OUT_EXCALIDRAW_MARKUP_DESC: "В режиме просмотра Markdown раздел после комментария %% исчезает. " +
    "Текст остается на месте, но визуальный беспорядок уменьшается. Обратите внимание, вы можете поместить %% в строку прямо над #Элементы текста, " +
    "в этом случае вся разметка рисунка исчезнет, включая #Элементы текста. Побочным эффектом будет то, что вы не сможете блокировать текст ссылок в других примечаниях, то есть после секции комментариев %%. Это редко является проблемой. " +
    "Если вы захотите отредактировать сценарий разметки Excalidraw, просто переключитесь в режим просмотра разметки и временно удалите комментарий %%.",
  EXCALIDRAW_PROPERTIES_NAME: "Загрузка свойств Excalidraw в Obsidian Suggester",
  EXCALIDRAW_PROPERTIES_DESC: "Отключите этот параметр, чтобы при запуске плагина свойства документа Excalidraw загружались в предложение свойств Obsidian. "+
   "Включение этой функции упрощает использование свойств титульного листа Excalidraw, позволяя использовать множество мощных настроек. Если вы предпочитаете не загружать эти свойства автоматически, " +
   "Вы можете отключить эту функцию, но при этом вам придется вручную удалить все ненужные свойства из предложения. " +
   "Обратите внимание, что включение этой настройки требует перезапуска плагина, так как свойства загружаются при запуске.",  
  CUSTOM_FONT_HEAD: "Локальный шрифт",
  ENABLE_FOURTH_FONT_NAME: "Включите опцию локального шрифта",
  ENABLE_FOURTH_FONT_DESC:
    "Включение этой опции добавит локальный шрифт в список шрифтов на панели свойств для текстовых элементов. " +
    "Имейте в виду, что использование локального шрифта может нарушить независимость от платформы. " +
    "Файлы, использующие пользовательский шрифт, могут отображаться по-разному при открытии в другом хранилище или в более позднее время, в зависимости от настроек шрифта. " +
    "Кроме того, на сайте excalidraw.com или других версиях Excalidraw 4-й шрифт по умолчанию будет соответствовать системному шрифту.",
  FOURTH_FONT_NAME: "Локальный файл шрифта",
  FOURTH_FONT_DESC:
    "Выберите файл шрифта .otf, .ttf, .woff или .woff2 из своего хранилища, чтобы использовать его в качестве локального шрифта. " +
    "Если файл не выбран, Excalidraw по умолчанию использует шрифт Virgil. " +
    "Для оптимальной производительности рекомендуется использовать файл .woff2, так как Excalidraw закодирует только необходимые глифы при экспорте изображений в SVG. " +
    "Другие форматы шрифтов будут встраивать весь шрифт в экспортируемый файл, что может привести к значительному увеличению размера файла.",
  SCRIPT_SETTINGS_HEAD: "Настройки для установленных сценариев",
  SCRIPT_SETTINGS_DESC: "Некоторые сценарии Excalidraw Automate Scripts включают в себя настройки. Настройки упорядочены по сценариям. Настройки станут видны в этом списке только после того, как вы один раз выполните загруженный скрипт.",
  TASKBONE_HEAD: "Taskbone Оптический распознаватель символов",
  TASKBONE_DESC: "Это экспериментальная интеграция оптического распознавания символов в Excalidraw. Обратите внимание, что taskbone - это независимый внешний сервис, не предоставляемый ни Excalidraw, ни проектом плагинов Excalidraw-Obsidian. " +
    "Сервис OCR выхватывает разборчивый текст из произвольных линий и встроенных изображений на вашем холсте и помещает распознанный текст на передний план вашего рисунка, а также в буфер обмена. " +
    "Наличие текста во frontmatter позволит вам искать в Obsidian их текстовое содержание. " +
    "Обратите внимание, что процесс извлечения текста из изображения происходит не локально, а через онлайн API. Сервис taskbone хранит изображение на своих серверах только до тех пор, пока это необходимо для извлечения текста. Однако если вас это не устраивает, не используйте эту функцию.",
  TASKBONE_ENABLE_NAME: "Включить Taskbone",
  TASKBONE_ENABLE_DESC: "Включая эту услугу, вы соглашаетесь с <a href='https://www.taskbone.com/legal/terms/' target='_blank'>Условиями использования Taskbone </a> и " +
    "<a href='https://www.taskbone.com/legal/privacy/' target='_blank'>политикой конфиденциальности</a>.",
  TASKBONE_APIKEY_NAME: "Taskbone API Ключ",
  TASKBONE_APIKEY_DESC: "Taskbone предлагает бесплатную услугу с разумным количеством сканирований в месяц. Если вы хотите использовать эту функцию чаще, или вам необходимо повысить " + 
    "разработчика Taskbone (как вы можете себе представить, не существует такого понятия, как «бесплатно», предоставление этого потрясающего сервиса OCR стоит разработчику Taskbone определенных денег), вы можете " +
    "приобрести платный API-ключ на сайте <a href='https://www.taskbone.com/' target='_blank'>taskbone.com</a>. Если вы уже приобрели ключ, просто перезапишите этот автоматически сгенерированный бесплатный API-ключ своим платным ключом.",

  //HotkeyEditor
  HOTKEY_PRESS_COMBO_NANE: "Нажмите комбинацию горячих клавиш",
  HOTKEY_PRESS_COMBO_DESC: "Пожалуйста, нажмите нужную комбинацию клавиш",
  HOTKEY_BUTTON_ADD_OVERRIDE: "Добавить новое переопределение",
  HOTKEY_BUTTON_REMOVE: "Удалить",

  //openDrawings.ts
  SELECT_FILE: "Выберите файл и нажмите Enter.",
  SELECT_COMMAND: "Выберите команду и нажмите Enter.",
  SELECT_FILE_WITH_OPTION_TO_SCALE: `Выберите файл и нажмите ENTER, или ${labelSHIFT()}+${labelMETA()}+ENTER для вставки в масштабе 100%.`,
  NO_MATCH: "Ни один файл не соответствует вашему запросу.",
  NO_MATCHING_COMMAND: "Ни одна команда не соответствует вашему запросу.",
  SELECT_FILE_TO_LINK: "Выберите файл, для которого нужно вставить ссылку.",
  SELECT_COMMAND_PLACEHOLDER: "Выберите команду, для которой нужно вставить ссылку.",
  SELECT_DRAWING: "Выберите изображение или рисунок, который необходимо вставить.",
  TYPE_FILENAME: "Введите название чертежа для выбора.",
  SELECT_FILE_OR_TYPE_NEW: "Выберите существующий чертеж или введите имя нового чертежа, затем нажмите Enter.",
  SELECT_TO_EMBED: "Выберите чертеж для вставки в активный документ.",
  SELECT_MD: "Выберите документ в формате markdown для вставки.",
  SELECT_PDF: "Выберите документ PDF для вставки.",
  PDF_PAGES_HEADER: "Страницы для загрузки?",
  PDF_PAGES_DESC: "Формат: 1, 3-5, 7, 9-11",

  //SelectCard.ts
  TYPE_SECTION: "Введите название раздела для выбора.",
  SELECT_SECTION_OR_TYPE_NEW: "Выберите существующий раздел или введите название нового раздела, затем нажмите Enter.",
  INVALID_SECTION_NAME: "Недопустимое название раздела.",
  EMPTY_SECTION_MESSAGE: "Введите название раздела и нажмите Enter, чтобы создать новый раздел.",

  //EmbeddedFileLoader.ts
  INFINITE_LOOP_WARNING: "ПРЕДУПРЕЖДЕНИЕ EXCALIDRAW\nОшибка при загрузке встроенных изображений из-за бесконечного цикла в файле:\n",

  //Scripts.ts
  SCRIPT_EXECUTION_ERROR: "Ошибка выполнения сценария. Пожалуйста, найдите сообщение об ошибке в консоли разработчика.",

  //ExcalidrawData.ts
  LOAD_FROM_BACKUP: "Файл Excalidraw был поврежден. Загрузка из резервного файла.",

  //ObsidianMenu.tsx
  GOTO_FULLSCREEN: "Переход в полноэкранный режим",
  EXIT_FULLSCREEN: "Выход из полноэкранного режима",
  TOGGLE_FULLSCREEN: "Переключить полноэкранный режим",
  TOGGLE_DISABLEBINDING: "Переключить инвертирование поведения привязки по умолчанию",
  TOGGLE_FRAME_RENDERING: "Переключить рендеринг кадра",
  TOGGLE_FRAME_CLIPPING: "Переключить обрезку кадра",
  OPEN_LINK_CLICK: "Открыть ссылку",
  OPEN_LINK_PROPS: "Открыть ссылку на изображение или редактор формул LaTeX",

  //IFrameActionsMenu.tsx
  NARROW_TO_HEADING: "Узкий к заголовку...",
  NARROW_TO_BLOCK: "Сузить до блока...",
  SHOW_ENTIRE_FILE: "Показать весь файл",
  ZOOM_TO_FIT: "Увеличить до нужного размера",
  RELOAD: "Перезагрузить исходную ссылку",
  OPEN_IN_BROWSER: "Открыть текущую ссылку в браузере",
  PROPERTIES: "Свойства",
  COPYCODE: "Копировать источник в буфер обмена",

  //EmbeddableSettings.tsx
  ES_TITLE: "Настройки встраиваемых элементов",
  ES_RENAME: "Переименовать файл",
  ES_ZOOM: "Масштабирование встраиваемого контента",
  ES_YOUTUBE_START: "Время начала YouTube",
  ES_YOUTUBE_START_DESC: "ss, mm:ss, hh:mm:ss",
  ES_YOUTUBE_START_INVALID: "Время начала YouTube недействительно. Проверьте формат и повторите попытку.",
  ES_FILENAME_VISIBLE: "Видимое имя файла",
  ES_BACKGROUND_HEAD: "Цвет фона встроенной заметки",
  ES_BACKGROUND_MATCH_ELEMENT: "Соответствие фонового цвета элемента",
  ES_BACKGROUND_MATCH_CANVAS: "Соответствие цвета фона холста",
  ES_BACKGROUND_COLOR: "Цвет фона",
  ES_BORDER_HEAD: "Цвет границы встроенной заметки",
  ES_BORDER_COLOR: "Цвет границы",
  ES_BORDER_MATCH_ELEMENT: "Цвет границы элемента",
  ES_BACKGROUND_OPACITY: "Непрозрачность фона",
  ES_BORDER_OPACITY: "Непрозрачность границы",
  ES_EMBEDDABLE_SETTINGS: "Настройки встраиваемой разметки",
  ES_USE_OBSIDIAN_DEFAULTS: "Использовать настройки Obsidian по умолчанию",
  ES_ZOOM_100_RELATIVE_DESC: "Кнопка настроит масштаб элемента так, чтобы он отображал содержимое на 100% относительно текущего уровня масштабирования холста",
  ES_ZOOM_100: "Относительный 100%",

  //Prompts.ts
  PROMPT_FILE_DOES_NOT_EXIST: "Файл не существует. Вы хотите его создать?",
  PROMPT_ERROR_NO_FILENAME: "Ошибка: Имя нового файла не может быть пустым",
  PROMPT_ERROR_DRAWING_CLOSED: "Неизвестная ошибка. Похоже, что ваш чертеж был закрыт или файл чертежа отсутствует",
  PROMPT_TITLE_NEW_FILE: "Новый файл",
  PROMPT_TITLE_CONFIRMATION: "Подтверждение",
  PROMPT_BUTTON_CREATE_EXCALIDRAW: "Создать EX",
  PROMPT_BUTTON_CREATE_EXCALIDRAW_ARIA: "Создать чертеж Excalidraw и открыть его в новой вкладке",
  PROMPT_BUTTON_CREATE_MARKDOWN: "Создать MD",
  PROMPT_BUTTON_CREATE_MARKDOWN_ARIA: "Создать документ в формате markdown и открыть его в новой вкладке",
  PROMPT_BUTTON_EMBED_MARKDOWN: "Встроить MD",
  PROMPT_BUTTON_EMBED_MARKDOWN_ARIA: "Замена выбранного элемента встроенным документом с разметкой",
  PROMPT_BUTTON_NEVERMIND: "Неважно",
  PROMPT_BUTTON_OK: "OK",
  PROMPT_BUTTON_CANCEL: "Отменить",
  PROMPT_BUTTON_INSERT_LINE: "Вставить новую строку",
  PROMPT_BUTTON_INSERT_SPACE: "Вставить пробел",
  PROMPT_BUTTON_INSERT_LINK: "Вставить ссылку на файл в формате markdown",
  PROMPT_BUTTON_UPPERCASE: "Прописные буквы",
  PROMPT_SELECT_TEMPLATE: "Выберите шаблон",

  //ModifierKeySettings
  WEB_BROWSER_DRAG_ACTION: "Действие перетаскивания веб-браузера",
  LOCAL_FILE_DRAG_ACTION: "Действие перетаскивания локального файла ОС",
  INTERNAL_DRAG_ACTION: "Внутреннее действие перетаскивания в Obsidian",
  PANE_TARGET: "Поведение при нажатии на ссылку",
  DEFAULT_ACTION_DESC: "Если ни одна из комбинаций не применяется, для этой группы будет действовать действие по умолчанию: ",

  //FrameSettings.ts
  FRAME_SETTINGS_TITLE: "Настройки кадров",
  FRAME_SETTINGS_ENABLE: "Включить кадры",
  FRAME_SETTIGNS_NAME: "Отображение имени кадра",
  FRAME_SETTINGS_OUTLINE: "Отображение контура кадра",
  FRAME_SETTINGS_CLIP: "Включить обрезку кадра",

  //InsertPDFModal.ts
  IPM_PAGES_TO_IMPORT_NAME: "Страницы для импорта",
  IPM_SELECT_PAGES_TO_IMPORT: "Пожалуйста, выберите страницы для импорта",
  IPM_ADD_BORDER_BOX_NAME: "Добавить рамку",
  IPM_ADD_FRAME_NAME: "Добавить страницу в кадр",
  IPM_ADD_FRAME_DESC: "Для удобства работы я рекомендую зафиксировать страницу внутри кадра. " +
    "Однако если вы заблокировали страницу внутри кадра, то единственный способ разблокировать ее - щелкнуть правой кнопкой мыши кадр, выбрать пункт «Удалить элементы из кадра», а затем разблокировать страницу.",
  IPM_GROUP_PAGES_NAME: "Страницы группы",
  IPM_GROUP_PAGES_DESC: "Это позволит объединить все страницы в одну группу. Это рекомендуется делать, если вы блокируете страницы после импорта, потому что группу будет легче разблокировать позже, чем разблокировать каждую по отдельности.",
  IPM_SELECT_PDF: "Пожалуйста, выберите файл PDF",

};
