import { Bookmark, Camera, Copy, Crop, Globe, RotateCcw, Scan, Settings, TextSelect } from "lucide-react";
import * as React from "react";
import { PenStyle } from "src/types/penTypes";

export const ICONS = {
  ExportImage: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      stroke="var(--icon-fill-color)"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    >
      <g strokeWidth="1.25">
        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
        <path d="M15 8h.01"></path>
        <path d="M12 20h-5a3 3 0 0 1 -3 -3v-10a3 3 0 0 1 3 -3h10a3 3 0 0 1 3 3v5"></path>
        <path d="M4 15l4 -4c.928 -.893 2.072 -.893 3 0l4 4"></path>
        <path d="M14 14l1 -1c.617 -.593 1.328 -.793 2.009 -.598"></path>
        <path d="M19 16v6"></path>
        <path d="M22 19l-3 3l-3 -3"></path>
      </g>
    </svg>
  ),
  BackOfNote: (<TextSelect />),
  Reload: (<RotateCcw />),
  Copy: (<Copy /> ),
  Globe: (<Globe />),
  Crop: (<Crop />),
  Bookmark: (<Bookmark />),
  Camera: (<Camera />),
  ZoomToSelectedElement: (<Scan />),
  Properties: (<Settings />),
  ZoomToSection: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 24 24"
      fill="none"
      stroke="var(--icon-fill-color)"
      strokeWidth="1"
      strokeLinecap="round"
      strokeLinejoin="round"
    >
      <text x="6" y="18" fontSize="22px">#</text>
    </svg>
  ),
  ZoomToBlock: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 24 24"
      fill="none"
      stroke="var(--icon-fill-color)"
      strokeWidth="1"
      strokeLinecap="round"
      strokeLinejoin="round"
    >
      <text x="1" y="18" fontSize="22px">#^</text>
    </svg>
  ),
  Learn: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 24 24"
      fill="none"
      stroke="var(--icon-fill-color)"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    >
      <path d="M21.42 10.922a1 1 0 0 0-.019-1.838L12.83 5.18a2 2 0 0 0-1.66 0L2.6 9.08a1 1 0 0 0 0 1.832l8.57 3.908a2 2 0 0 0 1.66 0z"/>
      <path d="M22 10v6"/>
      <path d="M6 12.5V16a6 3 0 0 0 12 0v-3.5"/>
    </svg>
  ),
  Discord: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      fill="var(--icon-fill-color)"
      stroke="none"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
      viewBox="0 0 640 512"
    >
      <path
        d="M524.531,69.836a1.5,1.5,0,0,0-.764-.7A485.065,485.065,0,0,0,404.081,32.03a1.816,1.816,0,0,0-1.923.91,337.461,337.461,0,0,0-14.9,30.6,447.848,447.848,0,0,0-134.426,0,309.541,309.541,0,0,0-15.135-30.6,1.89,1.89,0,0,0-1.924-.91A483.689,483.689,0,0,0,116.085,69.137a1.712,1.712,0,0,0-.788.676C39.068,183.651,18.186,294.69,28.43,404.354a2.016,2.016,0,0,0,.765,1.375A487.666,487.666,0,0,0,176.02,479.918a1.9,1.9,0,0,0,2.063-.676A348.2,348.2,0,0,0,208.12,430.4a1.86,1.86,0,0,0-1.019-2.588,321.173,321.173,0,0,1-45.868-21.853,1.885,1.885,0,0,1-.185-3.126c3.082-2.309,6.166-4.711,9.109-7.137a1.819,1.819,0,0,1,1.9-.256c96.229,43.917,200.41,43.917,295.5,0a1.812,1.812,0,0,1,1.924.233c2.944,2.426,6.027,4.851,9.132,7.16a1.884,1.884,0,0,1-.162,3.126,301.407,301.407,0,0,1-45.89,21.83,1.875,1.875,0,0,0-1,2.611,391.055,391.055,0,0,0,30.014,48.815,1.864,1.864,0,0,0,2.063.7A486.048,486.048,0,0,0,610.7,405.729a1.882,1.882,0,0,0,.765-1.352C623.729,277.594,590.933,167.465,524.531,69.836ZM222.491,337.58c-28.972,0-52.844-26.587-52.844-59.239S193.056,219.1,222.491,219.1c29.665,0,53.306,26.82,52.843,59.239C275.334,310.993,251.924,337.58,222.491,337.58Zm195.38,0c-28.971,0-52.843-26.587-52.843-59.239S388.437,219.1,417.871,219.1c29.667,0,53.307,26.82,52.844,59.239C470.715,310.993,447.538,337.58,417.871,337.58Z"
      />
    </svg>
  ),
  Github: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 24 24"
      fill="none"
      stroke="var(--icon-fill-color)"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    >
      <path
        d="M15 22v-4a4.8 4.8 0 0 0-1-3.5c3 0 6-2 6-5.5.08-1.25-.27-2.48-1-3.5.28-1.15.28-2.35 0-3.5 0 0-1 0-3 1.5-2.64-.5-5.36-.5-8 0C6 2 5 2 5 2c-.3 1.15-.3 2.35 0 3.5A5.403 5.403 0 0 0 4 9c0 3.5 3 5.5 6 5.5-.39.49-.68 1.05-.85 1.65-.17.6-.22 1.23-.15 1.85v4">
      </path>
      <path
        d="M9 18c-4.51 2-5-2-7-2">
      </path>
    </svg>
  ),
  YouTube: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 24 24"
      fill="none"
      stroke="var(--icon-fill-color)"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    >
      <path
        d="M12 19c-2.3 0-6.4-.2-8.1-.6-.7-.2-1.2-.7-1.4-1.4-.3-1.1-.5-3.4-.5-5s.2-3.9.5-5c.2-.7.7-1.2 1.4-1.4C5.6 5.2 9.7 5 12 5s6.4.2 8.1.6c.7.2 1.2.7 1.4 1.4.3 1.1.5 3.4.5 5s-.2 3.9-.5 5c-.2.7-.7 1.2-1.4 1.4-1.7.4-5.8.6-8.1.6 0 0 0 0 0 0z">
      </path>
      <polygon points="10 15 15 12 10 9"></polygon>
    </svg>
    )  
  ,
  heart: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 24 24"
      fill="none"
      stroke="var(--icon-fill-color)"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    >
      <path
        d="M20.42 4.58a5.4 5.4 0 0 0-7.65 0l-.77.78-.77-.78a5.4 5.4 0 0 0-7.65 0C1.46 6.7 1.33 10.28 4 13l8 8 8-8c2.67-2.72 2.54-6.3.42-8.42z">
      </path>
    </svg>
  ),
  twitter: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 24 24"
      fill="none"
      stroke="var(--icon-fill-color)"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    >
      <path
        d="M22 4s-.7 2.1-2 3.4c1.6 10-9.4 17.3-18 11.6 2.2.1 4.4-.6 6-2C3 15.5.5 9.6 3 5c2.2 2.6 5.6 4.1 9 4-.9-4.2 4-6.6 7-3.8 1.1 0 3-1.2 3-1.2z">
      </path>
    </svg>
  ),
  exportLibrary: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 200 190"
      fill="var(--icon-fill-color)"
    >
      <g fillRule="evenodd">
        <path strokeWidth="0" d="M50 10h20v20H50" />
        <path
          fill="none"
          stroke="var(--icon-fill-color)"
          strokeWidth="2"
          d="M50 10h20m-20 0h20m0 0v20m0-20v20m0 0H50m20 0H50m0 0V10m0 20V10"
        />
      </g>
      <g fillRule="evenodd">
        <path strokeWidth="0" d="M90 10h20v20H90" />
        <path
          fill="none"
          stroke="var(--icon-fill-color)"
          strokeWidth="2"
          d="M90 10h20m-20 0h20m0 0v20m0-20v20m0 0H90m20 0H90m0 0V10m0 20V10"
        />
      </g>
      <g fillRule="evenodd">
        <path strokeWidth="0" d="M130 10h20v20h-20" />
        <path
          fill="none"
          stroke="var(--icon-fill-color)"
          strokeWidth="2"
          d="M130 10h20m-20 0h20m0 0v20m0-20v20m0 0h-20m20 0h-20m0 0V10m0 20V10"
        />
      </g>
      <g fillRule="evenodd">
        <path strokeWidth="0" d="M170 10h20v20h-20" />
        <path
          fill="none"
          stroke="var(--icon-fill-color)"
          strokeWidth="2"
          d="M170 10h20m-20 0h20m0 0v20m0-20v20m0 0h-20m20 0h-20m0 0V10m0 20V10"
        />
      </g>
      <g fillRule="evenodd">
        <path strokeWidth="0" d="M70 50h60v80h20l-50 50-50-50h20V50" />
        <path
          fill="none"
          stroke="var(--icon-fill-color)"
          strokeWidth="2"
          d="M70 50h60m-60 0h60m0 0v80m0-80v80m0 0h20m-20 0h20m0 0-50 50m50-50-50 50m0 0-50-50m50 50-50-50m0 0h20m-20 0h20m0 0V50m0 80V50m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0"
        />
      </g>
      <g fillRule="evenodd">
        <path strokeWidth="0" d="M10 10h20v20H10" />
        <path
          fill="none"
          stroke="var(--icon-fill-color)"
          strokeWidth="2"
          d="M10 10h20m-20 0h20m0 0v20m0-20v20m0 0H10m20 0H10m0 0V10m0 20V10"
        />
      </g>
    </svg>
  ),
  //fa-file-pdf
  insertPDF: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 512 512"
      fill="var(--icon-fill-color)"
      stroke="none"
    >
      <path
        d="M64 464H96v48H64c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0H229.5c17 0 33.3 6.7 45.3 18.7l90.5 90.5c12 12 18.7 28.3 18.7 45.3V288H336V160H256c-17.7 0-32-14.3-32-32V48H64c-8.8 0-16 7.2-16 16V448c0 8.8 7.2 16 16 16zM176 352h32c30.9 0 56 25.1 56 56s-25.1 56-56 56H192v32c0 8.8-7.2 16-16 16s-16-7.2-16-16V448 368c0-8.8 7.2-16 16-16zm32 80c13.3 0 24-10.7 24-24s-10.7-24-24-24H192v48h16zm96-80h32c26.5 0 48 21.5 48 48v64c0 26.5-21.5 48-48 48H304c-8.8 0-16-7.2-16-16V368c0-8.8 7.2-16 16-16zm32 128c8.8 0 16-7.2 16-16V400c0-8.8-7.2-16-16-16H320v96h16zm80-112c0-8.8 7.2-16 16-16h48c8.8 0 16 7.2 16 16s-7.2 16-16 16H448v32h32c8.8 0 16 7.2 16 16s-7.2 16-16 16H448v48c0 8.8-7.2 16-16 16s-16-7.2-16-16V432 368z"
      />
    </svg>
  ),
  //far fa-image
  insertImage: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 512 512"
      fill="var(--icon-fill-color)"
      stroke="none"
    >
      <path 
        d="M464 64H48C21.49 64 0 85.49 0 112v288c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V112c0-26.51-21.49-48-48-48zm-6 336H54a6 6 0 0 1-6-6V118a6 6 0 0 1 6-6h404a6 6 0 0 1 6 6v276a6 6 0 0 1-6 6zM128 152c-22.091 0-40 17.909-40 40s17.909 40 40 40 40-17.909 40-40-17.909-40-40-40zM96 352h320v-80l-87.515-87.515c-4.686-4.686-12.284-4.686-16.971 0L192 304l-39.515-39.515c-4.686-4.686-12.284-4.686-16.971 0L96 304v48z" 
      />
    </svg>
  ),
  //far fa-file-alt
  insertMD: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 384 512"
      fill="var(--icon-fill-color)"
      stroke="none"
    >
      <path d="M288 248v28c0 6.6-5.4 12-12 12H108c-6.6 0-12-5.4-12-12v-28c0-6.6 5.4-12 12-12h168c6.6 0 12 5.4 12 12zm-12 72H108c-6.6 0-12 5.4-12 12v28c0 6.6 5.4 12 12 12h168c6.6 0 12-5.4 12-12v-28c0-6.6-5.4-12-12-12zm108-188.1V464c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V48C0 21.5 21.5 0 48 0h204.1C264.8 0 277 5.1 286 14.1L369.9 98c9 8.9 14.1 21.2 14.1 33.9zm-128-80V128h76.1L256 51.9zM336 464V176H232c-13.3 0-24-10.7-24-24V48H48v416h288z" />
    </svg>
  ),
  //far fa-square-root-alt
  insertLaTeX: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 576 512"
      stroke="none"
      fill="var(--icon-fill-color)"
      strokeWidth="20"
    >
      <path d="M571.31 251.31l-22.62-22.62c-6.25-6.25-16.38-6.25-22.63 0L480 274.75l-46.06-46.06c-6.25-6.25-16.38-6.25-22.63 0l-22.62 22.62c-6.25 6.25-6.25 16.38 0 22.63L434.75 320l-46.06 46.06c-6.25 6.25-6.25 16.38 0 22.63l22.62 22.62c6.25 6.25 16.38 6.25 22.63 0L480 365.25l46.06 46.06c6.25 6.25 16.38 6.25 22.63 0l22.62-22.62c6.25-6.25 6.25-16.38 0-22.63L525.25 320l46.06-46.06c6.25-6.25 6.25-16.38 0-22.63zM552 0H307.65c-14.54 0-27.26 9.8-30.95 23.87l-84.79 322.8-58.41-106.1A32.008 32.008 0 0 0 105.47 224H24c-13.25 0-24 10.74-24 24v48c0 13.25 10.75 24 24 24h43.62l88.88 163.73C168.99 503.5 186.3 512 204.94 512c17.27 0 44.44-9 54.28-41.48L357.03 96H552c13.25 0 24-10.75 24-24V24c0-13.26-10.75-24-24-24z" />
    </svg>
  ),
  //fas fa-link
  insertLink: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 512 512"
      stroke="none"
      fill="var(--icon-fill-color)"
      strokeWidth="20"
    >
      <path d="M326.612 185.391c59.747 59.809 58.927 155.698.36 214.59-.11.12-.24.25-.36.37l-67.2 67.2c-59.27 59.27-155.699 59.262-214.96 0-59.27-59.26-59.27-155.7 0-214.96l37.106-37.106c9.84-9.84 26.786-3.3 27.294 10.606.648 17.722 3.826 35.527 9.69 52.721 1.986 5.822.567 12.262-3.783 16.612l-13.087 13.087c-28.026 28.026-28.905 73.66-1.155 101.96 28.024 28.579 74.086 28.749 102.325.51l67.2-67.19c28.191-28.191 28.073-73.757 0-101.83-3.701-3.694-7.429-6.564-10.341-8.569a16.037 16.037 0 0 1-6.947-12.606c-.396-10.567 3.348-21.456 11.698-29.806l21.054-21.055c5.521-5.521 14.182-6.199 20.584-1.731a152.482 152.482 0 0 1 20.522 17.197zM467.547 44.449c-59.261-59.262-155.69-59.27-214.96 0l-67.2 67.2c-.12.12-.25.25-.36.37-58.566 58.892-59.387 154.781.36 214.59a152.454 152.454 0 0 0 20.521 17.196c6.402 4.468 15.064 3.789 20.584-1.731l21.054-21.055c8.35-8.35 12.094-19.239 11.698-29.806a16.037 16.037 0 0 0-6.947-12.606c-2.912-2.005-6.64-4.875-10.341-8.569-28.073-28.073-28.191-73.639 0-101.83l67.2-67.19c28.239-28.239 74.3-28.069 102.325.51 27.75 28.3 26.872 73.934-1.155 101.96l-13.087 13.087c-4.35 4.35-5.769 10.79-3.783 16.612 5.864 17.194 9.042 34.999 9.69 52.721.509 13.906 17.454 20.446 27.294 10.606l37.106-37.106c59.271-59.259 59.271-155.699.001-214.959z" />
    </svg>
  ),
  //fa-solid fa-magnifying-glass
  search: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 512 512"
      stroke="var(--icon-fill-color)"
      fill="var(--icon-fill-color)"
      strokeWidth="20"
    >
      <path d="M500.3 443.7l-119.7-119.7c27.22-40.41 40.65-90.9 33.46-144.7C401.8 87.79 326.8 13.32 235.2 1.723C99.01-15.51-15.51 99.01 1.724 235.2c11.6 91.64 86.08 166.7 177.6 178.9c53.8 7.189 104.3-6.236 144.7-33.46l119.7 119.7c15.62 15.62 40.95 15.62 56.57 0C515.9 484.7 515.9 459.3 500.3 443.7zM79.1 208c0-70.58 57.42-128 128-128s128 57.42 128 128c0 70.58-57.42 128-128 128S79.1 278.6 79.1 208z" />
    </svg>
  ),
  ocr: (
    <svg
      xmlns="http://www.w3.org/2000/svg" 
      viewBox="0 0 24 24"
      fill="none"
      stroke="var(--icon-fill-color)"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    >
      <path d="m6 18 6-12 6 12"></path><path d="M8 14h8"></path><path d="M3 7V5a2 2 0 0 1 2-2h2"></path><path d="M17 3h2a2 2 0 0 1 2 2v2"></path><path d="M21 17v2a2 2 0 0 1-2 2h-2"></path><path d="M7 21H5a2 2 0 0 1-2-2v-2"></path>
    </svg>
  ),
  scriptEngine: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 100 100"
      stroke="var(--icon-fill-color)"
      fill="var(--icon-fill-color)"
      strokeLinecap="round"
      strokeWidth="4"
    >
      <g transform="translate(-8,-8)">
        <path d="M24.318 37.983c-1.234-1.232-8.433-3.903-7.401-7.387 1.057-3.484 9.893-12.443 13.669-13.517 3.776-1.074 6.142 6.523 9.012 7.073 2.87.55 6.797-1.572 8.207-3.694 1.384-2.148-3.147-7.413.15-9.168 3.298-1.755 16.389-2.646 19.611-1.284 3.247 1.363-1.611 7.335-.151 9.483 1.46 2.148 6.067 3.746 8.836 3.38 2.769-.368 4.154-6.733 7.728-5.633 3.575 1.1 12.36 8.828 13.67 12.233 1.308 3.406-5.186 5.423-5.79 8.2-.58 2.75-.026 6.705 2.265 8.355 2.266 1.65 9.642-1.78 11.404 1.598 1.762 3.38 1.007 15.35-.806 18.651-1.787 3.353-7.753-.367-9.969 1.31-2.215 1.65-3.901 5.92-3.373 8.67.504 2.777 7.754 4.48 6.445 7.885C96.49 87.543 87.15 95.454 83.5 96.685c-3.65 1.231-4.96-4.741-7.577-5.16-2.593-.393-6.57.707-8.03 2.75-1.436 2.017 2.668 7.806-.63 9.483-3.323 1.676-15.759 2.226-19.157.655-3.373-1.598.554-7.964-1.108-10.138-1.687-2.174-6.394-3.431-9.012-2.907-2.643.55-3.273 7.282-6.747 6.103-3.499-1.126-12.788-9.535-14.172-13.019-1.36-3.484 5.437-5.108 5.966-7.858.529-2.777-.68-7.073-2.744-8.697-2.064-1.624-7.93 2.41-9.642-1.126-1.737-3.537-2.441-16.765-.654-20.118 1.787-3.3 9.062 1.598 11.429.183 2.366-1.44 2.316-7.282 2.769-8.749m.126-.104c-1.234-1.232-8.433-3.903-7.401-7.387 1.057-3.484 9.893-12.443 13.669-13.517 3.776-1.074 6.142 6.523 9.012 7.073 2.87.55 6.797-1.572 8.207-3.694 1.384-2.148-3.147-7.413.15-9.168 3.298-1.755 16.389-2.646 19.611-1.284 3.247 1.363-1.611 7.335-.151 9.483 1.46 2.148 6.067 3.746 8.836 3.38 2.769-.368 4.154-6.733 7.728-5.633 3.575 1.1 12.36 8.828 13.67 12.233 1.308 3.406-5.186 5.423-5.79 8.2-.58 2.75-.026 6.705 2.265 8.355 2.266 1.65 9.642-1.78 11.404 1.598 1.762 3.38 1.007 15.35-.806 18.651-1.787 3.353-7.753-.367-9.969 1.31-2.215 1.65-3.901 5.92-3.373 8.67.504 2.777 7.754 4.48 6.445 7.885C96.49 87.543 87.15 95.454 83.5 96.685c-3.65 1.231-4.96-4.741-7.577-5.16-2.593-.393-6.57.707-8.03 2.75-1.436 2.017 2.668 7.806-.63 9.483-3.323 1.676-15.759 2.226-19.157.655-3.373-1.598.554-7.964-1.108-10.138-1.687-2.174-6.394-3.431-9.012-2.907-2.643.55-3.273 7.282-6.747 6.103-3.499-1.126-12.788-9.535-14.172-13.019-1.36-3.484 5.437-5.108 5.966-7.858.529-2.777-.68-7.073-2.744-8.697-2.064-1.624-7.93 2.41-9.642-1.126-1.737-3.537-2.441-16.765-.654-20.118 1.787-3.3 9.062 1.598 11.429.183 2.366-1.44 2.316-7.282 2.769-8.749" fill="none" strokeWidth="2"/>
        <path d="M81.235 56.502a23.3 23.3 0 0 1-1.46 8.068 20.785 20.785 0 0 1-1.762 3.72 24.068 24.068 0 0 1-5.337 6.26 22.575 22.575 0 0 1-3.449 2.358 23.726 23.726 0 0 1-7.803 2.803 24.719 24.719 0 0 1-8.333 0 24.102 24.102 0 0 1-4.028-1.074 23.71 23.71 0 0 1-3.776-1.729 23.259 23.259 0 0 1-6.369-5.265 23.775 23.775 0 0 1-2.416-3.353 24.935 24.935 0 0 1-1.762-3.72 23.765 23.765 0 0 1-1.083-3.981 23.454 23.454 0 0 1 0-8.173c.252-1.336.604-2.698 1.083-3.956a24.935 24.935 0 0 1 1.762-3.72 22.587 22.587 0 0 1 2.416-3.378c.881-1.048 1.888-2.017 2.946-2.908a24.38 24.38 0 0 1 3.423-2.357 23.71 23.71 0 0 1 3.776-1.73 21.74 21.74 0 0 1 4.028-1.047 23.437 23.437 0 0 1 8.333 0 24.282 24.282 0 0 1 7.803 2.777 26.198 26.198 0 0 1 3.45 2.357 24.62 24.62 0 0 1 5.336 6.287 20.785 20.785 0 0 1 1.762 3.72 21.32 21.32 0 0 1 1.083 3.955c.251 1.336.302 3.405.377 4.086.05.681.05-.68 0 0" fill="none"/>
        <path d="M69.404 56.633c-6.596-3.3-13.216-6.6-19.51-9.744m19.51 9.744c-6.747-3.379-13.493-6.758-19.51-9.744m0 0v19.489m0-19.49v19.49m0 0c4.355-2.148 8.71-4.322 19.51-9.745m-19.51 9.745c3.978-1.965 7.93-3.956 19.51-9.745m0 0h0m0 0h0"/>
      </g>
    </svg>
  ),
  openLink: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 24 24"
      fill="none"
      stroke="var(--icon-fill-color)"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    >
      <path d="M4 22h14a2 2 0 0 0 2-2V7.5L14.5 2H6a2 2 0 0 0-2 2v7"/>
      <polyline points="14 2 14 8 20 8"/>
      <path d="m10 18 3-3-3-3"/>
      <path d="M4 18v-1a2 2 0 0 1 2-2h6"/>
    </svg>
  ),
  openLinkProperties: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 24 24"
      fill="none"
      stroke="var(--icon-fill-color)"
      strokeWidth="3"
      strokeLinecap="round"
      strokeLinejoin="round"
    >
      <path d="M10 12.5 8 15l2 2.5"/>
      <path d="m14 12.5 2 2.5-2 2.5"/>
      <path d="M14 2v4a2 2 0 0 0 2 2h4"/>
      <path d="M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7z"/>
    </svg>
  ),
  //fa-brands fa-markdown
  switchToMarkdown: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 640 512"
      stroke="var(--icon-fill-color)"
      strokeWidth="10"      
      fill="var(--icon-fill-color)"
    >
      <path d="M593.8 59.1H46.2C20.7 59.1 0 79.8 0 105.2v301.5c0 25.5 20.7 46.2 46.2 46.2h547.7c25.5 0 46.2-20.7 46.1-46.1V105.2c0-25.4-20.7-46.1-46.2-46.1zM338.5 360.6H277v-120l-61.5 76.9-61.5-76.9v120H92.3V151.4h61.5l61.5 76.9 61.5-76.9h61.5v209.2zm135.3 3.1L381.5 256H443V151.4h61.5V256H566z" />
    </svg>
  ),
  //fa-solid fa-expand
  gotoFullScreen: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 448 512"
      stroke="var(--icon-fill-color)"
      fill="var(--icon-fill-color)"
      strokeWidth="20"
    >
      <path d="M128 32H32C14.31 32 0 46.31 0 64v96c0 17.69 14.31 32 32 32s32-14.31 32-32V96h64c17.69 0 32-14.31 32-32S145.7 32 128 32zM416 32h-96c-17.69 0-32 14.31-32 32s14.31 32 32 32h64v64c0 17.69 14.31 32 32 32s32-14.31 32-32V64C448 46.31 433.7 32 416 32zM128 416H64v-64c0-17.69-14.31-32-32-32s-32 14.31-32 32v96c0 17.69 14.31 32 32 32h96c17.69 0 32-14.31 32-32S145.7 416 128 416zM416 320c-17.69 0-32 14.31-32 32v64h-64c-17.69 0-32 14.31-32 32s14.31 32 32 32h96c17.69 0 32-14.31 32-32v-96C448 334.3 433.7 320 416 320z" />
    </svg>
  ),
  //fa-solid fa-compress
  exitFullScreen: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 448 512"
      stroke="var(--icon-fill-color)"
      fill="var(--icon-fill-color)"
      strokeWidth="20"
    >
      <path d="M128 320H32c-17.69 0-32 14.31-32 32s14.31 32 32 32h64v64c0 17.69 14.31 32 32 32s32-14.31 32-32v-96C160 334.3 145.7 320 128 320zM416 320h-96c-17.69 0-32 14.31-32 32v96c0 17.69 14.31 32 32 32s32-14.31 32-32v-64h64c17.69 0 32-14.31 32-32S433.7 320 416 320zM320 192h96c17.69 0 32-14.31 32-32s-14.31-32-32-32h-64V64c0-17.69-14.31-32-32-32s-32 14.31-32 32v96C288 177.7 302.3 192 320 192zM128 32C110.3 32 96 46.31 96 64v64H32C14.31 128 0 142.3 0 160s14.31 32 32 32h96c17.69 0 32-14.31 32-32V64C160 46.31 145.7 32 128 32z" />
    </svg>
  ),
  //fa-solid fa-book-open-reader
  releaseNotes: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 512 512"
      stroke="var(--icon-fill-color)"
      fill="var(--icon-fill-color)"
      strokeWidth="20"
    >
      <path d="M0 219.2v212.5c0 14.25 11.62 26.25 26.5 27C75.32 461.2 180.2 471.3 240 511.9V245.2C181.4 205.5 79.99 194.8 29.84 192C13.59 191.1 0 203.6 0 219.2zM482.2 192c-50.09 2.848-151.3 13.47-209.1 53.09C272.1 245.2 272 245.3 272 245.5v266.5c60.04-40.39 164.7-50.76 213.5-53.28C500.4 457.9 512 445.9 512 431.7V219.2C512 203.6 498.4 191.1 482.2 192zM352 96c0-53-43-96-96-96S160 43 160 96s43 96 96 96S352 149 352 96z" />
    </svg>
  ),
  rawMode: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 100 60"
    >
      <path
        stroke="var(--icon-fill-color)"
        strokeWidth="4"
        d="M20 10H10m10 0H10m0 0v40m0-40v40m0 0h10m-10 0h10M40 10H30m10 0H30m0 0v40m0-40v40m0 0h10m-10 0h10M60 10h10m-10 0h10m0 0v40m0-40v40m0 0H60m10 0H60M80 10h10m-10 0h10m0 0v40m0-40v40m0 0H80m10 0H80"
      />
    </svg>
  ),
  //fa-solid fa-glasses
  parsedMode: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 576 512"
      stroke="var(--icon-fill-color)"
      strokeWidth="20"
    >
      <path d="M574.1 280.4l-45.38-181.8c-5.875-23.63-21.62-44-43-55.75c-21.5-11.75-46.1-14.13-70.25-6.375l-15.25 5.125c-8.375 2.75-12.87 11.88-10 20.25l5 15.13c2.75 8.375 11.88 12.88 20.25 10.13l13.12-4.375c10.88-3.625 23-3.625 33.25 1.75c10.25 5.375 17.5 14.5 20.38 25.75l38.38 153.9c-22.12-6.875-49.75-12.5-81.13-12.5c-34.88 0-73.1 7-114.9 26.75H251.4C210.5 258.6 171.4 251.6 136.5 251.6c-31.38 0-59 5.625-81.12 12.5l38.38-153.9c2.875-11.25 10.12-20.38 20.5-25.75C124.4 79.12 136.5 79.12 147.4 82.74l13.12 4.375c8.375 2.75 17.5-1.75 20.25-10.13l5-15.13C188.6 53.49 184.1 44.37 175.6 41.62l-15.25-5.125c-23.13-7.75-48.75-5.375-70.13 6.375c-21.37 11.75-37.12 32.13-43 55.75L1.875 280.4C.6251 285.4 .0001 290.6 .0001 295.9v70.25C.0001 428.1 51.63 480 115.3 480h37.13c60.25 0 110.4-46 114.9-105.4l2.875-38.63h35.75l2.875 38.63C313.3 433.1 363.4 480 423.6 480h37.13c63.62 0 115.2-51 115.2-113.9V295.9C576 290.6 575.4 285.5 574.1 280.4zM203.4 369.7c-2 26-24.38 46.25-51 46.25H115.2C87 415.1 64 393.6 64 366.1v-37.5c18.12-6.5 43.38-13 72.62-13c23.88 0 47.25 4.375 69.88 13L203.4 369.7zM512 366.1c0 27.5-23 49.88-51.25 49.88h-37.13c-26.62 0-49-20.25-51-46.25l-3.125-41.13c22.62-8.625 46.13-13 70-13c29 0 54.38 6.5 72.5 13V366.1z" />
    </svg>
  ),
  convertFile: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      viewBox="0 110 700 340"
      xmlns="http://www.w3.org/2000/svg"
      stroke="var(--icon-fill-color)"
      strokeWidth="20"
    >
      <path d="m593.95 239.4v-1.5742c-0.85547-1.8828-2.043-3.6016-3.5-5.0742l-52.5-52.5c-1.4688-1.457-3.1875-2.6445-5.0742-3.5h-1.5742c-1.4727-0.49219-3.0039-0.78516-4.5508-0.875h-124.25c-4.6406 0-9.0938 1.8438-12.375 5.125s-5.125 7.7344-5.125 12.375v87.5h-70v-105.88-1.0508c-0.089844-1.5469-0.38281-3.0781-0.875-4.5508v-1.5742c-0.85547-1.8828-2.043-3.6016-3.5-5.0742l-52.5-52.5c-1.4727-1.457-3.1914-2.6445-5.0742-3.5h-1.5742c-1.7031-0.875-3.5352-1.4688-5.4258-1.75h-123.55c-4.6406 0-9.0938 1.8438-12.375 5.125s-5.125 7.7344-5.125 12.375v245c0 4.6406 1.8438 9.0938 5.125 12.375s7.7344 5.125 12.375 5.125h175c4.6406 0 9.0938-1.8438 12.375-5.125s5.125-7.7344 5.125-12.375v-52.5h70v122.5c0 4.6406 1.8438 9.0938 5.125 12.375s7.7344 5.125 12.375 5.125h175c4.6406 0 9.0938-1.8438 12.375-5.125s5.125-7.7344 5.125-12.375v-192.5-1.0508c-0.14453-1.5547-0.5-3.0859-1.0508-4.5508zm-313.95 110.6h-140v-210h87.5v35c0 4.6406 1.8438 9.0938 5.125 12.375s7.7344 5.125 12.375 5.125h35v87.5h-52.5c-6.2539 0-12.031 3.3359-15.156 8.75s-3.125 12.086 0 17.5 8.9023 8.75 15.156 8.75h52.5zm140 70v-105h27.824l-5.0742 5.0742c-3.7031 3.1719-5.9141 7.7461-6.1055 12.617-0.1875 4.8711 1.668 9.6016 5.1133 13.051 3.4492 3.4453 8.1797 5.3008 13.051 5.1133 4.8711-0.19141 9.4453-2.4023 12.617-6.1055l35-35c3.2578-3.2773 5.0898-7.7148 5.0898-12.336 0-4.625-1.832-9.0586-5.0898-12.34l-35-35c-4.5078-3.8555-10.66-5.1719-16.348-3.4883-5.6875 1.6797-10.137 6.1289-11.816 11.816-1.6836 5.6914-0.37109 11.844 3.4883 16.348l5.0742 5.0742h-27.824v-69.824h87.5v35c0 4.6406 1.8438 9.0938 5.125 12.375s7.7344 5.125 12.375 5.125h35v157.5z" />
    </svg>
  ),
  cog: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 512 512"
      fill="var(--icon-fill-color)"
      stroke="none"
    >
      <path d="M495.9 166.6C499.2 175.2 496.4 184.9 489.6 191.2L446.3 230.6C447.4 238.9 448 247.4 448 256C448 264.6 447.4 273.1 446.3 281.4L489.6 320.8C496.4 327.1 499.2 336.8 495.9 345.4C491.5 357.3 486.2 368.8 480.2 379.7L475.5 387.8C468.9 398.8 461.5 409.2 453.4 419.1C447.4 426.2 437.7 428.7 428.9 425.9L373.2 408.1C359.8 418.4 344.1 427 329.2 433.6L316.7 490.7C314.7 499.7 307.7 506.1 298.5 508.5C284.7 510.8 270.5 512 255.1 512C241.5 512 227.3 510.8 213.5 508.5C204.3 506.1 197.3 499.7 195.3 490.7L182.8 433.6C167 427 152.2 418.4 138.8 408.1L83.14 425.9C74.3 428.7 64.55 426.2 58.63 419.1C50.52 409.2 43.12 398.8 36.52 387.8L31.84 379.7C25.77 368.8 20.49 357.3 16.06 345.4C12.82 336.8 15.55 327.1 22.41 320.8L65.67 281.4C64.57 273.1 64 264.6 64 256C64 247.4 64.57 238.9 65.67 230.6L22.41 191.2C15.55 184.9 12.82 175.3 16.06 166.6C20.49 154.7 25.78 143.2 31.84 132.3L36.51 124.2C43.12 113.2 50.52 102.8 58.63 92.95C64.55 85.8 74.3 83.32 83.14 86.14L138.8 103.9C152.2 93.56 167 84.96 182.8 78.43L195.3 21.33C197.3 12.25 204.3 5.04 213.5 3.51C227.3 1.201 241.5 0 256 0C270.5 0 284.7 1.201 298.5 3.51C307.7 5.04 314.7 12.25 316.7 21.33L329.2 78.43C344.1 84.96 359.8 93.56 373.2 103.9L428.9 86.14C437.7 83.32 447.4 85.8 453.4 92.95C461.5 102.8 468.9 113.2 475.5 124.2L480.2 132.3C486.2 143.2 491.5 154.7 495.9 166.6V166.6zM256 336C300.2 336 336 300.2 336 255.1C336 211.8 300.2 175.1 256 175.1C211.8 175.1 176 211.8 176 255.1C176 300.2 211.8 336 256 336z" />
    </svg>
  ),
  trayMode: (
    <svg
      aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 640 512"
      stroke="var(--icon-fill-color)"
      fill="var(--icon-fill-color)"
      strokeWidth="20"
    >
      <path d="M618.1 97.67c-13.02-4.375-27.45 .1562-35.72 11.16L464 266.7l-118.4-157.8c-8.266-11.03-22.64-15.56-35.72-11.16C296.8 102 288 114.2 288 128v256c0 17.69 14.33 32 32 32s32-14.31 32-32v-160l86.41 115.2c12.06 16.12 39.13 16.12 51.19 0L576 224v160c0 17.69 14.33 32 32 32s32-14.31 32-32v-256C640 114.2 631.2 102 618.1 97.67zM224 96.01H32c-17.67 0-32 14.31-32 32s14.33 32 32 32h64v223.1c0 17.69 14.33 31.99 32 31.99s32-14.3 32-31.99V160h64c17.67 0 32-14.31 32-32S241.7 96.01 224 96.01z" />
    </svg>
  ),
  copyElementLink: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 260 260"
      aria-hidden="true"
      focusable="false"
      role="img"
    >
      <path
        stroke="var(--icon-fill-color)"
        fill="none"
        strokeLinecap="round"
        strokeWidth="8"
        d="M10 10h40m-40 0h40m0 0v40m0-40v40m0 0H10m40 0H10m0 0V10m0 40V10M210 10h40m-40 0h40m0 0v40m0-40v40m0 0h-40m40 0h-40m0 0V10m0 40V10M210 210h40m-40 0h40m0 0v40m0-40v40m0 0h-40m40 0h-40m0 0v-40m0 40v-40M10 210h40m-40 0h40m0 0v40m0-40v40m0 0H10m40 0H10m0 0v-40m0 40v-40M30 210V50m0 160V50M50 30h160M50 30h160M230 50v160m0-160v160M50 230h160m-160 0h160"
      />
      <path
        stroke="var(--icon-fill-color)"
        fill="none"
        strokeLinecap="round"
        strokeWidth="16"
        d="M110 90c-6.67 1.67-30 3.11-40 10-10 6.89-20 21.37-20 31.37S60 153.56 70 160c10 6.44 33.33 8.33 40 10m0-80c-6.67 1.67-30 3.11-40 10-10 6.89-20 21.37-20 31.37S60 153.56 70 160c10 6.44 33.33 8.33 40 10M150 90c6.67 1.67 30 3.11 40 10 10 6.89 20 21.37 20 31.37s-10 22.19-20 28.63c-10 6.44-33.33 8.33-40 10m0-80c6.67 1.67 30 3.11 40 10 10 6.89 20 21.37 20 31.37s-10 22.19-20 28.63c-10 6.44-33.33 8.33-40 10"
      />
      <path
        stroke="var(--icon-fill-color)"
        fill="none"
        strokeLinecap="round"
        strokeWidth="16"
        d="M89.868 130.198c13.36-.03 66.78-.17 80.13-.2m-80.13.2c13.36-.03 66.78-.17 80.13-.2"
      />
    </svg>
  ),
  importSVG: (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 526 526">
      <g fillRule="evenodd" strokeLinecap="round">
        <path 
          fill="var(--input-bg-color)"
          strokeWidth="0"
          d="m133.462 71 .33-6.54.97-6.34 1.58-6.13 2.16-5.88 2.69-5.6 3.21-5.27 3.69-4.93 4.13-4.55 4.55-4.13 4.93-3.69 5.27-3.21 5.6-2.69 5.88-2.16 6.13-1.58 6.34-.97 6.54-.33h160v128l.16 3.28.49 3.18.79 3.07 1.07 2.94 1.35 2.8 1.6 2.63 1.84 2.47 2.06 2.27 2.27 2.06 2.47 1.84 2.63 1.6 2.8 1.35 2.94 1.07 3.07.79 3.18.49 3.28.16h128v288l-.33 6.54-.97 6.34-1.58 6.13-2.16 5.88-2.69 5.6-3.21 5.27-3.69 4.93-4.13 4.55-4.55 4.13-4.93 3.69-5.27 3.21-5.6 2.69-5.88 2.16-6.13 1.58-6.34.97-6.54.33h-256l-6.54-.33-6.34-.97-6.13-1.58-5.88-2.16-5.6-2.69-5.27-3.21-4.93-3.69-4.55-4.13-4.13-4.55-3.69-4.93-3.21-5.27-2.69-5.6-2.16-5.88-1.58-6.13-.97-6.34-.33-6.54V343h174.1l-39 39-1.65 1.83-1.43 1.94-1.22 2.05-.99 2.13-.77 2.2-.55 2.25-.33 2.29-.11 2.3.11 2.3.33 2.28.55 2.24.77 2.19.99 2.12 1.22 2.04 1.43 1.93 1.65 1.81 1.83 1.64 1.94 1.42 2.05 1.2 2.13.99 2.2.76 2.25.56 2.29.33 2.3.11 2.3-.1 2.28-.33 2.24-.54 2.19-.77 2.12-.98 2.04-1.21 1.93-1.43 1.81-1.65 80-80 1.65-1.83 1.43-1.94 1.22-2.05.99-2.13.77-2.2.55-2.25.33-2.29.11-2.3-.11-2.3-.33-2.28-.55-2.24-.77-2.19-.99-2.12-1.22-2.04-1.43-1.93-1.65-1.81-80-80-1.83-1.65-1.94-1.43-2.05-1.22-2.13-.99-2.2-.77-2.25-.55-2.29-.33-2.3-.11-2.3.11-2.28.33-2.24.55-2.19.77-2.12.99-2.04 1.22-1.93 1.43-1.81 1.65-1.64 1.83-1.42 1.94-1.2 2.05-.99 2.13-.76 2.2-.56 2.25-.33 2.29-.11 2.3.1 2.3.33 2.28.54 2.24.77 2.19.98 2.12 1.21 2.04 1.43 1.93 1.65 1.81 39 39h-174.1V71"
        />
        <path
          fill="none"
          stroke="var(--icon-fill-color)"
          strokeWidth="18"
          d="M133.462 71s0 0 0 0m0 0s0 0 0 0m0 0 .33-6.54m-.33 6.54c.13-2.57.26-5.13.33-6.54m0 0c.36-2.33.72-4.67.97-6.34m-.97 6.34c.35-2.26.69-4.53.97-6.34m0 0c.51-1.99 1.03-3.98 1.58-6.13m-1.58 6.13c.4-1.56.81-3.12 1.58-6.13m0 0c.81-2.22 1.62-4.43 2.16-5.88m-2.16 5.88c.45-1.22.9-2.44 2.16-5.88m0 0c.72-1.51 1.45-3.01 2.69-5.6m-2.69 5.6c.69-1.45 1.39-2.9 2.69-5.6m0 0c.93-1.52 1.86-3.05 3.21-5.27m-3.21 5.27c.97-1.59 1.94-3.18 3.21-5.27m0 0c.86-1.15 1.71-2.29 3.69-4.93m-3.69 4.93c.78-1.04 1.56-2.08 3.69-4.93m0 0c1.53-1.69 3.07-3.38 4.13-4.55m-4.13 4.55c1.54-1.69 3.07-3.38 4.13-4.55m0 0c1.03-.93 2.06-1.87 4.55-4.13m-4.55 4.13c.98-.89 1.97-1.78 4.55-4.13m0 0c1.64-1.23 3.28-2.46 4.93-3.69m-4.93 3.69c1.72-1.29 3.45-2.58 4.93-3.69m0 0c1.11-.68 2.23-1.35 5.27-3.21m-5.27 3.21c1.5-.91 3.01-1.83 5.27-3.21m0 0c1.87-.89 3.73-1.79 5.6-2.69m-5.6 2.69c2.09-1 4.17-2.01 5.6-2.69m0 0c1.72-.64 3.44-1.27 5.88-2.16m-5.88 2.16c1.94-.72 3.89-1.43 5.88-2.16m0 0c2.3-.59 4.6-1.19 6.13-1.58m-6.13 1.58c2.32-.6 4.65-1.2 6.13-1.58m0 0c2.06-.31 4.12-.63 6.34-.97m-6.34.97c2.34-.36 4.69-.72 6.34-.97m0 0c2.05-.1 4.09-.21 6.54-.33m-6.54.33c2.06-.1 4.12-.21 6.54-.33m0 0h160m-160 0h160m0 0v128m0-128v128m0 0s0 0 0 0m0 0s0 0 0 0m0 0 .16 3.28m-.16-3.28c.06 1.16.12 2.32.16 3.28m0 0c.13.82.26 1.64.49 3.18m-.49-3.18c.18 1.13.35 2.26.49 3.18m0 0c.24.95.49 1.91.79 3.07m-.79-3.07c.28 1.1.56 2.2.79 3.07m0 0c.39 1.06.78 2.13 1.07 2.94m-1.07-2.94c.42 1.15.84 2.3 1.07 2.94m0 0c.38.79.76 1.57 1.35 2.8m-1.35-2.8c.4.82.79 1.64 1.35 2.8m0 0c.45.75.91 1.5 1.6 2.63m-1.6-2.63c.4.65.8 1.31 1.6 2.63m0 0c.56.76 1.13 1.52 1.84 2.47m-1.84-2.47c.58.79 1.17 1.57 1.84 2.47m0 0c.75.82 1.5 1.65 2.06 2.27m-2.06-2.27c.75.82 1.5 1.65 2.06 2.27m0 0c.74.66 1.47 1.33 2.27 2.06m-2.27-2.06c.89.81 1.78 1.61 2.27 2.06m0 0c.69.51 1.37 1.02 2.47 1.84m-2.47-1.84c.68.5 1.35 1.01 2.47 1.84m0 0c.81.49 1.62.99 2.63 1.6m-2.63-1.6c.74.45 1.47.9 2.63 1.6m0 0c.72.35 1.43.69 2.8 1.35m-2.8-1.35c.61.3 1.22.59 2.8 1.35m0 0c.85.31 1.69.62 2.94 1.07m-2.94-1.07c1.03.38 2.07.75 2.94 1.07m0 0c.83.22 1.67.43 3.07.79m-3.07-.79 3.07.79m0 0c1.07.16 2.14.33 3.18.49m-3.18-.49c1.2.18 2.39.36 3.18.49m0 0 3.28.16m-3.28-.16c.97.04 1.93.09 3.28.16m0 0h128m-128 0h128m0 0v288m0-288v288m0 0s0 0 0 0m0 0s0 0 0 0m0 0c-.1 2.02-.2 4.04-.33 6.54m.33-6.54c-.13 2.52-.26 5.05-.33 6.54m0 0c-.33 2.14-.66 4.29-.97 6.34m.97-6.34c-.32 2.06-.63 4.12-.97 6.34m0 0c-.59 2.28-1.17 4.55-1.58 6.13m1.58-6.13c-.53 2.07-1.07 4.14-1.58 6.13m0 0c-.73 1.99-1.46 3.97-2.16 5.88m2.16-5.88c-.72 1.97-1.44 3.94-2.16 5.88m0 0c-.94 1.97-1.89 3.93-2.69 5.6m2.69-5.6c-.91 1.89-1.82 3.77-2.69 5.6m0 0c-.89 1.46-1.78 2.92-3.21 5.27m3.21-5.27c-.65 1.05-1.29 2.11-3.21 5.27m0 0c-1.13 1.51-2.25 3.01-3.69 4.93m3.69-4.93c-1.29 1.72-2.58 3.44-3.69 4.93m0 0c-1.29 1.42-2.58 2.84-4.13 4.55m4.13-4.55-4.13 4.55m0 0-4.55 4.13m4.55-4.13-4.55 4.13m0 0c-1.2.9-2.41 1.8-4.93 3.69m4.93-3.69-4.93 3.69m0 0c-1.56.95-3.13 1.9-5.27 3.21m5.27-3.21c-1.99 1.21-3.98 2.42-5.27 3.21m0 0c-1.8.86-3.6 1.73-5.6 2.69m5.6-2.69c-1.34.64-2.67 1.28-5.6 2.69m0 0c-2.24.82-4.48 1.65-5.88 2.16m5.88-2.16c-1.38.51-2.77 1.02-5.88 2.16m0 0c-1.46.38-2.93.76-6.13 1.58m6.13-1.58c-1.54.4-3.09.79-6.13 1.58m0 0c-2.12.32-4.24.65-6.34.97m6.34-.97c-2.47.38-4.94.75-6.34.97m0 0c-2.23.11-4.46.22-6.54.33m6.54-.33c-1.97.1-3.93.2-6.54.33m0 0h-256m256 0h-256m0 0s0 0 0 0m0 0s0 0 0 0m0 0c-2.33-.12-4.66-.24-6.54-.33m6.54.33c-1.33-.07-2.65-.13-6.54-.33m0 0c-1.88-.29-3.77-.58-6.34-.97m6.34.97c-2.07-.32-4.14-.63-6.34-.97m0 0c-1.52-.39-3.04-.79-6.13-1.58m6.13 1.58c-2.02-.52-4.04-1.04-6.13-1.58m0 0c-1.6-.59-3.19-1.17-5.88-2.16m5.88 2.16c-1.9-.7-3.8-1.39-5.88-2.16m0 0c-1.41-.68-2.82-1.36-5.6-2.69m5.6 2.69c-1.6-.77-3.2-1.54-5.6-2.69m0 0c-1.4-.86-2.81-1.71-5.27-3.21m5.27 3.21c-2.08-1.27-4.17-2.54-5.27-3.21m0 0c-1.72-1.29-3.43-2.57-4.93-3.69m4.93 3.69c-1.79-1.34-3.57-2.67-4.93-3.69m0 0c-1.18-1.07-2.36-2.15-4.55-4.13m4.55 4.13c-1.64-1.49-3.27-2.97-4.55-4.13m0 0c-1.07-1.19-2.15-2.37-4.13-4.55m4.13 4.55c-1.46-1.61-2.93-3.23-4.13-4.55m0 0-3.69-4.93m3.69 4.93c-.88-1.17-1.76-2.35-3.69-4.93m0 0c-.83-1.37-1.67-2.75-3.21-5.27m3.21 5.27c-1.15-1.89-2.3-3.79-3.21-5.27m0 0c-1.03-2.14-2.05-4.27-2.69-5.6m2.69 5.6c-.68-1.43-1.37-2.85-2.69-5.6m0 0c-.8-2.17-1.59-4.34-2.16-5.88m2.16 5.88c-.82-2.22-1.63-4.44-2.16-5.88m0 0c-.47-1.82-.94-3.64-1.58-6.13m1.58 6.13c-.37-1.44-.74-2.88-1.58-6.13m0 0-.97-6.34m.97 6.34c-.3-1.98-.61-3.97-.97-6.34m0 0c-.13-2.54-.26-5.07-.33-6.54m.33 6.54-.33-6.54m0 0V343m0 112V343m0 0h174.1m-174.1 0h174.1m0 0-39 39m39-39-39 39m0 0s0 0 0 0m0 0s0 0 0 0m0 0c-.65.72-1.3 1.44-1.65 1.83m1.65-1.83c-.34.38-.68.76-1.65 1.83m0 0c-.35.47-.7.95-1.43 1.94m1.43-1.94c-.38.5-.75 1.01-1.43 1.94m0 0c-.32.54-.64 1.08-1.22 2.05m1.22-2.05c-.38.64-.76 1.28-1.22 2.05m0 0c-.2.45-.41.89-.99 2.13m.99-2.13c-.38.82-.76 1.64-.99 2.13m0 0c-.18.53-.36 1.05-.77 2.2m.77-2.2c-.3.88-.61 1.75-.77 2.2m0 0c-.15.61-.3 1.22-.55 2.25m.55-2.25c-.16.68-.33 1.35-.55 2.25m0 0-.33 2.29m.33-2.29c-.13.9-.26 1.79-.33 2.29m0 0-.11 2.3m.11-2.3c-.03.59-.06 1.19-.11 2.3m0 0c.03.54.05 1.08.11 2.3m-.11-2.3c.03.72.07 1.44.11 2.3m0 0c.1.71.21 1.43.33 2.28m-.33-2.28c.1.71.21 1.42.33 2.28m0 0c.22.88.44 1.77.55 2.24m-.55-2.24c.16.66.33 1.32.55 2.24m0 0c.26.72.51 1.45.77 2.19m-.77-2.19c.25.69.49 1.39.77 2.19m0 0c.33.7.65 1.4.99 2.12m-.99-2.12c.37.79.74 1.57.99 2.12m0 0c.38.63.75 1.25 1.22 2.04m-1.22-2.04c.4.67.8 1.35 1.22 2.04m0 0c.38.52.77 1.05 1.43 1.93m-1.43-1.93c.38.52.77 1.05 1.43 1.93m0 0c.46.5.91 1 1.65 1.81m-1.65-1.81c.35.39.7.77 1.65 1.81m0 0c.37.33.75.67 1.83 1.64m-1.83-1.64c.43.39.87.78 1.83 1.64m0 0c.62.45 1.25.91 1.94 1.42m-1.94-1.42c.45.32.9.65 1.94 1.42m0 0c.53.3 1.05.61 2.05 1.2m-2.05-1.2c.43.25.86.5 2.05 1.2m0 0c.78.36 1.56.72 2.13.99m-2.13-.99c.54.25 1.08.5 2.13.99m0 0c.67.23 1.33.46 2.2.76m-2.2-.76c.51.17 1.03.35 2.2.76m0 0c.87.22 1.73.43 2.25.56m-2.25-.56c.79.2 1.57.39 2.25.56m0 0 2.29.33m-2.29-.33c.58.08 1.16.16 2.29.33m0 0c.91.04 1.82.09 2.3.11m-2.3-.11c.89.04 1.79.09 2.3.11m0 0c.48-.02.96-.04 2.3-.1m-2.3.1c.73-.03 1.47-.06 2.3-.1m0 0c.61-.09 1.22-.18 2.28-.33m-2.28.33c.58-.09 1.17-.17 2.28-.33m0 0c.79-.19 1.59-.38 2.24-.54m-2.24.54c.88-.21 1.75-.42 2.24-.54m0 0c.7-.25 1.4-.49 2.19-.77m-2.19.77c.5-.18 1.01-.35 2.19-.77m0 0c.56-.26 1.13-.52 2.12-.98m-2.12.98c.69-.31 1.37-.63 2.12-.98m0 0c.63-.37 1.25-.74 2.04-1.21m-2.04 1.21c.8-.48 1.6-.95 2.04-1.21m0 0c.67-.5 1.34-.99 1.93-1.43m-1.93 1.43c.52-.39 1.05-.78 1.93-1.43m0 0c.43-.39.87-.79 1.81-1.65m-1.81 1.65c.42-.38.83-.76 1.81-1.65m0 0 80-80m-80 80 80-80m0 0s0 0 0 0m0 0s0 0 0 0m0 0c.33-.37.67-.74 1.65-1.83m-1.65 1.83c.63-.7 1.27-1.4 1.65-1.83m0 0c.3-.4.59-.79 1.43-1.94m-1.43 1.94c.42-.57.84-1.13 1.43-1.94m0 0c.4-.68.8-1.35 1.22-2.05m-1.22 2.05c.47-.79.93-1.57 1.22-2.05m0 0c.28-.62.57-1.23.99-2.13m-.99 2.13c.3-.65.6-1.31.99-2.13m0 0c.26-.74.51-1.47.77-2.2m-.77 2.2.77-2.2m0 0 .55-2.25m-.55 2.25c.2-.84.41-1.68.55-2.25m0 0 .33-2.29m-.33 2.29c.11-.75.21-1.49.33-2.29m0 0c.03-.54.05-1.08.11-2.3m-.11 2.3c.04-.91.09-1.81.11-2.3m0 0c-.03-.7-.07-1.41-.11-2.3m.11 2.3c-.04-.75-.07-1.49-.11-2.3m0 0c-.08-.52-.15-1.04-.33-2.28m.33 2.28c-.09-.63-.18-1.26-.33-2.28m0 0-.55-2.24m.55 2.24c-.19-.79-.39-1.58-.55-2.24m0 0-.77-2.19m.77 2.19c-.25-.72-.51-1.44-.77-2.19m0 0c-.23-.5-.46-.99-.99-2.12m.99 2.12c-.39-.83-.78-1.66-.99-2.12m0 0c-.42-.7-.83-1.39-1.22-2.04m1.22 2.04c-.32-.53-.64-1.06-1.22-2.04m0 0c-.47-.64-.95-1.28-1.43-1.93m1.43 1.93c-.47-.63-.94-1.27-1.43-1.93m0 0c-.44-.49-.89-.98-1.65-1.81m1.65 1.81c-.64-.7-1.28-1.4-1.65-1.81m0 0-80-80m80 80-80-80m0 0s0 0 0 0m0 0s0 0 0 0m0 0c-.72-.65-1.44-1.3-1.83-1.65m1.83 1.65c-.68-.62-1.37-1.23-1.83-1.65m0 0c-.51-.38-1.02-.75-1.94-1.43m1.94 1.43c-.58-.43-1.17-.87-1.94-1.43m0 0c-.73-.43-1.45-.86-2.05-1.22m2.05 1.22c-.77-.45-1.53-.9-2.05-1.22m0 0c-.46-.21-.93-.43-2.13-.99m2.13.99-2.13-.99m0 0c-.83-.29-1.65-.57-2.2-.77m2.2.77c-.56-.19-1.12-.39-2.2-.77m0 0c-.65-.16-1.29-.31-2.25-.55m2.25.55c-.57-.14-1.13-.27-2.25-.55m0 0c-.74-.11-1.48-.21-2.29-.33m2.29.33c-.51-.07-1.02-.15-2.29-.33m0 0c-.77-.04-1.54-.07-2.3-.11m2.3.11c-.88-.04-1.76-.08-2.3-.11m0 0c-.49.02-.98.05-2.3.11m2.3-.11c-.88.04-1.77.09-2.3.11m0 0c-.62.09-1.23.18-2.28.33m2.28-.33c-.6.09-1.2.17-2.28.33m0 0c-.45.11-.91.22-2.24.55m2.24-.55c-.79.2-1.58.39-2.24.55m0 0c-.56.2-1.12.4-2.19.77m2.19-.77c-.51.18-1.01.36-2.19.77m0 0c-.85.4-1.7.8-2.12.99m2.12-.99c-.51.24-1.02.48-2.12.99m0 0c-.6.36-1.2.71-2.04 1.22m2.04-1.22c-.46.27-.91.55-2.04 1.22m0 0c-.49.36-.99.73-1.93 1.43m1.93-1.43-1.93 1.43m0 0c-.42.38-.85.77-1.81 1.65m1.81-1.65c-.69.63-1.39 1.27-1.81 1.65m0 0-1.64 1.83m1.64-1.83c-.54.6-1.08 1.21-1.64 1.83m0 0c-.53.73-1.07 1.47-1.42 1.94m1.42-1.94c-.36.5-.73 1-1.42 1.94m0 0c-.35.61-.7 1.21-1.2 2.05m1.2-2.05c-.33.58-.67 1.15-1.2 2.05m0 0c-.26.57-.53 1.15-.99 2.13m.99-2.13c-.39.85-.78 1.69-.99 2.13m0 0c-.24.7-.48 1.4-.76 2.2m.76-2.2c-.17.51-.35 1.01-.76 2.2m0 0c-.17.68-.33 1.35-.56 2.25m.56-2.25c-.2.79-.39 1.57-.56 2.25m0 0c-.09.65-.18 1.29-.33 2.29m.33-2.29c-.06.48-.13.95-.33 2.29m0 0c-.03.71-.07 1.43-.11 2.3m.11-2.3-.11 2.3m0 0c.04.86.08 1.73.1 2.3m-.1-2.3c.03.8.07 1.6.1 2.3m0 0c.13.88.25 1.76.33 2.28m-.33-2.28c.11.73.21 1.47.33 2.28m0 0c.18.74.36 1.49.54 2.24m-.54-2.24c.15.64.31 1.28.54 2.24m0 0c.2.57.4 1.15.77 2.19m-.77-2.19c.21.58.41 1.17.77 2.19m0 0c.23.5.46 1.01.98 2.12m-.98-2.12c.35.76.71 1.53.98 2.12m0 0c.38.64.76 1.29 1.21 2.04m-1.21-2.04 1.21 2.04m0 0c.45.6.89 1.21 1.43 1.93m-1.43-1.93c.3.4.6.81 1.43 1.93m0 0 1.65 1.81m-1.65-1.81c.47.52.94 1.03 1.65 1.81m0 0 39 39m-39-39 39 39m0 0h-174.1m174.1 0h-174.1m0 0V71m0 223.9V71m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0"
        />
      </g>
      <path
        fill="none"
        stroke="var(--icon-fill-color)"
        strokeLinecap="round"
        strokeWidth="18"
        d="M135 343.068H31m104 0H31m0 0s0 0 0 0m0 0s0 0 0 0m0 0c-.74-.04-1.48-.07-2.46-.12m2.46.12c-.77-.04-1.54-.08-2.46-.12m0 0c-.87-.14-1.75-.27-2.39-.37m2.39.37c-.55-.09-1.1-.17-2.39-.37m0 0c-.87-.22-1.74-.44-2.3-.59m2.3.59c-.62-.15-1.24-.31-2.3-.59m0 0c-.82-.29-1.64-.59-2.21-.8m2.21.8c-.52-.18-1.03-.37-2.21-.8m0 0c-.55-.26-1.09-.52-2.1-1.01m2.1 1.01c-.64-.31-1.28-.61-2.1-1.01m0 0c-.74-.45-1.48-.89-1.98-1.2m1.98 1.2c-.42-.25-.84-.51-1.98-1.2m0 0c-.7-.52-1.41-1.05-1.84-1.38m1.84 1.38c-.37-.28-.75-.56-1.84-1.38m0 0c-.4-.36-.8-.71-1.71-1.54m1.71 1.54c-.35-.31-.7-.63-1.71-1.54m0 0c-.43-.47-.85-.95-1.54-1.71m1.54 1.71c-.61-.68-1.23-1.36-1.54-1.71m0 0c-.29-.38-.58-.76-1.38-1.84m1.38 1.84c-.54-.71-1.08-1.43-1.38-1.84m0 0c-.46-.76-.92-1.52-1.2-1.98m1.2 1.98c-.45-.74-.89-1.47-1.2-1.98m0 0c-.37-.77-.74-1.53-1.01-2.1m1.01 2.1c-.3-.62-.6-1.25-1.01-2.1m0 0c-.2-.54-.39-1.07-.8-2.21m.8 2.21c-.2-.54-.4-1.09-.8-2.21m0 0c-.22-.85-.44-1.71-.59-2.3m.59 2.3c-.12-.46-.24-.92-.59-2.3m0 0c-.11-.72-.22-1.43-.37-2.39m.37 2.39c-.08-.48-.15-.96-.37-2.39m0 0c-.03-.74-.07-1.48-.12-2.46m.12 2.46c-.04-.79-.08-1.59-.12-2.46m0 0c.04-.74.07-1.49.12-2.46m-.12 2.46.12-2.46m0 0c.08-.53.16-1.07.37-2.39m-.37 2.39c.09-.56.17-1.12.37-2.39m0 0c.17-.69.35-1.38.59-2.3m-.59 2.3c.15-.61.31-1.23.59-2.3m0 0c.17-.48.34-.96.8-2.21m-.8 2.21c.2-.55.4-1.1.8-2.21m0 0c.25-.52.49-1.03 1.01-2.1m-1.01 2.1c.36-.76.73-1.52 1.01-2.1m0 0c.43-.72.87-1.44 1.2-1.98m-1.2 1.98c.27-.45.55-.91 1.2-1.98m0 0c.54-.73 1.09-1.47 1.38-1.84m-1.38 1.84c.4-.54.81-1.09 1.38-1.84m0 0c.53-.59 1.07-1.18 1.54-1.71m-1.54 1.71c.59-.66 1.19-1.32 1.54-1.71m0 0c.54-.49 1.08-.97 1.71-1.54m-1.71 1.54c.48-.43.95-.86 1.71-1.54m0 0c.46-.35.92-.7 1.84-1.38m-1.84 1.38c.5-.38 1.01-.76 1.84-1.38m0 0c.52-.32 1.04-.63 1.98-1.2m-1.98 1.2c.72-.44 1.44-.88 1.98-1.2m0 0 2.1-1.01m-2.1 1.01c.84-.4 1.67-.81 2.1-1.01m0 0c.45-.17.91-.33 2.21-.8m-2.21.8c.56-.21 1.12-.41 2.21-.8m0 0c.89-.23 1.79-.46 2.3-.59m-2.3.59c.48-.13.95-.25 2.3-.59m0 0c.51-.08 1.02-.16 2.39-.37m-2.39.37 2.39-.37m0 0c.52-.02 1.03-.05 2.46-.12m-2.46.12c.74-.03 1.48-.07 2.46-.12m0 0 103.34-.27m-103.34.27c30.04-.08 60.08-.16 103.34-.27"
      />
      <g fillRule="evenodd" strokeLinecap="round">
        <path
          fill="var(--input-bg-color)"
          strokeWidth="0"
          d="M517.462 135h-128V7l128 128"
        />
        <path
          fill="none"
          stroke="var(--icon-fill-color)"
          strokeWidth="18"
          d="M517.462 135h-128m128 0h-128m0 0V7m0 128V7m0 0 128 128m-128-128 128 128m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0"
        />
      </g>
    </svg>
  ),
  obsidian: (
    <svg
      //aria-hidden="true"
      focusable="false"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 512 512"
    >
      <defs>
        <radialGradient id="b" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-48 -185 123 -32 179 429.7)">
          <stop stopColor="#fff" stopOpacity=".4"/>
          <stop offset="1" stopOpacity=".1"/>
        </radialGradient>
        <radialGradient id="c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(41 -310 229 30 341.6 351.3)">
          <stop stopColor="#fff" stopOpacity=".6"/>
          <stop offset="1" stopColor="#fff" stopOpacity=".1"/>
        </radialGradient>
        <radialGradient id="d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(57 -261 178 39 190.5 296.3)">
          <stop stopColor="#fff" stopOpacity=".8"/>
          <stop offset="1" stopColor="#fff" stopOpacity=".4"/>
        </radialGradient>
        <radialGradient id="e" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-79 -133 153 -90 321.4 464.2)">
          <stop stopColor="#fff" stopOpacity=".3"/>
          <stop offset="1" stopOpacity=".3"/>
        </radialGradient>
        <radialGradient id="f" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-29 136 -92 -20 300.7 149.9)">
          <stop stopColor="#fff" stopOpacity="0"/>
          <stop offset="1" stopColor="#fff" stopOpacity=".2"/>
        </radialGradient>
        <radialGradient id="g" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(72 73 -155 153 137.8 225.2)">
          <stop stopColor="#fff" stopOpacity=".2"/>
          <stop offset="1" stopColor="#fff" stopOpacity=".4"/>
        </radialGradient>
        <radialGradient id="h" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(20 118 -251 43 215.1 273.7)">
          <stop stopColor="#fff" stopOpacity=".1"/>
          <stop offset="1" stopColor="#fff" stopOpacity=".3"/>
        </radialGradient>
        <radialGradient id="i" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-162 -85 268 -510 374.4 371.7)">
          <stop stopColor="#fff" stopOpacity=".2"/>
          <stop offset=".5" stopColor="#fff" stopOpacity=".2"/>
          <stop offset="1" stopColor="#fff" stopOpacity=".3"/>
        </radialGradient>
        <filter id="a" x="80.1" y="37" width="351.1" height="443.2" filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
          <feFlood floodOpacity="0" result="BackgroundImageFix"/>
          <feBlend in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
          <feGaussianBlur stdDeviation="6.5" result="effect1_foregroundBlur_744_9191"/>
        </filter>
      </defs>
      <g filter="url(#a)">
        <path d="M359.2 437.5c-2.6 19-21.3 33.9-40 28.7-26.5-7.2-57.2-18.6-84.8-20.7l-42.4-3.2a28 28 0 0 1-18-8.3l-73-74.8a27.7 27.7 0 0 1-5.4-30.7s45-98.6 46.8-103.7c1.6-5.1 7.8-49.9 11.4-73.9a28 28 0 0 1 9-16.5L249 57.2a28 28 0 0 1 40.6 3.4l72.6 91.6a29.5 29.5 0 0 1 6.2 18.3c0 17.3 1.5 53 11.2 76a301.3 301.3 0 0 0 35.6 58.2 14 14 0 0 1 1 15.6c-6.3 10.7-18.9 31.3-36.6 57.6a142.2 142.2 0 0 0-20.5 59.6Z" fill="#000" fillOpacity=".3"/>
      </g>
      <path id="arrow" d="M359.9 434.3c-2.6 19.1-21.3 34-40 28.9-26.4-7.3-57-18.7-84.7-20.8l-42.3-3.2a27.9 27.9 0 0 1-18-8.4l-73-75a27.9 27.9 0 0 1-5.4-31s45.1-99 46.8-104.2c1.7-5.1 7.8-50 11.4-74.2a28 28 0 0 1 9-16.6l86.2-77.5a28 28 0 0 1 40.6 3.5l72.5 92a29.7 29.7 0 0 1 6.2 18.3c0 17.4 1.5 53.2 11.1 76.3a303 303 0 0 0 35.6 58.5 14 14 0 0 1 1.1 15.7c-6.4 10.8-18.9 31.4-36.7 57.9a143.3 143.3 0 0 0-20.4 59.8Z" fill="#6c31e3"/>
      <path d="M182.7 436.4c33.9-68.7 33-118 18.5-153-13.2-32.4-37.9-52.8-57.3-65.5-.4 1.9-1 3.7-1.8 5.4L96.5 324.8a27.9 27.9 0 0 0 5.5 31l72.9 75c2.3 2.3 5 4.2 7.8 5.6Z" fill="url(#b)"/>
      <path d="M274.9 297c9.1.9 18 2.9 26.8 6.1 27.8 10.4 53.1 33.8 74 78.9 1.5-2.6 3-5.1 4.6-7.5a1222 1222 0 0 0 36.7-57.9 14 14 0 0 0-1-15.7 303 303 0 0 1-35.7-58.5c-9.6-23-11-58.9-11.1-76.3 0-6.6-2.1-13.1-6.2-18.3l-72.5-92-1.2-1.5c5.3 17.5 5 31.5 1.7 44.2-3 11.8-8.6 22.5-14.5 33.8-2 3.8-4 7.7-5.9 11.7a140 140 0 0 0-15.8 58c-1 24.2 3.9 54.5 20 95Z" fill="url(#c)"/>
      <path d="M274.8 297c-16.1-40.5-21-70.8-20-95 1-24 8-42 15.8-58l6-11.7c5.8-11.3 11.3-22 14.4-33.8a78.5 78.5 0 0 0-1.7-44.2 28 28 0 0 0-39.4-2l-86.2 77.5a28 28 0 0 0-9 16.6L144.2 216c0 .7-.2 1.3-.3 2 19.4 12.6 44 33 57.3 65.3 2.6 6.4 4.8 13.1 6.4 20.4a200 200 0 0 1 67.2-6.8Z" fill="url(#d)"/>
      <path d="M320 463.2c18.6 5.1 37.3-9.8 39.9-29a153 153 0 0 1 15.9-52.2c-21-45.1-46.3-68.5-74-78.9-29.5-11-61.6-7.3-94.2.6 7.3 33.1 3 76.4-24.8 132.7 3.1 1.6 6.6 2.5 10.1 2.8l43.9 3.3c23.8 1.7 59.3 14 83.2 20.7Z" fill="url(#e)"/>
      <path fillRule="evenodd" clipRule="evenodd" d="M255 200.5c-1.1 24 1.9 51.4 18 91.8l-5-.5c-14.5-42.1-17.7-63.7-16.6-88 1-24.3 8.9-43 16.7-59 2-4 6.6-11.5 8.6-15.3 5.8-11.3 9.7-17.2 13-27.5 4.8-14.4 3.8-21.2 3.2-28 3.7 24.5-10.4 45.8-21 67.5a145 145 0 0 0-17 59Z" fill="url(#f)"/>
      <path fillRule="evenodd" clipRule="evenodd" d="M206 285.1c2 4.4 3.7 8 4.9 13.5l-4.3 1c-1.7-6.4-3-11-5.5-16.5-14.6-34.3-38-52-57-65 23 12.4 46.7 31.9 61.9 67Z" fill="url(#g)"/>
      <path fillRule="evenodd" clipRule="evenodd" d="M211.1 303c8 37.5-1 85.2-27.5 131.6 22.2-46 33-90.1 24-131l3.5-.7Z" fill="url(#h)"/>
      <path fillRule="evenodd" clipRule="evenodd" d="M302.7 299.5c43.5 16.3 60.3 52 72.8 81.9-15.5-31.2-37-65.7-74.4-78.5-28.4-9.8-52.4-8.6-93.5.7l-.9-4c43.6-10 66.4-11.2 96 0Z" fill="url(#i)"/>
    </svg>
  ),
  "add-file": (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 24 24"
      fill="none"
      stroke="var(--icon-fill-color)"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    >
      <path d="M14.5 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7.5L14.5 2z"/>
      <polyline points="14 2 14 8 20 8"/>
      <line x1="12" x2="12" y1="18" y2="12"/>
      <line x1="9" x2="15" y1="15" y2="15"/>
    </svg>
  ),
};

export const SwordColors = {
  Bronze: { grip: "#cd7f32", decoration: "#96510d", blade: "#7A420B", bladeFillLight: "#E1B384", title: "Apprentice of Sketchnoting" },
  Silver: { grip: "#CECDCC", decoration: "#b2b0b0", blade: "#979595", bladeFillLight: "#F5F5F5", title: "Champion of Spatial Thinking" },
  Gold: { grip: "#F5D000", decoration: "#D6B600", blade: "#B89C00", bladeFillLight: "#FFEA70", title: "Hero of Visual Notetaking" }, 
  Platinum: { grip: "#646261", decoration: "#323131", blade: "#000", bladeFillLight: "#8B8988", title: "Legend of Visual Thinking" },
}

export type Rank = keyof typeof SwordColors;

export const excalidrawSword = (rank: Rank) => {
  const { grip, decoration, blade, bladeFillLight } = SwordColors[rank];

  return (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 528 1140">
      <g fillRule="evenodd" strokeLinecap="round">
        <path fill={bladeFillLight} d="m272 979 118-121-80-571-104 1-36 580 104 113-1-2"/>
        <path fill="none" stroke="black" strokeWidth="4" d="M271 978c31-30 67-60 117-120M273 979c42-46 89-95 115-120m-1-1c-19-163-41-323-79-569m78 570c-20-165-42-329-78-570m-2 0c-23-2-56-2-102 0m106-1c-34 0-63-1-104 1m0 1c-12 192-21 384-34 574m33-576-31 576m3 2c30 40 71 85 98 112M173 863c38 47 75 87 100 117m1 1s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0"/>
      </g>
      <g fill="none" fillRule="evenodd" strokeLinecap="round">
        <path stroke={blade} strokeWidth=".5" d="M207 287s0 0 0 0m0 0s0 0 0 0m-2 6 7-5m-6 6 6-7m-6 17c0-8 3-14 10-15m-9 12c4-3 5-8 12-14m-11 20c4-7 6-8 11-20m-13 19c4-6 10-10 15-16m-14 27c4-12 7-14 21-28m-23 24c8-6 13-16 23-27m-23 35c14-11 17-26 31-37m-32 37c10-10 16-17 28-35m-29 39c12-6 18-13 31-37m-28 37c5-8 12-14 33-37m-33 47c7-12 20-27 36-44m-36 42c14-17 26-36 38-44m-36 53c8-11 22-26 37-53m-42 48c14-14 29-29 46-49m-45 60c18-29 42-49 52-62m-52 61c18-22 36-40 52-59m-56 63c15-17 34-27 57-65m-54 66 58-63m-62 71c15-18 35-38 64-74m-62 74c25-30 48-57 62-71m-62 78c22-25 42-52 72-75m-71 72c22-26 47-53 70-75m-69 84c25-30 50-67 70-88m-72 87 74-82m-72 85c30-27 58-58 75-89m-75 94c17-23 37-42 79-90m-82 97c24-21 45-47 86-95m-85 94 84-98m-84 105c22-23 40-48 92-105m-93 106c23-30 47-57 90-105m-90 106c29-25 51-56 95-105m-94 108c19-23 38-47 96-109m-93 118c36-44 72-86 93-114m-98 114c30-35 55-69 102-120M197 408c30-26 58-60 110-119M199 412l108-124M198 421c31-37 66-71 111-129M201 418c32-41 71-82 110-130M196 426c38-43 73-77 119-132M198 426l114-130M196 430c41-47 85-87 120-128M198 431c29-29 53-57 113-133M201 436c25-31 51-61 112-127M198 439c28-30 52-61 114-133M194 442c29-33 63-65 123-134M198 442c42-48 85-97 118-132M195 449c28-35 63-63 122-135M198 449c43-49 88-96 117-131M197 459c45-51 86-103 121-139M199 455c47-49 88-100 117-133M196 463c31-40 67-74 121-133M199 463c44-52 90-106 119-137M195 467c41-39 77-90 118-133M196 472c26-34 54-62 121-141M196 478c45-49 89-102 122-138M198 476c26-28 52-58 117-138M195 481c36-41 69-86 124-140M197 481c26-33 55-66 120-141M192 486c45-46 90-93 123-138M196 490c34-34 64-72 123-142M194 494c42-43 83-93 129-138M194 496c30-32 57-65 127-144M195 506c44-55 88-99 125-146M195 504l123-146M197 506c41-41 80-87 127-142M193 511c40-42 77-84 129-148M195 518c26-37 57-72 127-146M193 517c41-52 85-101 128-146M192 523c42-42 77-85 133-147M192 524c49-60 98-116 129-151M193 527c34-34 69-71 128-147M194 528c45-53 88-104 130-149M192 537c48-48 92-98 129-155M192 537c50-56 99-112 132-152M190 540c47-54 97-107 138-152M192 541c39-49 82-97 131-151M191 546c36-38 68-78 136-153M192 549c51-62 105-123 133-154M194 558c27-42 55-72 134-159M190 557c31-35 59-71 135-155M191 564c49-53 91-108 139-162M190 562l137-155M189 567l142-153M190 568c40-43 76-87 137-157M189 572c50-50 98-108 138-155M190 574l139-158M192 579c58-62 109-126 136-156M190 581c44-48 87-98 139-158M191 591c51-58 95-111 140-164M190 588c35-43 70-84 140-162M188 592c32-32 60-65 139-160M188 595l143-162M191 602c31-43 72-87 141-168M189 600c34-32 64-67 142-161M185 610c54-57 102-117 149-165M187 606c53-58 100-114 146-164M191 610c53-54 106-112 141-166M188 615c37-40 74-81 143-167M185 621c46-46 87-94 150-167M187 621c32-35 64-70 148-169M190 625c45-52 94-112 141-169M188 625c56-62 113-124 146-167M189 633l144-172M187 633c34-40 67-76 146-171M186 643c34-44 71-90 148-172M185 639c60-70 119-135 152-172M187 643c39-43 81-86 147-172M187 646c29-37 61-73 148-172M187 651c52-60 102-117 148-174M185 651l152-171M185 661c59-73 121-137 151-175M187 660c31-44 66-83 150-175M183 667c44-51 84-95 153-176M186 667c35-40 68-78 153-179M183 674c40-47 80-99 158-178M184 671c57-69 116-137 155-175M187 678c39-44 79-97 154-180M185 681c55-62 112-126 153-180M187 687c51-62 110-121 152-178M185 684c29-37 62-73 155-179M181 692c50-63 104-125 163-182M185 692l156-183M187 696c39-46 87-96 154-181M185 697c43-51 84-100 156-180M184 704c48-52 103-110 158-184M185 705c54-69 115-138 159-182M184 710c62-70 131-143 157-183M184 712c59-72 119-143 161-186M184 721c60-71 118-142 159-189M184 719c40-50 86-104 162-186M184 722c41-45 81-91 163-186M182 725c63-76 127-148 163-189M179 728c55-59 110-124 167-188M182 731c45-50 92-104 163-190M179 740c43-47 82-97 169-194M182 738l163-191M184 741c50-62 105-129 166-190M182 743c35-45 74-89 166-189M182 753c33-44 67-87 164-193M180 749c42-43 83-88 169-189M181 757c58-70 125-145 166-195M181 757l166-193M179 763c39-39 73-85 172-193M180 764l169-196M176 771c73-77 138-156 171-196M181 770c47-57 98-115 168-196M182 778c68-77 129-153 171-201M178 777c46-54 93-104 171-197M180 780c54-64 113-132 171-197M180 782c50-56 101-118 171-199M180 789c43-52 90-101 170-197M179 789c43-43 83-90 174-198M178 795c63-64 120-138 173-198M178 795c47-52 93-106 175-201M178 803c42-45 82-96 176-206M177 802c55-62 111-128 176-200M176 809c65-65 124-136 180-201M177 810l176-206M175 817c58-71 118-136 182-203M178 816c69-82 141-162 176-205M175 819c39-40 79-86 180-204M176 822c60-66 117-133 180-208M178 827c40-41 76-91 179-203M176 829c36-47 75-90 180-206M174 835c59-62 114-123 180-211M175 835c36-44 75-86 181-209M176 842c38-48 79-98 182-212M177 842c59-66 115-131 182-210M176 849c44-58 96-119 185-212M176 848c36-46 76-92 183-210M177 853c51-56 99-114 181-210M173 856c59-70 122-140 186-215M176 862c35-44 77-87 184-212M175 862c61-69 120-135 187-216M177 862c74-75 142-156 183-208M177 866c53-58 103-119 183-211M180 866c66-70 131-149 182-211M180 869c44-53 89-104 183-211M180 873c61-70 117-142 185-206M182 871c48-55 94-106 181-208M184 873c41-47 82-97 180-204M185 874c64-75 126-147 179-204M190 879c35-42 72-86 174-202M186 878c58-69 116-138 177-203M188 882c38-46 81-96 174-203M189 881c58-65 117-129 177-200M195 883c53-65 105-123 170-201M192 884c48-62 103-120 174-199M196 886c64-76 132-155 172-199M194 885c52-55 102-115 172-194M195 888c42-36 75-79 173-193M197 889c55-58 105-116 171-195M203 895c55-70 115-138 164-192M201 892c53-64 106-125 165-191M203 897c42-53 82-98 166-188M202 896c34-35 68-74 167-189M205 901c54-62 109-127 161-192M207 897c46-57 96-115 161-188M209 899c46-51 92-101 159-185M209 900c37-35 68-74 161-183M210 906c50-62 103-118 163-187M210 905c45-55 92-103 161-184M212 907c50-59 103-117 159-177M213 908c35-45 73-88 157-181M219 912c46-57 97-115 153-181M215 912c50-56 100-112 156-180M219 916c48-60 96-108 152-177M217 915c30-39 61-72 156-178M218 916c45-47 86-91 153-175M220 918c34-37 69-78 153-176M226 918l149-171M225 919c43-50 83-97 149-170M223 924c33-34 64-71 154-174M228 923c34-42 68-82 148-172M226 930c41-44 76-89 147-174M229 925c35-43 72-84 146-168M231 932l144-168M231 929c49-54 99-111 145-165M234 931c29-36 63-69 143-160M233 933l144-163M237 935c49-53 99-111 137-162M236 934c51-55 99-111 142-161M239 942c44-51 88-100 140-163M239 938l139-157M243 941c31-39 65-79 138-156M242 940l135-154M248 945c52-62 99-123 133-153M245 945l134-153M250 947c32-43 66-85 130-148M246 948c44-50 83-97 133-152M247 951c35-36 65-72 134-148M251 952c50-55 101-114 128-151M254 957c34-50 80-99 128-152M255 954c46-59 93-114 128-148M255 956c53-55 101-120 127-149M257 957c37-43 73-83 125-146M261 962c39-49 83-101 118-142M259 961l122-143M258 961c37-42 71-83 127-139M261 965c30-37 61-69 122-142M265 965c48-46 86-99 120-136M262 964c42-50 88-99 123-136M263 967c43-47 88-91 124-134M267 970c33-41 67-79 117-138M272 971c41-45 75-82 116-134M269 972c31-41 66-82 118-136M268 974c30-35 64-68 120-134M270 975l118-134M275 975c31-28 60-62 113-127M273 976c29-31 55-65 115-128M274 980c47-43 87-97 116-128M275 980c26-26 51-57 111-126"/>
        <path stroke="black" d="M272 980c39-30 68-66 119-121M273 982c49-46 92-93 114-126m1 0c-26-177-53-358-78-568m78 570c-18-155-40-312-78-569m3-1c-31-1-59 0-106-3m101 3c-29-2-59 0-101-1m-1 1c-10 204-24 410-31 575m32-576c-10 116-16 231-32 576m-2-1c27 25 44 44 105 120M175 865l98 117m2-2s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0"/>
      </g>
        <path fill="none" stroke={blade} strokeLinecap="round" strokeWidth="4" d="M271 610c1 44 6 217 6 261m-10-263 9 258"/>
      <g fillOpacity=".8" fillRule="evenodd" strokeLinecap="round" strokeOpacity=".8">
        <path fill="#dbc9f3" d="m320 484-4-4-5-3-4-3-4-2-5-2-4-1-5-1h-13l-4 1-5 2-4 2-5 3-4 3-5 4-133 117-5 4-2 2-2 2-2 2-2 2-1 3-1 3-19 127 10 7 10 8 10 7 9 8 8 8 8 8 7 8 7 9 6 9 6 9 5 9 4 9 5 10 3 9 4 10 2 10 15-3 8-2 7-1 7-1 6-1 7-1 6-1 6-1h6l6-1h16l4 1h5l-4-10-2-10-3-10-2-10-3-10-1-10-2-10-1-9-1-10v-10l-1-9v-19l1-10 1-9 1-9 1-10 1-9 2-9 2-9 2-9 3-10 3-9 2-9 4-9 3-9 3-9 4-9 4-9 4-9 9-19 2-3 2-4 1-4 1-5 2-4 1-5v-5l1-6v-23l-1-6-1-7-1-7-2-7"/>
        <path fill="none" stroke="black" strokeWidth="4" d="M320 484s0 0 0 0m0 0s0 0 0 0m0 0-4-4m4 4-4-4m0 0-5-3m5 3-5-3m0 0-4-3m4 3-4-3m0 0-4-2m4 2-4-2m0 0-5-2m5 2-5-2m0 0-4-1m4 1-4-1m0 0-5-1m5 1-5-1m0 0h-4m4 0h-4m0 0h-5m5 0h-5m0 0h-4m4 0h-4m0 0-4 1m4-1-4 1m0 0-5 2m5-2-5 2m0 0-4 2m4-2-4 2m0 0-5 3m5-3-5 3m0 0-4 3m4-3-4 3m0 0-5 4m5-4-5 4m0 0L116 600m133-117L116 600m0 0s0 0 0 0m0 0s0 0 0 0m0 0-5 4m5-4-5 4m0 0-2 2m2-2-2 2m0 0-2 2m2-2-2 2m0 0-2 2m2-2-2 2m0 0-2 2m2-2-2 2m0 0-1 3m1-3-1 3m0 0-1 3m1-3-1 3m0 0L82 745m19-127L82 745m0 0s0 0 0 0m0 0s0 0 0 0m0 0 10 7m-10-7 10 7m0 0 10 8m-10-8 10 8m0 0 10 7m-10-7 10 7m0 0 9 8m-9-8 9 8m0 0 8 8m-8-8 8 8m0 0 8 8m-8-8 8 8m0 0 7 8m-7-8 7 8m0 0 7 9m-7-9 7 9m0 0 6 9m-6-9 6 9m0 0 6 9m-6-9 6 9m0 0 5 9m-5-9 5 9m0 0 4 9m-4-9 4 9m0 0 5 10m-5-10 5 10m0 0 3 9m-3-9 3 9m0 0 4 10m-4-10 4 10m0 0 2 10m-2-10 2 10m0 0 15-3m-15 3 15-3m0 0 8-2m-8 2 8-2m0 0 7-1m-7 1 7-1m0 0 7-1m-7 1 7-1m0 0 6-1m-6 1 6-1m0 0 7-1m-7 1 7-1m0 0 6-1m-6 1 6-1m0 0 6-1m-6 1 6-1m0 0h6m-6 0h6m0 0 6-1m-6 1 6-1m0 0h5m-5 0h5m0 0h6m-6 0h6m0 0h5m-5 0h5m0 0 4 1m-4-1 4 1m0 0h5m-5 0h5m0 0-4-10m4 10-4-10m0 0-2-10m2 10-2-10m0 0-3-10m3 10-3-10m0 0-2-10m2 10-2-10m0 0-3-10m3 10-3-10m0 0-1-10m1 10-1-10m0 0-2-10m2 10-2-10m0 0-1-9m1 9-1-9m0 0-1-10m1 10-1-10m0 0v-10m0 10v-10m0 0-1-9m1 9-1-9m0 0v-10m0 10v-10m0 0v-9m0 9v-9m0 0 1-10m-1 10 1-10m0 0 1-9m-1 9 1-9m0 0 1-9m-1 9 1-9m0 0 1-10m-1 10 1-10m0 0 1-9m-1 9 1-9m0 0 2-9m-2 9 2-9m0 0 2-9m-2 9 2-9m0 0 2-9m-2 9 2-9m0 0 3-10m-3 10 3-10m0 0 3-9m-3 9 3-9m0 0 2-9m-2 9 2-9m0 0 4-9m-4 9 4-9m0 0 3-9m-3 9 3-9m0 0 3-9m-3 9 3-9m0 0 4-9m-4 9 4-9m0 0 4-9m-4 9 4-9m0 0 4-9m-4 9 4-9m0 0 9-19m-9 19 9-19m0 0 2-3m-2 3 2-3m0 0 2-4m-2 4 2-4m0 0 1-4m-1 4 1-4m0 0 1-5m-1 5 1-5m0 0 2-4m-2 4 2-4m0 0 1-5m-1 5 1-5m0 0v-5m0 5v-5m0 0 1-6m-1 6 1-6m0 0v-5m0 5v-5m0 0v-6m0 6v-6m0 0v-6m0 6v-6m0 0v-6m0 6v-6m0 0-1-6m1 6-1-6m0 0-1-7m1 7-1-7m0 0-1-7m1 7-1-7m0 0-2-7m2 7-2-7m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0"/>
      </g>
      <g fillOpacity=".8" fillRule="evenodd" strokeLinecap="round" strokeOpacity=".8">
        <path fill="#a887e8" d="m434 628 3 4 3 5 2 6 2 5 2 6 1 5 1 7v6l1 13 1 13 1 12 2 13 2 12 3 13 4 12 4 12 4 13 5 12 5 12 7 12 6 11 7 12 8 12 9 12 3 3 2 3 2 3 1 3 1 3 1 3 1 3v5l-1 3-1 2-1 3-1 3-1 2-4 5-61 100-4-9-4-8-4-8-4-8-4-7-5-7-4-7-5-7-4-6-5-6-5-6-5-6-5-5-5-5-5-4-6-5-5-4-6-4-6-4-5-3-6-3-6-3-6-3-6-2-7-2-6-2-7-2-6-1-7-2-7-1h-6l-7-1-4-10-3-10-2-10-3-9-2-10-2-10-1-10-2-9-1-10v-9l-1-10v-19l1-9v-9l1-10 1-9 2-9 1-9 2-10 2-9 3-9 2-9 3-9 3-9 4-9 3-9 4-10 4-9 5-9 4-9 5-9 2-5 2-5 2-5 2-5 1-5 1-5 1-6v-22l-1-6-1-5v-6l-3-12 114 144"/>
        <path fill="none" stroke="black" strokeWidth="4" d="M434 628s0 0 0 0m0 0s0 0 0 0m0 0 3 4m-3-4 3 4m0 0 3 5m-3-5 3 5m0 0 2 6m-2-6 2 6m0 0 2 5m-2-5 2 5m0 0 2 6m-2-6 2 6m0 0 1 5m-1-5 1 5m0 0 1 7m-1-7 1 7m0 0v6m0-6v6m0 0 1 13m-1-13 1 13m0 0 1 13m-1-13 1 13m0 0 1 12m-1-12 1 12m0 0 2 13m-2-13 2 13m0 0 2 12m-2-12 2 12m0 0 3 13m-3-13 3 13m0 0 4 12m-4-12 4 12m0 0 4 12m-4-12 4 12m0 0 4 13m-4-13 4 13m0 0 5 12m-5-12 5 12m0 0 5 12m-5-12 5 12m0 0 7 12m-7-12 7 12m0 0 6 11m-6-11 6 11m0 0 7 12m-7-12 7 12m0 0 8 12m-8-12 8 12m0 0 9 12m-9-12 9 12m0 0 3 3m-3-3 3 3m0 0 2 3m-2-3 2 3m0 0 2 3m-2-3 2 3m0 0 1 3m-1-3 1 3m0 0 1 3m-1-3 1 3m0 0 1 3m-1-3 1 3m0 0 1 3m-1-3 1 3m0 0v3m0-3v3m0 0v2m0-2v2m0 0-1 3m1-3-1 3m0 0-1 2m1-2-1 2m0 0-1 3m1-3-1 3m0 0-1 3m1-3-1 3m0 0-1 2m1-2-1 2m0 0-4 5m4-5-4 5m0 0-61 100m61-100-61 100m0 0s0 0 0 0m0 0s0 0 0 0m0 0-4-9m4 9-4-9m0 0-4-8m4 8-4-8m0 0-4-8m4 8-4-8m0 0-4-8m4 8-4-8m0 0-4-7m4 7-4-7m0 0-5-7m5 7-5-7m0 0-4-7m4 7-4-7m0 0-5-7m5 7-5-7m0 0-4-6m4 6-4-6m0 0-5-6m5 6-5-6m0 0-5-6m5 6-5-6m0 0-5-6m5 6-5-6m0 0-5-5m5 5-5-5m0 0-5-5m5 5-5-5m0 0-5-4m5 4-5-4m0 0-6-5m6 5-6-5m0 0-5-4m5 4-5-4m0 0-6-4m6 4-6-4m0 0-6-4m6 4-6-4m0 0-5-3m5 3-5-3m0 0-6-3m6 3-6-3m0 0-6-3m6 3-6-3m0 0-6-3m6 3-6-3m0 0-6-2m6 2-6-2m0 0-7-2m7 2-7-2m0 0-6-2m6 2-6-2m0 0-7-2m7 2-7-2m0 0-6-1m6 1-6-1m0 0-7-2m7 2-7-2m0 0-7-1m7 1-7-1m0 0h-6m6 0h-6m0 0-7-1m7 1-7-1m0 0-4-10m4 10-4-10m0 0-3-10m3 10-3-10m0 0-2-10m2 10-2-10m0 0-3-9m3 9-3-9m0 0-2-10m2 10-2-10m0 0-2-10m2 10-2-10m0 0-1-10m1 10-1-10m0 0-2-9m2 9-2-9m0 0-1-10m1 10-1-10m0 0v-9m0 9v-9m0 0-1-10m1 10-1-10m0 0v-9m0 9v-9m0 0v-10m0 10v-10m0 0 1-9m-1 9 1-9m0 0v-9m0 9v-9m0 0 1-10m-1 10 1-10m0 0 1-9m-1 9 1-9m0 0 2-9m-2 9 2-9m0 0 1-9m-1 9 1-9m0 0 2-10m-2 10 2-10m0 0 2-9m-2 9 2-9m0 0 3-9m-3 9 3-9m0 0 2-9m-2 9 2-9m0 0 3-9m-3 9 3-9m0 0 3-9m-3 9 3-9m0 0 4-9m-4 9 4-9m0 0 3-9m-3 9 3-9m0 0 4-10m-4 10 4-10m0 0 4-9m-4 9 4-9m0 0 5-9m-5 9 5-9m0 0 4-9m-4 9 4-9m0 0 5-9m-5 9 5-9m0 0 2-5m-2 5 2-5m0 0 2-5m-2 5 2-5m0 0 2-5m-2 5 2-5m0 0 2-5m-2 5 2-5m0 0 1-5m-1 5 1-5m0 0 1-5m-1 5 1-5m0 0 1-6m-1 6 1-6m0 0v-5m0 5v-5m0 0v-6m0 6v-6m0 0v-5m0 5v-5m0 0v-6m0 6v-6m0 0-1-6m1 6-1-6m0 0-1-5m1 5-1-5m0 0v-6m0 6v-6m0 0-3-12m3 12-3-12m0 0 114 144M320 484l114 144m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0"/>
      </g>
      <g fillOpacity=".8" fillRule="evenodd" strokeLinecap="round" strokeOpacity=".8">
        <path fill="#6342a0" d="m184 884 2 7 2 7 1 8 1 7 1 7 1 7v7l1 7v7l-1 7v7l-1 7v7l-1 7-3 13-3 13-4 14-5 12-5 13-6 13-6 12-6 13-8 12h14l14 1h14l14 1 13 1 14 2 13 2 14 1 13 3 13 2 13 3 13 3 13 4 12 4 13 4 12 5 7 2 6 2 6 1 6 1h5l5-1 6-1 4-2 5-3 5-3 4-4 4-4 2-3 1-2 2-3 2-3 2-4 1-3 2-4 1-4 25-85-5-11-4-11-6-10-5-10-6-9-6-9-6-8-6-8-7-8-7-7-7-6-7-6-8-6-8-5-8-5-8-4-9-4-9-3-9-3-9-2-10-2-10-2-10-1h-32l-11 1-12 2-11 1-12 3-12 3-13 3"/>
        <path fill="none" stroke="black" strokeWidth="4" d="M184 884s0 0 0 0m0 0s0 0 0 0m0 0 2 7m-2-7 2 7m0 0 2 7m-2-7 2 7m0 0 1 8m-1-8 1 8m0 0 1 7m-1-7 1 7m0 0 1 7m-1-7 1 7m0 0 1 7m-1-7 1 7m0 0v7m0-7v7m0 0 1 7m-1-7 1 7m0 0v7m0-7v7m0 0-1 7m1-7-1 7m0 0v7m0-7v7m0 0-1 7m1-7-1 7m0 0v7m0-7v7m0 0-1 7m1-7-1 7m0 0-3 13m3-13-3 13m0 0-3 13m3-13-3 13m0 0-4 14m4-14-4 14m0 0-5 12m5-12-5 12m0 0-5 13m5-13-5 13m0 0-6 13m6-13-6 13m0 0-6 12m6-12-6 12m0 0-6 13m6-13-6 13m0 0-8 12m8-12-8 12m0 0h14m-14 0h14m0 0 14 1m-14-1 14 1m0 0h14m-14 0h14m0 0 14 1m-14-1 14 1m0 0 13 1m-13-1 13 1m0 0 14 2m-14-2 14 2m0 0 13 2m-13-2 13 2m0 0 14 1m-14-1 14 1m0 0 13 3m-13-3 13 3m0 0 13 2m-13-2 13 2m0 0 13 3m-13-3 13 3m0 0 13 3m-13-3 13 3m0 0 13 4m-13-4 13 4m0 0 12 4m-12-4 12 4m0 0 13 4m-13-4 13 4m0 0 12 5m-12-5 12 5m0 0 7 2m-7-2 7 2m0 0 6 2m-6-2 6 2m0 0 6 1m-6-1 6 1m0 0 6 1m-6-1 6 1m0 0h5m-5 0h5m0 0 5-1m-5 1 5-1m0 0 6-1m-6 1 6-1m0 0 4-2m-4 2 4-2m0 0 5-3m-5 3 5-3m0 0 5-3m-5 3 5-3m0 0 4-4m-4 4 4-4m0 0 4-4m-4 4 4-4m0 0 2-3m-2 3 2-3m0 0 1-2m-1 2 1-2m0 0 2-3m-2 3 2-3m0 0 2-3m-2 3 2-3m0 0 2-4m-2 4 2-4m0 0 1-3m-1 3 1-3m0 0 2-4m-2 4 2-4m0 0 1-4m-1 4 1-4m0 0 25-85m-25 85 25-85m0 0s0 0 0 0m0 0s0 0 0 0m0 0-5-11m5 11-5-11m0 0-4-11m4 11-4-11m0 0-6-10m6 10-6-10m0 0-5-10m5 10-5-10m0 0-6-9m6 9-6-9m0 0-6-9m6 9-6-9m0 0-6-8m6 8-6-8m0 0-6-8m6 8-6-8m0 0-7-8m7 8-7-8m0 0-7-7m7 7-7-7m0 0-7-6m7 6-7-6m0 0-7-6m7 6-7-6m0 0-8-6m8 6-8-6m0 0-8-5m8 5-8-5m0 0-8-5m8 5-8-5m0 0-8-4m8 4-8-4m0 0-9-4m9 4-9-4m0 0-9-3m9 3-9-3m0 0-9-3m9 3-9-3m0 0-9-2m9 2-9-2m0 0-10-2m10 2-10-2m0 0-10-2m10 2-10-2m0 0-10-1m10 1-10-1m0 0h-10m10 0h-10m0 0h-11m11 0h-11m0 0h-11m11 0h-11m0 0-11 1m11-1-11 1m0 0-12 2m12-2-12 2m0 0-11 1m11-1-11 1m0 0-12 3m12-3-12 3m0 0-12 3m12-3-12 3m0 0-13 3m13-3-13 3m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0"/>
      </g>
      <g fillOpacity=".8" fillRule="evenodd" strokeLinecap="round" strokeOpacity=".8">
        <path fill="#390f8c" d="m82 745 13 9 6 5 6 4 6 5 5 5 6 5 5 5 5 6 5 5 5 6 5 6 4 6 4 6 4 6 4 6 3 6 4 7 3 6 2 7 3 7 2 7 2 7 2 7 1 6 2 7 1 7 2 6 1 7v7l1 6v33l-1 7-1 7-1 6-1 7-1 6-2 7-1 7-2 6-3 7-2 6-3 7-2 7-3 6-4 7-3 7-3 6-4 7-4 7-4 7-5 6L16 970l-3-4-4-3-2-4-3-4-1-4-2-5-1-4v-9l1-5v-5l2-5 2-5 2-6 3-5 3-6 69-151"/>
        <path fill="none" stroke="black" strokeWidth="4" d="M82 745s0 0 0 0m0 0s0 0 0 0m0 0 13 9m-13-9 13 9m0 0 6 5m-6-5 6 5m0 0 6 4m-6-4 6 4m0 0 6 5m-6-5 6 5m0 0 5 5m-5-5 5 5m0 0 6 5m-6-5 6 5m0 0 5 5m-5-5 5 5m0 0 5 6m-5-6 5 6m0 0 5 5m-5-5 5 5m0 0 5 6m-5-6 5 6m0 0 5 6m-5-6 5 6m0 0 4 6m-4-6 4 6m0 0 4 6m-4-6 4 6m0 0 4 6m-4-6 4 6m0 0 4 6m-4-6 4 6m0 0 3 6m-3-6 3 6m0 0 4 7m-4-7 4 7m0 0 3 6m-3-6 3 6m0 0 2 7m-2-7 2 7m0 0 3 7m-3-7 3 7m0 0 2 7m-2-7 2 7m0 0 2 7m-2-7 2 7m0 0 2 7m-2-7 2 7m0 0 1 6m-1-6 1 6m0 0 2 7m-2-7 2 7m0 0 1 7m-1-7 1 7m0 0 2 6m-2-6 2 6m0 0 1 7m-1-7 1 7m0 0v7m0-7v7m0 0 1 6m-1-6 1 6m0 0v7m0-7v7m0 0v7m0-7v7m0 0v6m0-6v6m0 0v7m0-7v7m0 0v6m0-6v6m0 0-1 7m1-7-1 7m0 0-1 7m1-7-1 7m0 0-1 6m1-6-1 6m0 0-1 7m1-7-1 7m0 0-1 6m1-6-1 6m0 0-2 7m2-7-2 7m0 0-1 7m1-7-1 7m0 0-2 6m2-6-2 6m0 0-3 7m3-7-3 7m0 0-2 6m2-6-2 6m0 0-3 7m3-7-3 7m0 0-2 7m2-7-2 7m0 0-3 6m3-6-3 6m0 0-4 7m4-7-4 7m0 0-3 7m3-7-3 7m0 0-3 6m3-6-3 6m0 0-4 7m4-7-4 7m0 0-4 7m4-7-4 7m0 0-4 7m4-7-4 7m0 0-5 6m5-6-5 6m0 0L16 970m128 126L16 970m0 0s0 0 0 0m0 0s0 0 0 0m0 0-3-4m3 4-3-4m0 0-4-3m4 3-4-3m0 0-2-4m2 4-2-4m0 0-3-4m3 4-3-4m0 0-1-4m1 4-1-4m0 0-2-5m2 5-2-5m0 0-1-4m1 4-1-4m0 0v-4m0 4v-4m0 0v-5m0 5v-5m0 0 1-5m-1 5 1-5m0 0v-5m0 5v-5m0 0 2-5m-2 5 2-5m0 0 2-5m-2 5 2-5m0 0 2-6m-2 6 2-6m0 0 3-5m-3 5 3-5m0 0 3-6m-3 6 3-6m0 0 69-151M13 896l69-151m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0"/>
      </g>
        <path fill="none" stroke="#CECDCC" strokeLinecap="round" strokeWidth="10" d="M86 746s0 0 0 0m0 0s0 0 0 0m0 0 11 8m-11-8 11 8m0 0 10 8m-10-8 10 8m0 0 10 9m-10-9 10 9m0 0 8 8m-8-8 8 8m0 0 8 8m-8-8 8 8m0 0 8 8m-8-8 8 8m0 0 6 9m-6-9 6 9m0 0 7 8m-7-8 7 8m0 0 5 8m-5-8 5 8m0 0 6 9m-6-9 6 9m0 0 4 8m-4-8 4 8m0 0 4 9m-4-9 4 9m0 0 4 9m-4-9 4 9m0 0 3 9m-3-9 3 9m0 0 3 9m-3-9 3 9m0 0 3 9m-3-9 3 9m0 0 7-2m-7 2 7-2m0 0 8-1m-8 1 8-1m0 0 7-2m-7 2 7-2m0 0 7-1m-7 1 7-1m0 0 7-1m-7 1 7-1m0 0 7-1m-7 1 7-1m0 0 7-1m-7 1 7-1m0 0 6-1m-6 1 6-1m0 0h6m-6 0h6m0 0 6-1m-6 1 6-1m0 0h6m-6 0h6m0 0 5-1m-5 1 5-1m0 0h5m-5 0h5m0 0h5m-5 0h5m0 0h4m-4 0h4m0 0h4m-4 0h4m0 0-3-11m3 11-3-11m0 0-3-10m3 10-3-10m0 0-3-10m3 10-3-10m0 0-3-10m3 10-3-10m0 0-2-10m2 10-2-10m0 0-2-10m2 10-2-10m0 0-1-10m1 10-1-10m0 0-2-9m2 9-2-9m0 0-1-10m1 10-1-10m0 0v-10m0 10v-10m0 0-1-9m1 9-1-9m0 0v-10m0 10v-10m0 0v-9m0 9v-9m0 0 1-9m-1 9 1-9m0 0 1-10m-1 10 1-10m0 0 1-9m-1 9 1-9m0 0 1-9m-1 9 1-9m0 0 1-10m-1 10 1-10m0 0 2-9m-2 9 2-9m0 0 2-9m-2 9 2-9m0 0 3-9m-3 9 3-9m0 0 2-9m-2 9 2-9m0 0 3-9m-3 9 3-9m0 0 3-9m-3 9 3-9m0 0 3-9m-3 9 3-9m0 0 4-9m-4 9 4-9m0 0 3-9m-3 9 3-9m0 0c2-2 3-5 4-9m-4 9 4-9m0 0 5-9m-5 9 5-9m0 0 4-8m-4 8 4-8m0 0 5-9m-5 9 5-9m0 0 4-11m-4 11 4-11m0 0 4-11m-4 11 4-11m0 0 4-10m-4 10 4-10m0 0 2-11m-2 11 2-11"/>
      <g fillRule="evenodd" strokeLinecap="round">
        <path fill="#FFF6F0" d="m153 288-19-25 21-20 199-5 23 21-24 28-201 3-4-4"/>
        <path fill="none" stroke="black" strokeWidth="4" d="M153 290c-4-9-13-13-20-29m19 25c-8-8-15-18-22-23m4-5c2-6 16-15 20-20m-23 22c10-7 18-16 27-22m-5 2 205-1m-203-2c57-1 114-4 201-2m2 3 24 23m-24-24c3 7 11 10 20 21m0 0c-8 6-9 21-24 24m25-20c-3 2-10 8-22 21m-1 4c-70-1-146 1-207 1m208-5c-64 2-131 3-205 3m-1 1s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0"/>
      </g>
        <path fill="none" stroke="#E6E6E5" strokeLinecap="round" strokeWidth="10" d="M455 1003s0 0 0 0m0 0s0 0 0 0m0 0-5-10m5 10-5-10m0 0-5-10m5 10-5-10m0 0-5-10m5 10-5-10m0 0-6-9m6 9-6-9m0 0-5-9m5 9-5-9m0 0-6-8m6 8-6-8m0 0-7-8m7 8-7-8m0 0-6-8m6 8-6-8m0 0-6-7m6 7-6-7m0 0-7-6m7 6-7-6m0 0-7-6m7 6-7-6m0 0-7-6m7 6-7-6m0 0-8-5m8 5-8-5m0 0-8-5m8 5-8-5m0 0-8-5m8 5-8-5m0 0-8-4m8 4-8-4m0 0-8-3m8 3-8-3m0 0-9-3m9 3-9-3m0 0-9-3m9 3-9-3m0 0-9-2m9 2-9-2m0 0-9-2m9 2-9-2m0 0-10-1m10 1-10-1m0 0-10-1m10 1-10-1m0 0h-10m10 0h-10m0 0h-10m10 0h-10m0 0h-11m11 0h-11m0 0-11 1m11-1-11 1m0 0-11 1m11-1-11 1m0 0-12 2m12-2-12 2m0 0-12 2m12-2-12 2m0 0-12 2m12-2-12 2m0 0-12 3m12-3-12 3m0 0 2 8m-2-8 2 8m0 0 1 7m-1-7 1 7m0 0 2 7m-2-7 2 7m0 0 1 7m-1-7 1 7m0 0 1 7m-1-7 1 7m0 0 1 7m-1-7 1 7m0 0v7m0-7v7m0 0v6m0-6v6m0 0v7m0-7v7m0 0v7m0-7v7m0 0v6m0-6v6m0 0v7m0-7v7m0 0-2 12m2-12-2 12m0 0-2 13m2-13-2 13m0 0-3 12m3-12-3 12m0 0-4 12m4-12-4 12m0 0-4 12m4-12-4 12m0 0-5 12m5-12-5 12m0 0-5 12m5-12-5 12m0 0-6 13m6-13-6 13m0 0-6 12m6-12-6 12m0 0-7 12m7-12-7 12"/>
        <path fill="none" stroke="#6d6d6d" strokeLinecap="round" strokeWidth="10" d="M185 883s0 0 0 0m0 0s0 0 0 0m0 0 3 14m-3-14 3 14m0 0 3 13m-3-13 3 13m0 0 1 13m-1-13 1 13m0 0 1 13m-1-13 1 13m0 0 1 13m-1-13 1 13m0 0-1 13m1-13-1 13m0 0-1 13m1-13-1 13m0 0-2 12m2-12-2 12m0 0-3 13m3-13-3 13m0 0-3 13m3-13-3 13m0 0-4 12m4-12-4 12m0 0-5 13m5-13-5 13m0 0-6 13m6-13-6 13m0 0-6 12m6-12-6 12m0 0-7 13m7-13-7 13m0 0-8 13m8-13-8 13"/>
      <g fillRule="evenodd" strokeLinecap="round">
        <path fill={decoration} d="m148 291-18-30 23-17 206-3 17 19-22 22-204 9v-5"/>
        <path fill="none" stroke="transparent" strokeWidth=".5" d="M153 289c-5-11-10-12-24-27m21 29c-3-9-9-16-20-30m-1 1c13-6 16-13 26-21m-22 20c5-6 14-14 25-20m-1 2c67-5 137-8 198-6m-199 2c67 3 132 3 203-1m2 1c3 6 15 17 19 19m-23-22c9 12 17 19 21 24m-2 0c-3 9-8 12-15 29m18-29-20 27m-4-1-206 4m209-5c-64 0-131 3-207 2m0 2s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0m0 0s0 0 0 0"/>
      </g>
        <path fill="none" stroke="black" strokeLinecap="round" strokeWidth="4" d="M153 284c-6-2-17-14-22-25m21 29-21-27m4-1c2-7 8-10 21-24m-26 24c8-7 17-12 27-22m-1 1c75-6 140-6 202-3m-201 1c41 4 81 3 202-2m-3-1c10 7 11 8 25 27m-23-23c5 3 8 9 19 24m-1 0c-8 6-10 19-21 23m25-27c-5 6-9 13-24 25m1 2c-64 1-132 2-206-1m207 0c-56 0-112-2-208 2m1 1s0 0 0 0m0 0s0 0 0 0"/>
      <g fillRule="evenodd" strokeLinecap="round">
        <path fill={bladeFillLight} d="M298 233c-2-10-12-36-12-60 1-24 8-62 13-84s13-37 17-48 7-13 7-16c-1-3-2-2-9-2-7-1-23 1-31-1-9-2-14-9-18-12l-11-6c-3 0 0 0-5 3s-17 12-26 15-19 2-25 2c-7 0-10-4-12-1-1 3 4 13 5 18 2 5 2 2 5 12l11 47 8 62c2 16 4 23 4 32 0 10-4 18-5 25 0 7 0 13 2 17s4 4 12 4l36-3 35-4"/>
        <path fill="none" stroke="black" strokeWidth="4" d="M297 236c-1-10-8-38-8-62s5-61 9-83 12-40 16-51c3-11 7-12 7-14-1-3-2-1-8-1-6-1-19-1-27-4-9-2-18-8-23-11s-6-7-8-8c-3 0-2 1-7 4s-14 12-23 15c-9 4-22 4-29 5-6 0-8-3-9-1s2 10 4 14l3 15c3 10 11 29 15 46l7 60c2 15 1 25 1 35l-1 26c0 7-3 14-1 17 2 2 6 0 14 0h34l35-2m1 0c-2-11-10-37-10-61-1-24 4-61 8-83 5-22 13-39 17-51 4-11 9-15 8-18 0-3-5 2-11 1l-24-3c-8-2-17-5-22-8-5-4-6-11-8-12-3-1-3 1-8 4-6 3-15 11-24 14-9 4-24 5-30 6s-7-4-8-1c-1 2 2 10 3 15l4 14 12 48c4 18 11 43 12 59 2 16-2 25-2 35l-1 26c0 8-1 16 1 18 2 3 4-2 12-2l36-1h34"/>
      </g>
      <g fillOpacity=".8" fillRule="evenodd" strokeLinecap="round" strokeOpacity=".8">
        <path fill={bladeFillLight} d="M293 232c-1-10-6-38-5-61 1-24 7-58 11-80 4-21 12-38 15-50 4-12 9-17 8-19-1-3-9 6-16 5-6 0-13-6-21-8s-20-2-25-4c-5-3-3-12-6-13s-6 5-11 8c-5 2-10 5-18 7s-26 3-32 5c-7 2-5 4-6 7l3 9c0 4-1 2 1 14 2 11 6 35 11 53 4 17 14 37 16 52 2 14-4 26-5 36 0 10 3 16 3 24s-5 21-3 24 9-4 17-5c9-2 20-2 31-2l35-1"/>
        <path fill="none" stroke="black" d="M298 234c-1-11-11-36-12-60 0-24 5-62 9-84s11-36 15-47 11-14 11-17c1-3-2 1-9 0l-31-8c-9-3-15-3-20-6-4-3-6-12-9-12s-1 6-6 9-14 8-23 11l-29 4c-6 1-7-1-8 1-1 3-1 10 1 14 1 5 5 3 8 13s5 30 9 48c3 17 9 41 11 57 2 17 2 30 2 40l-2 23c-1 7-3 15-1 18 3 2 7-1 14-1 8 0 21 3 32 2 12 0 29-6 35-6m1 6c-1-10-12-37-12-62a493 493 0 0 1 26-139c4-10 9-8 9-10-1-2-5-2-11-3s-19-1-27-3l-22-11c-4-3-1-6-3-7-2 0-3 3-8 5-6 3-16 11-25 13-8 2-18 0-24 0-6 1-11-1-12 1-1 3 4 11 6 16 2 4 2 0 4 11l8 52 7 56c2 16 2 30 2 41l-2 21c0 6 2 11 4 13 3 3 3 0 11 1l34 3 33 1"/>
      </g>
      <g fillOpacity=".8" fillRule="evenodd" strokeLinecap="round" strokeOpacity=".8">
        <path fill={grip} d="M298 233c-1-10-10-35-10-59 0-23 6-60 10-83 5-23 13-41 16-52l4-13c0-3 0-3-6-3-5-1-21 1-29-1-9-2-15-8-20-11l-11-8c-3-1 1-1-4 2l-25 13-27 9c-6 1-8-4-9-3-1 2 0 9 1 14s0 7 4 18c3 10 12 25 16 43 4 17 6 43 7 59 2 16 2 25 2 36l-2 28c-1 7-1 12 1 14s4-1 12-1l33 1 37-3"/>
        <path fill="none" stroke="black" strokeWidth="4" d="M297 235c-2-10-10-37-10-61-1-24 5-60 9-82 5-22 14-40 18-51s8-13 7-16c0-3-4-2-11-3-6 0-18 0-26-2s-17-7-22-10-6-7-8-7c-3-1-2 1-7 3-5 3-15 10-23 13-9 4-22 5-28 6-7 1-9-2-10 0s3 9 4 13l3 15c3 10 10 28 14 46s8 45 10 61v35l-2 25c0 7-3 14-1 17s6 1 13 1l33-2 37-1m-1-1c-3-10-11-35-11-59 1-24 9-62 14-85 4-23 12-40 15-51l6-17c-1-2-3 3-9 2a123 123 0 0 1-50-15c-5-3-3-7-5-7-3-1-3 1-8 4s-15 11-24 14-23 4-30 5c-6 1-8-3-8-1-1 2 3 9 4 14l3 14c3 10 11 30 15 48l8 61c1 16 0 25-1 35l-1 24c0 7-1 16 1 19s4-1 11-2l34 1 37-3"/>
      </g>
      <g strokeLinecap="round">
        <path fill={decoration} d="M256 36c3 0 6 2 8 5s4 9 4 13l-3 12c-2 4-5 7-8 8s-6 1-8-1c-3-2-6-6-7-10s-2-9-1-13 4-8 6-10c2-3 7-4 8-4 2-1 1 1 1 1m1-1c3 0 6 4 8 7l3 12c0 5-2 10-4 13-1 3-4 6-7 7-3 0-8-1-10-4-3-2-5-6-5-10V48c1-4 4-8 6-10 3-2 7-2 9-2v1"/>
        <path fill="none" stroke="black" strokeWidth="4" d="M252 37c2-1 7-1 9 1l5 10c1 4 2 9 1 13s-4 8-6 11c-3 2-6 3-8 2-3 0-7-3-9-6s-3-8-3-12c-1-4 1-10 3-13s7-5 8-6v-1m0 0c2-1 6 0 9 2 2 2 5 6 6 10v14c-1 4-4 7-6 9-3 2-6 4-9 3-3 0-6-3-8-7-2-3-4-8-4-12s2-9 4-12l8-7v1"/>
      </g>
      <g fillRule="evenodd" strokeLinecap="round">
        <path fill="hsla(30, 2%, 62%, 1)" d="m275 624-12-21c-4-9-7-22-12-30s-12-12-19-18l-23-19c-6-4-10-2-12-5-2-4 0-5 0-16l4-53 8-154c2-28-1-14 2-16s8 3 16 3c7 0 25-6 30-3s-3-3-2 22l7 125 9 187"/>
        <path fill="none" stroke="black" strokeWidth="4" d="m273 626-9-24c-4-9-6-18-11-26l-21-23-23-14c-5-4-9-4-11-7-2-4-2-2-2-14l3-57 9-154c1-28-1-11 2-13 3-3 11 0 18 0 8-1 25-5 29-2s-3-5-2 19l7 127 12 187m0 0-11-25c-4-9-6-18-11-26-5-7-13-14-21-20-7-6-18-11-23-15-6-3-7-1-9-5s-2-5-2-17c-1-12-1-21 1-56l11-152c3-28-1-14 2-16s10 2 17 2c8-1 24-6 28-4 4 3-2-5-1 19l6 127 14 188"/>
      </g>
      <g fill="none" fillRule="evenodd" strokeLinecap="round">
        <path stroke={blade} strokeWidth=".3" d="M208 292s0 0 0 0m0 0s0 0 0 0m0 3 1-1m-1 1 1-1m-1 5 2-4m-3 4 3-4m-3 5c2 0 2-3 7-6m-6 7c0-2 3-3 5-6m-8 12c4-5 5-8 13-14m-11 12c3-5 6-8 9-10m-11 11c3 3 8-2 12-11m-10 13 11-15m-14 16c5-9 13-9 16-17m-11 19c1-5 6-8 13-15m-13 17c3-2 8-15 16-22m-19 22 18-17m-17 20 20-19m-18 22c4-10 12-18 19-26m-18 30c0-12 13-21 17-33m-19 29c6-6 9-13 20-24m-18 29c7-7 10-19 19-31m-23 30c8-8 18-19 25-29m-25 34c13-16 18-21 32-31m-31 31c6-12 16-20 27-35m-28 41c11-11 11-20 33-40m-34 36 35-36m-36 37c18-13 30-31 39-40m-37 42c9-9 21-21 33-40m-36 41c20-9 29-31 42-44m-40 48c11-11 21-21 38-43m-41 45c13-11 21-22 48-44m-44 43 41-45m-42 52c12-20 34-34 46-52m-47 49c13-13 27-25 46-49m-46 54c9-18 21-31 51-52m-48 51 46-55m-46 60c15-16 25-38 44-62m-48 59c14-15 30-30 50-56m-47 63c12-15 23-27 46-63m-47 61 50-59m-48 64c19-26 40-50 50-61m-53 58 54-62m-52 69c15-21 37-46 48-61m-49 58 54-63m-54 68c15-20 30-40 51-61m-50 59c16-23 35-44 50-59m-51 64c11-14 24-27 48-59m-48 57 51-62m-55 65c16-13 24-25 57-57m-55 57c12-11 22-27 53-60m-50 61c21-18 40-42 54-60m-56 61 54-59m-55 60c20-11 35-28 51-60m-49 63c16-18 30-39 50-62m-52 63c13-16 30-27 51-62m-51 65c14-19 29-33 53-61m-55 60c18-13 30-25 59-56m-57 60c12-13 28-30 53-62m-56 63c27-18 46-44 60-62m-59 64c17-14 33-31 58-61m-52 66c20-27 41-51 54-68m-56 65c8-14 24-26 52-60m-54 62c19-16 34-31 58-60m-59 62 56-63m-55 70c15-26 32-41 51-67m-52 63c21-22 42-47 57-60m-53 65c12-15 21-26 48-67m-50 65c11-15 22-28 54-60m-54 64c12-20 33-39 51-60m-53 61c17-20 36-44 57-65m-59 66c15-11 23-23 56-65m-52 68c11-18 25-32 54-65m-54 69c20-25 39-41 51-64m-51 63c17-20 35-41 55-67m-58 68c23-21 43-45 59-66m-58 66c15-19 30-37 57-65m-55 72c18-21 37-44 54-69m-56 68 55-65m-57 68c20-24 41-45 59-63m-57 60c19-21 36-39 56-65m-55 68c14-17 28-26 58-65m-61 66 57-65m-54 69c17-16 26-33 57-68m-59 66c18-22 40-43 58-64m-55 72c12-15 19-34 57-72m-61 71 60-68m-61 67c23-20 43-41 61-61m-60 62c18-19 34-37 58-67m-59 70c14-18 35-35 64-66m-64 68c24-27 43-48 58-67m-55 67c20-23 46-52 54-63m-54 67c19-26 37-45 58-68m-57 73c11-20 33-44 56-72m-58 68c14-17 31-32 59-67m-61 71c20-16 41-36 60-69m-57 71c21-27 41-50 59-68m-57 73c18-22 30-41 59-72m-61 69 60-70m-59 73c11-20 28-36 57-71m-61 73c21-23 40-44 62-72m-58 74c12-18 32-40 56-67m-58 66c15-19 32-37 57-70m-56 72 56-67m-59 70 61-70m-63 76c26-29 50-63 60-77m-56 74 61-72m-64 77c15-20 36-36 64-77m-62 73c22-26 49-52 62-71m-62 77c15-15 27-38 59-75m-60 73 62-71m-60 75c17-20 30-33 57-74m-60 73c15-15 33-33 64-71m-65 78c14-21 30-42 67-75m-64 71c16-15 29-33 60-70m-62 78c21-28 33-46 60-79m-61 74c23-23 42-49 63-71m-65 78c24-33 47-53 70-75m-66 71c26-27 53-57 61-73m-63 76c24-21 39-47 61-69m-60 69 64-72m-65 74c13-15 30-35 64-68m-63 70c19-19 35-37 65-71m-64 73c24-21 41-48 60-71m-63 71c25-29 50-56 65-71m-62 73c19-18 35-39 60-74m-62 76c15-19 33-39 64-71m-66 78c18-27 41-43 71-73m-69 71c26-29 53-58 64-74m-62 80c17-28 37-51 66-78m-68 76c15-17 25-32 66-78m-68 80c22-17 34-37 64-75m-63 73 67-71m-69 75c23-26 49-48 66-73m-64 74c12-15 26-32 66-77m-68 79c20-16 30-33 68-75m-64 76 65-77m-70 84c19-15 29-35 73-79m-71 77c26-32 51-57 70-79m-71 82c24-20 36-44 73-77m-71 76c21-28 47-54 69-77m-68 82c17-26 38-50 66-76m-67 75c16-23 35-40 67-78m-64 79c19-22 43-49 69-76m-73 76 69-76m-70 83c27-31 53-60 69-81m-67 80c19-22 34-43 67-78m-65 83c16-24 36-46 69-83m-72 79c20-24 41-51 70-76m-68 81c25-35 55-64 64-79m-65 75c27-29 54-56 67-75m-64 79c21-31 41-51 63-81m-65 80c17-17 33-31 69-74m-70 79c19-21 29-36 66-80m-64 79 65-76m-60 79c12-22 35-42 63-79m-64 74 65-73m-61 77c19-27 35-47 59-72m-63 73c23-28 43-52 65-76m-61 75c11-22 34-43 58-72m-62 71c20-18 36-39 64-68m-63 68 62-65m-60 68c11-16 26-33 59-70m-59 69c16-14 28-29 57-67m-53 70 57-68m-53 72c11-25 23-35 51-71m-56 67c15-19 33-37 56-66m-50 70c20-30 39-55 52-64m-55 62 55-65m-50 66c12-17 25-27 46-65m-50 64c20-24 36-46 54-60m-52 59c20-16 37-33 56-60m-58 60c18-18 32-35 52-57m-49 60 52-58m-50 57c14-15 26-32 47-57m-44 61c9-19 25-29 43-56m-46 52c19-19 34-35 49-55m-47 57c10-7 16-24 44-51m-44 51c16-15 29-34 46-52m-47 54c12-17 27-30 49-55m-46 54c10-13 23-26 45-51m-47 56c19-25 39-40 44-52m-40 50c18-22 34-40 43-53m-41 52c5-11 19-22 43-44m-45 44c11-10 20-22 42-47m-41 49c14-10 21-18 44-51m-42 50 43-48m-39 50 37-47m-38 48c8-14 18-22 40-46m-39 50c4-9 15-25 35-48m-35 43c10-13 23-26 38-41m-33 45c12-23 30-32 31-47m-35 44c14-14 28-31 36-41m-36 43c9-13 24-22 39-42m-37 41c11-14 26-25 33-39m-30 46c8-13 18-24 34-40m-36 37 33-39m-33 43c18-22 24-32 35-44m-35 40c9-8 19-16 35-36m-29 35c3-3 12-19 29-30m-34 31c13-9 22-20 36-33m-33 40c11-12 24-31 31-40m-31 39c8-12 18-20 29-38m-24 40c3-10 13-19 26-39m-28 35c3-5 13-14 29-31m-27 37c11-13 18-26 27-36m-30 33 28-33m-24 30c9-8 20-15 21-28m-23 33c7-8 14-14 28-31m-25 33c7-10 8-18 24-29m-26 27 25-30m-23 30c11-9 15-19 20-30m-18 32c4-8 11-13 22-28m-24 27c13-8 21-19 24-25m-24 26c10-6 18-17 25-26m-26 25c10-7 18-8 23-18m-20 23c9-9 17-20 23-27m-20 28c10-12 14-19 20-24m-21 23c6-4 8-10 21-24m-20 23c7 0 12-9 16-17m-17 19c8-6 16-16 20-20m-14 20c3 1 2-8 12-17m-14 20c5-7 8-12 18-21m-21 26c10-10 14-16 19-26m-15 21c4-6 12-12 15-17m-14 21c3-6 9-11 13-19m-13 18c3-6 11-14 15-19m-15 24c0-6 5-15 14-21m-16 17c7-6 13-14 17-19m-13 22c1-5 8-11 16-17m-19 18c4-4 8-7 15-16m-12 16c7-1 10-7 17-19m-16 19c5-7 10-10 14-15m-15 20c5-5 3-10 16-19m-15 17 14-17m-15 21c6-4 10-11 13-14m-12 14c4-4 7-7 12-16m-11 16c5-7 11-9 9-17m-10 17c6-5 9-9 16-12m-10 13c-4-2 4-4 8-10m-12 13 11-15m-11 13c2-4 9-3 13-10m-11 11 9-12m-9 14c0-1 5-1 13-14m-14 17c5-6 5-8 12-12m-13 11 15-9m-12 9 11-11m-10 17c2-9 6-13 8-16m-9 13 10-10m-9 13 10-12m-9 11 8-10m-9 11c3-3 8-4 8-9m-7 11 9-10m-6 13c-2-3 1-4 7-9m-10 7c4-2 6-3 9-8m-8 10c5-1 6-4 7-6m-6 6 6-7m-4 8c0 2 2-1 4-3m-6 5 6-5m-5 6c2 0 3-2 5-4m-4 4 4-4m-3 8 3-5m-3 4 4-4m-3 7 2-4m-3 4 3-5m-2 6 3-3m-3 3 3-3m-2 5 1-2m-1 2 2-2m-1 4 1-1m-1 1 1-1"/>
        <path stroke="transparent" strokeWidth=".5" d="m275 627-11-23c-4-9-10-23-15-31s-10-11-17-17l-24-19c-6-3-8 2-10-1-2-4-3-7-3-19l3-56 10-153c2-27-4-11 0-14 3-2 15-1 22-1 8 0 19-3 23-1 5 3 1-6 2 18l8 131 11 184m-2 1-9-26c-3-8-3-18-8-25-6-7-16-10-23-16s-14-18-19-22c-6-4-10 1-12-2-3-4-3-9-4-21-1-13-4-20-2-54 1-35 7-127 9-155s0-10 4-12c5-2 16 2 24 2 8-1 22-8 25-4 4 3-2 0-1 25 0 25 2 74 6 125 3 52 12 152 13 183"/>
      </g>
        <path fill="none" stroke="black" strokeLinecap="round" strokeWidth="4" d="m275 627-13-26c-4-9-5-17-10-25s-12-15-19-21l-23-15c-6-3-9-3-11-7-3-4-3-4-3-16l4-55 8-154c1-28-1-12 3-14 3-3 10 0 18 0 7 0 23-5 28-2 4 4-1-3 0 21l6 127 12 186m-1 0-10-24c-3-9-8-20-13-28s-11-13-18-19l-25-18c-5-3-6-2-8-5s-3-1-3-13c-1-12 0-22 2-57l10-155c2-28-4-12-1-14 4-2 13 1 20 2 8 0 22-3 27 0s1-7 2 18l5 126c3 52 12 155 13 186"/>
      <g fillRule="evenodd" strokeLinecap="round">
        <path fill={bladeFillLight} d="M273 611c1-4 5-21 9-31 5-10 12-22 18-29 6-8 11-12 18-18 7-5 20-9 24-15 3-5 0 13-5-17l-24-161c-4-31-4-17-5-23-1-7 1-12 1-17-1-4-2-9-4-10s-4 4-8 4l-17-2-15 1c-5 0-11 1-12 3s5 2 6 9c0 6-4-7-2 31 1 38 10 160 12 198l1 31 3 45"/>
        <path fill="none" stroke="black" strokeWidth="4" d="M270 610c2-5 6-21 11-30 5-10 11-21 17-29l22-18c7-6 18-8 21-14 2-6 2 9-3-21l-25-158-4-25v-14c-1-3-2-7-4-9s-5-1-9-1l-16 2-13 1c-5 0-9-2-11 0-1 2 2 5 2 12 0 8-2-6 0 32l9 197 2 28 2 47m1 2c1-6 4-24 8-34s10-18 17-26 17-16 24-22c6-5 15-6 18-11s5 12 0-18l-25-163c-5-31-1-18-2-23l-5-12c-1-4 0-10-2-12-1-2-5 0-9 1l-17 1h-12c-4 0-10-2-11 1-2 2 2 4 3 11 0 8-2-7 0 31l10 199c2 38-1 16-1 28l1 47"/>
      </g>
      <g fill="none" fillRule="evenodd" strokeLinecap="round">
        <path stroke={blade} strokeWidth=".5" d="m254 299 7-5m-7 5 7-5m-4 8 4-8m-4 8 4-8m-7 11c4-4 6-4 12-11m-12 11 12-11m-9 13c4-2 4-6 9-13m-9 13 9-13m-11 17c2-5 8-9 17-17m-17 17 17-17m-14 19 14-19m-14 19 14-19m-17 22 23-23m-23 23 23-23m-20 26 20-26m-20 26 20-26m-23 30c10-13 21-22 28-29m-28 29c8-11 17-19 28-29m-25 31c7-9 18-20 25-31m-25 31 25-31m-28 34 33-35m-33 35 33-35m-30 38c9-11 18-20 30-38m-30 38 30-38m-32 41 38-41m-38 41 38-41m-35 43c13-14 27-30 35-43m-35 43 35-43m-38 46c9-10 21-25 44-47m-44 47 44-47m-41 50c11-16 24-32 41-50m-41 50 41-50m-43 53c16-16 32-33 46-51m-46 51c12-16 28-30 46-51m-43 54 43-54m-43 54c9-13 19-24 43-54m-46 57c21-21 37-42 51-56m-51 56 51-56m-48 58c11-12 23-26 48-58m-48 58 48-58m-51 62 53-58m-53 58c14-14 25-29 53-58m-50 61c17-23 38-42 50-61m-50 61 50-61m-53 64 53-59m-53 59c20-21 39-41 53-59m-50 61c16-15 29-35 50-61m-50 61 50-61m-53 64 54-58m-54 58c13-12 24-26 54-58m-51 61 51-61m-51 61 51-61m-53 64c18-21 39-39 54-59m-54 59c20-21 39-41 54-59m-51 62c15-20 33-42 51-62m-51 62c18-23 35-45 51-62m-54 65 54-59m-54 59c17-21 35-41 54-59m-51 61c18-20 34-39 51-61m-51 61 51-61m-53 64c14-17 30-31 54-59m-54 59 54-59m-51 62 51-62m-51 62 51-62m-55 66c22-21 40-43 56-61m-56 61 56-61m-53 63c18-19 34-38 53-63m-53 63 53-63m-55 66 55-60m-55 60c20-24 42-48 55-60m-52 63c12-18 27-32 52-63m-52 63 52-63m-55 66 55-61m-55 61c15-17 33-35 55-61m-52 64c15-18 32-36 52-64m-52 64 52-64m-54 67c16-16 30-34 56-62m-56 62 56-62m-53 64c15-16 26-31 53-64m-53 64c12-14 23-30 53-64m-56 67c17-15 33-32 57-62m-57 62 57-62m-54 65c16-23 35-44 54-65m-54 65 54-65m-57 68c23-24 47-48 58-63m-58 63c18-18 35-38 58-63m-55 66c12-16 26-31 55-66m-55 66 55-66m-58 69c16-14 31-34 58-63m-58 63c15-18 31-34 58-63m-55 66 55-66m-55 66c12-13 24-27 55-66m-58 69c21-22 44-46 59-64m-59 64 59-64m-56 67c20-27 40-49 56-67m-56 67 56-67m-58 70 59-65m-59 65c14-16 28-33 59-65m-56 67c21-26 43-55 56-67m-56 67c15-20 33-40 56-67m-59 70 59-65m-59 65c23-23 44-49 59-65m-56 68 56-68m-56 68c13-14 25-29 56-68m-58 71c22-23 44-46 60-66m-60 66 60-66m-57 69c16-18 29-38 57-69m-57 69c17-23 36-44 57-69m-60 72c12-15 26-28 61-67m-61 67c12-15 26-28 61-67m-58 69 58-69m-58 69 58-69m-61 73c13-16 30-35 61-67m-61 67 61-67m-58 70c20-22 39-48 58-70m-58 70c20-24 38-48 58-70m-61 73c17-23 37-45 62-68m-62 68c18-18 34-37 62-68m-59 70 59-70m-59 70 59-70m-61 73c22-22 44-46 62-69m-62 69c16-17 33-35 62-69m-59 72 59-72m-59 72c13-18 27-34 59-72m-62 75c21-24 42-43 62-69m-62 69c23-26 46-53 62-69m-59 72 59-72m-59 72 59-72m-62 75c21-21 40-46 64-70m-64 70c14-14 27-28 64-70m-61 72c15-15 28-30 61-72m-61 72 61-72m-63 75c15-16 30-31 64-70m-64 70 64-70m-61 73 61-73m-61 73 61-73m-65 77 66-72m-66 72 66-72m-62 74c17-20 34-43 62-74m-62 74c20-22 39-46 62-74m-65 77 65-72m-65 72 65-72m-62 75 62-75m-62 75 62-75m-65 78c19-18 33-39 66-73m-66 73 66-73m-63 76c19-20 38-42 63-76m-63 76 63-76m-65 79c22-23 45-48 66-74m-66 74 66-74m-63 76c23-26 43-51 63-76m-63 76 63-76m-66 79c20-20 36-41 67-73m-67 73 67-73m-64 76c18-22 37-42 64-76m-64 76c18-19 33-40 64-76m-67 79 68-74m-68 74 68-74m-65 76c13-16 28-31 65-76m-65 76 65-76m-68 80 69-75m-69 75 69-75m-66 78c26-33 50-64 66-78m-66 78 66-78m-68 81c19-24 37-43 68-76m-68 76 68-76m-65 78c12-16 27-35 65-78m-65 78 65-78m-68 82c15-15 28-34 69-77m-69 77 69-77m-66 79 66-79m-66 79 66-79m-69 82c23-27 49-53 70-77m-70 77 70-77m-67 80c16-19 33-42 67-80m-67 80 67-80m-69 83 70-77m-70 77c23-26 47-50 70-77m-67 79c12-17 28-32 67-79m-67 79 67-79m-70 82 71-77m-71 77c17-15 32-32 71-77m-68 80c14-16 29-32 68-80m-68 80c16-17 30-36 68-80m-71 84c17-22 34-40 72-80m-72 80c20-24 42-48 72-80m-69 82c16-22 35-42 69-82m-69 82 69-82m-72 85 73-80m-73 80c20-19 37-40 73-80m-70 83c27-28 50-60 70-83m-70 83c16-18 30-38 70-83m-72 86c19-21 39-41 72-80m-72 80c15-19 34-38 72-80m-69 83c24-28 51-58 69-83m-69 83 69-83m-72 86c19-21 38-46 73-81m-73 81 73-81m-70 83 70-83m-70 83 70-83m-73 86c9-7 13-13 32-33m-32 33c14-13 25-26 32-33m-28 36c11-11 18-24 28-36m-28 36 28-36m-1-1 43-47m-43 47c12-15 25-29 43-47m-40 49c13-13 20-25 40-49m-40 49c7-10 15-20 40-49m-73 87c2-5 9-7 13-12m-13 12 13-12m-10 15c1-4 6-10 10-15m-10 15c4-6 6-11 10-15m39-48c7-5 12-13 22-22m-22 22 22-22m-19 24c9-6 12-17 19-24m-19 24c7-7 13-16 19-24m-74 88 10-8m-10 8 10-8m-7 11c2-3 3-7 7-11m-7 11 7-11m53-65 12-10m-12 10 12-10m-9 13c4-4 6-8 9-13m-9 13 9-13m-75 89 7-5m-7 5 7-5m-4 8 4-8m-4 8 4-8m-7 11 4-1m-4 1 4-1m-1 3 1-3m-1 3 1-3"/>
        <path stroke="transparent" d="M271 612c2-5 5-23 10-32 4-10 11-18 17-26l22-22c7-6 17-7 20-13 3-5 3 11-1-19l-27-159c-5-31 0-19-1-26l-4-13c-1-3 1-8-1-10-2-1-5 1-10 2l-16-1-13 2c-4 0-9-3-11-1-1 3 1 7 1 14s-2-9 0 29l10 200 2 25 1 49m-1 1c2-5 6-21 11-31 4-10 11-21 17-29 7-8 16-13 23-19 8-5 19-8 22-13 4-6 3 9-2-21l-28-160c-5-31-1-18-2-24l-2-10c0-4 1-8-1-10s-6 0-10 0l-18-2-12 1c-4 0-9-2-11 0s1 7 2 14c0 7-2-9 0 30l8 200c2 38 1 12 2 24l4 49"/>
      </g>
        <path fill="none" stroke="black" strokeLinecap="round" strokeWidth="4" d="m270 610 10-30a129 129 0 0 1 39-49c8-6 18-7 21-12s2 10-3-20l-24-160c-5-31-4-18-5-25l-1-13c0-4 1-7-1-8-2-2-6-1-10-1h-16l-14 1c-4 1-9-1-11 1s0 4 1 11l1 32 10 198 1 27 3 48m1 2c2-5 3-24 7-33 5-10 11-18 18-26 6-8 16-16 23-21 7-6 16-7 19-13 3-5 3 8-1-21l-24-157c-5-31-2-21-3-27-2-7-5-8-6-11 0-4 4-9 2-11-1-1-6 1-11 1l-17-1h-12c-4 1-11 0-13 3-2 2 1 5 2 13l2 31 8 196c2 37 3 14 4 27v48"/>
      <g fillRule="evenodd" strokeLinecap="round">
        <path fill={grip} d="m273 624-10-21c-4-8-7-18-12-26s-11-17-19-23c-7-5-21-9-27-12-5-4-5-5-7-9-2-3-5-1-5-13 0-11 3-22 5-57l6-153c2-28 1-14 5-17s10-1 17 0c8 0 25 0 29 3 5 3-1-7 0 16l4 127c3 53 8 159 11 189"/>
        <path fill="none" stroke="black" strokeWidth="4" d="m272 627-11-25c-4-8-6-19-11-26-5-8-12-14-19-20s-18-13-24-16c-6-4-7-3-9-7-3-3-4-4-4-15l3-56 10-153c2-27-2-12 2-14 3-3 11 0 19 0s23-4 27-1c5 3-1-4-1 20l6 125 12 187m-2 1-10-23c-4-9-6-19-11-27s-11-14-18-20c-6-6-16-13-22-17-6-3-11-1-13-4-3-4-2-4-2-16l2-59 9-153c3-28 1-12 5-14 3-2 11 2 19 2 7 0 21-6 25-3 5 3 0-4 1 20 0 25 1 77 4 129l13 184"/>
      </g>
      <g fill="none" fillRule="evenodd" strokeLinecap="round">
        <path stroke={blade} strokeWidth=".3" d="M207 292s0 0 0 0m0 0s0 0 0 0m1 3v-1m0 1s0 0 0 0m0 4c0-1 0-2 2-3m-3 3 3-3m-4 5c1-1 6-2 7-6m-5 7c0-2 2-3 4-6m-4 8c1-4 5-6 7-11m-9 12c4-2 5-5 10-9m-11 16c2-6 7-13 10-14m-9 9c2-3 9-7 11-13m-9 17c2-3 9-12 17-13m-19 13c8-7 11-11 13-16m-16 19 24-17m-21 17c8-6 13-13 19-19m-16 23c1-6 7-13 15-24m-17 23c4-5 10-15 18-23m-23 32c7-13 13-22 30-31m-26 28c7-10 12-18 23-28m-25 28c14-8 20-23 30-27m-28 30c7-12 19-20 28-32m-27 31c7-9 22-24 25-33m-25 38c10-17 22-28 28-37m-29 35c10-4 17-11 31-30m-33 34c12-12 21-23 32-38m-33 40c17-9 26-28 35-37m-34 39c12-12 17-19 34-43m-30 46c10-11 23-28 37-48m-39 46 38-43m-42 44c12-10 22-16 46-42m-42 43c10-9 22-22 40-45m-44 51c14-11 31-26 48-54m-44 52c10-15 25-29 44-48m-44 54c12-15 24-27 43-55m-43 55 44-56m-47 58c21-18 42-45 49-60m-46 61c12-17 27-35 47-58m-46 59c14-17 28-37 50-55m-51 56c14-18 29-38 51-58m-53 62c15-19 29-37 52-60m-50 57c17-16 31-35 53-59m-53 63c20-19 37-40 48-58m-49 59c21-26 42-49 53-59m-53 60c8-13 19-28 54-61m-54 63 53-61m-53 66 47-64m-48 63 54-62m-54 66c23-25 38-48 52-59m-54 60c13-13 23-26 53-64m-54 66c12-16 30-30 56-62m-55 63c17-15 30-34 53-62m-52 65c16-23 27-39 51-64m-52 62c20-22 42-45 53-61m-52 63c10-16 31-35 55-63m-57 66c12-12 24-25 57-64m-55 63c21-13 36-40 53-57m-54 62c15-15 27-30 54-65m-55 67c24-18 41-38 58-60m-56 61 52-66m-54 63c20-18 45-44 59-58m-59 64c17-19 34-35 56-66m-56 67c20-19 42-46 54-61m-51 60c12-17 30-33 52-59m-55 64c19-17 31-33 60-66m-58 67c15-21 34-42 53-65m-56 69c21-31 47-52 61-65m-59 61 57-60m-56 63c24-24 40-45 53-65m-55 67c14-15 26-27 55-65m-53 68c15-21 36-42 55-62m-55 64c14-18 32-39 56-65m-54 67c14-15 24-32 49-62m-52 62 55-65m-58 66c17-22 36-38 57-61m-53 64c21-24 42-50 54-67m-54 70c13-15 25-35 56-63m-57 62 57-64m-60 70c15-22 38-41 55-70m-54 68c15-18 34-36 57-65m-59 64c13-13 29-28 59-63m-56 69c18-24 36-42 56-67m-60 64c21-18 45-42 61-65m-56 70c16-22 29-37 55-67m-54 68c14-17 30-32 54-64m-57 66c14-14 28-32 60-67m-62 68c16-18 32-34 57-66m-55 65c16-15 32-32 58-63m-58 71c13-21 34-44 60-66m-61 63c23-24 44-52 60-66m-57 69c8-19 29-31 58-68m-58 67c17-18 32-41 56-66m-61 68c15-12 33-27 60-65m-57 68c16-14 31-34 59-67m-55 71c9-19 24-31 59-69m-61 70c14-21 30-36 57-69m-58 74c17-24 34-41 56-73m-57 69c20-25 43-48 59-68m-57 73c16-20 34-37 56-71m-58 69c19-22 38-45 62-69m-63 72c18-19 36-44 60-68m-60 70c17-22 35-41 62-71m-60 74c12-17 31-39 62-67m-62 67c22-25 41-53 58-73m-57 76c21-25 42-46 58-73m-59 71c10-11 24-26 58-67m-62 69c14-9 29-26 60-70m-57 74c25-29 45-56 59-74m-60 79c16-25 34-43 61-77m-61 75c11-16 26-33 61-74m-62 74c15-8 25-25 64-71m-62 72c22-26 43-48 60-71m-63 79 65-76m-61 74c16-26 37-50 58-72m-63 73c18-19 28-35 64-68m-60 67c13-18 33-35 60-68m-63 73c16-12 25-32 60-72m-59 73c21-25 39-48 64-73m-66 77c24-30 48-52 63-76m-63 73c23-23 43-46 66-72m-66 77c14-16 31-27 68-72m-67 73c19-23 36-44 64-73m-67 73c21-24 47-50 68-72m-66 74 64-75m-66 77c23-23 43-51 70-74m-65 73c11-14 29-31 64-70m-65 73c16-14 32-33 65-72m-64 74c21-27 44-53 63-76m-62 83c22-34 45-56 59-80m-62 78 65-75m-67 77c26-28 51-53 70-75m-68 73c12-12 27-31 66-75m-66 78c24-27 45-55 63-77m-64 81 66-76m-65 74c27-27 49-51 63-77m-61 81 64-75m-64 79c19-28 52-55 61-79m-62 79c22-28 43-50 65-77m-65 75c19-19 41-46 64-73m-64 75c21-27 45-54 66-76m-65 81c20-26 52-63 64-77m-67 77c26-27 49-55 67-77m-69 76c26-19 39-41 69-71m-65 74 65-77m-64 83c16-26 34-48 68-82m-70 80c12-16 26-33 66-77m-69 77c26-28 47-50 73-71m-70 74c25-28 52-62 67-76m-69 79c24-24 52-57 71-76m-69 75c18-26 42-51 65-79m-65 82c18-17 40-37 71-81m-69 81c18-24 39-49 64-77m-63 81c17-29 43-54 67-80m-67 76c18-19 36-41 64-73m-66 76c22-24 41-44 66-74m-63 74c11-19 26-32 64-73m-60 78c21-34 46-57 56-77m-59 71c23-26 48-57 62-71m-64 74c20-20 34-31 68-74m-66 73c22-22 43-45 64-71m-58 69c19-21 37-46 55-66m-58 69c22-24 43-48 59-69m-54 75c17-24 37-47 54-72m-55 68c12-21 32-39 55-67m-54 65c14-13 29-36 54-59m-54 64c15-23 32-43 56-67m-55 67c13-18 34-35 52-66m-52 67c13-18 30-37 53-64m-51 63c12-21 25-33 56-60m-58 61c14-14 27-28 53-62m-54 64c20-24 41-46 58-65m-55 64 53-61m-52 64c14-18 24-37 52-61m-49 58c16-20 36-43 50-57m-53 61c13-17 30-29 50-63m-47 60c13-15 21-28 50-55m-49 58c13-16 20-28 50-57m-49 54 46-54m-47 55c19-16 36-39 50-48m-47 50c13-16 31-37 46-51m-44 56c11-20 32-41 41-57m-43 51c19-18 37-37 47-51m-46 53c11-10 16-24 46-51m-44 53c15-18 31-35 41-51m-42 53c15-13 25-29 40-52m-38 51 41-49m-37 50c11-20 33-34 39-50m-39 48c14-15 25-32 38-45m-40 46c17-14 32-33 43-39m-40 40c6-10 20-24 35-42m-38 45c15-12 25-31 40-44m-37 41c11-10 23-23 36-40m-37 42c13-10 31-31 39-41m-34 42 35-41m-34 39c5-6 15-17 34-33m-34 38c5-13 16-21 31-43m-31 41c12-5 23-20 35-38m-36 38c15-13 24-27 36-37m-37 43c12-10 21-20 38-37m-33 34c11-11 19-25 30-37m-27 36c4-8 18-21 26-35m-28 37c7-7 14-16 28-37m-30 36c14-4 19-16 35-27m-31 31c11-15 23-28 28-33m-27 30c12-10 20-21 27-27m-30 30c10-9 21-23 30-34m-25 37c6-7 15-17 27-35m-28 34c6-11 14-19 27-30m-26 27c9-8 16-18 21-23m-22 28 24-31m-22 32c6-9 19-20 23-26m-25 27c8-7 13-17 25-28m-26 30c13-8 16-15 24-28m-22 26 26-24m-21 25 19-22m-20 24c7-11 16-21 22-28m-21 30 19-25m-21 23c10-8 16-17 24-23m-23 25c9-3 9-12 25-26m-24 27c7-8 9-13 21-25m-17 29c0-9 6-13 18-26m-18 24c4-8 11-17 16-21m-19 19c8-4 17-15 23-22m-21 25c3-3 6-10 18-20m-18 20c7-3 10-15 19-20m-17 20c4-5 6-9 16-17m-19 20c6-6 9-13 17-17m-15 16c6-5 11-9 17-19m-15 21c5-2 10-11 19-16m-20 19c7-6 11-11 15-18m-15 19c2-4 12-7 18-21m-15 20c4-7 7-9 13-17m-13 16c5-1 5-5 12-13m-11 16 14-18m-11 22c2-5 7-12 11-16m-14 14c3-4 8-12 11-14m-10 16c4-7 10-5 16-16m-17 15 15-13m-10 19c-1-8 7-12 9-15m-13 10 13-11m-14 13c2-3 8-5 13-14m-11 15c3-2 7-3 10-12m-6 18c-1-9 5-10 10-18m-13 15 11-11m-12 12c5-1 10-5 10-8m-6 9c0-3 3-6 7-11m-9 11c7-1 7-4 10-9m-9 12c2-6 8-8 8-11m-8 10 9-6m-9 8 9-8m-7 12c4-5 6-6 6-13m-6 11c3-3 6-5 8-9m-9 13c2-2 6-4 8-8m-7 7 8-9m-8 10c3-2 5-4 6-8m-5 9 7-7m-6 8c1 0 2-4 7-7m-7 8 6-6m-6 7c3 1 2-2 6-6m-4 7 4-5m-3 6 3-5m-3 5 3-4m-2 6 2-3m-3 4 3-4m-2 6 2-3m-2 3 2-3m-1 5 2-2m-2 2 2-2m-1 4 1-1m-2 1 2-1"/>
        <path stroke="transparent" strokeWidth=".5" d="m272 626-11-25c-3-8-4-17-10-24-5-8-14-15-21-21s-14-14-20-17c-5-4-12-2-15-6-2-4 0-6 0-17l4-52c3-34 7-127 9-155s-1-12 3-14c3-2 12-1 19-1 8 1 22-1 26 2s-3-10-2 15c1 24 3 78 7 130l11 182m-3 0c-3-3-8-12-11-19s-3-17-8-24c-5-8-13-15-20-21l-22-20c-5-5-9-6-10-9-2-3-1 1-1-10s-1-20 1-56c1-35 4-130 7-159 2-28 4-9 8-11 5-1 13 2 19 3 7 0 17-4 21-1 3 3 0-4 1 20s1 73 5 125l14 188"/>
      </g>
      <path fill="none" stroke="black" strokeLinecap="round" strokeWidth="4" d="m271 626-10-23c-4-8-7-18-12-26s-10-15-17-21l-25-16c-6-4-8-3-10-7-2-3-2-2-2-14l3-56 9-154c2-28-2-12 2-14 3-2 11 1 18 1 8 0 22-6 27-3 4 3-1-3 0 21a9897 9897 0 0 0 17 312m2 2-13-24c-3-8-4-18-8-26-5-8-13-15-20-21-7-7-18-13-24-17-5-4-8-1-10-4-2-4-2-6-2-18s-1-20 1-55l8-155c2-28-2-11 1-13 4-3 14-1 22-1s23-1 28 2c4 3-3-7-2 17a4634 4634 0 0 0 17 312"/>
      <path fill="none" stroke={blade} strokeLinecap="round" strokeWidth="8" d="m255 296 12 320m-15-322 21 325"/>
    </svg>
  )
}
export const saveIcon = (isDirty: boolean) => {
  return (
    <svg 
      xmlns="http://www.w3.org/2000/svg" 
      viewBox="0 0 24 24"
      fill="none" 
      stroke={isDirty?"var(--color-accent)":"var(--icon-fill-color)"}
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    >
      <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/>
      <polyline points="17 21 17 13 7 13 7 21"/>
      <polyline points="7 3 7 8 15 8"/>
    </svg>
  )
}

export const penIcon = (pen: PenStyle) => {
  switch(pen.type) {
    case "highlighter":
      return (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          viewBox="0 0 24 24"
          fill="none"
          stroke="var(--icon-fill-color)"
          strokeWidth="2"
          strokeLinecap="round"
          strokeLinejoin="round"
        >
          <path fill={
            pen.strokeColor??"var(--icon-fill-color)"}
            strokeWidth="2" d="m9 11-6 6v3h9l3-3"
            style={pen.strokeColor ? { filter: "var(--theme-filter)" } : {}}
          ></path>
          <path fill="none" strokeWidth="2" d="m22 12-4.6 4.6a2 2 0 0 1-2.8 0l-5.2-5.2a2 2 0 0 1 0-2.8L14 4"></path>
        </svg>
      )
    case "finetip":
      return (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          viewBox="0 0 24 24"
          fill={pen.strokeColor??"var(--icon-fill-color)"}
          stroke={pen.strokeColor??"var(--icon-fill-color)"}
          strokeWidth="2"
          strokeLinecap="round"
          strokeLinejoin="round"
          style={pen.strokeColor ? { filter: "var(--theme-filter)" } : {}}
        >
          <path strokeWidth="2" d="M17 3a2.828 2.828 0 1 1 4 4L7.5 20.5 2 22l1.5-5.5L17 3z"></path>
        </svg>
      )
    case "fountain":
      return (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          viewBox="0 0 24 24"
          fill="none"
          stroke="var(--icon-fill-color)"
          strokeWidth="2"
          strokeLinecap="round"
          strokeLinejoin="round"
        >
          <path fill={pen.strokeColor??"var(--icon-fill-color)"} d="m12 19 7-7 3 3-7 7-3-3z"></path>
          <path fill="none"  d="m18 13-1.5-7.5L2 2l3.5 14.5L13 18l5-5z"></path>
          <path fill="none"  d="m2 2 7.586 7.586"></path>
          <circle fill="none" cx="11" cy="11" r="2"></circle>
        </svg>
      )
    case "marker": 
      return (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          viewBox="0 0 576 512"
          fill={pen.strokeColor??"var(--icon-fill-color)"}
          stroke={pen.strokeColor??"var(--icon-fill-color)"}
          strokeWidth="2"
          strokeLinecap="round"
          strokeLinejoin="round"
          style={pen.strokeColor ? { filter: "var(--theme-filter)" } : {}}
        >
          <path d="M331 315l158.4-215L460.1 70.6 245 229 331 315zm-187 5l0 0V248.3c0-15.3 7.2-29.6 19.5-38.6L436.6 8.4C444 2.9 453 0 462.2 0c11.4 0 22.4 4.5 30.5 12.6l54.8 54.8c8.1 8.1 12.6 19 12.6 30.5c0 9.2-2.9 18.2-8.4 25.6L350.4 396.5c-9 12.3-23.4 19.5-38.6 19.5H240l-25.4 25.4c-12.5 12.5-32.8 12.5-45.3 0l-50.7-50.7c-12.5-12.5-12.5-32.8 0-45.3L144 320zM23 466.3l63-63 70.6 70.6-31 31c-4.5 4.5-10.6 7-17 7H40c-13.3 0-24-10.7-24-24v-4.7c0-6.4 2.5-12.5 7-17z"/>
        </svg>
      )
    case "thick-thin": 
      return  (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          viewBox="0 0 108 106"
          strokeWidth="2" 
          fill={pen.strokeColor??"var(--icon-fill-color)"}
          stroke={pen.strokeColor??"var(--icon-fill-color)"}
          style={pen.strokeColor ? { filter: "var(--theme-filter)" } : {}}
        >
        <path d="m-.58 95.628.22-.89q.22-.89.49-2.44.26-1.54.77-3.35t1.31-3.43q.79-1.61.2-.26-.6 1.34-.03-.14.58-1.49 1.54-2.97.96-1.49 2.54-3.18 1.59-1.68 3.46-2.96 1.86-1.27.81-.54-1.04.73.6-.46 1.64-1.19 2.8-1.81 1.16-.63.16-.08-.99.54 1.21-.5 2.2-1.03 1.11-.58-1.1.45-.03-.07 1.06-.53 2.32-.82 1.26-.3 2.91-.52 1.64-.23 3.05-.18 1.4.05 2.5.12 1.09.07 2.25.24 1.16.17 2.3.49 1.15.32 2.11.78.96.47 2.21 1.01 1.25.55 2.37 1.04t2.34.89q1.22.4 2.5.65 1.29.25 2.44.33 1.16.08 2.35.17 1.18.08 2.26-.1 1.08-.19 2-1.1.92-.91 1.25-1.93.32-1.02.38-2.15t.57.21q.51 1.34-.03-.02-.55-1.37-.96-2.83-.41-1.45.5-.67.92.79-.03-.06-.95-.85-1.52-1.8-.57-.94-1.5-1.52-.93-.57-1.94-1.22-1.01-.65-1.97-1.88-.96-1.22-1.44-2.54-.49-1.32-.65-2.57-.17-1.24-.11-2.35.06-1.11.31-2.91.24-1.79.76-2.77.51-.97 1.29-1.8.77-.84 1.64-1.55.88-.72 1.9-1.33 1.03-.61 2.43-1.15 1.41-.55 2.69-.92 1.29-.37 2.81-.68 1.53-.31 2.83-.58 1.31-.27 2.78-.47 1.47-.2 2.58-.49 1.12-.28 2.19-.58 1.08-.31 2.13-.73 1.05-.42 2.44-1.32 1.39-.9 2.68-1.85 1.3-.95 2.25-1.87.95-.91 2.06-2 1.11-1.09 1.92-1.93.82-.84 1.54-1.82.71-.98 1.4-1.88.69-.9 1.38-1.96.69-1.07 1.25-2.04.55-.97 1.21-1.94.65-.96 1.35-1.79.69-.83 1.46-1.74.77-.9 1.66-1.73.89-.84 2.72-2.31 1.84-1.48 1.84-1.47v.01l-1.1 1.03q-1.1 1.02-1.77 1.92-.68.9-1.39 1.85-.71.96-1.41 1.91-.7.96-1.19 1.92-.48.95-.95 1.92-.46.96-.9 1.95-.43.99-1.02 2.16-.59 1.17-1.17 2.15-.58.97-1.23 2.13t-1.29 2.02q-.64.86-1.3 1.73-.66.88-1.42 1.78-.75.9-1.72 2.03-.97 1.14-1.81 1.89-.85.75-1.98 1.71-1.14.96-2.05 1.61-.91.64-2.42 1.38-1.51.73-2.71 1.21t-2.49.92q-1.3.44-2.35.69-1.06.24-2.1.59-1.03.34-2.06.74-1.03.4-2.29.94-1.26.54-2.27 1.11-1.01.58-1.57 1.57-.56.99-.81 2.06-.25 1.08.56 2.02.8.94-.21-.02-1.02-.96-.01-.48 1 .49 1.87 1.25.87.77 0 0-.88-.77.46-.01 1.34.75 2.6 1.68 1.26.94 2.08 2.03.81 1.09.01.27-.8-.82.3.26 1.11 1.08 1.71 2.1.61 1.02 1.21 2.25.6 1.24.92 2.36.32 1.12-.16.13-.49-.98.02.36.51 1.35.71 2.69.2 1.34.24 2.46.03 1.12-.09 2.42-.13 1.29-.72 3.21-.6 1.92-1.4 3.49-.81 1.58-1.77 2.83-.96 1.24-2.88 2.72-1.92 1.48-2.95 1.85-1.04.36-2.47.76-1.44.41-3.33.72-1.89.32-3.37.41-1.48.09-2.63.15-1.15.05-2.74-.06-1.59-.1-2.8-.29-1.2-.19-3.2-.63-1.99-.45-3.63-.92-1.63-.48-3.28-.79-1.65-.31-2.76-.2-1.11.1-2.21.42-1.11.32.39-.29 1.49-.6-.12.21-1.61.8-.39.19 1.21-.61.29.13-.92.74-1.83 1.34-.92.61.15-.19t.3-.05q-.77.75-1.58 1.57-.81.82.01-.18.82-1 .24.23t-.72 2.72q-.15 1.48-.08 2.4.07.91-.19 2.16-.26 1.26-.81 2.41-.55 1.16-1.36 2.15t-1.84 1.75q-1.03.77-2.21 1.27t-2.44.7q-1.27.2-2.53.1-1.28-.11-2.49-.52-1.22-.41-2.3-1.1-1.08-.68-1.96-1.61-.89-.92-1.52-2.04-.64-1.11-.99-2.34-.36-1.23-.41-2.51l-.04-1.27Z"/>
        </svg>
      )
    case "thin-thick-thin":
      return (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          viewBox="0 0 114 113"
          strokeWidth="2" 
          fill={pen.strokeColor??"var(--icon-fill-color)"}
          stroke={pen.strokeColor??"var(--icon-fill-color)"}
          style={pen.strokeColor ? { filter: "var(--theme-filter)" } : {}}
        >
          <path d="m10 103.405.13-1.22q.14-1.22 1.3-3.16 1.15-1.94 2.74-3.46 1.59-1.53 3.35-2.72 1.77-1.2 4-1.95 2.23-.76 4.45-1t4.86-.4q2.64-.15 5.14-.34 2.51-.19 4.85-.94 2.35-.75 4.55-1.71 2.21-.97 4.16-2.26 1.95-1.3 4.03-2.97 2.07-1.67 3.85-3.05 1.78-1.37 3.72-2.48 1.94-1.11 3.3-2.99 1.36-1.89 2.58-3.74 1.22-1.85-.63-3.42-1.85-1.57-3.82-2.86-1.97-1.3-4.11-2.08-2.15-.78-4.21-1.6-2.06-.81-4.02-1.96-1.96-1.14-3.71-2.48-1.74-1.33-3.37-2.77-1.63-1.43-3.23-3.62-1.6-2.18-2.23-4.64-.62-2.46-.36-4.96.27-2.49 1.19-4.46.91-1.97 2.42-3.7 1.5-1.73 3.5-3.15t4.11-2.28q2.1-.86 4.33-1.44 2.24-.58 4.92-.84 2.68-.26 4.83-.19t4.69.35q2.53.28 4.75.66 2.23.38 4.48.2 2.26-.19 4.43-1.3 2.17-1.12 4.2-2.36 2.04-1.24 3.93-2.43 1.9-1.19 3.84-2.14 1.95-.95 4.04-1.78 2.09-.83 4.56-2.28 2.46-1.46 2.46-1.45h.01q.01 0-1.38 1.3-1.38 1.29-3.08 2.59-1.7 1.3-3.5 2.5t-3.42 2.65q-1.62 1.45-3.18 3-1.57 1.56-3.37 3.13-1.8 1.57-3.6 2.91-1.81 1.33-3.92 2.12t-4.24.92q-2.13.14-4.31.26-2.18.12-4.5.39t-4.56.88q-2.25.61-4.24 1.6-1.99 1-3.83 2.29-1.83 1.29.18 2.44 2.01 1.15 4.2 1.92 2.2.78 4.34 1 2.15.22 4.4.69 2.25.46 4.34 1.16 2.08.71 4.33 1.91 2.25 1.21 4.11 2.73 1.87 1.52 3.68 4.03 1.82 2.5 2.74 5 .93 2.5 1.18 5.03.26 2.53-.04 4.81t-1.4 4.85q-1.09 2.58-2.4 4.26-1.3 1.68-3.1 3.44t-4.02 3.62q-2.23 1.85-4.32 3.07-2.08 1.23-4.34 1.99-2.25.76-4.46 1.96t-4.37 2.14q-2.15.93-4.22 1.81t-4.36 1.35q-2.3.46-4.52.82-2.22.35-4.76.38-2.54.04-4.87-.28t-4.67-.67q-2.34-.35-4.72-.54-2.39-.19-4.64.37-2.25.56-4.16 1.66-1.91 1.11-3.52 2.71-1.61 1.6-2.55 2.39l-.94.78Z"/>
        </svg>
      )
    default: 
      return (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          viewBox="0 0 512 512"
          fill={pen.strokeColor??"var(--icon-fill-color)"}
          stroke={pen.strokeColor??"var(--icon-fill-color)"}
          strokeWidth="2"
          strokeLinecap="round"
          strokeLinejoin="round"
          style={pen.strokeColor ? { filter: "var(--theme-filter)" } : {}}
        >
          <path d="M453.3 19.3l39.4 39.4c25 25 25 65.5 0 90.5l-52.1 52.1 0 0-1-1 0 0-16-16-96-96-17-17 52.1-52.1c25-25 65.5-25 90.5 0zM241 114.9c-9.4-9.4-24.6-9.4-33.9 0L105 217c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L173.1 81c28.1-28.1 73.7-28.1 101.8 0L288 94.1l17 17 96 96 16 16 1 1-17 17L229.5 412.5c-48 48-109.2 80.8-175.8 94.1l-25 5c-7.9 1.6-16-.9-21.7-6.6s-8.1-13.8-6.6-21.7l5-25c13.3-66.6 46.1-127.8 94.1-175.8L254.1 128 241 114.9z"/>
        </svg>
      )
  }
}

export const stringToSVG = (svg: string) => {
  if(svg.match('class="skip"')) {
    return <div dangerouslySetInnerHTML={{__html: svg}}></div>
  }
  svg = svg
    .replace(/stroke\s*=\s*['"][^"']*['"]/g,"")
    .replace(/[^-]width\s*=\s*['"][^"']*['"]/g,"")
    .replace(/[^-]height\s*=\s*['"][^"']*['"]/g,"")
    .replace("<svg ",`<svg style="stroke:var(--icon-fill-color);color:var(--icon-fill-color);fill:var(--icon-fill-color);stroke-width:6;" `)
    
    return (
      <div dangerouslySetInnerHTML={{__html: svg}}></div>
    )
}

export const LogoWrapper = ({ children }: { children: React.ReactNode }) => {
  return (
    <div className="welcome-screen-center__logo virgil welcome-screen-decor">
      {children} {/* Render the children, including the ExcalidrawSword SVG icon */}
    </div>
  );
};
