# Excalidraw Automate How To

【English | [简体中文](zh-cn/docs/readme.md)】

Use ExcalidrawAutomate to create or manipulate Excalidraw drawings using the [ExcalidrawAutomate Script Engine](ExcalidrawScriptsEngine.md), the [Templater](https://silentvoid13.github.io/Templater/docs/) or the [QuickAdd](https://github.com/chhoumann/quickadd) plugins, and to generate embedded SVG and PNG images using [DataviewJS](https://blacksmithgu.github.io/obsidian-dataview/docs/api/intro/)

With a little work, using ExcalidrawAutomate you can generate simple mindmaps, build a family tree, fill out SVG forms, create customized charts, or automate simple tasks (i.e. create macros) in Excalidraw.
![image](https://user-images.githubusercontent.com/14358394/117549619-bae41180-b03b-11eb-968d-c909e79a7524.png)

## API documentation
- **start here** [Introduction to the API](API/introduction.md)
- [Overview of Attributes and Functions](API/attributes_functions_overview.md)
- [Element Style](API/element_style.md)
- [Canvas Style](API/canvas_style.md)
- [Adding Objects](API/objects.md)
- [Utility Functions](API/utility.md)

## ExcalidrawAutomate Script Engine
I recommend using the Scripts Engine for "Macro" like automation, when you want to automate a few simple steps, such as adding a box around a text element, or connecting two objects with an arrow, or setting line width or the grid to a custom value.  
- [ExcalidrawAutomate Script Engine](ExcalidrawScriptsEngine.md).

## Examples
- **Templater** 
  - [Insert new drawing into currently edited document](Examples/insert_new_drawing.md)
  - [Connect objects](Examples/connect_objects.md)
  - [Apply an Excalidraw template](Examples/apply_template.md)
  - [Mindmap with Templater](Examples/templater_mindmap.md)

- **Dataview** 
  - [Mindmap with Dataview](Examples/dataviewjs_mindmap.md)
  - [Family tree with Dataview](Examples/dataviewjs_familytree.md)

## If you are enjoying the Obsidian Excalidraw Plugin...
Help spread the word by sharing about the Plugin on social media.

You can find me on Twitter [@zsviczian](https://twitter.com/zsviczian), and on my blog [zsolt.blog](https://zsolt.blog).

[<img style="float:left" src="https://user-images.githubusercontent.com/14358394/115450238-f39e8100-a21b-11eb-89d0-fa4b82cdbce8.png" width="150">](https://ko-fi.com/zsolt)


