/// <reference types="node" />
import { Transports } from '@sentry/node';
import { Event, Response, SentryRequest, SentryRequestType, TransportOptions } from '@sentry/types';
import { PromiseBuffer } from '@sentry/utils';
/**
 * SentryElectronRequest
 */
export interface SentryElectronRequest extends Omit<SentryRequest, 'body'> {
    body: string | Buffer;
}
/** Using net module of electron */
export declare class NetTransport extends Transports.BaseTransport {
    options: TransportOptions;
    /** A simple buffer holding all requests. */
    protected readonly _buffer: PromiseBuffer<Response>;
    /** Create a new instance and set this.agent */
    constructor(options: TransportOptions);
    /**
     * @inheritDoc
     */
    sendEvent(event: Event): Promise<Response>;
    /**
     * Checks if a category is rate-limited
     */
    isRateLimited(category: SentryRequestType): boolean;
    /**
     * Dispatches a Request to Sentry. Only handles SentryRequest
     */
    sendRequest(request: SentryElectronRequest): Promise<Response>;
}
//# sourceMappingURL=net.d.ts.map