Object.defineProperty(exports, "__esModule", { value: true });
exports.close = exports.flush = exports.captureMinidump = exports.showReportDialog = exports.init = exports.RendererClient = exports.RendererBackend = exports.withScope = exports.setUser = exports.setTags = exports.setTag = exports.setExtras = exports.setExtra = exports.setContext = exports.Scope = exports.Hub = exports.getCurrentHub = exports.getHubFromCarrier = exports.configureScope = exports.captureMessage = exports.captureEvent = exports.captureException = exports.addBreadcrumb = exports.addGlobalEventProcessor = exports.Status = exports.Severity = void 0;
var tslib_1 = require("tslib");
var types_1 = require("@sentry/types");
Object.defineProperty(exports, "Severity", { enumerable: true, get: function () { return types_1.Severity; } });
Object.defineProperty(exports, "Status", { enumerable: true, get: function () { return types_1.Status; } });
var core_1 = require("@sentry/core");
Object.defineProperty(exports, "addGlobalEventProcessor", { enumerable: true, get: function () { return core_1.addGlobalEventProcessor; } });
Object.defineProperty(exports, "addBreadcrumb", { enumerable: true, get: function () { return core_1.addBreadcrumb; } });
Object.defineProperty(exports, "captureException", { enumerable: true, get: function () { return core_1.captureException; } });
Object.defineProperty(exports, "captureEvent", { enumerable: true, get: function () { return core_1.captureEvent; } });
Object.defineProperty(exports, "captureMessage", { enumerable: true, get: function () { return core_1.captureMessage; } });
Object.defineProperty(exports, "configureScope", { enumerable: true, get: function () { return core_1.configureScope; } });
Object.defineProperty(exports, "getHubFromCarrier", { enumerable: true, get: function () { return core_1.getHubFromCarrier; } });
Object.defineProperty(exports, "getCurrentHub", { enumerable: true, get: function () { return core_1.getCurrentHub; } });
Object.defineProperty(exports, "Hub", { enumerable: true, get: function () { return core_1.Hub; } });
Object.defineProperty(exports, "Scope", { enumerable: true, get: function () { return core_1.Scope; } });
Object.defineProperty(exports, "setContext", { enumerable: true, get: function () { return core_1.setContext; } });
Object.defineProperty(exports, "setExtra", { enumerable: true, get: function () { return core_1.setExtra; } });
Object.defineProperty(exports, "setExtras", { enumerable: true, get: function () { return core_1.setExtras; } });
Object.defineProperty(exports, "setTag", { enumerable: true, get: function () { return core_1.setTag; } });
Object.defineProperty(exports, "setTags", { enumerable: true, get: function () { return core_1.setTags; } });
Object.defineProperty(exports, "setUser", { enumerable: true, get: function () { return core_1.setUser; } });
Object.defineProperty(exports, "withScope", { enumerable: true, get: function () { return core_1.withScope; } });
var browser_1 = require("@sentry/browser");
var core_2 = require("@sentry/core");
var minimal_1 = require("@sentry/minimal");
var client_1 = require("./client");
var backend_1 = require("./backend");
Object.defineProperty(exports, "RendererBackend", { enumerable: true, get: function () { return backend_1.RendererBackend; } });
var client_2 = require("./client");
Object.defineProperty(exports, "RendererClient", { enumerable: true, get: function () { return client_2.RendererClient; } });
/**
 * Call init on @sentry/browser with all browser integrations
 * @param options ElectronOptions
 */
function init(options) {
    if (options.defaultIntegrations === undefined) {
        options.defaultIntegrations = browser_1.defaultIntegrations;
    }
    core_2.initAndBind(client_1.RendererClient, options);
}
exports.init = init;
/**
 * Present the user with a report dialog.
 *
 * @param options Everything is optional, we try to fetch all info need from the global scope.
 */
function showReportDialog(options) {
    if (options === void 0) { options = {}; }
    core_2.getCurrentHub().getClient().showReportDialog(options);
}
exports.showReportDialog = showReportDialog;
/**
 * Uploads a native crash dump (Minidump) to Sentry.
 *
 * @param path The relative or absolute path to the minidump.
 * @param event Optional event payload to attach to the minidump.
 */
function captureMinidump(path, event) {
    if (event === void 0) { event = {}; }
    minimal_1._callOnClient('captureMinidump', path, event);
}
exports.captureMinidump = captureMinidump;
/**
 * A promise that resolves when all current events have been sent.
 * If you provide a timeout and the queue takes longer to drain the promise returns false.
 *
 * @param timeout Maximum time in ms the client should wait.
 */
function flush(timeout) {
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var client;
        return tslib_1.__generator(this, function (_a) {
            client = core_2.getCurrentHub().getClient();
            if (client) {
                return [2 /*return*/, client.flush(timeout)];
            }
            return [2 /*return*/, Promise.reject(false)];
        });
    });
}
exports.flush = flush;
/**
 * A promise that resolves when all current events have been sent.
 * If you provide a timeout and the queue takes longer to drain the promise returns false.
 *
 * @param timeout Maximum time in ms the client should wait.
 */
function close(timeout) {
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var client;
        return tslib_1.__generator(this, function (_a) {
            client = core_2.getCurrentHub().getClient();
            if (client) {
                return [2 /*return*/, client.close(timeout)];
            }
            return [2 /*return*/, Promise.reject(false)];
        });
    });
}
exports.close = close;
//# sourceMappingURL=index.js.map