import { BaseBackend } from '@sentry/core';
import { Event, EventHint, Severity, Transport } from '@sentry/types';
import { CommonBackend, ElectronOptions } from '../common';
/**
 * Returns a promise that resolves when app is ready.
 */
export declare function isAppReady(): Promise<boolean>;
/** Backend implementation for Electron renderer backends. */
export declare class MainBackend extends BaseBackend<ElectronOptions> implements CommonBackend<ElectronOptions> {
    /** The inner SDK used to record Node events. */
    private readonly _inner;
    /** Store to persist context information beyond application crashes. */
    private readonly _scopeStore;
    /** Temp store for the scope of last run */
    private _scopeLastRun?;
    /** Uploader for minidump files. */
    private _uploader?;
    /** Counter used to ensure no race condition when updating extra params */
    private _updateEpoch;
    /** Creates a new Electron backend instance. */
    constructor(options: ElectronOptions);
    /**
     * @inheritDoc
     */
    eventFromException(exception: any, hint?: EventHint): PromiseLike<Event>;
    /**
     * @inheritDoc
     */
    eventFromMessage(message: string, level?: Severity, hint?: EventHint): PromiseLike<Event>;
    /**
     * @inheritDoc
     */
    sendEvent(event: Event): void;
    /**
     * Uploads the given minidump and attaches event information.
     *
     * @param path A relative or absolute path to the minidump file.
     * @param event Optional event information to add to the minidump request.
     */
    uploadMinidump(path: string, event?: Event): void;
    /**
     * Setup Transport
     */
    protected _setupTransport(): Transport;
    /**
     * Adds a scope listener to persist changes to disk.
     */
    private _setupScopeListener;
    /** Updates Electron uploader extra params */
    private _updateExtraParams;
    /** Builds up an event to send with the native Electron uploader */
    private _getNativeUploaderEvent;
    /** Chunks up event JSON into 1 or more parameters for use with the native Electron uploader
     *
     * Returns chunks with keys and values:
     * {
     *    sentry__1: '{ json...',
     *    sentry__2: 'more json...',
     *    sentry__x: 'end json }',
     * }
     */
    private _getNativeUploaderExtraParams;
    /** Returns whether native reports are enabled. */
    private _isNativeEnabled;
    /** Activates the Electron CrashReporter. */
    private _installNativeHandler;
    /** Installs IPC handlers to receive events and metadata from renderers. */
    private _installIPC;
    /** Loads new native crashes from disk and sends them to Sentry. */
    private _sendNativeCrashes;
    /** Returns extra information from a renderer's web contents. */
    private _getNewEventWithElectronContext;
}
//# sourceMappingURL=backend.d.ts.map