import { BrowserOptions, ReportDialogOptions } from '@sentry/browser';
import { BaseBackend } from '@sentry/core';
import { NodeOptions } from '@sentry/node';
import { Client, Event, Options, Scope } from '@sentry/types';
export declare const IPC: {
    /** IPC to ping the main process when initializing in the renderer. */
    PING: string;
    /** IPC to send a captured event (exception or message) to Sentry. */
    EVENT: string;
    /** IPC to capture a scope globally. */
    SCOPE: string;
};
/**
 * Configuration options for {@link ElectronOptions}.
 *
 * By default, all native crashes and JavaScript errors will be captured and
 * sent to Sentry. Note that these settings have to be specified during startup
 * and cannot be changed later.
 *
 * This options object can also contain options for the Browser and Node SDKs,
 * which are being used under the hood to record JavaScript errors. Please refer
 * to their documentation for a description of the fields.
 *
 * @see BrowserOptions
 * @see NodeOptions
 * @see ElectronOptions
 */
export interface ElectronOptions extends Options, BrowserOptions, NodeOptions {
    /**
     * The name of the application. Primarily used for crash directory naming. If this property is not supplied,
     * it will be retrieved using the Electron `app.getName/name` API. If you disable the Electron `remote` module in
     * the renderer, this property is required.
     */
    appName?: string;
    /**
     * Enables crash reporting for JavaScript errors in this process. Defaults to
     * `true`.
     */
    enableJavaScript?: boolean;
    /**
     * Enables crash reporting for native crashes of this process (via Minidumps).
     * Defaults to `true`.
     */
    enableNative?: boolean;
    /**
     * Enables the Sentry internal uploader for minidumps.
     * Defaults to `true`.
     */
    useSentryMinidumpUploader?: boolean;
    /**
     * This sets `uploadToServer` of the crashReporter to `true`. The SDK also tries to set data (Sentry Event)
     * with `crashReporter.addExtraParameter` to provide more context. Keep in mind, you should set
     * `useSentryMinidumpUploader` to `false` otherwise you recieve the crash report twice.
     * Defaults to `false`.
     */
    useCrashpadMinidumpUploader?: boolean;
    /**
     * Enables event reporting for BrowserWindow 'unresponsive' events
     * Defaults to `true`.
     */
    enableUnresponsive?: boolean;
    /**
     * Callback to allow custom naming of renderer processes
     * If the callback is not set, or it returns `undefined`, the default naming
     * scheme is used.
     */
    getRendererName?(contents: Electron.WebContents): string | undefined;
}
/** Common interface for Electron clients. */
export interface ElectronClient extends Client<ElectronOptions> {
    /**
     * Uploads a native crash dump (Minidump) to Sentry.
     *
     * @param path The relative or absolute path to the minidump.
     * @param event Optional event payload to attach to the minidump.
     * @param scope Optional The SDK scope used to upload.
     */
    captureMinidump(path: string, event?: Event, scope?: Scope): string | undefined;
    /**
     * Shows Report Dialog
     */
    showReportDialog(options: ReportDialogOptions): void;
}
/** Get the name of an electron app for <v5 and v7< */
export declare function getNameFallback(): string;
/** Common interface for Electron backends. */
export { BaseBackend as CommonBackend };
//# sourceMappingURL=common.d.ts.map